/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.regressions;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.managedbuilder.testplugin.AbstractBuilderTest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class Bug_335476
extends AbstractBuilderTest {
    private final String VAR_NAME = "INC";
    IProject app;
    IEnvironmentVariableManager envManager = CCorePlugin.getDefault().getBuildEnvironmentManager();
    ICdtVariableManager buildMacroManager = CCorePlugin.getDefault().getCdtVariableManager();

    protected void setUp() throws Exception {
        super.setUp();
        this.setWorkspace("regressions");
        this.app = this.loadProject("bug_335476");
        this.setActiveConfigurationByName(this.app, "Debug");
    }

    public void runTest(int build_kind) throws Exception {
        IFile lala = this.app.getFile((IPath)new Path(".settings/org.eclipse.cdt.core.prefs.lala"));
        IFile foo = this.app.getFile((IPath)new Path(".settings/org.eclipse.cdt.core.prefs.foo"));
        IFile env = this.app.getFile((IPath)new Path(".settings/org.eclipse.cdt.core.prefs"));
        IFile current = foo;
        int i = 0;
        while (i < 5) {
            String expected = current == foo ? "foo" : "lala";
            env.setContents(current.getContents(), 0, null);
            this.app.build(build_kind, null);
            IFile makefile = this.app.getFile("Debug/src/subdir.mk");
            BufferedReader reader = new BufferedReader(new InputStreamReader(makefile.getContents()));
            try {
                Pattern p = Pattern.compile(".*?-I.*?\"(.*?)\".*");
                boolean found = false;
                while (reader.ready()) {
                    String line = reader.readLine();
                    if (!line.contains("gcc")) continue;
                    Matcher m = p.matcher(line);
                    Bug_335476.assertTrue((boolean)m.matches());
                    String buildVar = m.group(1);
                    String value = this.envManager.getVariable("INC", CCorePlugin.getDefault().getProjectDescription(this.app, false).getActiveConfiguration(), false).getValue();
                    String value2 = this.buildMacroManager.resolveValue("${INC}", "", ";", CCorePlugin.getDefault().getProjectDescription(this.app, false).getActiveConfiguration());
                    Bug_335476.assertTrue((String)(String.valueOf(i) + " EnvManager " + expected + " exepected, but was: " + value), (boolean)expected.equals(value));
                    Bug_335476.assertTrue((String)(String.valueOf(i) + " CdtVarManager " + expected + " exepected, but was: " + value2), (boolean)expected.equals(value2));
                    Bug_335476.assertTrue((String)(String.valueOf(i) + " Makefile: " + expected + " exepected, but was: " + buildVar), (boolean)expected.equals(buildVar));
                    found = true;
                }
                Bug_335476.assertTrue((boolean)found);
            }
            finally {
                reader.close();
            }
            current = current == lala ? foo : lala;
            ++i;
        }
    }

    public void testChangingEnvironmentBuildSystem_FULL_BUILD() throws Exception {
        this.runTest(6);
    }

    public void testChangingEnvironmentBuildSystem_INC_BUILD() throws Exception {
        this.runTest(10);
    }
}

