/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.testplugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.cdt.managedbuilder.testplugin.ResourceDeltaVerifier;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuilderTest
extends TestCase {
    private static final boolean WINDOWS = File.separatorChar == '\\';
    static final String PATH = "builderTests";
    private String workspace;
    private List<IProject> projects;

    protected void setUp() throws Exception {
        super.setUp();
        this.setAutoBuilding(false);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        Job.getJobManager().cancel((Object)CCorePlugin.getPDOMManager());
        Job.getJobManager().join((Object)CCorePlugin.getPDOMManager(), null);
        for (IProject project : this.projects) {
            project.delete(true, null);
        }
        this.projects.clear();
    }

    protected void verifyBuild(IProject project, int kind, ResourceDeltaVerifier verifier) throws CoreException {
        this.verifyBuild(new IBuildConfiguration[]{project.getActiveBuildConfig()}, kind, verifier);
    }

    protected void verifyBuild(final IBuildConfiguration[] configs, final int kind, ResourceDeltaVerifier verifier) throws CoreException {
        this.getWorkspace().getRoot().refreshLocal(2, null);
        this.getWorkspace().addResourceChangeListener((IResourceChangeListener)verifier);
        try {
            IWorkspaceRunnable body = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    AbstractBuilderTest.this.getWorkspace().build(configs, kind, true, monitor);
                }
            };
            this.getWorkspace().run(body, null);
        }
        finally {
            AbstractBuilderTest.assertTrue((String)verifier.getMessage(), (boolean)verifier.isDeltaValid());
            this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)verifier);
            this.printAllMarkers();
        }
    }

    protected void setActiveConfigurationByName(IProject project, String cfgName) throws CoreException {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription desc = mngr.getProjectDescription(project, true);
        ICConfigurationDescription cfg = desc.getConfigurationByName(cfgName);
        AbstractBuilderTest.assertNotNull((Object)cfg);
        desc.setActiveConfiguration(cfg);
        mngr.setProjectDescription(project, desc);
    }

    protected Collection<IResource> getProjectBuildExeResources(String projectName, String cfgName, String obj) throws CoreException {
        return this.getProjectBuildExeResources(projectName, cfgName, new String[]{obj});
    }

    protected Collection<IResource> getProjectBuildLibResources(String projectName, String cfgName, String obj) throws CoreException {
        return this.getProjectBuildLibResources(projectName, cfgName, new String[]{obj});
    }

    protected Collection<IResource> getProjectBuildSharedLibResources(String projectName, String cfgName, String obj) throws CoreException {
        return this.getProjectBuildSharedLibResources(projectName, cfgName, new String[]{obj});
    }

    protected Collection<IResource> getProjectBuildExeResources(String projectName, String cfgName, String[] objs) throws CoreException {
        Collection<IResource> resources = this.getProjectBuildResources(projectName, cfgName, objs);
        IProject project = this.getWorkspace().getRoot().getProject(projectName);
        IFolder buildDir = project.getFolder(cfgName);
        resources.add((IResource)buildDir.getFile(String.valueOf(projectName) + (WINDOWS ? ".exe" : "")));
        return resources;
    }

    protected Collection<IResource> getProjectBuildLibResources(String projectName, String cfgName, String[] objs) throws CoreException {
        Collection<IResource> resources = this.getProjectBuildResources(projectName, cfgName, objs);
        IProject project = this.getWorkspace().getRoot().getProject(projectName);
        IFolder buildDir = project.getFolder(cfgName);
        resources.add((IResource)buildDir.getFile("lib" + projectName + ".a"));
        return resources;
    }

    protected Collection<IResource> getProjectBuildSharedLibResources(String projectName, String cfgName, String[] objs) throws CoreException {
        Collection<IResource> resources = this.getProjectBuildResources(projectName, cfgName, objs);
        IProject project = this.getWorkspace().getRoot().getProject(projectName);
        IFolder buildDir = project.getFolder(cfgName);
        resources.add((IResource)buildDir.getFile("lib" + projectName + ".so"));
        return resources;
    }

    protected Collection<IResource> getProjectBuildResources(String projectName, String cfgName, String[] objs) throws CoreException {
        IProject project = this.getWorkspace().getRoot().getProject(projectName);
        IFolder buildDir = project.getFolder(cfgName);
        LinkedHashSet<IResource> resources = new LinkedHashSet<IResource>();
        resources.add((IResource)buildDir);
        resources.add((IResource)buildDir.getFile("makefile"));
        resources.add((IResource)buildDir.getFile("objects.mk"));
        resources.add((IResource)buildDir.getFile("sources.mk"));
        String[] stringArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            String obj = stringArray[n2];
            resources.add((IResource)buildDir.getFile(String.valueOf(obj) + ".d"));
            resources.add((IResource)buildDir.getFile(String.valueOf(obj) + ".o"));
            resources.add((IResource)buildDir.getFile(new Path(obj).removeLastSegments(1).append("subdir.mk")));
            IPath p = new Path(obj).removeLastSegments(1);
            while (p.segmentCount() > 0) {
                IFolder folder = buildDir.getFolder(p);
                resources.add((IResource)folder);
                p = p.removeLastSegments(1);
            }
            ++n2;
        }
        return resources;
    }

    public AbstractBuilderTest() {
    }

    public AbstractBuilderTest(String name) {
        super(name);
    }

    protected void setWorkspace(String name) {
        this.workspace = name;
        this.projects = new ArrayList<IProject>();
    }

    protected IProject loadProject(String name) throws CoreException {
        ManagedBuildTestHelper.loadProject(name, "builderTests/" + this.workspace);
        IProject project = this.getWorkspace().getRoot().getProject(name);
        AbstractBuilderTest.assertTrue((boolean)project.exists());
        this.projects.add(project);
        project.refreshLocal(2, null);
        return project;
    }

    private List<IMarker> getAllMarkers() throws CoreException {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        for (IProject project : this.projects) {
            markers.addAll(Arrays.asList(project.findMarkers("org.eclipse.cdt.core.problem", true, 2)));
        }
        return markers;
    }

    protected void printAllMarkers() throws CoreException {
        List<IMarker> markers = this.getAllMarkers();
        String[] attributes = new String[]{"lineNumber", "severity", "message", "location"};
        StringBuilder sb = new StringBuilder();
        for (IMarker m : markers) {
            if (m.getResource().getProject() == null) {
                sb.append("?");
            } else {
                sb.append(m.getResource().getProject().getName());
            }
            sb.append(", ");
            sb.append(m.getResource().getFullPath());
            Object[] attrs = m.getAttributes(attributes);
            sb.append(":");
            int i = 0;
            if (attrs[i] != null) {
                sb.append(" line " + attrs[i]);
            }
            if (attrs[++i] != null) {
                switch ((Integer)attrs[i++]) {
                    case 2: {
                        sb.append(" ERROR");
                        break;
                    }
                    case 1: {
                        sb.append(" WARNING");
                        break;
                    }
                    case 0: {
                        sb.append(" INFO");
                    }
                }
            }
            do {
                if (attrs[i] == null) continue;
                sb.append(" " + attrs[i]);
            } while (++i < attrs.length);
            System.err.println(sb.toString());
            sb.setLength(0);
        }
    }

    protected void setAutoBuilding(boolean value) throws CoreException {
        IWorkspace workspace = this.getWorkspace();
        if (workspace.isAutoBuilding() == value) {
            return;
        }
        IWorkspaceDescription desc = workspace.getDescription();
        desc.setAutoBuilding(value);
        workspace.setDescription(desc);
    }

    protected IWorkspace getWorkspace() throws CoreException {
        return ResourcesPlugin.getWorkspace();
    }
}

