/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactory;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameProcessor;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.widgets.Shell;

public class RenameSupport {
    public static final int NONE = 0;
    public static final int UPDATE_REFERENCES = 1;
    public static final int UPDATE_TEXTUAL_MATCHES = 64;
    public static final int UPDATE_GETTER_METHOD = 16;
    public static final int UPDATE_SETTER_METHOD = 32;
    private CRenameRefactoring fRefactoring;
    private RefactoringStatus fPreCheckStatus;

    public IStatus preCheck() throws CoreException {
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            return this.fPreCheckStatus.getEntryMatchingSeverity(4).toStatus();
        }
        return Status.OK_STATUS;
    }

    public void openDialog(Shell parent) throws CoreException {
        this.openDialog(parent, false);
    }

    public boolean openDialog(Shell shell, boolean showPreviewOnly) throws CoreException {
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            this.showInformation(shell, this.fPreCheckStatus);
            return false;
        }
        return CRefactory.openDialog(shell, this.fRefactoring, showPreviewOnly);
    }

    public void perform(Shell parent, IRunnableContext context) throws InterruptedException, InvocationTargetException {
        try {
            this.ensureChecked();
            if (this.fPreCheckStatus.hasFatalError()) {
                this.showInformation(parent, this.fPreCheckStatus);
                return;
            }
            CRenameProcessor renameProcessor = this.getRenameProcessor();
            try {
                renameProcessor.lockIndex();
                this.fPreCheckStatus = renameProcessor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
                if (this.fPreCheckStatus.hasFatalError()) {
                    this.showInformation(parent, this.fPreCheckStatus);
                    return;
                }
                RefactoringExecutionHelper helper = new RefactoringExecutionHelper((Refactoring)this.fRefactoring, RefactoringCore.getConditionCheckingFailedSeverity(), renameProcessor.getSaveMode(), parent, context);
                helper.perform(true, true);
            }
            finally {
                renameProcessor.unlockIndex();
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private RenameSupport(CRenameProcessor processor) {
        this.fRefactoring = new CRenameRefactoring(processor);
    }

    private CRenameProcessor getRenameProcessor() {
        return (CRenameProcessor)this.fRefactoring.getProcessor();
    }

    public static RenameSupport create(CRenameProcessor processor) throws CoreException {
        return new RenameSupport(processor);
    }

    private void ensureChecked() throws CoreException {
        if (this.fPreCheckStatus == null) {
            this.fPreCheckStatus = !this.fRefactoring.isApplicable() ? RefactoringStatus.createFatalErrorStatus((String)RenameMessages.RenameSupport_not_available) : new RefactoringStatus();
        }
    }

    private void showInformation(Shell parent, RefactoringStatus status) {
        String message = status.getMessageMatchingSeverity(4);
        MessageDialog.openInformation((Shell)parent, (String)RenameMessages.RenameSupport_dialog_title, (String)message);
    }
}

