/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.tm.internal.tcf.debug.Activator;
import org.eclipse.tm.internal.tcf.debug.model.TCFLaunch;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IBreakpoints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFBreakpointsModel
implements IBreakpointListener,
IBreakpointManagerListener {
    private final IBreakpointManager bp_manager = DebugPlugin.getDefault().getBreakpointManager();
    private final HashSet<IChannel> channels = new HashSet();
    private final HashMap<String, IBreakpoint> id2bp = new HashMap();
    private boolean disposed;

    public static TCFBreakpointsModel getBreakpointsModel() {
        return Activator.getBreakpointsModel();
    }

    public void dispose() {
        this.bp_manager.removeBreakpointListener((IBreakpointListener)this);
        this.bp_manager.removeBreakpointManagerListener((IBreakpointManagerListener)this);
        this.channels.clear();
        this.disposed = true;
    }

    public boolean isSupported(IChannel channel, IBreakpoint bp) {
        return true;
    }

    public String getBreakpointID(IBreakpoint bp) throws CoreException {
        IMarker marker = bp.getMarker();
        String id = (String)marker.getAttributes().get("org.eclipse.tm.tcf.debug.ID");
        if (id != null) {
            return id;
        }
        id = marker.getResource().getLocationURI().toString();
        if (id == null) {
            return null;
        }
        return String.valueOf(id) + ':' + marker.getId();
    }

    public IBreakpoint getBreakpoint(String id) {
        assert (Protocol.isDispatchThread());
        return this.id2bp.get(id);
    }

    public void downloadBreakpoints(final IChannel channel, final Runnable done) throws IOException, CoreException {
        assert (Protocol.isDispatchThread());
        assert (!this.disposed);
        IBreakpoints service = (IBreakpoints)channel.getRemoteService(IBreakpoints.class);
        if (service != null) {
            if (this.channels.isEmpty()) {
                this.bp_manager.addBreakpointListener((IBreakpointListener)this);
                this.bp_manager.addBreakpointManagerListener((IBreakpointManagerListener)this);
            }
            this.channels.add(channel);
            channel.addChannelListener(new IChannel.IChannelListener(){

                public void congestionLevel(int level) {
                }

                public void onChannelClosed(Throwable error) {
                    if (TCFBreakpointsModel.this.disposed) {
                        return;
                    }
                    TCFBreakpointsModel.this.channels.remove(channel);
                    if (TCFBreakpointsModel.this.channels.isEmpty()) {
                        TCFBreakpointsModel.this.bp_manager.removeBreakpointListener((IBreakpointListener)TCFBreakpointsModel.this);
                        TCFBreakpointsModel.this.bp_manager.removeBreakpointManagerListener((IBreakpointManagerListener)TCFBreakpointsModel.this);
                        TCFBreakpointsModel.this.id2bp.clear();
                    }
                }

                public void onChannelOpened() {
                }
            });
            IBreakpoint[] arr = this.bp_manager.getBreakpoints();
            if (arr != null && arr.length > 0) {
                ArrayList<Map<String, Object>> bps = new ArrayList<Map<String, Object>>(arr.length);
                int i = 0;
                while (i < arr.length) {
                    String id;
                    if (this.isSupported(channel, arr[i]) && (id = this.getBreakpointID(arr[i])) != null && arr[i].isPersisted()) {
                        IMarker marker = arr[i].getMarker();
                        String file = this.getFilePath(marker.getResource());
                        bps.add(this.toBreakpointAttributes(channel, id, file, marker.getType(), marker.getAttributes()));
                        this.id2bp.put(id, arr[i]);
                    }
                    ++i;
                }
                if (!bps.isEmpty()) {
                    Map[] bpArr = bps.toArray(new Map[bps.size()]);
                    service.set(bpArr, new IBreakpoints.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            if (error == null) {
                                done.run();
                            } else {
                                channel.terminate((Throwable)error);
                            }
                        }
                    });
                    return;
                }
            }
        }
        Protocol.invokeLater((Runnable)done);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointManagerEnablementChanged(final boolean enabled) {
        try {
            IBreakpoint[] arr = this.bp_manager.getBreakpoints();
            if (arr == null || arr.length == 0) {
                return;
            }
            final HashMap<String, IBreakpoint> map = new HashMap<String, IBreakpoint>();
            int i = 0;
            while (i < arr.length) {
                String id;
                IMarker marker = arr[i].getMarker();
                Boolean b = marker.getAttribute("org.eclipse.debug.core.enabled", Boolean.FALSE.booleanValue());
                if (b.booleanValue() && (id = this.getBreakpointID(arr[i])) != null) {
                    map.put(id, arr[i]);
                }
                ++i;
            }
            if (map.isEmpty()) {
                return;
            }
            Runnable r = new Runnable(){

                public void run() {
                    if (TCFBreakpointsModel.this.disposed) {
                        return;
                    }
                    for (final IChannel channel : TCFBreakpointsModel.this.channels) {
                        IBreakpoints service = (IBreakpoints)channel.getRemoteService(IBreakpoints.class);
                        HashSet<String> ids = new HashSet<String>();
                        for (String id : map.keySet()) {
                            IBreakpoint bp = (IBreakpoint)map.get(id);
                            if (!TCFBreakpointsModel.this.isSupported(channel, bp)) continue;
                            ids.add(id);
                        }
                        IBreakpoints.DoneCommand done = new IBreakpoints.DoneCommand(){

                            public void doneCommand(IToken token, Exception error) {
                                if (error != null) {
                                    channel.terminate((Throwable)error);
                                }
                            }
                        };
                        if (enabled) {
                            service.enable(ids.toArray(new String[ids.size()]), done);
                            continue;
                        }
                        service.disable(ids.toArray(new String[ids.size()]), done);
                    }
                    Protocol.sync((Runnable)new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Map map2 = map;
                            synchronized (map2) {
                                map.notify();
                            }
                        }
                    });
                }
            };
            HashMap<String, IBreakpoint> hashMap = map;
            synchronized (hashMap) {
                assert (!Protocol.isDispatchThread());
                Protocol.invokeLater((Runnable)r);
                map.wait();
            }
        }
        catch (Throwable x) {
            Activator.log("Unhandled exception in breakpoint listener", x);
        }
    }

    private String getFilePath(IResource resource) throws IOException {
        if (resource == ResourcesPlugin.getWorkspace().getRoot()) {
            return null;
        }
        IPath p = resource.getRawLocation();
        if (p == null) {
            return null;
        }
        return p.toFile().getCanonicalPath();
    }

    public void breakpointAdded(final IBreakpoint breakpoint) {
        try {
            new BreakpointUpdate(breakpoint){

                void update() {
                    if (!Boolean.FALSE.equals(this.marker_attrs.get("org.eclipse.debug.core.persisted"))) {
                        this.service.add(this.tcf_attrs, this.done);
                    }
                    TCFBreakpointsModel.this.id2bp.put((String)this.tcf_attrs.get("ID"), breakpoint);
                }
            }.exec();
        }
        catch (Throwable x) {
            Activator.log("Unhandled exception in breakpoint listener", x);
        }
    }

    private Set<String> calcMarkerDeltaKeys(IMarker marker, IMarkerDelta delta) throws CoreException {
        HashSet<String> keys = new HashSet<String>();
        if (delta == null) {
            return keys;
        }
        Map m0 = delta.getAttributes();
        Map m1 = marker.getAttributes();
        if (m0 != null) {
            keys.addAll(m0.keySet());
        }
        if (m1 != null) {
            keys.addAll(m1.keySet());
        }
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            Object v1;
            String key = (String)i.next();
            Object v0 = m0 != null ? (Object)m0.get(key) : null;
            Object v02 = v1 = m1 != null ? m1.get(key) : null;
            if (v0 instanceof String && ((String)v0).length() == 0) {
                v0 = null;
            }
            if (v1 instanceof String && ((String)v1).length() == 0) {
                v1 = null;
            }
            if (v0 instanceof Boolean && !((Boolean)v0).booleanValue()) {
                v0 = null;
            }
            if (v1 instanceof Boolean && !((Boolean)v1).booleanValue()) {
                v1 = null;
            }
            if (v0 == null != (v1 == null) || v0 != null && !v0.equals(v1)) continue;
            i.remove();
        }
        keys.remove("org.eclipse.cdt.debug.core.installCount");
        return keys;
    }

    public void breakpointChanged(final IBreakpoint breakpoint, IMarkerDelta delta) {
        try {
            final Set<String> s = this.calcMarkerDeltaKeys(breakpoint.getMarker(), delta);
            if (s.isEmpty()) {
                return;
            }
            new BreakpointUpdate(breakpoint){

                void update() {
                    String id = (String)this.tcf_attrs.get("ID");
                    if (s.size() == 1 && s.contains("org.eclipse.debug.core.enabled")) {
                        Boolean enabled = (Boolean)this.tcf_attrs.get("Enabled");
                        if (enabled == null || !enabled.booleanValue()) {
                            this.service.disable(new String[]{id}, this.done);
                        } else {
                            this.service.enable(new String[]{id}, this.done);
                        }
                    } else {
                        this.service.change(this.tcf_attrs, this.done);
                    }
                    TCFBreakpointsModel.this.id2bp.put(id, breakpoint);
                }
            }.exec();
        }
        catch (Throwable x) {
            Activator.log("Unhandled exception in breakpoint listener", x);
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        try {
            new BreakpointUpdate(breakpoint){

                void update() {
                    String id = (String)this.tcf_attrs.get("ID");
                    if (!Boolean.FALSE.equals(this.marker_attrs.get("org.eclipse.debug.core.persisted"))) {
                        this.service.remove(new String[]{id}, this.done);
                    }
                    TCFBreakpointsModel.this.id2bp.remove(id);
                }
            }.exec();
        }
        catch (Throwable x) {
            Activator.log("Unhandled exception in breakpoint listener", x);
        }
    }

    public Map<String, Object> toMarkerAttributes(Map<String, Object> p) {
        assert (!this.disposed);
        assert (Protocol.isDispatchThread());
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : p.entrySet()) {
            String key = e.getKey();
            Object val = e.getValue();
            if (key.equals("Enabled") || key.equals("File") || key.equals("Line") || key.equals("Column")) continue;
            m.put("org.eclipse.tm.tcf.debug." + key, val);
        }
        Boolean enabled = (Boolean)p.get("Enabled");
        if (enabled == null) {
            m.put("org.eclipse.debug.core.enabled", Boolean.FALSE);
        } else {
            m.put("org.eclipse.debug.core.enabled", enabled);
        }
        m.put("org.eclipse.debug.core.registered", Boolean.TRUE);
        m.put("org.eclipse.debug.core.persisted", Boolean.TRUE);
        m.put("org.eclipse.debug.core.id", "org.eclipse.tm.tcf.debug");
        String msg = "";
        if (p.get("Location") != null) {
            msg = String.valueOf(msg) + p.get("Location");
        }
        m.put("message", "Breakpoint: " + msg);
        Number line = (Number)p.get("Line");
        if (line != null) {
            m.put("lineNumber", new Integer(line.intValue()));
            Number column = (Number)p.get("Column");
            if (column != null) {
                m.put("charStart", new Integer(column.intValue()));
                m.put("charEnd", new Integer(column.intValue() + 1));
            }
        }
        return m;
    }

    public Map<String, Object> toBreakpointAttributes(IChannel channel, String id, String file, String type, Map<String, Object> p) {
        Integer skip_count;
        String condition;
        String address;
        String expr;
        assert (!this.disposed);
        assert (Protocol.isDispatchThread());
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("ID", id);
        for (Map.Entry<String, Object> e : p.entrySet()) {
            String key = e.getKey();
            String[] val = e.getValue();
            if (!key.startsWith("org.eclipse.tm.tcf.debug")) continue;
            String tcfKey = key.substring("org.eclipse.tm.tcf.debug".length() + 1);
            if ("ContextIds".equals(tcfKey)) {
                val = this.filterContextIds(channel, ((String)val).split(",\\s*"));
            }
            m.put(tcfKey, val);
        }
        Boolean enabled = (Boolean)p.get("org.eclipse.debug.core.enabled");
        if (enabled != null && enabled.booleanValue() && this.bp_manager.isEnabled()) {
            m.put("Enabled", enabled);
        }
        if (file == null) {
            file = (String)p.get("org.eclipse.cdt.debug.core.sourceHandle");
        }
        if (file != null && file.length() > 0) {
            int i = file.lastIndexOf(47);
            int j = file.lastIndexOf(92);
            String name = file;
            if (i > j) {
                name = file.substring(i + 1);
            } else if (i < j) {
                name = file.substring(j + 1);
            }
            m.put("File", name);
            Integer line = (Integer)p.get("lineNumber");
            if (line != null) {
                m.put("Line", new Integer(line));
                Integer column = (Integer)p.get("charStart");
                if (column != null) {
                    m.put("Column", column);
                }
            }
        }
        if ("org.eclipse.cdt.debug.core.cWatchpointMarker".equals(type)) {
            expr = (String)p.get("org.eclipse.cdt.debug.core.expression");
            if (expr != null && expr.length() != 0) {
                int size;
                boolean writeAccess = Boolean.TRUE.equals(p.get("org.eclipse.cdt.debug.core.write"));
                boolean readAccess = Boolean.TRUE.equals(p.get("org.eclipse.cdt.debug.core.read"));
                int accessMode = 0;
                if (readAccess) {
                    accessMode |= 1;
                }
                if (writeAccess) {
                    accessMode |= 2;
                }
                m.put("AccessMode", accessMode);
                Object range = p.get("org.eclipse.cdt.debug.core.range");
                if (range != null && (size = Integer.parseInt(range.toString())) > 0) {
                    m.put("Size", size);
                }
                if (!Character.isDigit(expr.charAt(0))) {
                    expr = "&(" + expr + ')';
                }
                m.put("Location", expr);
            }
        } else if ("org.eclipse.cdt.debug.core.cFunctionBreakpointMarker".equals(type)) {
            expr = (String)p.get("org.eclipse.cdt.debug.core.function");
            if (expr != null && expr.length() != 0) {
                m.put("Location", expr);
            }
        } else if (file == null && (address = (String)p.get("org.eclipse.cdt.debug.core.address")) != null && address.length() > 0) {
            m.put("Location", address);
        }
        if ((condition = (String)p.get("org.eclipse.cdt.debug.core.condition")) != null && condition.length() > 0) {
            m.put("Condition", condition);
        }
        if ((skip_count = (Integer)p.get("org.eclipse.cdt.debug.core.ignoreCount")) != null && skip_count > 0) {
            m.put("IgnoreCount", skip_count);
        }
        return m;
    }

    private String[] filterContextIds(IChannel channel, String[] scopeIds) {
        String sessionId = this.getSessionId(channel);
        ArrayList<String> contextIds = new ArrayList<String>();
        String[] stringArray = scopeIds;
        int n = scopeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String scopeId = stringArray[n2];
            if (scopeId.length() != 0) {
                int slash = scopeId.indexOf(47);
                if (slash < 0) {
                    contextIds.add(scopeId);
                } else if (sessionId != null && sessionId.equals(scopeId.substring(0, slash))) {
                    contextIds.add(scopeId.substring(slash + 1));
                }
            }
            ++n2;
        }
        return contextIds.toArray(new String[contextIds.size()]);
    }

    private String getSessionId(IChannel channel) {
        ILaunch[] launches;
        ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof TCFLaunch && channel == ((TCFLaunch)launch).getChannel()) {
                ILaunchConfiguration lc = launch.getLaunchConfiguration();
                return lc != null ? lc.getName() : null;
            }
            ++n2;
        }
        return null;
    }

    private abstract class BreakpointUpdate
    implements Runnable {
        private final IBreakpoint breakpoint;
        protected final Map<String, Object> marker_attrs;
        private final String marker_file;
        private final String marker_type;
        private final String marker_id;
        IBreakpoints service;
        IBreakpoints.DoneCommand done;
        Map<String, Object> tcf_attrs;

        BreakpointUpdate(IBreakpoint breakpoint) throws CoreException, IOException {
            this.breakpoint = breakpoint;
            this.marker_attrs = new HashMap<String, Object>(breakpoint.getMarker().getAttributes());
            this.marker_file = TCFBreakpointsModel.this.getFilePath(breakpoint.getMarker().getResource());
            this.marker_type = breakpoint.getMarker().getType();
            this.marker_id = TCFBreakpointsModel.this.getBreakpointID(breakpoint);
        }

        synchronized void exec() throws InterruptedException {
            assert (!Protocol.isDispatchThread());
            if (this.marker_id != null) {
                Protocol.invokeLater((Runnable)this);
                this.wait();
            }
        }

        public void run() {
            if (TCFBreakpointsModel.this.disposed) {
                return;
            }
            for (final IChannel channel : TCFBreakpointsModel.this.channels) {
                this.tcf_attrs = TCFBreakpointsModel.this.toBreakpointAttributes(channel, this.marker_id, this.marker_file, this.marker_type, this.marker_attrs);
                this.service = (IBreakpoints)channel.getRemoteService(IBreakpoints.class);
                if (!TCFBreakpointsModel.this.isSupported(channel, this.breakpoint)) continue;
                this.done = new IBreakpoints.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null) {
                            channel.terminate((Throwable)error);
                        }
                    }
                };
                this.update();
            }
            Protocol.sync((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    BreakpointUpdate breakpointUpdate = BreakpointUpdate.this;
                    synchronized (breakpointUpdate) {
                        BreakpointUpdate.this.notify();
                    }
                }
            });
        }

        abstract void update();
    }
}

