/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edu.internal.ui.sourcelookup;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.edc.internal.launch.CSourceLookup;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edu.internal.ui.sourcelookup.InstructionPointerManager;
import org.eclipse.cdt.debug.edu.internal.ui.sourcelookup.SourceLookupResult;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceNotFoundElement;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.CSourceNotFoundEditorInput;
import org.eclipse.cdt.debug.ui.ICDebugUIConstants;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.ui.sourcelookup.IInstructionPointerPresentation;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

@ThreadSafe
public class EDCSourceDisplayAdapter
implements ISourceDisplay,
SteppingController.ISteppingControlParticipant {
    private static final boolean DEBUG = false;
    private DsfSession fSession;
    private DsfExecutor fExecutor;
    private DsfServicesTracker fServicesTracker;
    private FrameData fPrevFrameData;
    private SourceLookupResult fPrevResult;
    private InstructionPointerManager fIPManager;
    private LookupJob fRunningLookupJob;
    private DisplayJob fRunningDisplayJob;
    private DisplayJob fPendingDisplayJob;
    private ClearingJob fRunningClearingJob;
    private Set<IRunControl.IExecutionDMContext> fPendingExecDmcsToClear = new HashSet<IRunControl.IExecutionDMContext>();
    private SteppingController fController;
    private int fSelectionChangeDelay = 150;
    private long fStepStartTime = 0L;
    private long fLastStepTime = 0L;
    private long fStepCount;
    private boolean fEnableLineBackgroundPainter;

    public EDCSourceDisplayAdapter(DsfSession session) {
        this(session, null);
    }

    public EDCSourceDisplayAdapter(DsfSession session, SteppingController controller) {
        this.fSession = session;
        this.fExecutor = session.getExecutor();
        this.fServicesTracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), session.getId());
        IInstructionPointerPresentation ipPresentation = (IInstructionPointerPresentation)session.getModelAdapter(IInstructionPointerPresentation.class);
        this.fIPManager = new InstructionPointerManager(ipPresentation);
        this.fExecutor.execute((Runnable)new DsfRunnable(){

            public void run() {
                EDCSourceDisplayAdapter.this.fSession.addServiceEventListener((Object)EDCSourceDisplayAdapter.this, null);
            }
        });
        this.fController = controller;
        if (this.fController != null) {
            this.fController.addSteppingControlParticipant((SteppingController.ISteppingControlParticipant)this);
        }
    }

    public void setSelectionChangeDelay(int delay) {
        this.fSelectionChangeDelay = delay;
    }

    public void dispose() {
        if (this.fController != null) {
            this.fController.removeSteppingControlParticipant((SteppingController.ISteppingControlParticipant)this);
            this.fController = null;
        }
        try {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    EDCSourceDisplayAdapter.this.fSession.removeServiceEventListener((Object)EDCSourceDisplayAdapter.this);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
        this.fServicesTracker.dispose();
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    EDCSourceDisplayAdapter.this.enableLineBackgroundPainter();
                    EDCSourceDisplayAdapter.this.fIPManager.removeAllAnnotations();
                }
            });
        }
    }

    public void displaySource(Object context, IWorkbenchPage page, boolean force) {
        this.fStepCount = 0L;
        IStack.IFrameDMContext displayFrame = null;
        if (context instanceof IDMVMContext) {
            IDMContext dmc = ((IDMVMContext)context).getDMContext();
            if (dmc instanceof IStack.IFrameDMContext) {
                displayFrame = (IStack.IFrameDMContext)dmc;
            }
        } else if (context instanceof IStack.IFrameDMContext) {
            displayFrame = (IStack.IFrameDMContext)context;
        }
        if (displayFrame != null) {
            this.doDisplaySource(displayFrame, page, force, false);
        }
    }

    private void doDisplaySource(final IStack.IFrameDMContext context, final IWorkbenchPage page, final boolean force, final boolean eventTriggered) {
        if (context.getLevel() < 0) {
            return;
        }
        this.fExecutor.execute((Runnable)new DsfRunnable(){

            public void run() {
                IStack stackService = (IStack)EDCSourceDisplayAdapter.this.fServicesTracker.getService(IStack.class);
                if (stackService == null) {
                    return;
                }
                stackService.getFrameData(context, (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMData>((Executor)EDCSourceDisplayAdapter.this.fExecutor, null){

                    public void handleSuccess() {
                        FrameData frameData = new FrameData();
                        frameData.fDmc = context;
                        frameData.fLevel = context.getLevel();
                        IStack.IFrameDMData data = (IStack.IFrameDMData)this.getData();
                        frameData.fLine = data.getLine() - 1;
                        frameData.fFile = data.getFile();
                        if (!force && frameData.equals(EDCSourceDisplayAdapter.this.fPrevFrameData)) {
                            EDCSourceDisplayAdapter.this.fPrevResult.updateArtifact((IDMContext)context);
                            EDCSourceDisplayAdapter.this.startDisplayJob(EDCSourceDisplayAdapter.this.fPrevResult, frameData, page, eventTriggered);
                        } else {
                            CSourceLookup lookup = (CSourceLookup)EDCSourceDisplayAdapter.this.fServicesTracker.getService(CSourceLookup.class);
                            RunControl runControl = (RunControl)EDCSourceDisplayAdapter.this.fServicesTracker.getService(RunControl.class);
                            CSourceLookupDirector[] directors = lookup.getSourceLookupDirectors((ISourceLookup.ISourceLookupDMContext)runControl.getRootDMC());
                            EDCSourceDisplayAdapter.this.startLookupJob(frameData, page, eventTriggered, directors);
                        }
                    }

                    protected void handleFailure() {
                        EDCSourceDisplayAdapter.this.doneStepping((IDMContext)context);
                    }

                    protected void handleRejectedExecutionException() {
                        EDCSourceDisplayAdapter.this.doneStepping((IDMContext)context);
                    }
                });
            }
        });
    }

    private void executeFromJob(Runnable runnable) {
        try {
            this.fExecutor.execute(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
    }

    private void startLookupJob(FrameData frameData, IWorkbenchPage page, boolean eventTriggered, CSourceLookupDirector[] directors) {
        if (this.fRunningLookupJob != null) {
            this.fRunningLookupJob.cancel();
        }
        this.fRunningLookupJob = new LookupJob(frameData, page, eventTriggered, directors);
        this.fRunningLookupJob.schedule();
    }

    private void startDisplayJob(SourceLookupResult lookupResult, FrameData frameData, IWorkbenchPage page, boolean eventTriggered) {
        DisplayJob nextDisplayJob = new DisplayJob(lookupResult, frameData, page, eventTriggered);
        if (this.fRunningDisplayJob != null) {
            this.fPendingDisplayJob = null;
            IRunControl.IExecutionDMContext[] execCtxs = (IRunControl.IExecutionDMContext[])DMContexts.getAllAncestorsOfType((IDMContext)frameData.fDmc, IRunControl.IExecutionDMContext.class);
            this.fPendingExecDmcsToClear.removeAll(Arrays.asList(execCtxs));
            if (!eventTriggered && frameData.isIdentical(this.fRunningDisplayJob.fFrameData)) {
                return;
            }
            this.fRunningDisplayJob.cancel();
        }
        if (this.fRunningClearingJob != null) {
            this.fPendingDisplayJob = nextDisplayJob;
        } else {
            this.fRunningDisplayJob = nextDisplayJob;
            this.fRunningDisplayJob.schedule();
        }
    }

    private void doneStepping(IDMContext context) {
        IRunControl.IExecutionDMContext dmc;
        if (this.fController != null && (dmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IRunControl.IExecutionDMContext.class)) != null) {
            try {
                this.fController.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        EDCSourceDisplayAdapter.this.fController.doneStepping(dmc, (SteppingController.ISteppingControlParticipant)EDCSourceDisplayAdapter.this);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        }
    }

    private void serviceDisplayAndClearingJobs() {
        if (!this.fPendingExecDmcsToClear.isEmpty()) {
            this.fRunningClearingJob = new ClearingJob(this.fPendingExecDmcsToClear);
            this.fRunningClearingJob.schedule();
            this.fPendingExecDmcsToClear = new HashSet<IRunControl.IExecutionDMContext>();
        } else if (this.fPendingDisplayJob != null) {
            this.fRunningDisplayJob = this.fPendingDisplayJob;
            this.fRunningDisplayJob.schedule();
            this.fPendingDisplayJob = null;
        }
    }

    private void startAnnotationClearingJob(IRunControl.IExecutionDMContext execDmc) {
        this.fPendingExecDmcsToClear.add(execDmc);
        if (this.fRunningLookupJob != null && DMContexts.isAncestorOf((IDMContext)this.fRunningLookupJob.getDmc(), (IDMContext)execDmc)) {
            this.fRunningLookupJob.cancel();
            this.fRunningLookupJob = null;
        }
        if (this.fPendingDisplayJob != null && DMContexts.isAncestorOf((IDMContext)this.fPendingDisplayJob.getDmc(), (IDMContext)execDmc)) {
            this.fPendingDisplayJob = null;
        }
        if (this.fRunningClearingJob == null && this.fRunningDisplayJob == null) {
            this.fRunningClearingJob = new ClearingJob(this.fPendingExecDmcsToClear);
            this.fRunningClearingJob.schedule();
            this.fPendingExecDmcsToClear = new HashSet<IRunControl.IExecutionDMContext>();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        if (e.getReason() != IRunControl.StateChangeReason.STEP) {
            this.startAnnotationClearingJob((IRunControl.IExecutionDMContext)e.getDMContext());
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        this.startAnnotationClearingJob((IRunControl.IExecutionDMContext)e.getDMContext());
    }

    @DsfServiceEventHandler
    public void eventDispatched(SteppingController.SteppingTimedOutEvent e) {
        this.startAnnotationClearingJob((IRunControl.IExecutionDMContext)e.getDMContext());
    }

    @DsfServiceEventHandler
    public void eventDispatched(final IRunControl.ISuspendedDMEvent e) {
        this.updateStepTiming();
        if (e.getReason() == IRunControl.StateChangeReason.STEP || e.getReason() == IRunControl.StateChangeReason.BREAKPOINT) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IDMContext dmc;
                    IAdaptable context = DebugUITools.getDebugContext();
                    if (context instanceof IDMVMContext && (dmc = ((IDMVMContext)context).getDMContext()) instanceof IStack.IFrameDMContext && DMContexts.isAncestorOf((IDMContext)dmc, (IDMContext)e.getDMContext())) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        EDCSourceDisplayAdapter.this.doDisplaySource((IStack.IFrameDMContext)dmc, page, false, true);
                        return;
                    }
                    EDCSourceDisplayAdapter.this.doneStepping(e.getDMContext());
                }
            });
        } else {
            this.doneStepping(e.getDMContext());
        }
    }

    private void updateStepTiming() {
        long now = System.currentTimeMillis();
        if (now - this.fLastStepTime > (long)Math.max(this.fSelectionChangeDelay, 200)) {
            this.fStepCount = 0L;
            this.fStepStartTime = this.fLastStepTime = now;
            return;
        }
        this.fLastStepTime = now;
        ++this.fStepCount;
    }

    private void disableLineBackgroundPainter() {
        if (!this.fEnableLineBackgroundPainter) {
            this.fEnableLineBackgroundPainter = EditorsUI.getPreferenceStore().getBoolean("currentLine");
            if (this.fEnableLineBackgroundPainter) {
                EditorsUI.getPreferenceStore().setValue("currentLine", false);
            }
        }
    }

    private void enableLineBackgroundPainter() {
        if (this.fEnableLineBackgroundPainter) {
            this.fEnableLineBackgroundPainter = false;
            EditorsUI.getPreferenceStore().setValue("currentLine", true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClearingJob
    extends UIJob {
        Set<IRunControl.IExecutionDMContext> fDmcsToClear;

        public ClearingJob(Set<IRunControl.IExecutionDMContext> dmcs) {
            super("Debug Source Display");
            this.setSystem(true);
            this.setPriority(10);
            this.fDmcsToClear = dmcs;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            DsfRunnable clearingJobFinishedRunnable = new DsfRunnable(){

                public void run() {
                    if (!$assertionsDisabled && EDCSourceDisplayAdapter.this.fRunningClearingJob != ClearingJob.this) {
                        throw new AssertionError();
                    }
                    EDCSourceDisplayAdapter.this.fRunningClearingJob = null;
                    EDCSourceDisplayAdapter.this.serviceDisplayAndClearingJobs();
                }
            };
            EDCSourceDisplayAdapter.this.enableLineBackgroundPainter();
            if (monitor.isCanceled()) {
                EDCSourceDisplayAdapter.this.executeFromJob((Runnable)clearingJobFinishedRunnable);
                return Status.CANCEL_STATUS;
            }
            for (IRunControl.IExecutionDMContext dmc : this.fDmcsToClear) {
                EDCSourceDisplayAdapter.this.fIPManager.removeAnnotations(dmc);
            }
            EDCSourceDisplayAdapter.this.executeFromJob((Runnable)clearingJobFinishedRunnable);
            return Status.OK_STATUS;
        }
    }

    class DisplayJob
    extends UIJob {
        private final SourceLookupResult fResult;
        private final IWorkbenchPage fPage;
        private final FrameData fFrameData;
        private final DsfRunnable fDisplayJobFinishedRunnable;
        private final AtomicBoolean fDoneStepping;
        private IRegion fRegion;
        private ITextViewer fTextViewer;
        private final boolean fEventTriggered;

        IDMContext getDmc() {
            return this.fResult.getDmc();
        }

        public DisplayJob(SourceLookupResult result, FrameData frameData, IWorkbenchPage page, boolean eventTriggered) {
            super("Debug Source Display");
            this.fDisplayJobFinishedRunnable = new DsfRunnable(){

                public void run() {
                    if (EDCSourceDisplayAdapter.this.fRunningDisplayJob == DisplayJob.this) {
                        EDCSourceDisplayAdapter.this.fRunningDisplayJob = null;
                        if (DisplayJob.this.fEventTriggered && !DisplayJob.this.fDoneStepping.getAndSet(true)) {
                            EDCSourceDisplayAdapter.this.doneStepping(DisplayJob.this.fResult.getDmc());
                        }
                        EDCSourceDisplayAdapter.this.serviceDisplayAndClearingJobs();
                    }
                }
            };
            this.fDoneStepping = new AtomicBoolean(false);
            this.setSystem(true);
            this.setPriority(10);
            this.fResult = result;
            this.fFrameData = frameData;
            this.fPage = page;
            this.fEventTriggered = eventTriggered;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                EDCSourceDisplayAdapter.this.executeFromJob((Runnable)this.fDisplayJobFinishedRunnable);
                return Status.CANCEL_STATUS;
            }
            if (this.fRegion != null && this.fTextViewer != null) {
                if (EDCSourceDisplayAdapter.this.fRunningDisplayJob == this) {
                    if (!this.shouldCancelSelectionChange()) {
                        EDCSourceDisplayAdapter.this.enableLineBackgroundPainter();
                        this.fTextViewer.setSelectedRange(this.fRegion.getOffset(), 0);
                    }
                    EDCSourceDisplayAdapter.this.executeFromJob((Runnable)this.fDisplayJobFinishedRunnable);
                }
            } else {
                IEditorPart editor = this.openEditor(this.fResult, this.fPage);
                if (editor == null) {
                    EDCSourceDisplayAdapter.this.executeFromJob((Runnable)this.fDisplayJobFinishedRunnable);
                    return Status.OK_STATUS;
                }
                ITextEditor textEditor = null;
                textEditor = editor instanceof ITextEditor ? (ITextEditor)editor : (ITextEditor)editor.getAdapter(ITextEditor.class);
                if (textEditor != null && this.positionEditor(textEditor, this.fFrameData)) {
                    return Status.OK_STATUS;
                }
                EDCSourceDisplayAdapter.this.executeFromJob((Runnable)this.fDisplayJobFinishedRunnable);
            }
            return Status.OK_STATUS;
        }

        private boolean shouldCancelSelectionChange() {
            Query<Boolean> delaySelectionChangeQuery = new Query<Boolean>(){

                protected void execute(DataRequestMonitor<Boolean> rm) {
                    IRunControl.IExecutionDMContext execCtx = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((DisplayJob)DisplayJob.this).fFrameData.fDmc, IRunControl.IExecutionDMContext.class);
                    IRunControl runControl = (IRunControl)EDCSourceDisplayAdapter.this.fServicesTracker.getService(IRunControl.class);
                    rm.setData((Object)(runControl != null && execCtx != null && (EDCSourceDisplayAdapter.this.fController != null && EDCSourceDisplayAdapter.this.fController.getPendingStepCount(execCtx) != 0 || runControl.isStepping(execCtx)) ? 1 : 0));
                    rm.done();
                }
            };
            try {
                EDCSourceDisplayAdapter.this.fExecutor.execute((Runnable)delaySelectionChangeQuery);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                return false;
            }
            try {
                return (Boolean)delaySelectionChangeQuery.get();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (ExecutionException executionException) {
                return false;
            }
        }

        private IEditorPart openEditor(SourceLookupResult result, IWorkbenchPage page) {
            IEditorInput input = result.getEditorInput();
            String id = result.getEditorId();
            if (input == null || id == null) {
                return null;
            }
            return this.openEditor(page, input, id);
        }

        private IEditorPart openEditor(final IWorkbenchPage page, final IEditorInput input, final String id) {
            final IEditorPart[] editor = new IEditorPart[1];
            Runnable r = new Runnable(){

                public void run() {
                    if (!page.getWorkbenchWindow().getWorkbench().isClosing()) {
                        try {
                            if (input instanceof CSourceNotFoundEditorInput) {
                                IReusableEditor re;
                                editor[0] = page.openEditor(input, id, false, 2);
                                if (editor[0] instanceof IReusableEditor && !input.equals((re = (IReusableEditor)editor[0]).getEditorInput())) {
                                    re.setInput(input);
                                }
                            } else {
                                editor[0] = page.openEditor(input, id, false);
                            }
                        }
                        catch (PartInitException partInitException) {}
                    }
                }
            };
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)r);
            return editor[0];
        }

        private boolean positionEditor(ITextEditor editor, FrameData frameData) {
            this.fRegion = this.getLineInformation(editor, frameData.fLine);
            if (this.fRegion != null) {
                EDCSourceDisplayAdapter.this.fIPManager.addAnnotation(editor, frameData.fDmc, new Position(this.fRegion.getOffset(), this.fRegion.getLength()), frameData.fLevel == 0);
                Object tot = editor.getAdapter(ITextOperationTarget.class);
                if (tot instanceof ITextViewer) {
                    this.fTextViewer = (ITextViewer)tot;
                    int widgetLine = frameData.fLine;
                    if (tot instanceof ITextViewerExtension5) {
                        ITextViewerExtension5 ext5 = (ITextViewerExtension5)tot;
                        ext5.exposeModelRange(this.fRegion);
                        widgetLine = ext5.modelLine2WidgetLine(widgetLine);
                    }
                    this.revealLine(this.fTextViewer, widgetLine);
                    if (EDCSourceDisplayAdapter.this.fStepCount > 0L && EDCSourceDisplayAdapter.this.fSelectionChangeDelay > 0) {
                        EDCSourceDisplayAdapter.this.disableLineBackgroundPainter();
                        this.schedule(EDCSourceDisplayAdapter.this.fSelectionChangeDelay);
                        if (!this.fDoneStepping.getAndSet(true)) {
                            EDCSourceDisplayAdapter.this.doneStepping(this.getDmc());
                        }
                        return true;
                    }
                    EDCSourceDisplayAdapter.this.enableLineBackgroundPainter();
                    this.fTextViewer.setSelectedRange(this.fRegion.getOffset(), 0);
                } else {
                    editor.selectAndReveal(this.fRegion.getOffset(), 0);
                }
            }
            return false;
        }

        private void revealLine(ITextViewer viewer, int focusLine) {
            StyledText textWidget = viewer.getTextWidget();
            int top = textWidget.getTopIndex();
            if (top > -1) {
                int lines = this.getEstimatedVisibleLinesInViewport(textWidget);
                int bottom = top + lines;
                int bottomBuffer = Math.max(1, lines / 3);
                if (focusLine < top || focusLine > bottom - bottomBuffer) {
                    if (focusLine > bottom - bottomBuffer && focusLine <= bottom) {
                        int scrollDelta = focusLine - (bottom - bottomBuffer);
                        textWidget.setTopIndex(top + scrollDelta);
                    } else {
                        int topBuffer = lines / 3;
                        textWidget.setTopIndex(Math.max(0, focusLine - topBuffer));
                    }
                }
            }
        }

        private int getEstimatedVisibleLinesInViewport(StyledText textWidget) {
            Rectangle clArea;
            if (textWidget != null && !(clArea = textWidget.getClientArea()).isEmpty()) {
                return clArea.height / textWidget.getLineHeight();
            }
            return -1;
        }

        private IRegion getLineInformation(ITextEditor editor, int lineNumber) {
            IDocumentProvider provider = editor.getDocumentProvider();
            IEditorInput input = editor.getEditorInput();
            try {
                provider.connect((Object)input);
            }
            catch (CoreException coreException) {
                return null;
            }
            try {
                IDocument document = provider.getDocument((Object)input);
                if (document != null) {
                    IRegion iRegion = document.getLineInformation(lineNumber);
                    return iRegion;
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                provider.disconnect((Object)input);
            }
            return null;
        }
    }

    private static final class FrameData {
        IStack.IFrameDMContext fDmc;
        int fLine;
        int fLevel;
        String fFile;

        private FrameData() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FrameData other = (FrameData)obj;
            if (!this.fDmc.equals(other.fDmc)) {
                return false;
            }
            return !(this.fFile == null ? other.fFile != null : !this.fFile.equals(other.fFile));
        }

        public boolean isIdentical(FrameData frameData) {
            return this.equals(frameData) && this.fLine == frameData.fLine;
        }
    }

    class LookupJob
    extends Job {
        private final IWorkbenchPage fPage;
        private final FrameData fFrameData;
        private final boolean fEventTriggered;
        private CSourceLookupDirector[] fDirectors;

        public LookupJob(FrameData frameData, IWorkbenchPage page, boolean eventTriggered, CSourceLookupDirector[] directors) {
            super("DSF Source Lookup");
            this.setPriority(10);
            this.setSystem(true);
            this.fFrameData = frameData;
            this.fPage = page;
            this.fEventTriggered = eventTriggered;
            this.fDirectors = directors;
        }

        IDMContext getDmc() {
            return this.fFrameData.fDmc;
        }

        protected IStatus run(final IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            final SourceLookupResult result = this.performLookup(this.fDirectors);
            EDCSourceDisplayAdapter.this.executeFromJob((Runnable)new DsfRunnable(){

                public void run() {
                    if (!monitor.isCanceled()) {
                        EDCSourceDisplayAdapter.this.fPrevResult = result;
                        EDCSourceDisplayAdapter.this.fPrevFrameData = LookupJob.this.fFrameData;
                        EDCSourceDisplayAdapter.this.fRunningLookupJob = null;
                        EDCSourceDisplayAdapter.this.startDisplayJob(EDCSourceDisplayAdapter.this.fPrevResult, LookupJob.this.fFrameData, LookupJob.this.fPage, LookupJob.this.fEventTriggered);
                    }
                }
            });
            return Status.OK_STATUS;
        }

        private SourceLookupResult performLookup(CSourceLookupDirector[] directors) {
            IStack.IFrameDMContext dmc = this.fFrameData.fDmc;
            SourceLookupResult result = new SourceLookupResult((IDMContext)dmc, null, null, null);
            String editorId = null;
            CSourceNotFoundEditorInput editorInput = null;
            Object sourceElement = null;
            CSourceLookupDirector[] cSourceLookupDirectorArray = directors;
            int n = directors.length;
            int n2 = 0;
            while (n2 < n) {
                CSourceLookupDirector director = cSourceLookupDirectorArray[n2];
                sourceElement = director.getSourceElement((Object)dmc);
                if (sourceElement != null) {
                    ISourcePresentation presentation = null;
                    if (director instanceof ISourcePresentation) {
                        presentation = (ISourcePresentation)director;
                    } else if (dmc != null) {
                        presentation = (ISourcePresentation)dmc.getAdapter(ISourcePresentation.class);
                    }
                    if (presentation != null) {
                        editorInput = presentation.getEditorInput(sourceElement);
                        if (editorInput == null) break;
                        editorId = presentation.getEditorId((IEditorInput)editorInput, sourceElement);
                        break;
                    }
                    if (sourceElement instanceof IFile) {
                        editorId = this.getEditorIdForFilename(((IFile)sourceElement).getName());
                        editorInput = new FileEditorInput((IFile)sourceElement);
                        break;
                    }
                    if (sourceElement instanceof ITranslationUnit) {
                        try {
                            URI uriLocation = ((ITranslationUnit)sourceElement).getLocationURI();
                            IFileStore fileStore = EFS.getStore((URI)uriLocation);
                            editorInput = new FileStoreEditorInput(fileStore);
                            editorId = this.getEditorIdForFilename(fileStore.getName());
                        }
                        catch (CoreException coreException) {
                            editorInput = new CSourceNotFoundEditorInput((Object)new CSourceNotFoundElement((IAdaptable)dmc, director.getLaunchConfiguration(), this.fFrameData.fFile));
                            editorId = ICDebugUIConstants.CSOURCENOTFOUND_EDITOR_ID;
                        }
                        break;
                    }
                    if (!(sourceElement instanceof LocalFileStorage)) break;
                    File file = ((LocalFileStorage)sourceElement).getFile();
                    IFileStore fileStore = EFS.getLocalFileSystem().fromLocalFile(file);
                    editorInput = new FileStoreEditorInput(fileStore);
                    editorId = this.getEditorIdForFilename(file.getName());
                    break;
                }
                editorInput = new CSourceNotFoundEditorInput((Object)new CSourceNotFoundElement((IAdaptable)dmc, director.getLaunchConfiguration(), this.fFrameData.fFile));
                editorId = ICDebugUIConstants.CSOURCENOTFOUND_EDITOR_ID;
                ++n2;
            }
            result.setEditorInput((IEditorInput)editorInput);
            result.setEditorId(editorId);
            result.setSourceElement(sourceElement);
            return result;
        }

        private String getEditorIdForFilename(String filename) {
            try {
                IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)filename);
                return descriptor.getId();
            }
            catch (PartInitException exc) {
                DsfUIPlugin.log((Throwable)exc);
                return "org.eclipse.ui.DefaultTextEditor";
            }
        }
    }
}

