/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSourceLookup
extends AbstractDsfService
implements ISourceLookup {
    private final Map<ISourceLookup.ISourceLookupDMContext, List<CSourceLookupDirector>> directors = new HashMap<ISourceLookup.ISourceLookupDMContext, List<CSourceLookupDirector>>();

    public CSourceLookup(DsfSession session) {
        super(session);
    }

    protected BundleContext getBundleContext() {
        return EDCDebugger.getBundleContext();
    }

    public void addSourceLookupDirector(ISourceLookup.ISourceLookupDMContext ctx, CSourceLookupDirector director) {
        List<CSourceLookupDirector> directorsInContext = this.directors.get(ctx);
        if (directorsInContext == null) {
            directorsInContext = new ArrayList<CSourceLookupDirector>();
        }
        directorsInContext.add(director);
        this.directors.put(ctx, directorsInContext);
    }

    public CSourceLookupDirector[] getSourceLookupDirectors(ISourceLookup.ISourceLookupDMContext ctx) {
        List<CSourceLookupDirector> directorList = this.directors.get(ctx);
        return directorList.toArray(new CSourceLookupDirector[directorList.size()]);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                CSourceLookup.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.register(new String[]{CSourceLookup.class.getName(), ISourceLookup.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    public void getDebuggerPath(ISourceLookup.ISourceLookupDMContext sourceLookupCtx, Object source, final DataRequestMonitor<String> rm) {
        if (!(source instanceof String)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10003, "Only string source element is supported", null));
            rm.done();
            return;
        }
        final String sourceString = (String)source;
        if (!this.directors.containsKey(sourceLookupCtx)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10002, "No source director configured for given context", null));
            rm.done();
            return;
        }
        final CSourceLookupDirector[] director = this.getSourceLookupDirectors(sourceLookupCtx);
        new Job("Lookup Debugger Path"){

            protected IStatus run(IProgressMonitor monitor) {
                rm.setData((Object)sourceString);
                CSourceLookupDirector[] cSourceLookupDirectorArray = director;
                int n = director.length;
                int n2 = 0;
                while (n2 < n) {
                    CSourceLookupDirector cSourceLookupDirector = cSourceLookupDirectorArray[n2];
                    IPath debuggerPath = cSourceLookupDirector.getCompilationPath(sourceString);
                    if (debuggerPath != null) {
                        rm.setData((Object)debuggerPath.toString());
                        break;
                    }
                    ++n2;
                }
                rm.done();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void getSource(ISourceLookup.ISourceLookupDMContext sourceLookupCtx, final String debuggerPath, final DataRequestMonitor<Object> rm) {
        if (!this.directors.containsKey(sourceLookupCtx)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10002, "No source director configured for given context", null));
            rm.done();
            return;
        }
        final CSourceLookupDirector[] director = this.getSourceLookupDirectors(sourceLookupCtx);
        new Job("Lookup Source"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        CSourceLookupDirector[] cSourceLookupDirectorArray = director;
                        int n = director.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CSourceLookupDirector cSourceLookupDirector = cSourceLookupDirectorArray[n2];
                            Object[] sources = cSourceLookupDirector.findSourceElements((Object)debuggerPath);
                            if (sources != null && sources.length != 0) {
                                rm.setData(sources[0]);
                                break;
                            }
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "No sources found", null));
                            ++n2;
                        }
                    }
                    catch (CoreException e) {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "Source lookup failed", (Throwable)e));
                        rm.done();
                    }
                }
                finally {
                    rm.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

