/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ISteppingModeTarget;
import org.eclipse.cdt.debug.core.model.ITargetProperties;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionDelegate;

public class ToggleInstructionStepModeActionDelegate
extends ActionDelegate
implements IViewActionDelegate,
Preferences.IPropertyChangeListener {
    private ISteppingModeTarget fTarget = null;
    private IAction fAction = null;
    private IViewPart fView;

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        boolean value;
        IAction action = this.getAction();
        if (action != null && event.getNewValue() instanceof Boolean && (value = ((Boolean)event.getNewValue()).booleanValue()) != action.isChecked()) {
            action.setChecked(value);
        }
    }

    public void init(IViewPart view) {
        this.fView = view;
    }

    public void dispose() {
        ISteppingModeTarget target = this.getTarget();
        if (target != null && target instanceof ITargetProperties) {
            ((ITargetProperties)target).removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        }
        this.setTarget(null);
        this.setAction(null);
    }

    public void init(IAction action) {
        this.setAction(action);
        action.setChecked(false);
        action.setEnabled(false);
    }

    public void run(IAction action) {
        boolean enabled = this.getAction().isChecked();
        ISteppingModeTarget target = this.getTarget();
        if (target != null) {
            target.enableInstructionStepping(enabled);
            if (enabled && target instanceof ICDebugTarget) {
                try {
                    this.getView().getSite().getPage().showView("org.eclipse.cdt.dsf.debug.ui.disassembly.view");
                }
                catch (PartInitException e) {
                    CDebugUIPlugin.log(e.getStatus());
                }
            }
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        ISteppingModeTarget oldTarget;
        ISteppingModeTarget newTarget = null;
        if (selection instanceof IStructuredSelection) {
            newTarget = this.getTargetFromSelection(((IStructuredSelection)selection).getFirstElement());
        }
        if ((oldTarget = this.getTarget()) != null && !oldTarget.equals(newTarget)) {
            if (oldTarget instanceof ITargetProperties) {
                ((ITargetProperties)oldTarget).removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
            }
            this.setTarget(null);
            action.setChecked(false);
        }
        if (newTarget != null && !this.isTerminated(newTarget)) {
            this.setTarget(newTarget);
            if (newTarget instanceof ITargetProperties) {
                ((ITargetProperties)newTarget).addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
            }
            action.setChecked(newTarget.isInstructionSteppingEnabled());
        }
        action.setEnabled(newTarget != null && newTarget.supportsInstructionStepping() && !this.isTerminated(newTarget));
    }

    private boolean isTerminated(ISteppingModeTarget target) {
        return target instanceof ITerminate && ((ITerminate)target).isTerminated() || target instanceof IDisconnect && ((IDisconnect)target).isDisconnected();
    }

    private ISteppingModeTarget getTarget() {
        return this.fTarget;
    }

    private void setTarget(ISteppingModeTarget target) {
        this.fTarget = target;
    }

    private IAction getAction() {
        return this.fAction;
    }

    private void setAction(IAction action) {
        this.fAction = action;
    }

    private ISteppingModeTarget getTargetFromSelection(Object element) {
        IDebugTarget debugTarget;
        ISteppingModeTarget target = null;
        if (element instanceof IDebugElement && (debugTarget = ((IDebugElement)element).getDebugTarget()) instanceof ISteppingModeTarget) {
            target = (ISteppingModeTarget)debugTarget;
        }
        if (target == null && element instanceof IAdaptable) {
            target = (ISteppingModeTarget)((IAdaptable)element).getAdapter(ISteppingModeTarget.class);
        }
        return target;
    }

    private IViewPart getView() {
        return this.fView;
    }
}

