/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.disassembly.rendering;

import java.util.Arrays;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.IAsmInstruction;
import org.eclipse.cdt.debug.core.model.IAsmSourceLine;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.IDisassembly;
import org.eclipse.cdt.debug.core.model.IDisassemblyBlock;
import org.eclipse.cdt.debug.internal.ui.disassembly.rendering.DisassemblyMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class DisassemblyEditorInput
implements IEditorInput {
    public static final IEditorInput EMPTY_EDITOR_INPUT = new DisassemblyEditorInput();
    public static final IEditorInput PENDING_EDITOR_INPUT = new DisassemblyEditorInput(){

        public String getContents() {
            return DisassemblyMessages.getString("DisassemblyDocumentProvider.Pending_1");
        }
    };
    private IDisassemblyBlock fBlock;
    private String fContents = "";
    private IRegion[] fSourceRegions = new IRegion[0];

    protected DisassemblyEditorInput() {
    }

    private DisassemblyEditorInput(IDisassemblyBlock block) {
        this.fBlock = block;
        this.createContents();
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean contains(ICStackFrame frame) {
        if (this.fBlock != null) {
            return this.fBlock.contains(frame);
        }
        return false;
    }

    public String getContents() {
        return this.fContents;
    }

    public int getInstructionLine(IAddress address) {
        if (this.fBlock != null) {
            IAsmSourceLine[] lines = this.fBlock.getSourceLines();
            int result = 0;
            int i = 0;
            while (i < lines.length) {
                IAsmInstruction[] instructions = lines[i].getInstructions();
                if (this.fBlock.isMixedMode()) {
                    ++result;
                }
                int j = 0;
                while (j < instructions.length) {
                    ++result;
                    if (address.equals((Object)instructions[j].getAdress())) {
                        return result;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return -1;
    }

    public int getInstructionLine(ICLineBreakpoint breakpoint) {
        ICDebugTarget target;
        IDisassembly dis;
        if (this.fBlock != null && (dis = this.fBlock.getDisassembly()) != null && (target = (ICDebugTarget)dis.getDebugTarget().getAdapter(ICDebugTarget.class)) != null) {
            try {
                IAddress address = target.getBreakpointAddress(breakpoint);
                if (address != null && !address.isZero()) {
                    return this.getInstructionLine(address);
                }
            }
            catch (DebugException debugException) {}
        }
        return -1;
    }

    public IAddress getAddress(int lineNumber) {
        if (this.fBlock != null) {
            IAsmSourceLine[] lines = this.fBlock.getSourceLines();
            int current = 0;
            int i = 0;
            while (i < lines.length) {
                IAsmInstruction[] instructions = lines[i].getInstructions();
                if (this.fBlock.isMixedMode()) {
                    ++current;
                }
                if (lineNumber == current && instructions.length > 0) {
                    return instructions[0].getAdress();
                }
                if (lineNumber > current && lineNumber <= current + instructions.length) {
                    return instructions[lineNumber - current - 1].getAdress();
                }
                current += instructions.length;
                ++i;
            }
        }
        return null;
    }

    public String getModuleFile() {
        return this.fBlock != null ? this.fBlock.getModuleFile() : null;
    }

    public String getSourceFile() {
        if (this.fBlock != null) {
            Object element = this.fBlock.getSourceElement();
            if (element instanceof IFile) {
                return ((IFile)element).getLocation().toOSString();
            }
            if (element instanceof IStorage) {
                return ((IStorage)element).getFullPath().toOSString();
            }
        }
        return null;
    }

    public int getSourceLine(int instrNumber) {
        if (this.fBlock != null) {
            IAsmSourceLine[] sl = this.fBlock.getSourceLines();
            int current = 0;
            int i = 0;
            while (i < sl.length) {
                IAsmInstruction[] ins = sl[i].getInstructions();
                if (instrNumber >= ++current && instrNumber <= current + ins.length) {
                    return sl[i].getLineNumber();
                }
                current += ins.length;
                ++i;
            }
        }
        return -1;
    }

    public static DisassemblyEditorInput create(ICStackFrame frame) throws DebugException {
        DisassemblyEditorInput input = null;
        ICDebugTarget target = (ICDebugTarget)frame.getDebugTarget();
        IDisassembly disassembly = target.getDisassembly();
        if (disassembly != null) {
            IDisassemblyBlock block = disassembly.getDisassemblyBlock(frame);
            input = new DisassemblyEditorInput(block);
        }
        return input;
    }

    public static DisassemblyEditorInput create(IDisassemblyBlock block) throws DebugException {
        return new DisassemblyEditorInput(block);
    }

    private void createContents() {
        this.fSourceRegions = new IRegion[0];
        StringBuffer lines = new StringBuffer();
        int maxFunctionName = 0;
        int maxOpcodeLength = 0;
        long maxOffset = 0L;
        if (this.fBlock != null) {
            IAsmSourceLine[] mi = this.fBlock.getSourceLines();
            int j = 0;
            while (j < mi.length) {
                IAsmInstruction[] instructions = mi[j].getInstructions();
                int i = 0;
                while (i < instructions.length) {
                    long offset;
                    String opcode;
                    String functionName = instructions[i].getFunctionName();
                    if (functionName.length() > maxFunctionName) {
                        maxFunctionName = functionName.length();
                    }
                    if ((opcode = instructions[i].getOpcode()).length() > maxOpcodeLength) {
                        maxOpcodeLength = opcode.length();
                    }
                    if ((offset = Math.abs(instructions[i].getOffset())) > maxOffset) {
                        maxOffset = offset;
                    }
                    ++i;
                }
                ++j;
            }
            int instrPos = this.calculateInstructionPosition(maxFunctionName, maxOffset);
            int argPosition = instrPos + maxOpcodeLength + 1;
            if (this.fBlock.isMixedMode()) {
                this.fSourceRegions = new IRegion[mi.length];
            }
            int j2 = 0;
            while (j2 < mi.length) {
                if (this.fBlock.isMixedMode()) {
                    String sl = this.getSourceLineString(mi[j2]);
                    this.fSourceRegions[j2] = new Region(lines.length(), sl.length());
                    lines.append(sl);
                }
                IAsmInstruction[] instructions = mi[j2].getInstructions();
                int i = 0;
                while (i < instructions.length) {
                    lines.append(this.getInstructionString(instructions[i], instrPos, argPosition));
                    ++i;
                }
                ++j2;
            }
        }
        this.fContents = lines.toString();
    }

    private String getInstructionString(IAsmInstruction instruction, int instrPosition, int argPosition) {
        int worstCaseSpace = Math.max(instrPosition, argPosition);
        char[] spaces = new char[worstCaseSpace];
        Arrays.fill(spaces, ' ');
        StringBuffer sb = new StringBuffer();
        if (instruction != null) {
            sb.append(instruction.getAdress().toHexAddressString());
            sb.append(' ');
            String functionName = instruction.getFunctionName();
            if (functionName != null && functionName.length() > 0) {
                sb.append('<');
                sb.append(functionName);
                long offset = instruction.getOffset();
                if (offset != 0L) {
                    if (offset > 0L) {
                        sb.append('+');
                    }
                    sb.append(instruction.getOffset());
                }
                sb.append(">:");
                sb.append(spaces, 0, instrPosition - sb.length());
            }
            sb.append(instruction.getOpcode());
            sb.append(spaces, 0, argPosition - sb.length());
            sb.append(instruction.getArguments());
            sb.append('\n');
        }
        return sb.toString();
    }

    private int calculateInstructionPosition(int maxFunctionName, long maxOffset) {
        int addressLength = this.getDisassembly().getAddressFactory().getMax().getCharsNum();
        return addressLength + 6 + maxFunctionName + Long.toString(maxOffset).length();
    }

    private String getSourceLineString(IAsmSourceLine line) {
        String text = line.toString();
        if (text == null) {
            text = String.valueOf(DisassemblyMessages.getString("DisassemblyEditorInput.source_line_is_not_available_1")) + '\n';
        }
        return text;
    }

    public IRegion[] getSourceRegions() {
        return this.fSourceRegions;
    }

    protected IDisassembly getDisassembly() {
        return this.fBlock != null ? this.fBlock.getDisassembly() : null;
    }

    public IDisassemblyBlock getDisassemblyBlock() {
        return this.fBlock;
    }

    public ICLineBreakpoint breakpointExists(IAddress address) throws CoreException {
        ICDebugTarget bt;
        Assert.isTrue((address != null ? 1 : 0) != 0);
        IDisassembly dis = this.getDisassembly();
        if (dis != null && (bt = (ICDebugTarget)dis.getDebugTarget().getAdapter(ICDebugTarget.class)) != null) {
            String modelId = CDIDebugModel.getPluginIdentifier();
            IBreakpoint[] bps = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(modelId);
            int i = 0;
            while (i < bps.length) {
                if (bps[i] instanceof ICLineBreakpoint) {
                    ICLineBreakpoint b = (ICLineBreakpoint)bps[i];
                    try {
                        IAddress a = bt.getBreakpointAddress(b);
                        if (a != null && address.compareTo((Object)a) == 0) {
                            return b;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
        }
        return null;
    }
}

