/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.executables;

import java.io.File;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.core.executables.ExecutablesManager;
import org.eclipse.cdt.debug.core.executables.IExecutablesChangeListener;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.CSourceNotFoundEditorInput;
import org.eclipse.cdt.debug.internal.ui.views.executables.BaseViewer;
import org.eclipse.cdt.debug.internal.ui.views.executables.ExecutablesView;
import org.eclipse.cdt.debug.internal.ui.views.executables.ExecutablesViewerComparator;
import org.eclipse.cdt.debug.internal.ui.views.executables.Messages;
import org.eclipse.cdt.debug.internal.ui.views.executables.SourceFilesContentProvider;
import org.eclipse.cdt.debug.internal.ui.views.executables.SourceFilesLabelProvider;
import org.eclipse.cdt.debug.ui.ICDebugUIConstants;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.util.LRUCache;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class SourceFilesViewer
extends BaseViewer {
    private static final String P_COLUMN_ORDER_KEY_SF = "columnOrderKeySF";
    private static final String P_SORTED_COLUMN_INDEX_KEY_SF = "sortedColumnIndexKeySF";
    private static final String P_COLUMN_SORT_DIRECTION_KEY_SF = "columnSortDirectionKeySF";
    private static final String P_VISIBLE_COLUMNS_KEY_SF = "visibleColumnsKeySF";
    TreeColumn originalLocationColumn;
    private Tree sourceFilesTree;
    static final long FILE_CHECK_DELTA = 30000L;
    private static LRUCache<Object, TranslationUnitInfo> translationUnitInfoCache = new LRUCache(1024);

    public SourceFilesViewer(ExecutablesView view, Composite parent, int style) {
        super(view, parent, style);
        this.setContentProvider((IContentProvider)new SourceFilesContentProvider(this));
        this.setLabelProvider((IBaseLabelProvider)new SourceFilesLabelProvider(this));
        this.sourceFilesTree = this.getTree();
        this.sourceFilesTree.setHeaderVisible(true);
        this.sourceFilesTree.setLinesVisible(true);
        this.createColumns();
        this.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                SourceFilesViewer.this.openSourceFile(event);
            }
        });
        ExecutablesManager.getExecutablesManager().addExecutablesChangeListener(new IExecutablesChangeListener(){

            public void executablesListChanged() {
            }

            public void executablesChanged(List<Executable> executables) {
                SourceFilesViewer.flushTranslationUnitCache();
            }
        });
    }

    private void openSourceFile(OpenEvent event) {
        boolean opened = false;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof ICElement) {
            IWorkbenchPage p;
            ITranslationUnit tu;
            IPath path;
            if (element instanceof ITranslationUnit && (path = (tu = (ITranslationUnit)element).getLocation()) != null && !path.toFile().exists() && (p = CUIPlugin.getActivePage()) != null) {
                try {
                    String editorID = ICDebugUIConstants.CSOURCENOTFOUND_EDITOR_ID;
                    p.openEditor((IEditorInput)new CSourceNotFoundEditorInput(tu), editorID, true);
                    opened = true;
                }
                catch (PartInitException partInitException) {}
            }
            if (!opened) {
                try {
                    IEditorPart part = EditorUtility.openInEditor((Object)element);
                    if (part != null) {
                        IWorkbenchPage page = this.getExecutablesView().getSite().getPage();
                        page.bringToTop((IWorkbenchPart)part);
                        if (element instanceof ISourceReference) {
                            EditorUtility.revealInEditor((IEditorPart)part, (ICElement)((ICElement)element));
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private void createColumns() {
        this.nameColumn = new TreeColumn(this.sourceFilesTree, 0);
        this.nameColumn.setWidth(100);
        this.nameColumn.setText(Messages.SourceFilesViewer_SourceFileName);
        this.nameColumn.setMoveable(true);
        this.nameColumn.addSelectionListener((SelectionListener)new BaseViewer.ColumnSelectionAdapter(0));
        this.locationColumn = new TreeColumn(this.sourceFilesTree, 0);
        this.locationColumn.setWidth(100);
        this.locationColumn.setText(Messages.SourceFilesViewer_Location);
        this.locationColumn.setMoveable(true);
        this.locationColumn.addSelectionListener((SelectionListener)new BaseViewer.ColumnSelectionAdapter(2));
        this.originalLocationColumn = new TreeColumn(this.sourceFilesTree, 0);
        this.originalLocationColumn.setWidth(100);
        this.originalLocationColumn.setText(Messages.SourceFilesViewer_Original);
        this.originalLocationColumn.setMoveable(true);
        this.originalLocationColumn.addSelectionListener((SelectionListener)new BaseViewer.ColumnSelectionAdapter(6));
        this.sizeColumn = new TreeColumn(this.sourceFilesTree, 0);
        this.sizeColumn.setWidth(100);
        this.sizeColumn.setText(Messages.SourceFilesViewer_Size);
        this.sizeColumn.setMoveable(true);
        this.sizeColumn.addSelectionListener((SelectionListener)new BaseViewer.ColumnSelectionAdapter(3));
        this.modifiedColumn = new TreeColumn(this.sourceFilesTree, 0);
        this.modifiedColumn.setWidth(100);
        this.modifiedColumn.setText(Messages.SourceFilesViewer_Modified);
        this.modifiedColumn.setMoveable(true);
        this.modifiedColumn.addSelectionListener((SelectionListener)new BaseViewer.ColumnSelectionAdapter(4));
        this.typeColumn = new TreeColumn(this.sourceFilesTree, 0);
        this.typeColumn.setWidth(100);
        this.typeColumn.setText(Messages.SourceFilesViewer_Type);
        this.typeColumn.setMoveable(true);
        this.typeColumn.addSelectionListener((SelectionListener)new BaseViewer.ColumnSelectionAdapter(5));
    }

    protected ViewerComparator getViewerComparator(int sortType) {
        if (sortType == 6) {
            return new ExecutablesViewerComparator(sortType, this.column_sort_order[6]){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    if (e1 instanceof ITranslationUnit && e2 instanceof ITranslationUnit) {
                        ITranslationUnit entry1 = (ITranslationUnit)e1;
                        ITranslationUnit entry2 = (ITranslationUnit)e2;
                        Executable exe = (Executable)SourceFilesViewer.this.getInput();
                        String originalLocation1 = exe.getOriginalLocation(entry1);
                        String originalLocation2 = exe.getOriginalLocation(entry2);
                        return this.getComparator().compare(originalLocation1, originalLocation2) * SourceFilesViewer.this.column_sort_order[6];
                    }
                    return super.compare(viewer, e1, e2);
                }
            };
        }
        return new ExecutablesViewerComparator(sortType, this.column_sort_order[sortType]);
    }

    protected String getColumnOrderKey() {
        return P_COLUMN_ORDER_KEY_SF;
    }

    protected String getSortedColumnIndexKey() {
        return P_SORTED_COLUMN_INDEX_KEY_SF;
    }

    protected String getSortedColumnDirectionKey() {
        return P_COLUMN_SORT_DIRECTION_KEY_SF;
    }

    protected String getVisibleColumnsKey() {
        return P_VISIBLE_COLUMNS_KEY_SF;
    }

    protected String getDefaultVisibleColumnsValue() {
        return "1,1,0,0,0,0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TranslationUnitInfo fetchTranslationUnitInfo(Executable executable, Object element) {
        TranslationUnitInfo info;
        if (!(element instanceof ITranslationUnit)) {
            return null;
        }
        ITranslationUnit tu = (ITranslationUnit)element;
        long now = System.currentTimeMillis();
        LRUCache<Object, TranslationUnitInfo> lRUCache = translationUnitInfoCache;
        synchronized (lRUCache) {
            info = (TranslationUnitInfo)translationUnitInfoCache.get(element);
        }
        if (info == null || info.nextCheckTimestamp <= now) {
            if (info == null) {
                info = new TranslationUnitInfo();
            }
            info.location = tu.getLocation();
            if (info.location != null) {
                if (Util.isNativeAbsolutePath((String)info.location.toOSString())) {
                    File file = info.location.toFile();
                    info.exists = file.exists();
                    if (info.exists) {
                        info.fileLength = file.length();
                        info.lastModified = file.lastModified();
                    } else {
                        info.fileLength = 0L;
                        info.lastModified = 0L;
                    }
                } else {
                    info.exists = false;
                    info.fileLength = 0L;
                    info.lastModified = 0L;
                }
                info.originalLocation = new Path(executable.getOriginalLocation(tu));
                info.originalExists = Util.isNativeAbsolutePath((String)info.originalLocation.toOSString()) && info.originalLocation.toFile().exists();
            } else {
                info.exists = false;
                info.fileLength = 0L;
                info.lastModified = 0L;
                info.originalExists = false;
                info.originalLocation = null;
            }
            info.nextCheckTimestamp = System.currentTimeMillis() + 30000L;
            lRUCache = translationUnitInfoCache;
            synchronized (lRUCache) {
                translationUnitInfoCache.put(element, (Object)info);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void flushTranslationUnitCache() {
        LRUCache<Object, TranslationUnitInfo> lRUCache = translationUnitInfoCache;
        synchronized (lRUCache) {
            translationUnitInfoCache.flush();
        }
    }

    public void restartCanceledExecutableParse() {
        SourceFilesContentProvider provider = (SourceFilesContentProvider)this.getContentProvider();
        if (provider != null) {
            provider.restartCanceledExecutableParse();
        }
    }

    static class TranslationUnitInfo {
        long nextCheckTimestamp;
        IPath location;
        boolean exists;
        long fileLength;
        long lastModified;
        IPath originalLocation;
        boolean originalExists;

        TranslationUnitInfo() {
        }
    }
}

