/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.includebrowser;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.internal.ui.includebrowser.IBMessages;
import org.eclipse.cdt.internal.ui.includebrowser.IncludeBrowserUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenIncludeBrowserAction
extends SelectionDispatchAction {
    private ITextEditor fEditor;

    public OpenIncludeBrowserAction(IWorkbenchSite site) {
        super(site);
        this.setText(IBMessages.OpenIncludeBrowserAction_label);
        this.setToolTipText(IBMessages.OpenIncludeBrowserAction_tooltip);
    }

    public OpenIncludeBrowserAction(ITextEditor editor) {
        this((IWorkbenchSite)editor.getSite());
        this.fEditor = editor;
        this.setEnabled(this.fEditor != null && CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput()) != null);
    }

    public void run(ITextSelection sel) {
        IncludeBrowserUI.open(this.fEditor, sel);
    }

    public void run(IStructuredSelection selection) {
        Object selectedObject;
        ICElement elem;
        if (!selection.isEmpty() && (elem = (ICElement)this.getAdapter(selectedObject = selection.getFirstElement(), ICElement.class)) != null) {
            IncludeBrowserUI.open(this.getSite().getWorkbenchWindow(), elem);
        }
    }

    public void selectionChanged(ITextSelection sel) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        Object selectedObject = selection.getFirstElement();
        ICElement elem = (ICElement)this.getAdapter(selectedObject, ICElement.class);
        if (elem != null) {
            this.setEnabled(this.isValidElement(elem));
        } else {
            this.setEnabled(false);
        }
    }

    private boolean isValidElement(ICElement elem) {
        return elem instanceof ISourceReference;
    }

    private Object getAdapter(Object object, Class desiredClass) {
        if (desiredClass.isInstance(object)) {
            return object;
        }
        if (object instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)object;
            return adaptable.getAdapter(desiredClass);
        }
        return null;
    }
}

