/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.util.NameComposer;
import org.eclipse.cdt.internal.ui.viewsupport.ProjectTemplateStore;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameStyleBlock
extends OptionsConfigurationBlock {
    private static final String EXAMPLE_CONSTANT_NAME = "MY_CONSTANT";
    private static final String EXAMPLE_VARIABLE_NAME = "myVariable";
    private static final String EXAMPLE_FIELD_NAME = "myField";
    private static final String EXAMPLE_CLASS_NAME = "MyClass";
    private final String[] CAPITALIZATION_VALUES = new String[]{String.valueOf(0), String.valueOf(1), String.valueOf(2), String.valueOf(3), String.valueOf(4)};
    private final String[] CAPITALIZATION_LABELS = new String[]{String.valueOf(PreferencesMessages.NameStyleBlock_capitalization_original), String.valueOf(PreferencesMessages.NameStyleBlock_capitalization_upper_case), String.valueOf(PreferencesMessages.NameStyleBlock_capitalization_lower_case), String.valueOf(PreferencesMessages.NameStyleBlock_capitalization_camel_case), String.valueOf(PreferencesMessages.NameStyleBlock_capitalization_lower_camel_case)};
    private static final OptionsConfigurationBlock.Key KEY_CONSTANT_CAPITALIZATION = NameStyleBlock.getCDTUIKey("nameStyle.constant.capitalization");
    private static final OptionsConfigurationBlock.Key KEY_CONSTANT_WORD_DELIMITER = NameStyleBlock.getCDTUIKey("nameStyle.constant.wordDelimiter");
    private static final OptionsConfigurationBlock.Key KEY_CONSTANT_PREFIX = NameStyleBlock.getCDTUIKey("nameStyle.constant.prefix");
    private static final OptionsConfigurationBlock.Key KEY_CONSTANT_SUFFIX = NameStyleBlock.getCDTUIKey("nameStyle.constant.suffix");
    private static final OptionsConfigurationBlock.Key KEY_VARIABLE_CAPITALIZATION = NameStyleBlock.getCDTUIKey("nameStyle.variable.capitalization");
    private static final OptionsConfigurationBlock.Key KEY_VARIABLE_WORD_DELIMITER = NameStyleBlock.getCDTUIKey("nameStyle.variable.wordDelimiter");
    private static final OptionsConfigurationBlock.Key KEY_VARIABLE_PREFIX = NameStyleBlock.getCDTUIKey("nameStyle.variable.prefix");
    private static final OptionsConfigurationBlock.Key KEY_VARIABLE_SUFFIX = NameStyleBlock.getCDTUIKey("nameStyle.variable.suffix");
    private static final OptionsConfigurationBlock.Key KEY_FIELD_CAPITALIZATION = NameStyleBlock.getCDTUIKey("nameStyle.field.capitalization");
    private static final OptionsConfigurationBlock.Key KEY_FIELD_WORD_DELIMITER = NameStyleBlock.getCDTUIKey("nameStyle.field.wordDelimiter");
    private static final OptionsConfigurationBlock.Key KEY_FIELD_PREFIX = NameStyleBlock.getCDTUIKey("nameStyle.field.prefix");
    private static final OptionsConfigurationBlock.Key KEY_FIELD_SUFFIX = NameStyleBlock.getCDTUIKey("nameStyle.field.suffix");
    private static final OptionsConfigurationBlock.Key KEY_GETTER_CAPITALIZATION = NameStyleBlock.getCDTUIKey("nameStyle.getter.capitalization");
    private static final OptionsConfigurationBlock.Key KEY_GETTER_WORD_DELIMITER = NameStyleBlock.getCDTUIKey("nameStyle.getter.wordDelimiter");
    private static final OptionsConfigurationBlock.Key KEY_GETTER_PREFIX = NameStyleBlock.getCDTUIKey("nameStyle.getter.prefix");
    private static final OptionsConfigurationBlock.Key KEY_GETTER_PREFIX_FOR_BOOLEAN = NameStyleBlock.getCDTUIKey("nameStyle.getter.prefixForBoolean");
    private static final OptionsConfigurationBlock.Key KEY_GETTER_SUFFIX = NameStyleBlock.getCDTUIKey("nameStyle.getter.suffix");
    private static final OptionsConfigurationBlock.Key KEY_SETTER_CAPITALIZATION = NameStyleBlock.getCDTUIKey("nameStyle.setter.capitalization");
    private static final OptionsConfigurationBlock.Key KEY_SETTER_WORD_DELIMITER = NameStyleBlock.getCDTUIKey("nameStyle.setter.wordDelimiter");
    private static final OptionsConfigurationBlock.Key KEY_SETTER_PREFIX = NameStyleBlock.getCDTUIKey("nameStyle.setter.prefix");
    private static final OptionsConfigurationBlock.Key KEY_SETTER_SUFFIX = NameStyleBlock.getCDTUIKey("nameStyle.setter.suffix");
    private static final OptionsConfigurationBlock.Key KEY_CPP_SOURCE_CAPITALIZATION = NameStyleBlock.getCDTUIKey("nameStyle.cpp.source.capitalization");
    private static final OptionsConfigurationBlock.Key KEY_CPP_SOURCE_WORD_DELIMITER = NameStyleBlock.getCDTUIKey("nameStyle.cpp.source.wordDelimiter");
    private static final OptionsConfigurationBlock.Key KEY_CPP_SOURCE_PREFIX = NameStyleBlock.getCDTUIKey("nameStyle.cpp.source.prefix");
    private static final OptionsConfigurationBlock.Key KEY_CPP_SOURCE_SUFFIX = NameStyleBlock.getCDTUIKey("nameStyle.cpp.source.suffix");
    private static final OptionsConfigurationBlock.Key KEY_CPP_HEADER_CAPITALIZATION = NameStyleBlock.getCDTUIKey("nameStyle.cpp.header.capitalization");
    private static final OptionsConfigurationBlock.Key KEY_CPP_HEADER_WORD_DELIMITER = NameStyleBlock.getCDTUIKey("nameStyle.cpp.header.wordDelimiter");
    private static final OptionsConfigurationBlock.Key KEY_CPP_HEADER_PREFIX = NameStyleBlock.getCDTUIKey("nameStyle.cpp.header.prefix");
    private static final OptionsConfigurationBlock.Key KEY_CPP_HEADER_SUFFIX = NameStyleBlock.getCDTUIKey("nameStyle.cpp.header.suffix");
    private static final OptionsConfigurationBlock.Key KEY_CPP_TEST_CAPITALIZATION = NameStyleBlock.getCDTUIKey("nameStyle.cpp.test.capitalization");
    private static final OptionsConfigurationBlock.Key KEY_CPP_TEST_WORD_DELIMITER = NameStyleBlock.getCDTUIKey("nameStyle.cpp.test.wordDelimiter");
    private static final OptionsConfigurationBlock.Key KEY_CPP_TEST_PREFIX = NameStyleBlock.getCDTUIKey("nameStyle.cpp.test.prefix");
    private static final OptionsConfigurationBlock.Key KEY_CPP_TEST_SUFFIX = NameStyleBlock.getCDTUIKey("nameStyle.cpp.test.suffix");
    private static final IdentifierValidator IDENTIFIER_VALIDATOR = new IdentifierValidator();
    private static final FilenameValidator FILENAME_VALIDATOR = new FilenameValidator();
    private final Category[] rootCategories = NameStyleBlock.createCategories();
    private TreeListDialogField<Category> categoryTree;
    private PixelConverter pixelConverter;
    private StackLayout editorAreaStack;
    private Category selectedCategory;

    private static OptionsConfigurationBlock.Key[] getAllKeys() {
        return new OptionsConfigurationBlock.Key[]{KEY_CONSTANT_CAPITALIZATION, KEY_CONSTANT_WORD_DELIMITER, KEY_CONSTANT_PREFIX, KEY_CONSTANT_SUFFIX, KEY_VARIABLE_CAPITALIZATION, KEY_VARIABLE_WORD_DELIMITER, KEY_VARIABLE_PREFIX, KEY_VARIABLE_SUFFIX, KEY_FIELD_CAPITALIZATION, KEY_FIELD_WORD_DELIMITER, KEY_FIELD_PREFIX, KEY_FIELD_SUFFIX, KEY_GETTER_CAPITALIZATION, KEY_GETTER_WORD_DELIMITER, KEY_GETTER_PREFIX, KEY_GETTER_PREFIX_FOR_BOOLEAN, KEY_GETTER_SUFFIX, KEY_SETTER_CAPITALIZATION, KEY_SETTER_WORD_DELIMITER, KEY_SETTER_PREFIX, KEY_SETTER_SUFFIX, KEY_CPP_SOURCE_CAPITALIZATION, KEY_CPP_SOURCE_WORD_DELIMITER, KEY_CPP_SOURCE_PREFIX, KEY_CPP_SOURCE_SUFFIX, KEY_CPP_HEADER_CAPITALIZATION, KEY_CPP_HEADER_WORD_DELIMITER, KEY_CPP_HEADER_PREFIX, KEY_CPP_HEADER_SUFFIX, KEY_CPP_TEST_CAPITALIZATION, KEY_CPP_TEST_WORD_DELIMITER, KEY_CPP_TEST_PREFIX, KEY_CPP_TEST_SUFFIX};
    }

    public NameStyleBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, NameStyleBlock.getAllKeys(), container);
    }

    private static Category[] createCategories() {
        Category codeCategory = new Category(PreferencesMessages.NameStyleBlock_code_node);
        new Category(PreferencesMessages.NameStyleBlock_constant_node, PreferencesMessages.NameStyleBlock_constant_node_description, EXAMPLE_CONSTANT_NAME, codeCategory).setCapitalizationKey(KEY_CONSTANT_CAPITALIZATION).setWordDelimiterKey(KEY_CONSTANT_WORD_DELIMITER).setPrefixKey(KEY_CONSTANT_PREFIX).setSuffixKey(KEY_CONSTANT_SUFFIX).setNameValidator(IDENTIFIER_VALIDATOR);
        new Category(PreferencesMessages.NameStyleBlock_variable_node, PreferencesMessages.NameStyleBlock_variable_node_description, EXAMPLE_VARIABLE_NAME, codeCategory).setCapitalizationKey(KEY_VARIABLE_CAPITALIZATION).setWordDelimiterKey(KEY_VARIABLE_WORD_DELIMITER).setPrefixKey(KEY_VARIABLE_PREFIX).setSuffixKey(KEY_VARIABLE_SUFFIX).setNameValidator(IDENTIFIER_VALIDATOR);
        Category fieldCategory = new Category(PreferencesMessages.NameStyleBlock_field_node, PreferencesMessages.NameStyleBlock_field_node_description, EXAMPLE_FIELD_NAME, codeCategory).setCapitalizationKey(KEY_FIELD_CAPITALIZATION).setWordDelimiterKey(KEY_FIELD_WORD_DELIMITER).setPrefixKey(KEY_FIELD_PREFIX).setSuffixKey(KEY_FIELD_SUFFIX).setNameValidator(IDENTIFIER_VALIDATOR);
        new Category(PreferencesMessages.NameStyleBlock_getter_node, PreferencesMessages.NameStyleBlock_getter_node_description, EXAMPLE_FIELD_NAME, codeCategory).setCapitalizationKey(KEY_GETTER_CAPITALIZATION).setWordDelimiterKey(KEY_GETTER_WORD_DELIMITER).setPrefixKey(KEY_GETTER_PREFIX).setAlternativePrefixKey(KEY_GETTER_PREFIX_FOR_BOOLEAN).setSuffixKey(KEY_GETTER_SUFFIX).setSeedNameGenerator(fieldCategory).setNameValidator(IDENTIFIER_VALIDATOR);
        new Category(PreferencesMessages.NameStyleBlock_setter_node, PreferencesMessages.NameStyleBlock_setter_node_description, EXAMPLE_FIELD_NAME, codeCategory).setCapitalizationKey(KEY_SETTER_CAPITALIZATION).setWordDelimiterKey(KEY_SETTER_WORD_DELIMITER).setPrefixKey(KEY_SETTER_PREFIX).setSuffixKey(KEY_SETTER_SUFFIX).setSeedNameGenerator(fieldCategory).setNameValidator(IDENTIFIER_VALIDATOR);
        Category fileCategory = new Category(PreferencesMessages.NameStyleBlock_files_node);
        new Category(PreferencesMessages.NameStyleBlock_cpp_header_node, PreferencesMessages.NameStyleBlock_cpp_header_node_description, EXAMPLE_CLASS_NAME, fileCategory).setCapitalizationKey(KEY_CPP_HEADER_CAPITALIZATION).setWordDelimiterKey(KEY_CPP_HEADER_WORD_DELIMITER).setPrefixKey(KEY_CPP_HEADER_PREFIX).setSuffixKey(KEY_CPP_HEADER_SUFFIX).setNameValidator(FILENAME_VALIDATOR);
        new Category(PreferencesMessages.NameStyleBlock_cpp_source_node, PreferencesMessages.NameStyleBlock_cpp_source_node_description, EXAMPLE_CLASS_NAME, fileCategory).setCapitalizationKey(KEY_CPP_SOURCE_CAPITALIZATION).setWordDelimiterKey(KEY_CPP_SOURCE_WORD_DELIMITER).setPrefixKey(KEY_CPP_SOURCE_PREFIX).setSuffixKey(KEY_CPP_SOURCE_SUFFIX).setNameValidator(FILENAME_VALIDATOR);
        new Category(PreferencesMessages.NameStyleBlock_cpp_test_node, PreferencesMessages.NameStyleBlock_cpp_test_node_description, EXAMPLE_CLASS_NAME, fileCategory).setCapitalizationKey(KEY_CPP_TEST_CAPITALIZATION).setWordDelimiterKey(KEY_CPP_TEST_WORD_DELIMITER).setPrefixKey(KEY_CPP_TEST_PREFIX).setSuffixKey(KEY_CPP_TEST_SUFFIX).setNameValidator(FILENAME_VALIDATOR);
        return new Category[]{codeCategory, fileCategory};
    }

    public void postSetSelection(Object element) {
        this.categoryTree.postSetSelection((ISelection)new StructuredSelection(element));
    }

    @Override
    public boolean hasProjectSpecificOptions(IProject project) {
        if (super.hasProjectSpecificOptions(project)) {
            return true;
        }
        if (project != null) {
            return ProjectTemplateStore.hasProjectSpecificTempates(project);
        }
        return false;
    }

    @Override
    protected Control createContents(Composite parent) {
        this.pixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        NameStyleAdapter adapter = new NameStyleAdapter();
        this.categoryTree = new TreeListDialogField<Category>(adapter, null, (ILabelProvider)new NameStyleLabelProvider());
        this.categoryTree.setDialogFieldListener(adapter);
        this.categoryTree.setLabelText(PreferencesMessages.NameStyleBlock_categories_label);
        this.categoryTree.setViewerComparator(adapter);
        NameStyleBlock.createCategories();
        Category[] categoryArray = this.rootCategories;
        int n = this.rootCategories.length;
        int n2 = 0;
        while (n2 < n) {
            Category category = categoryArray[n2];
            this.categoryTree.addElement(category);
            ++n2;
        }
        Label label = this.categoryTree.getLabelControl(composite);
        GridData gd = new GridData(256);
        gd.verticalAlignment = 1;
        label.setLayoutData((Object)gd);
        Control tree = this.categoryTree.getTreeControl(composite);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = this.pixelConverter.convertWidthInCharsToPixels(50);
        gd.heightHint = this.pixelConverter.convertHeightInCharsToPixels(12);
        tree.setLayoutData((Object)gd);
        this.createCategoryEditorArea(composite);
        this.categoryTree.setTreeExpansionLevel(2);
        this.categoryTree.selectFirstElement();
        this.updateControls();
        return composite;
    }

    private void createCategoryEditorArea(Composite parent) {
        Composite editorArea = new Composite(parent, 0);
        editorArea.setLayoutData((Object)new GridData(1808));
        editorArea.setFont(parent.getFont());
        this.editorAreaStack = new StackLayout();
        editorArea.setLayout((Layout)this.editorAreaStack);
        Category[] categoryArray = this.rootCategories;
        int n = this.rootCategories.length;
        int n2 = 0;
        while (n2 < n) {
            Category category = categoryArray[n2];
            this.createCategoryEditor(editorArea, category);
            ++n2;
        }
    }

    private void createCategoryEditor(Composite parent, Category category) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.pixelConverter.convertHeightInCharsToPixels(1);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        if (category.isConcrete()) {
            Group group = ControlFactory.createGroup(composite, category.description, 1);
            Composite envelope = new Composite((Composite)group, 0);
            layout = new GridLayout(4, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            envelope.setLayout((Layout)layout);
            Combo control = this.addComboBox(envelope, PreferencesMessages.NameStyleBlock_capitalization_label, category.getCapitalizationKey(), this.CAPITALIZATION_VALUES, this.CAPITALIZATION_LABELS, 0);
            LayoutUtil.setHorizontalSpan(this.getLabel((Control)control), 1);
            LayoutUtil.setHorizontalSpan((Control)control, 3);
            control = this.addTextField(envelope, PreferencesMessages.NameStyleBlock_word_delimiter_label, category.getWordDelimiterKey(), 0, this.pixelConverter.convertWidthInCharsToPixels(10));
            LayoutUtil.setHorizontalSpan((Control)control, 3);
            LayoutUtil.setHorizontalAlignment((Control)control, 1);
            control = this.addTextField(envelope, PreferencesMessages.NameStyleBlock_prefix_label, category.getPrefixKey(), 0, this.pixelConverter.convertWidthInCharsToPixels(10));
            boolean getter = PreferencesMessages.NameStyleBlock_getter_node.equals(category.name);
            LayoutUtil.setHorizontalSpan((Control)control, getter ? 1 : 3);
            LayoutUtil.setHorizontalAlignment((Control)control, 1);
            if (getter) {
                control = this.addTextField(envelope, PreferencesMessages.NameStyleBlock_prefix_for_boolean_label, category.getAlternativePrefixKey(), this.pixelConverter.convertWidthInCharsToPixels(2), this.pixelConverter.convertWidthInCharsToPixels(10));
                LayoutUtil.setHorizontalSpan((Control)control, 1);
                LayoutUtil.setHorizontalAlignment((Control)control, 1);
            }
            control = this.addTextField(envelope, PreferencesMessages.NameStyleBlock_suffix_label, category.getSuffixKey(), 0, this.pixelConverter.convertWidthInCharsToPixels(10));
            LayoutUtil.setHorizontalSpan((Control)control, 3);
            LayoutUtil.setHorizontalAlignment((Control)control, 1);
            ControlFactory.insertSpace(envelope, 4, this.pixelConverter.convertHeightInCharsToPixels(1));
            ControlFactory.createLabel(envelope, PreferencesMessages.NameStyleBlock_preview_label);
            Text previewText = ControlFactory.createTextField(envelope, 2060);
            LayoutUtil.setWidthHint((Control)previewText, this.pixelConverter.convertWidthInCharsToPixels(35));
            LayoutUtil.setHorizontalSpan((Control)previewText, 3);
            category.setPreviewControl(previewText);
        } else {
            ControlFactory.createLabel(composite, PreferencesMessages.NameStyleBlock_select_concrete_category);
        }
        category.setEditorArea(composite);
        Category[] categoryArray = category.getChildren();
        int n = categoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Category child = categoryArray[n2];
            this.createCategoryEditor(parent, child);
            ++n2;
        }
    }

    @Override
    protected void updateControls() {
        super.updateControls();
        this.updatePreview();
    }

    private void updateConfigurationBlock(List<Object> selection) {
        if (selection.size() == 0) {
            return;
        }
        this.selectedCategory = (Category)selection.get(0);
        this.editorAreaStack.topControl = this.selectedCategory.getEditorArea();
        this.editorAreaStack.topControl.getParent().layout();
        this.updatePreview();
    }

    private void updatePreview() {
        Text text = this.selectedCategory.getPreviewControl();
        if (text != null) {
            text.setText(this.selectedCategory.composeExampleName(this));
        }
    }

    @Override
    public void performDefaults() {
        super.performDefaults();
        this.categoryTree.refresh();
        this.updateConfigurationBlock(this.categoryTree.getSelectedElements());
    }

    @Override
    public boolean performOk() {
        return super.performOk();
    }

    @Override
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        StatusInfo status = new StatusInfo();
        if (this.selectedCategory != null) {
            NameValidator validator = this.selectedCategory.getNameValidator();
            if (changedKey.equals(this.selectedCategory.getPrefixKey()) || changedKey.equals(this.selectedCategory.getAlternativePrefixKey())) {
                if (!validator.isValidStart(newValue)) {
                    status.setError(PreferencesMessages.NameStyleBlock_invalid_prefix);
                }
            } else if (changedKey.equals(this.selectedCategory.getWordDelimiterKey())) {
                if (!validator.isValidPart(newValue)) {
                    status.setError(PreferencesMessages.NameStyleBlock_invalid_word_delimiter);
                }
            } else if (changedKey.equals(this.selectedCategory.getSuffixKey()) && !validator.isValidPart(newValue)) {
                status.setError(PreferencesMessages.NameStyleBlock_invalid_suffix);
            }
        }
        this.updatePreview();
        this.fContext.statusChanged(status);
    }

    private static final class Category {
        public final String name;
        public final String description;
        public final Category parent;
        public final int index;
        private final List<Category> children;
        private OptionsConfigurationBlock.Key capitalizationKey;
        private OptionsConfigurationBlock.Key wordDelimiterKey;
        private OptionsConfigurationBlock.Key prefixKey;
        private OptionsConfigurationBlock.Key alternativePrefixKey;
        private OptionsConfigurationBlock.Key suffixKey;
        private String seedName;
        private Category seedNameGenerator;
        private NameValidator nameValidator;
        private Text previewText;
        private Composite editorArea;

        Category(String name, String description, String seedName, Category parent) {
            this.name = name;
            this.description = description;
            this.seedName = seedName;
            this.parent = parent;
            this.children = new ArrayList<Category>();
            this.index = parent != null ? parent.addChild(this) : 0;
        }

        Category(String name) {
            this(name, null, null, null);
        }

        private int addChild(Category category) {
            this.children.add(category);
            return this.children.size() - 1;
        }

        Category[] getChildren() {
            return this.children.toArray(new Category[this.children.size()]);
        }

        boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public String toString() {
            return this.name;
        }

        OptionsConfigurationBlock.Key getCapitalizationKey() {
            return this.capitalizationKey;
        }

        Category setCapitalizationKey(OptionsConfigurationBlock.Key capitalizationKey) {
            this.capitalizationKey = capitalizationKey;
            return this;
        }

        OptionsConfigurationBlock.Key getWordDelimiterKey() {
            return this.wordDelimiterKey;
        }

        Category setWordDelimiterKey(OptionsConfigurationBlock.Key wordDelimiterKey) {
            this.wordDelimiterKey = wordDelimiterKey;
            return this;
        }

        OptionsConfigurationBlock.Key getPrefixKey() {
            return this.prefixKey;
        }

        Category setPrefixKey(OptionsConfigurationBlock.Key prefixKey) {
            this.prefixKey = prefixKey;
            return this;
        }

        OptionsConfigurationBlock.Key getAlternativePrefixKey() {
            return this.alternativePrefixKey;
        }

        Category setAlternativePrefixKey(OptionsConfigurationBlock.Key alternativePrefixKey) {
            this.alternativePrefixKey = alternativePrefixKey;
            return this;
        }

        OptionsConfigurationBlock.Key getSuffixKey() {
            return this.suffixKey;
        }

        Category setSuffixKey(OptionsConfigurationBlock.Key suffixKey) {
            this.suffixKey = suffixKey;
            return this;
        }

        boolean isConcrete() {
            return this.capitalizationKey != null;
        }

        Composite getEditorArea() {
            return this.editorArea;
        }

        Category setEditorArea(Composite editorArea) {
            this.editorArea = editorArea;
            return this;
        }

        Text getPreviewControl() {
            return this.previewText;
        }

        Category setPreviewControl(Text previewText) {
            this.previewText = previewText;
            return this;
        }

        NameValidator getNameValidator() {
            return this.nameValidator;
        }

        Category setNameValidator(NameValidator nameValidator) {
            this.nameValidator = nameValidator;
            return this;
        }

        Category setSeedNameGenerator(Category seedNameGenerator) {
            this.seedNameGenerator = seedNameGenerator;
            return this;
        }

        String composeExampleName(NameStyleBlock settings) {
            int capitalization = Integer.parseInt(settings.getValue(this.capitalizationKey));
            String wordDelimiter = settings.getValue(this.wordDelimiterKey);
            String prefix = settings.getValue(this.prefixKey);
            String suffix = settings.getValue(this.suffixKey);
            NameComposer composer = new NameComposer(capitalization, wordDelimiter, prefix, suffix);
            String name = this.seedNameGenerator != null ? this.seedNameGenerator.composeExampleName(settings) : this.seedName;
            return composer.compose(name);
        }
    }

    private static class FilenameValidator
    extends NameValidator {
        private FilenameValidator() {
        }

        boolean isValidStart(char ch) {
            return this.isValidPart(ch);
        }

        boolean isValidPart(char ch) {
            return "\\/:*?<>|\" ".indexOf(ch) == -1;
        }
    }

    private static class IdentifierValidator
    extends NameValidator {
        private IdentifierValidator() {
        }

        boolean isValidStart(char ch) {
            return Character.isJavaIdentifierStart(ch);
        }

        boolean isValidPart(char ch) {
            return Character.isJavaIdentifierPart(ch);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NameStyleAdapter
    extends ViewerComparator
    implements ITreeListAdapter<Category>,
    IDialogFieldListener {
        private NameStyleAdapter() {
        }

        @Override
        public void selectionChanged(TreeListDialogField<Category> field) {
            NameStyleBlock.this.updateConfigurationBlock(field.getSelectedElements());
        }

        @Override
        public void customButtonPressed(TreeListDialogField<Category> field, int index) {
        }

        @Override
        public void doubleClicked(TreeListDialogField<Category> field) {
        }

        public Category[] getChildren(TreeListDialogField<Category> field, Object element) {
            return ((Category)element).getChildren();
        }

        public Category getParent(TreeListDialogField<Category> field, Object element) {
            return ((Category)element).parent;
        }

        @Override
        public boolean hasChildren(TreeListDialogField<Category> field, Object element) {
            return ((Category)element).hasChildren();
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
        }

        @Override
        public void keyPressed(TreeListDialogField<Category> field, KeyEvent event) {
        }

        public int category(Object element) {
            return ((Category)element).index;
        }
    }

    private static class NameStyleLabelProvider
    extends LabelProvider {
        private NameStyleLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ((Category)element).name;
        }
    }

    private static abstract class NameValidator {
        private NameValidator() {
        }

        boolean isValidStart(String prefix) {
            int i = 0;
            while (i < prefix.length()) {
                if (i == 0 ? !this.isValidStart(prefix.charAt(i)) : !this.isValidPart(prefix.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        boolean isValidPart(String part) {
            int i = 0;
            while (i < part.length()) {
                if (!this.isValidPart(part.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        abstract boolean isValidStart(char var1);

        abstract boolean isValidPart(char var1);
    }
}

