/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.io.File;
import java.util.Set;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class PathEntryVariableDialog
extends TitleAreaDialog {
    private Button okButton;
    private Label variableNameLabel;
    private Label variableValueLabel;
    private Text variableNameField;
    private Text variableValueField;
    private Button fileButton;
    private Button folderButton;
    private int type;
    private int variableType;
    private String variableName;
    private String variableValue;
    private String originalName;
    private boolean newVariable;
    private Set<String> namesInUse;
    private int validationStatus;
    private String validationMessage;
    private boolean nameEntered = false;
    private boolean locationEntered = false;
    private final String standardMessage;
    public static final int NEW_VARIABLE = 1;
    public static final int EXISTING_VARIABLE = 2;

    public PathEntryVariableDialog(Shell parentShell, int type, int variableType, Set<String> namesInUse) {
        super(parentShell);
        this.type = type;
        this.newVariable = type == 1;
        this.variableName = "";
        this.variableValue = "";
        this.variableType = variableType;
        this.namesInUse = namesInUse;
        this.standardMessage = this.newVariable ? PreferencesMessages.PathEntryVariableDialog_message_newVariable : PreferencesMessages.PathEntryVariableDialog_message_existingVariable;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.newVariable) {
            shell.setText(PreferencesMessages.PathEntryVariableDialog_shellTitle_newVariable);
        } else {
            shell.setText(PreferencesMessages.PathEntryVariableDialog_shellTitle_existingVariable);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite contents = this.createComposite(parentComposite);
        this.createWidgets(contents, parent.getFont());
        if (this.type == 2) {
            this.locationEntered = true;
            this.nameEntered = true;
            this.validateVariableValue();
        }
        return contents;
    }

    private Composite createComposite(Composite parentComposite) {
        Composite contents = new Composite(parentComposite, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        contents.setLayout((Layout)layout);
        contents.setFont(parentComposite.getFont());
        if (this.newVariable) {
            this.setTitle(PreferencesMessages.PathEntryVariableDialog_dialogTitle_newVariable);
        } else {
            this.setTitle(PreferencesMessages.PathEntryVariableDialog_dialogTitle_existingVariable);
        }
        this.setMessage(this.standardMessage);
        return contents;
    }

    private void createWidgets(Composite contents, Font font) {
        String nameLabelText = PreferencesMessages.PathEntryVariableDialog_variableName;
        String valueLabelText = PreferencesMessages.PathEntryVariableDialog_variableValue;
        this.variableNameLabel = new Label(contents, 16384);
        this.variableNameLabel.setText(nameLabelText);
        FormData data = new FormData();
        this.variableNameLabel.setLayoutData((Object)data);
        this.variableNameLabel.setFont(font);
        this.variableValueLabel = new Label(contents, 16384);
        this.variableValueLabel.setText(valueLabelText);
        data = new FormData();
        data.top = new FormAttachment((Control)this.variableNameLabel, this.convertVerticalDLUsToPixels(10));
        this.variableValueLabel.setLayoutData((Object)data);
        this.variableValueLabel.setFont(font);
        Label largerLabel = nameLabelText.length() > valueLabelText.length() ? this.variableNameLabel : this.variableValueLabel;
        this.variableNameField = new Text(contents, 2052);
        this.variableNameField.setText(this.variableName);
        data = new FormData();
        data.width = this.convertWidthInCharsToPixels(50);
        data.left = new FormAttachment((Control)largerLabel, this.convertHorizontalDLUsToPixels(5));
        this.variableNameField.setLayoutData((Object)data);
        this.variableNameField.setFont(font);
        this.variableNameField.setFocus();
        this.variableNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PathEntryVariableDialog.this.variableNameModified();
            }
        });
        this.variableValueField = new Text(contents, 2052);
        this.variableValueField.setText(this.variableValue);
        data = new FormData();
        data.width = this.convertWidthInCharsToPixels(50);
        data.left = new FormAttachment((Control)largerLabel, this.convertHorizontalDLUsToPixels(5));
        data.top = new FormAttachment((Control)this.variableNameLabel, this.convertVerticalDLUsToPixels(10));
        this.variableValueField.setLayoutData((Object)data);
        this.variableValueField.setFont(font);
        this.variableValueField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PathEntryVariableDialog.this.variableValueModified();
            }
        });
        this.fileButton = new Button(contents, 8);
        this.fileButton.setText(PreferencesMessages.PathEntryVariableDialog_file);
        if ((this.variableType & 1) == 0) {
            this.fileButton.setEnabled(false);
        }
        data = this.setButtonFormLayoutData(this.fileButton);
        data.top = new FormAttachment((Control)this.variableNameLabel, this.convertVerticalDLUsToPixels(10));
        data.left = new FormAttachment((Control)this.variableValueField, this.convertHorizontalDLUsToPixels(10));
        data.right = new FormAttachment(100, -5);
        this.fileButton.setLayoutData((Object)data);
        this.fileButton.setFont(font);
        this.fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathEntryVariableDialog.this.selectFile();
            }
        });
        this.folderButton = new Button(contents, 8);
        this.folderButton.setText(PreferencesMessages.PathEntryVariableDialog_folder);
        if ((this.variableType & 2) == 0) {
            this.folderButton.setEnabled(false);
        }
        data = this.setButtonFormLayoutData(this.folderButton);
        data.top = new FormAttachment((Control)this.variableValueLabel, this.convertVerticalDLUsToPixels(10));
        data.left = new FormAttachment((Control)this.variableValueField, this.convertHorizontalDLUsToPixels(10));
        data.right = new FormAttachment(100, -5);
        this.folderButton.setLayoutData((Object)data);
        this.folderButton.setFont(font);
        this.folderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathEntryVariableDialog.this.selectFolder();
            }
        });
    }

    private FormData setButtonFormLayoutData(Button button) {
        FormData data = new FormData();
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.width = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        return data;
    }

    protected void variableNameModified() {
        this.variableName = this.variableNameField.getText().trim();
        this.validationStatus = 0;
        this.okButton.setEnabled(this.validateVariableName() && this.validateVariableValue());
        this.nameEntered = true;
    }

    protected void variableValueModified() {
        this.variableValue = this.variableValueField.getText().trim();
        this.validationStatus = 0;
        this.okButton.setEnabled(this.validateVariableValue() && this.validateVariableName());
        this.locationEntered = true;
    }

    protected void selectFolder() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText(PreferencesMessages.PathEntryVariableDialog_selectFolderTitle);
        dialog.setMessage(PreferencesMessages.PathEntryVariableDialog_selectFolderMessage);
        dialog.setFilterPath(this.variableValue);
        String res = dialog.open();
        if (res != null) {
            this.variableValue = new Path(res).makeAbsolute().toOSString();
            this.variableValueField.setText(this.variableValue);
        }
    }

    protected void selectFile() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(PreferencesMessages.PathEntryVariableDialog_selectFileTitle);
        dialog.setFilterPath(this.variableValue);
        String res = dialog.open();
        if (res != null) {
            this.variableValue = new Path(res).makeAbsolute().toOSString();
            this.variableValueField.setText(this.variableValue);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(this.type == 2);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private boolean validateVariableName() {
        boolean allowFinish = false;
        if (this.validationStatus == 3) {
            return false;
        }
        String message = this.standardMessage;
        int newValidationStatus = 0;
        if (this.variableName.length() == 0) {
            if (this.nameEntered) {
                newValidationStatus = 3;
                message = PreferencesMessages.PathEntryVariableDialog_variableNameEmptyMessage;
            }
        } else if (this.namesInUse.contains(this.variableName) && !this.variableName.equals(this.originalName)) {
            message = PreferencesMessages.PathEntryVariableDialog_variableAlreadyExistsMessage;
            newValidationStatus = 3;
        } else {
            allowFinish = true;
        }
        if (this.validationStatus == 0 || newValidationStatus == 3) {
            this.validationStatus = newValidationStatus;
            this.validationMessage = message;
        }
        if (!allowFinish) {
            this.setMessage(this.validationMessage, this.validationStatus);
        }
        return allowFinish;
    }

    private boolean validateVariableValue() {
        boolean allowFinish = false;
        if (this.validationStatus == 3) {
            return false;
        }
        String message = this.standardMessage;
        int newValidationStatus = 0;
        if (this.variableValue.length() == 0) {
            if (this.locationEntered) {
                newValidationStatus = 3;
                message = PreferencesMessages.PathEntryVariableDialog_variableValueEmptyMessage;
            }
        } else if (!Path.EMPTY.isValidPath(this.variableValue)) {
            message = PreferencesMessages.PathEntryVariableDialog_variableValueInvalidMessage;
            newValidationStatus = 3;
        } else if (!new Path(this.variableValue).isAbsolute()) {
            message = PreferencesMessages.PathEntryVariableDialog_pathIsRelativeMessage;
            newValidationStatus = 3;
        } else if (!new File(this.variableValue).exists()) {
            message = PreferencesMessages.PathEntryVariableDialog_pathDoesNotExistMessage;
            newValidationStatus = 2;
            allowFinish = true;
        } else {
            allowFinish = true;
        }
        if (this.validationStatus == 0 || newValidationStatus > this.validationStatus) {
            this.validationStatus = newValidationStatus;
            this.validationMessage = message;
        }
        this.setMessage(this.validationMessage, this.validationStatus);
        return allowFinish;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableValue() {
        return this.variableValue;
    }

    public void setVariableName(String variableName) {
        this.originalName = this.variableName = variableName.trim();
    }

    public void setVariableValue(String variableValue) {
        this.variableValue = variableValue;
    }
}

