/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.formatter.qt;

import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.edc.formatter.AbstractCompositeFormatProvider;
import org.eclipse.cdt.debug.edc.formatter.FormatUtils;
import org.eclipse.cdt.debug.edc.formatter.ITypeContentProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableFormatProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableValueConverter;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.debug.edc.services.IEDCExpressions;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IExpressions2;
import org.eclipse.core.runtime.CoreException;

public class QStringFormatter
implements IVariableFormatProvider {
    private static final String TYPE_NAME = "QString";

    public ITypeContentProvider getTypeContentProvider(IType type) {
        return null;
    }

    public IVariableValueConverter getVariableValueConverter(IType type) {
        if (FormatUtils.checkClassOrInheritanceByName(type, TYPE_NAME)) {
            return new FormatProvider(type, false);
        }
        return null;
    }

    public IVariableValueConverter getDetailValueConverter(IType type) {
        if (FormatUtils.checkClassOrInheritanceByName(type, TYPE_NAME)) {
            return new FormatProvider(type, true);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FormatProvider
    extends AbstractCompositeFormatProvider {
        private static final String DATA_NAME = "data";
        private static final String DATA_PATH = "d->data";

        public FormatProvider(IType type, boolean forDetails) {
            super(type, forDetails, FormatProvider.getNameToFieldPaths());
        }

        private static List<AbstractCompositeFormatProvider.NameToFieldPath> getNameToFieldPaths() {
            return Collections.singletonList(new AbstractCompositeFormatProvider.NameToFieldPath(DATA_NAME, DATA_PATH));
        }

        @Override
        protected List<IExpressions.IExpressionDMContext> getChildren(IExpressions.IExpressionDMContext variable) throws CoreException {
            IEDCExpression dataChild = (IEDCExpression)FormatUtils.findInCollectionByName(super.getChildren(variable), DATA_NAME);
            IEDCExpressions expressions2 = dataChild.getExpressionsService();
            IExpressions2.CastInfo castInfo = new IExpressions2.CastInfo("wchar_t*");
            IExpressions2.ICastedExpressionDMContext castedChild = expressions2.createCastedExpression(dataChild, castInfo);
            return Collections.singletonList(castedChild);
        }

        @Override
        public String getValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            List<IExpressions.IExpressionDMContext> children = this.getChildren(variable);
            IExpressions.IExpressionDMContext dataChild = children.get(0);
            IVariableValueConverter valueConverter = FormatUtils.getCustomValueConverter(dataChild);
            if (valueConverter != null) {
                return valueConverter.getValue(dataChild);
            }
            return "";
        }
    }
}

