/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.scripting;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.edc.internal.scripting.DOMUtils;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.services.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtils {
    public static String createStackFrameLabel(Map<String, Object> frameData) {
        int line;
        String file;
        String function;
        StringBuilder label = new StringBuilder();
        Object o = frameData.get("function_name");
        if (o != null && (function = o.toString()).length() > 0) {
            label.append(function);
            label.append("()");
        }
        if ((o = frameData.get("source_file")) != null && (file = o.toString()).length() > 0) {
            label.append(" at ");
            label.append(file);
        }
        if ((o = frameData.get("line_number")) != null && (line = ((Integer)o).intValue()) >= 0) {
            label.append(": ");
            label.append(line);
        }
        return label.toString();
    }

    public static Object getStackFrameObjectFromLabel(String sessionId, String label) throws Exception {
        List<RunControl.ExecutionDMC> suspendedThreads = DOMUtils.getSuspendedThreads(sessionId);
        if (suspendedThreads.isEmpty()) {
            throw new IllegalStateException("TestUtils.getStackFrameObjectFromLabel called with no suspended threads");
        }
        if (suspendedThreads.size() > 1) {
            throw new IllegalStateException("TestUtils.getStackFrameObjectFromLabel called with multiple suspended threads");
        }
        RunControl.ExecutionDMC executionDMC = suspendedThreads.get(0);
        List<Stack.StackFrameDMC> stackFrames = DOMUtils.getStackFrames(executionDMC.getID());
        for (Stack.StackFrameDMC frame : stackFrames) {
            String testLabel = MessageFormat.format("{0}:{1}", frame.getSourceFile(), frame.getLineNumber());
            if (testLabel.indexOf(label) < 0) continue;
            return frame;
        }
        return null;
    }
}

