/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import java.util.Map;
import org.eclipse.cdt.debug.edc.internal.symbols.ConstType;
import org.eclipse.cdt.debug.edc.internal.symbols.IMayBeQualifedType;
import org.eclipse.cdt.debug.edc.internal.symbols.IQualifierType;
import org.eclipse.cdt.debug.edc.internal.symbols.Type;
import org.eclipse.cdt.debug.edc.internal.symbols.VolatileType;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.cdt.debug.edc.symbols.IType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MayBeQualifiedType
extends Type
implements IMayBeQualifedType {
    boolean qualifiersChecked = false;
    boolean isConst = false;
    boolean isVolatile = false;

    public MayBeQualifiedType(String name, IScope scope, int byteSize, Map<Object, Object> properties) {
        super(name, scope, byteSize, properties);
    }

    @Override
    public boolean isConst() {
        if (!this.qualifiersChecked) {
            this.checkQualifiers();
        }
        return this.isConst;
    }

    @Override
    public boolean isVolatile() {
        if (!this.qualifiersChecked) {
            this.checkQualifiers();
        }
        return this.isVolatile;
    }

    private void checkQualifiers() {
        IType checkedType = this.getType();
        while (checkedType != null && checkedType instanceof IQualifierType) {
            this.isConst |= checkedType instanceof ConstType;
            this.isVolatile |= checkedType instanceof VolatileType;
            checkedType = checkedType.getType();
        }
        this.qualifiersChecked = true;
    }
}

