/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.gdbjtag.core;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.gdbjtag.core.Activator;
import org.eclipse.cdt.debug.gdbjtag.core.GDBJtagCommandFactory;
import org.eclipse.cdt.debug.gdbjtag.core.IGDBJtagConnection;
import org.eclipse.cdt.debug.gdbjtag.core.Messages;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContribution;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContributionFactory;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.IGDBJtagDevice;
import org.eclipse.cdt.debug.mi.core.AbstractGDBCDIDebugger;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CLICommand;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MICommand;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSetNewConsole;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDBJtagDebugger
extends AbstractGDBCDIDebugger {
    private String miVersion;

    public ICDISession createSession(ILaunch launch, File executable, IProgressMonitor monitor) throws CoreException {
        return super.createSession(launch, executable, monitor);
    }

    public ICDISession createDebuggerSession(ILaunch launch, IBinaryParser.IBinaryObject exe, IProgressMonitor monitor) throws CoreException {
        return super.createDebuggerSession(launch, exe, monitor);
    }

    protected CommandFactory getCommandFactory(ILaunchConfiguration config) throws CoreException {
        this.miVersion = MIPlugin.getMIVersion((ILaunchConfiguration)config);
        return new GDBJtagCommandFactory(this.miVersion);
    }

    protected void doStartSession(ILaunch launch, Session session, IProgressMonitor monitor) throws CoreException {
        block34: {
            SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                IGDBJtagDevice gdbJtagDevice;
                submonitor.subTask(Messages.getString("GDBJtagDebugger.0"));
                ILaunchConfiguration config = launch.getLaunchConfiguration();
                ICDITarget[] targets = session.getTargets();
                if (targets.length == 0 || !(targets[0] instanceof Target)) {
                    Activator.log((IStatus)new Status(4, Activator.getUniqueIdentifier(), 120, Messages.getString("GDBJtagDebugger.1"), null));
                    return;
                }
                MISession miSession = ((Target)targets[0]).getMISession();
                CommandFactory factory = miSession.getCommandFactory();
                if (submonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    MIGDBSetNewConsole newConsole = factory.createMIGDBSetNewConsole();
                    miSession.postCommand((Command)newConsole);
                    MIInfo info = newConsole.getMIInfo();
                    if (info == null) {
                        throw new MIException(MIPlugin.getResourceString((String)"src.common.No_answer"));
                    }
                }
                catch (MIException mIException) {}
                submonitor.worked(10);
                if (submonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    gdbJtagDevice = this.getGDBJtagDevice(config);
                }
                catch (NullPointerException nullPointerException) {
                    return;
                }
                ArrayList<String> commands = new ArrayList<String>();
                if (submonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                boolean doLoadSymbols = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", true);
                if (doLoadSymbols) {
                    String symbolsFileName = null;
                    if (config.hasAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols") && config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", true)) {
                        IPath programFile = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
                        if (programFile != null) {
                            symbolsFileName = programFile.toOSString();
                        }
                    } else {
                        symbolsFileName = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", "");
                        if (symbolsFileName.length() > 0) {
                            symbolsFileName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(symbolsFileName);
                        }
                    }
                    if (symbolsFileName == null) {
                        throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), -1, Messages.getString("GDBJtagDebugger.err_no_sym_file"), null));
                    }
                    symbolsFileName = symbolsFileName.replace("\\", "\\\\");
                    String symbolsOffset = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", "");
                    if (symbolsOffset.length() > 0) {
                        symbolsOffset = "0x" + symbolsOffset;
                    }
                    commands.clear();
                    gdbJtagDevice.doLoadSymbol(symbolsFileName, symbolsOffset, commands);
                    monitor.beginTask(Messages.getString("GDBJtagDebugger.loading_symbols"), 1);
                    this.executeGDBScript(this.getGDBScript(commands), miSession, (IProgressMonitor)submonitor.newChild(15));
                }
                if (submonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                boolean useRemote = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
                if (useRemote) {
                    submonitor.subTask(Messages.getString("GDBJtagDebugger.2"));
                    try {
                        commands.clear();
                        if (gdbJtagDevice instanceof IGDBJtagConnection) {
                            URI connection = new URI(config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.connection", "unspecified-ip-address:unspecified-port-number"));
                            IGDBJtagConnection device = (IGDBJtagConnection)((Object)gdbJtagDevice);
                            device.doRemote(connection.getSchemeSpecificPart(), commands);
                        } else {
                            String ipAddress = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "");
                            int portNumber = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", 0);
                            gdbJtagDevice.doRemote(ipAddress, portNumber, commands);
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new OperationCanceledException();
                    }
                    this.executeGDBScript(this.getGDBScript(commands), miSession, (IProgressMonitor)submonitor.newChild(10));
                    if (submonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                }
                submonitor.subTask(Messages.getString("GDBJtagDebugger.3"));
                submonitor.setWorkRemaining(80);
                if (config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.doReset", true)) {
                    commands.clear();
                    gdbJtagDevice.doReset(commands);
                    int defaultDelay = gdbJtagDevice.getDefaultDelay();
                    gdbJtagDevice.doDelay(config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.delay", defaultDelay), commands);
                    this.executeGDBScript(this.getGDBScript(commands), miSession, (IProgressMonitor)submonitor.newChild(15));
                }
                submonitor.setWorkRemaining(65);
                if (config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.doHalt", true)) {
                    commands.clear();
                    gdbJtagDevice.doHalt(commands);
                    this.executeGDBScript(this.getGDBScript(commands), miSession, (IProgressMonitor)submonitor.newChild(15));
                }
                submonitor.setWorkRemaining(50);
                this.executeGDBScript(config, "org.eclipse.cdt.debug.gdbjtag.core.initCommands", miSession, (IProgressMonitor)submonitor.newChild(15));
                boolean doLoad = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadImage", true);
                if (doLoad) {
                    String imageFileName = null;
                    if (config.hasAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage") && config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", true)) {
                        IPath programFile = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
                        if (programFile != null) {
                            imageFileName = programFile.toOSString();
                        }
                    } else {
                        imageFileName = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageFileName", "");
                        if (imageFileName.length() > 0) {
                            imageFileName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(imageFileName);
                        }
                    }
                    if (imageFileName == null) {
                        throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), -1, Messages.getString("GDBJtagDebugger.err_no_img_file"), null));
                    }
                    imageFileName = imageFileName.replace("\\", "\\\\");
                    String imageOffset = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", "");
                    if (imageOffset.length() > 0) {
                        imageOffset = imageFileName.endsWith(".elf") ? "" : "0x" + config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", "");
                    }
                    commands.clear();
                    gdbJtagDevice.doLoadImage(imageFileName, imageOffset, commands);
                    monitor.beginTask(Messages.getString("GDBJtagDebugger.loading_image"), 1);
                    this.executeGDBScript(this.getGDBScript(commands), miSession, (IProgressMonitor)submonitor.newChild(20));
                }
                submonitor.setWorkRemaining(15);
            }
            catch (OperationCanceledException operationCanceledException) {
                if (launch == null || !launch.canTerminate()) break block34;
                launch.terminate();
            }
        }
    }

    public void doRunSession(ILaunch launch, ICDISession session, IProgressMonitor monitor) throws CoreException {
        block9: {
            SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                IGDBJtagDevice gdbJtagDevice;
                ILaunchConfiguration config = launch.getLaunchConfiguration();
                ICDITarget[] targets = session.getTargets();
                if (targets.length == 0 || !(targets[0] instanceof Target)) {
                    return;
                }
                MISession miSession = ((Target)targets[0]).getMISession();
                try {
                    gdbJtagDevice = this.getGDBJtagDevice(config);
                }
                catch (NullPointerException nullPointerException) {
                    return;
                }
                if (submonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                submonitor.worked(20);
                ArrayList<String> commands = new ArrayList<String>();
                boolean setPc = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", false);
                if (setPc) {
                    String pcRegister = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.pcRegister", config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", ""));
                    gdbJtagDevice.doSetPC(pcRegister, commands);
                    this.executeGDBScript(this.getGDBScript(commands), miSession, (IProgressMonitor)submonitor.newChild(20));
                }
                submonitor.setWorkRemaining(60);
                monitor.beginTask(Messages.getString("GDBJtagDebugger.18"), 1);
                boolean setStopAt = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.setStopAt", false);
                if (setStopAt) {
                    String stopAt = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.stopAt", "");
                    commands.clear();
                    gdbJtagDevice.doStopAt(stopAt, commands);
                    this.executeGDBScript(this.getGDBScript(commands), miSession, (IProgressMonitor)submonitor.newChild(20));
                }
                submonitor.setWorkRemaining(40);
                boolean setResume = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.setResume", false);
                if (setResume) {
                    commands.clear();
                    gdbJtagDevice.doContinue(commands);
                    this.executeGDBScript(this.getGDBScript(commands), miSession, (IProgressMonitor)submonitor.newChild(20));
                }
                submonitor.setWorkRemaining(20);
                this.executeGDBScript(config, "org.eclipse.cdt.debug.gdbjtag.core.runCommands", miSession, (IProgressMonitor)submonitor.newChild(20));
            }
            catch (OperationCanceledException operationCanceledException) {
                if (launch == null || !launch.canTerminate()) break block9;
                launch.terminate();
            }
        }
    }

    private void executeGDBScript(String script, MISession miSession, IProgressMonitor monitor) throws CoreException {
        if (script == null || script.length() == 0) {
            return;
        }
        script = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(script);
        String[] commands = script.split("\\r?\\n");
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)commands.length);
        int j = 0;
        while (j < commands.length) {
            try {
                submonitor.subTask(String.valueOf(Messages.getString("GDBJtagDebugger.21")) + commands[j]);
                Object cmd = null;
                cmd = commands[j].startsWith("-") ? new MICommand(this.miVersion, commands[j]) : new CLICommand(commands[j]);
                miSession.postCommand((Command)cmd, Integer.MAX_VALUE);
                submonitor.worked(1);
                if (submonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                MIInfo info = cmd.getMIInfo();
                if (info == null) {
                    throw new MIException("Timeout");
                }
            }
            catch (MIException e) {
                MultiStatus status = new MultiStatus("org.eclipse.cdt.debug.gdbjtag.core", 150, Messages.getString("GDBJtagDebugger.22"), (Throwable)e);
                status.add((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", 150, e == null ? "" : e.getLocalizedMessage(), (Throwable)e));
                CDebugCorePlugin.log((IStatus)status);
            }
            ++j;
        }
    }

    private void executeGDBScript(ILaunchConfiguration configuration, String attribute, MISession miSession, IProgressMonitor monitor) throws CoreException {
        this.executeGDBScript(configuration.getAttribute(attribute, ""), miSession, monitor);
    }

    private IGDBJtagDevice getGDBJtagDevice(ILaunchConfiguration config) throws CoreException, NullPointerException {
        IGDBJtagDevice gdbJtagDevice = null;
        String jtagDeviceName = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "");
        GDBJtagDeviceContribution[] availableDevices = GDBJtagDeviceContributionFactory.getInstance().getGDBJtagDeviceContribution();
        int i = 0;
        while (i < availableDevices.length) {
            if (jtagDeviceName.equals(availableDevices[i].getDeviceName())) {
                gdbJtagDevice = availableDevices[i].getDevice();
                break;
            }
            ++i;
        }
        return gdbJtagDevice;
    }

    private String getGDBScript(List<String> commands) {
        if (commands.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (String cmd : commands) {
            sb.append(cmd);
        }
        return sb.toString();
    }
}

