/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.ui.quickfix;

import java.util.HashMap;
import org.eclipse.cdt.codan.core.cxx.CxxAstUtils;
import org.eclipse.cdt.codan.internal.checkers.ui.CheckersUiActivator;
import org.eclipse.cdt.codan.internal.checkers.ui.quickfix.Messages;
import org.eclipse.cdt.codan.ui.AbstractAstRewriteQuickFix;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.CompositeChange;

public class QuickFixCreateParameter
extends AbstractAstRewriteQuickFix {
    public String getLabel() {
        return Messages.QuickFixCreateParameter_0;
    }

    public void modifyAST(IIndex index, IMarker marker) {
        CxxAstUtils utils = CxxAstUtils.getInstance();
        CompositeChange c = new CompositeChange(Messages.QuickFixCreateParameter_0);
        try {
            ITranslationUnit baseTU = this.getTranslationUnitViaEditor(marker);
            IASTTranslationUnit baseAST = baseTU.getAST(index, 2);
            IASTName astName = this.getASTNameFromMarker(marker, baseAST);
            if (astName == null) {
                return;
            }
            IASTDeclaration declaration = CxxAstUtils.getInstance().createDeclaration(astName, baseAST.getASTNodeFactory(), index);
            IASTDeclSpecifier finalDeclSpec = (IASTDeclSpecifier)declaration.getChildren()[0];
            IASTDeclarator finalDeclarator = (IASTDeclarator)declaration.getChildren()[1];
            IASTFunctionDefinition function = utils.getEnclosingFunction((IASTNode)astName);
            if (function == null) {
                return;
            }
            CxxAstUtils.NameFinderVisitor nameFinderVisitor = new CxxAstUtils.NameFinderVisitor();
            function.accept((ASTVisitor)nameFinderVisitor);
            IASTName funcName = nameFinderVisitor.name;
            IBinding binding = funcName.resolveBinding();
            IIndexName[] declarations = index.findNames(binding, 3);
            if (declarations.length == 0) {
                return;
            }
            HashMap<ITranslationUnit, IASTTranslationUnit> cachedASTs = new HashMap<ITranslationUnit, IASTTranslationUnit>();
            HashMap<ITranslationUnit, ASTRewrite> cachedRewrites = new HashMap<ITranslationUnit, ASTRewrite>();
            IIndexName[] iIndexNameArray = declarations;
            int n = declarations.length;
            int n2 = 0;
            while (n2 < n) {
                ASTRewrite rewrite;
                IASTTranslationUnit declAST;
                IIndexName iname = iIndexNameArray[n2];
                ITranslationUnit declTU = utils.getTranslationUnitFromIndexName(iname);
                if (!cachedASTs.containsKey(declTU)) {
                    declAST = declTU.getAST(index, 2);
                    rewrite = ASTRewrite.create((IASTTranslationUnit)declAST);
                    cachedASTs.put(declTU, declAST);
                    cachedRewrites.put(declTU, rewrite);
                } else {
                    declAST = (IASTTranslationUnit)cachedASTs.get(declTU);
                    rewrite = (ASTRewrite)cachedRewrites.get(declTU);
                }
                IASTFileLocation fileLocation = iname.getFileLocation();
                IASTName declName = declAST.getNodeSelector(null).findEnclosingName(fileLocation.getNodeOffset(), fileLocation.getNodeLength());
                if (declName != null) {
                    INodeFactory factory = declAST.getASTNodeFactory();
                    IASTName n3 = declName;
                    while (n3 instanceof IASTName) {
                        n3 = n3.getParent();
                    }
                    IASTFunctionDeclarator functionDecl = (IASTFunctionDeclarator)n3;
                    IASTParameterDeclaration newParam = factory.newParameterDeclaration(finalDeclSpec, finalDeclarator);
                    rewrite.insertBefore((IASTNode)functionDecl, null, (IASTNode)newParam, null);
                }
                ++n2;
            }
            for (ASTRewrite rewrite : cachedRewrites.values()) {
                c.add(rewrite.rewriteAST());
            }
            c.perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
        }
    }

    public boolean isApplicable(IMarker marker) {
        String problemArgument = this.getProblemArgument(marker, 1);
        return problemArgument.contains(":func");
    }
}

