/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.changegenerator;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModification;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModificationMap;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModificationStore;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTRewriteAnalyzer;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ProblemRuntimeException;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.Messages;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.UnhandledASTModificationException;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;
import org.eclipse.cdt.internal.core.dom.rewrite.util.FileContentHelper;
import org.eclipse.cdt.internal.core.dom.rewrite.util.FileHelper;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationResolver;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeGenerator
extends ASTVisitor {
    private final LinkedHashMap<String, Integer> sourceOffsets = new LinkedHashMap();
    public LinkedHashMap<IASTNode, List<ASTModification>> modificationParent = new LinkedHashMap();
    private final LinkedHashMap<IFile, MultiTextEdit> changes = new LinkedHashMap();
    private CompositeChange change;
    private final ASTModificationStore modificationStore;
    private NodeCommentMap commentMap;

    public ChangeGenerator(ASTModificationStore modificationStore, NodeCommentMap commentMap) {
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.shouldVisitNames = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitDeclSpecifiers = true;
        this.shouldVisitDeclarators = true;
        this.shouldVisitArrayModifiers = true;
        this.shouldVisitInitializers = true;
        this.shouldVisitBaseSpecifiers = true;
        this.shouldVisitNamespaces = true;
        this.shouldVisitTemplateParameters = true;
        this.shouldVisitParameterDeclarations = true;
        this.shouldVisitTranslationUnit = true;
        this.modificationStore = modificationStore;
        this.commentMap = commentMap;
    }

    public void generateChange(IASTNode rootNode) throws ProblemRuntimeException {
        this.generateChange(rootNode, this);
    }

    public void generateChange(IASTNode rootNode, ASTVisitor pathProvider) throws ProblemRuntimeException {
        this.change = new CompositeChange(Messages.ChangeGenerator_compositeChange);
        this.initParentModList();
        rootNode.accept(pathProvider);
        for (IFile currentFile : this.changes.keySet()) {
            TextFileChange subchange = ASTRewriteAnalyzer.createCTextFileChange(currentFile);
            subchange.setEdit((TextEdit)this.changes.get(currentFile));
            this.change.add((Change)subchange);
        }
    }

    private void initParentModList() {
        ASTModificationMap rootModifications = this.modificationStore.getRootModifications();
        if (rootModifications != null) {
            for (IASTNode modifiedNode : rootModifications.getModifiedNodes()) {
                List<ASTModification> modificationsForNode;
                IASTNode modifiedNodeParent = this.determineParentToBeRewritten(modifiedNode, modificationsForNode = rootModifications.getModificationsForNode(modifiedNode));
                List<ASTModification> list = this.modificationParent.get(modifiedNodeParent != null ? modifiedNodeParent : modifiedNode);
                if (list != null) {
                    list.addAll(modificationsForNode);
                    continue;
                }
                ArrayList<ASTModification> modifiableList = new ArrayList<ASTModification>(modificationsForNode);
                this.modificationParent.put(modifiedNodeParent != null ? modifiedNodeParent : modifiedNode, modifiableList);
            }
        }
    }

    private IASTNode determineParentToBeRewritten(IASTNode modifiedNode, List<ASTModification> modificationsForNode) {
        IASTNode modifiedNodeParent = modifiedNode;
        for (ASTModification currentModification : modificationsForNode) {
            if (currentModification.getKind() != ASTModification.ModificationKind.REPLACE) continue;
            modifiedNodeParent = modifiedNode.getParent();
            break;
        }
        modifiedNodeParent = modifiedNodeParent != null ? modifiedNodeParent : modifiedNode;
        return modifiedNodeParent;
    }

    @Override
    public int visit(IASTTranslationUnit translationUnit) {
        if (this.hasChangedChild(translationUnit)) {
            this.synthTreatment(translationUnit);
        }
        IASTFileLocation location = this.getFileLocationOfEmptyTranslationUnit(translationUnit);
        this.sourceOffsets.put(location.getFileName(), location.getNodeOffset());
        return super.visit(translationUnit);
    }

    public IASTFileLocation getFileLocationOfEmptyTranslationUnit(IASTNode node) {
        IASTFileLocation fileLocation = node.getFileLocation();
        if (fileLocation == null) {
            ILocationResolver lr = (ILocationResolver)node.getTranslationUnit().getAdapter(ILocationResolver.class);
            fileLocation = lr != null ? lr.getMappedFileLocation(0, 0) : node.getTranslationUnit().flattenLocationsToFile(node.getNodeLocations());
        }
        return fileLocation;
    }

    @Override
    public int leave(IASTTranslationUnit tu) {
        return super.leave(tu);
    }

    private int getOffsetForNodeFile(IASTNode rootNode) {
        Integer offset = this.sourceOffsets.get(rootNode.getFileLocation().getFileName());
        return offset == null ? 0 : offset;
    }

    @Override
    public int visit(IASTDeclaration declaration) {
        if (this.hasChangedChild(declaration)) {
            this.synthTreatment(declaration);
            return 1;
        }
        return super.visit(declaration);
    }

    private void synthTreatment(IASTNode synthNode) {
        this.synthTreatment(synthNode, null);
    }

    private void synthTreatment(IASTNode synthNode, String fileScope) {
        String indent = this.getIndent(synthNode);
        ASTWriter synthWriter = new ASTWriter(indent);
        synthWriter.setModificationStore(this.modificationStore);
        String synthSource = synthWriter.write(synthNode, fileScope, this.commentMap);
        this.createChange(synthNode, synthSource);
        int newOffset = synthNode.getFileLocation().getNodeOffset() + synthNode.getFileLocation().getNodeLength();
        this.sourceOffsets.put(synthNode.getFileLocation().getFileName(), newOffset);
    }

    private void synthTreatment(IASTTranslationUnit synthTU) {
        ASTWriter synthWriter = new ASTWriter();
        synthWriter.setModificationStore(this.modificationStore);
        for (ASTModification modification : this.modificationParent.get(synthTU)) {
            MultiTextEdit edit;
            IASTFileLocation targetLocation = this.getFileLocationOfEmptyTranslationUnit(modification.getTargetNode());
            String currentFile = targetLocation.getFileName();
            Path implPath = new Path(currentFile);
            IFile relevantFile = ResourceLookup.selectFileForLocation((IPath)implPath, null);
            if (relevantFile == null || !relevantFile.exists()) {
                throw new UnhandledASTModificationException(modification);
            }
            if (this.changes.containsKey(relevantFile)) {
                edit = this.changes.get(relevantFile);
            } else {
                edit = new MultiTextEdit();
                this.changes.put(relevantFile, edit);
            }
            String newNodeCode = synthWriter.write(modification.getNewNode(), null, this.commentMap);
            switch (modification.getKind()) {
                case REPLACE: {
                    edit.addChild((TextEdit)new ReplaceEdit(targetLocation.getNodeOffset(), targetLocation.getNodeLength(), newNodeCode));
                    break;
                }
                case INSERT_BEFORE: {
                    edit.addChild((TextEdit)new InsertEdit(this.getOffsetIncludingComments(modification.getTargetNode()), newNodeCode));
                    break;
                }
                case APPEND_CHILD: {
                    if (modification.getTargetNode() instanceof IASTTranslationUnit && ((IASTTranslationUnit)modification.getTargetNode()).getDeclarations().length > 0) {
                        IASTTranslationUnit tu = (IASTTranslationUnit)modification.getTargetNode();
                        IASTDeclaration lastDecl = tu.getDeclarations()[tu.getDeclarations().length - 1];
                        targetLocation = lastDecl.getFileLocation();
                    }
                    String lineDelimiter = FileHelper.determineLineDelimiter(FileHelper.getIFilefromIASTNode(modification.getTargetNode()));
                    edit.addChild((TextEdit)new InsertEdit(targetLocation.getNodeOffset() + targetLocation.getNodeLength(), String.valueOf(lineDelimiter) + lineDelimiter + newNodeCode));
                }
            }
        }
    }

    private void createChange(IASTNode synthNode, String synthSource) {
        MultiTextEdit edit;
        IFile relevantFile = FileHelper.getIFilefromIASTNode(synthNode);
        String originalCode = this.originalCodeOfNode(synthNode);
        CodeComparer codeComparer = new CodeComparer(originalCode, synthSource);
        if (this.changes.containsKey(relevantFile)) {
            edit = this.changes.get(relevantFile);
        } else {
            edit = new MultiTextEdit();
            this.changes.put(relevantFile, edit);
        }
        codeComparer.createChange(edit, synthNode);
    }

    public String originalCodeOfNode(IASTNode node) {
        if (node.getFileLocation() != null) {
            IFile sourceFile = FileHelper.getIFilefromIASTNode(node);
            int nodeOffset = this.getOffsetIncludingComments(node);
            int nodeLength = this.getNodeLengthIncludingComments(node);
            return FileContentHelper.getContent(sourceFile, nodeOffset, nodeLength);
        }
        return null;
    }

    private int getNodeLengthIncludingComments(IASTNode node) {
        int nodeOffset = node.getFileLocation().getNodeOffset();
        int nodeLength = node.getFileLocation().getNodeLength();
        ArrayList<IASTComment> comments = this.commentMap.getAllCommentsForNode(node);
        if (!comments.isEmpty()) {
            int startOffset = nodeOffset;
            int endOffset = nodeOffset + nodeLength;
            for (IASTComment comment : comments) {
                IASTFileLocation commentLocation = comment.getFileLocation();
                if (commentLocation.getNodeOffset() < startOffset) {
                    startOffset = commentLocation.getNodeOffset();
                }
                if (commentLocation.getNodeOffset() + commentLocation.getNodeLength() < endOffset) continue;
                endOffset = commentLocation.getNodeOffset() + commentLocation.getNodeLength();
            }
            nodeLength = endOffset - startOffset;
        }
        return nodeLength;
    }

    private int getOffsetIncludingComments(IASTNode node) {
        int nodeOffset = node.getFileLocation().getNodeOffset();
        ArrayList<IASTComment> comments = this.commentMap.getAllCommentsForNode(node);
        if (!comments.isEmpty()) {
            int startOffset = nodeOffset;
            for (IASTComment comment : comments) {
                IASTFileLocation commentLocation = comment.getFileLocation();
                if (commentLocation.getNodeOffset() >= startOffset) continue;
                startOffset = commentLocation.getNodeOffset();
            }
            nodeOffset = startOffset;
        }
        return nodeOffset;
    }

    private String getIndent(IASTNode nextNode) {
        IASTFileLocation fileLocation = nextNode.getFileLocation();
        int length = fileLocation.getNodeOffset() - this.getOffsetForNodeFile(nextNode);
        String originalSource = FileContentHelper.getContent(FileHelper.getIFilefromIASTNode(nextNode), this.getOffsetForNodeFile(nextNode), length);
        StringBuilder indent = new StringBuilder(originalSource);
        indent.reverse();
        String lastline = indent.substring(0, Math.max(indent.indexOf("\n"), 0));
        if (lastline.trim().length() == 0) {
            return lastline;
        }
        return "";
    }

    private boolean hasChangedChild(IASTNode parent) {
        return this.modificationParent.containsKey(parent);
    }

    @Override
    public int visit(IASTDeclarator declarator) {
        if (this.hasChangedChild(declarator)) {
            this.synthTreatment(declarator);
            return 1;
        }
        return super.visit(declarator);
    }

    @Override
    public int visit(IASTArrayModifier mod) {
        if (this.hasChangedChild(mod)) {
            this.synthTreatment(mod);
            return 1;
        }
        return super.visit(mod);
    }

    @Override
    public int visit(ICPPASTNamespaceDefinition namespaceDefinition) {
        if (this.hasChangedChild(namespaceDefinition)) {
            this.synthTreatment(namespaceDefinition);
            return 1;
        }
        return super.visit(namespaceDefinition);
    }

    @Override
    public int visit(IASTDeclSpecifier declSpec) {
        if (this.hasChangedChild(declSpec)) {
            this.synthTreatment(declSpec);
            return 1;
        }
        return super.visit(declSpec);
    }

    @Override
    public int visit(IASTExpression expression) {
        if (this.hasChangedChild(expression)) {
            this.synthTreatment(expression);
            return 1;
        }
        return super.visit(expression);
    }

    @Override
    public int visit(IASTInitializer initializer) {
        if (this.hasChangedChild(initializer)) {
            this.synthTreatment(initializer);
            return 1;
        }
        return super.visit(initializer);
    }

    @Override
    public int visit(IASTName name) {
        if (this.hasChangedChild(name)) {
            this.synthTreatment(name);
            return 1;
        }
        return super.visit(name);
    }

    @Override
    public int visit(IASTParameterDeclaration parameterDeclaration) {
        if (this.hasChangedChild(parameterDeclaration)) {
            this.synthTreatment(parameterDeclaration);
            return 1;
        }
        return super.visit(parameterDeclaration);
    }

    @Override
    public int visit(IASTStatement statement) {
        if (this.hasChangedChild(statement)) {
            this.synthTreatment(statement);
            return 1;
        }
        return super.visit(statement);
    }

    public Change getChange() {
        return this.change;
    }

    class CodeComparer {
        private final StringBuilder originalCode;
        private final StringBuilder synthCode;
        private int lastCommonInSynthStart;
        private int lastCommonInOriginalStart;
        private int firstCommonInSynthEnd;
        private int firstCommonInOriginalEnd;

        public CodeComparer(String originalCode, String synthCode) {
            this.originalCode = new StringBuilder(originalCode);
            this.synthCode = new StringBuilder(synthCode);
            this.calculatePositions();
        }

        private void calculatePositions() {
            this.lastCommonInSynthStart = this.calcLastCommonPositionInSynthCode();
            this.lastCommonInOriginalStart = this.calcLastCommonPositionInOriginalCode();
            this.firstCommonInSynthEnd = this.calcFirstPositionOfCommonEndInSynthCode(this.lastCommonInSynthStart, this.lastCommonInOriginalStart);
            this.firstCommonInOriginalEnd = this.calcFirstPositionOfCommonEndInOriginalCode(this.lastCommonInOriginalStart, this.lastCommonInSynthStart);
            this.trimTrailingNewlines();
        }

        private void trimTrailingNewlines() {
            int prevOrigEnd = this.firstCommonInOriginalEnd - 1;
            while (prevOrigEnd > this.lastCommonInOriginalStart && prevOrigEnd > -1 && this.isUninterresting(this.originalCode, prevOrigEnd)) {
                this.firstCommonInOriginalEnd = prevOrigEnd--;
            }
            while (this.firstCommonInOriginalEnd > 0 && this.firstCommonInOriginalEnd + 1 < this.originalCode.length() && (this.originalCode.charAt(this.firstCommonInOriginalEnd) == ' ' || this.originalCode.charAt(this.firstCommonInOriginalEnd) == '\t')) {
                ++this.firstCommonInOriginalEnd;
            }
            int prevSynthEnd = this.firstCommonInSynthEnd - 1;
            while (prevSynthEnd > this.lastCommonInSynthStart && prevSynthEnd > -1 && this.isUninterresting(this.synthCode, prevSynthEnd)) {
                this.firstCommonInSynthEnd = prevSynthEnd--;
            }
            while (this.firstCommonInSynthEnd > 0 && this.firstCommonInSynthEnd + 1 < this.synthCode.length() && (this.synthCode.charAt(this.firstCommonInSynthEnd) == ' ' || this.synthCode.charAt(this.firstCommonInSynthEnd) == '\t')) {
                ++this.firstCommonInSynthEnd;
            }
        }

        public int getLastCommonPositionInSynthCode() {
            return this.lastCommonInSynthStart;
        }

        public int getLastCommonPositionInOriginalCode() {
            return this.lastCommonInOriginalStart;
        }

        public int getFirstPositionOfCommonEndInOriginalCode() {
            return this.firstCommonInOriginalEnd;
        }

        public int getFirstPositionOfCommonEndInSynthCode() {
            return this.firstCommonInSynthEnd;
        }

        public int calcLastCommonPositionInSynthCode() {
            return this.findLastCommonPosition(this.synthCode, this.originalCode);
        }

        public int calcLastCommonPositionInOriginalCode() {
            return this.findLastCommonPosition(this.originalCode, this.synthCode);
        }

        private int calcFirstPositionOfCommonEndInOriginalCode(int originalLimit, int synthLimit) {
            StringBuilder reverseSynthCode;
            StringBuilder reverseOriginalCode = new StringBuilder(this.originalCode).reverse();
            int lastCommonPosition = this.findLastCommonPosition(reverseOriginalCode, reverseSynthCode = new StringBuilder(this.synthCode).reverse(), reverseOriginalCode.length() - originalLimit - 1, reverseSynthCode.length() - synthLimit - 1);
            if (lastCommonPosition < 0 || lastCommonPosition >= this.originalCode.length()) {
                return -1;
            }
            return this.originalCode.length() - lastCommonPosition - 1;
        }

        private int calcFirstPositionOfCommonEndInSynthCode(int synthLimit, int originalLimit) {
            StringBuilder reverseOriginalCode = new StringBuilder(this.originalCode).reverse();
            StringBuilder reverseSynthCode = new StringBuilder(this.synthCode).reverse();
            int lastCommonPosition = this.findLastCommonPosition(reverseSynthCode, reverseOriginalCode, reverseSynthCode.length() - synthLimit - 1, reverseOriginalCode.length() - originalLimit - 1);
            if (lastCommonPosition < 0 || lastCommonPosition >= this.synthCode.length()) {
                return -1;
            }
            return this.synthCode.length() - lastCommonPosition - 1;
        }

        private int findLastCommonPosition(StringBuilder first, StringBuilder second) {
            return this.findLastCommonPosition(first, second, first.length(), second.length());
        }

        private int findLastCommonPosition(StringBuilder first, StringBuilder second, int firstLimit, int secondLimit) {
            int firstIndex = -1;
            int secondIndex = -1;
            int lastCommonIndex = -1;
            do {
                lastCommonIndex = firstIndex;
                firstIndex = this.nextInterrestingPosition(first, firstIndex);
                secondIndex = this.nextInterrestingPosition(second, secondIndex);
            } while (firstIndex > -1 && firstIndex <= firstLimit && secondIndex > -1 && secondIndex <= secondLimit && first.charAt(firstIndex) == second.charAt(secondIndex));
            return lastCommonIndex;
        }

        private int nextInterrestingPosition(StringBuilder code, int position) {
            do {
                if (++position < code.length()) continue;
                return -1;
            } while (this.isUninterresting(code, position));
            return position;
        }

        private boolean isUninterresting(StringBuilder code, int position) {
            switch (code.charAt(position)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }

        protected void createChange(MultiTextEdit edit, IASTNode changedNode) {
            int changeOffset = ChangeGenerator.this.getOffsetIncludingComments(changedNode);
            TextEditGroup editGroup = new TextEditGroup(Messages.ChangeGenerator_group);
            for (ASTModification currentModification : ChangeGenerator.this.modificationParent.get(changedNode)) {
                if (currentModification.getAssociatedEditGroup() == null) continue;
                editGroup = currentModification.getAssociatedEditGroup();
                edit.addChildren(editGroup.getTextEdits());
                break;
            }
            this.createChange(edit, changeOffset);
        }

        private void createChange(MultiTextEdit edit, int changeOffset) {
            int i = (this.firstCommonInSynthEnd >= 0 ? this.firstCommonInOriginalEnd : this.originalCode.length()) - this.lastCommonInOriginalStart;
            if (i <= 0) {
                String insertCode = this.synthCode.substring(this.lastCommonInSynthStart, this.firstCommonInSynthEnd);
                InsertEdit iEdit = new InsertEdit(changeOffset + this.lastCommonInOriginalStart, insertCode);
                edit.addChild((TextEdit)iEdit);
            } else if ((this.firstCommonInSynthEnd >= 0 ? this.firstCommonInSynthEnd : this.synthCode.length()) - this.lastCommonInSynthStart <= 0) {
                int correction = 0;
                if (this.lastCommonInSynthStart > this.firstCommonInSynthEnd) {
                    correction = this.lastCommonInSynthStart - this.firstCommonInSynthEnd;
                }
                DeleteEdit dEdit = new DeleteEdit(changeOffset + this.lastCommonInOriginalStart, this.firstCommonInOriginalEnd - this.lastCommonInOriginalStart + correction);
                edit.addChild((TextEdit)dEdit);
            } else {
                String replacementCode = this.getReplacementCode(this.lastCommonInSynthStart, this.firstCommonInSynthEnd);
                ReplaceEdit rEdit = new ReplaceEdit(changeOffset + Math.max(this.lastCommonInOriginalStart, 0), (this.firstCommonInOriginalEnd >= 0 ? this.firstCommonInOriginalEnd : this.originalCode.length()) - Math.max(this.lastCommonInOriginalStart, 0), replacementCode);
                edit.addChild((TextEdit)rEdit);
            }
        }

        private String getReplacementCode(int lastCommonPositionInSynth, int firstOfCommonEndInSynth) {
            int replacementEnd;
            int replacementStart = Math.max(lastCommonPositionInSynth, 0);
            int n = replacementEnd = firstOfCommonEndInSynth >= 0 ? firstOfCommonEndInSynth : this.synthCode.length();
            if (replacementStart < replacementEnd) {
                return this.synthCode.substring(replacementStart, replacementEnd);
            }
            return "";
        }
    }
}

