/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.tcf.extension.agent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.edc.tcf.extension.agent.ContextInAgent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextManager {
    private static Map<String, ContextInAgent> gDebuggedContexts = new HashMap<String, ContextInAgent>();
    private static Map<String, ContextInAgent> gRunningContexts = new HashMap<String, ContextInAgent>();

    public static void addDebuggedContext(ContextInAgent c) {
        assert (c.getID() != null);
        gDebuggedContexts.put(c.getID(), c);
    }

    public static void removeDebuggedContext(String id, boolean removeChildren) {
        ContextInAgent cia;
        if (removeChildren && (cia = ContextManager.findDebuggedContext(id)) != null) {
            for (String c : cia.getChildren()) {
                ContextManager.removeDebuggedContext(c, true);
            }
        }
        gDebuggedContexts.remove(id);
    }

    public static List<String> getDebuggedContexts() {
        ArrayList<String> ret = new ArrayList<String>();
        for (ContextInAgent c : gDebuggedContexts.values()) {
            ret.add(c.getID());
        }
        return ret;
    }

    public static List<String> getDebuggedRunControlContexts() {
        ArrayList<String> ret = new ArrayList<String>();
        for (ContextInAgent c : gDebuggedContexts.values()) {
            if (!(c instanceof ContextInAgent.IRunControlContext)) continue;
            ret.add(c.getID());
        }
        return ret;
    }

    public static boolean hasDebuggedContext() {
        return gDebuggedContexts.size() > 0;
    }

    public static ContextInAgent findDebuggedContext(String id) {
        return gDebuggedContexts.get(id);
    }

    public static void addRunningContext(ContextInAgent c) {
        gRunningContexts.put(c.getID(), c);
    }

    public static void removeRunningContext(String id) {
        gRunningContexts.remove(id);
    }

    public static ContextInAgent findRunningContext(String id) {
        return gRunningContexts.get(id);
    }

    public static void clearRunningContextCache() {
        gRunningContexts.clear();
    }

    public static void clearDebuggedContextCache() {
        gDebuggedContexts.clear();
    }

    public static void clearContextCache() {
        ContextManager.clearRunningContextCache();
        ContextManager.clearDebuggedContextCache();
    }
}

