/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm.tcf.core.AbstractChannel;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class TraceView
extends ViewPart
implements Protocol.ChannelOpenListener {
    private static final String FILTER_HEARTBEATS = "filter_heartbeats";
    private static final String REUSE_TABS = "reuse_tabs";
    private Composite parent;
    private TabFolder tabs;
    private Label no_data;
    private final Map<TabItem, Page> tab2page = new HashMap<TabItem, Page>();
    private Action clearTabAction;
    private Action closeTabAction;
    private Action exportAction;
    private Action filterAction;
    private Action reuseAction;
    private IMemento memento;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento == null ? XMLMemento.createWriteRoot((String)"EDCTRACEVIEW") : memento;
        Preferences p = this.getViewPreferences();
        this.memento.putBoolean(FILTER_HEARTBEATS, p.getBoolean(FILTER_HEARTBEATS, true));
        this.memento.putBoolean(REUSE_TABS, p.getBoolean(REUSE_TABS, true));
    }

    public void saveState(IMemento memento) {
        if (this.memento == null || memento == null) {
            return;
        }
        this.memento.putString(FILTER_HEARTBEATS, this.filterAction.isChecked() ? "true" : "false");
        this.memento.putString(REUSE_TABS, this.reuseAction.isChecked() ? "true" : "false");
        memento.putMemento(this.memento);
        this.saveViewPreferences();
    }

    private void saveViewPreferences() {
        Preferences preferences = this.getViewPreferences();
        preferences.putBoolean(FILTER_HEARTBEATS, this.memento.getBoolean(FILTER_HEARTBEATS).booleanValue());
        preferences.putBoolean(REUSE_TABS, this.memento.getBoolean(REUSE_TABS).booleanValue());
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private Preferences getViewPreferences() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.cdt.debug.edc.ui");
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.createActions();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                IChannel[] arr;
                IChannel[] iChannelArray = arr = Protocol.getOpenChannels();
                int n = arr.length;
                int n2 = 0;
                while (n2 < n) {
                    IChannel c = iChannelArray[n2];
                    TraceView.this.onChannelOpen(c);
                    ++n2;
                }
                Protocol.addChannelOpenListener((Protocol.ChannelOpenListener)TraceView.this);
            }
        });
        if (this.tab2page.size() == 0) {
            this.hideTabs();
        }
    }

    private void createActions() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.clearTabAction = new Action(null){

            public void run() {
                Page currentPage = TraceView.this.getCurrentPage();
                if (currentPage != null) {
                    currentPage.text.setText("");
                }
            }
        };
        this.clearTabAction.setToolTipText("Clear the current tab");
        this.clearTabAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.debug.edc.ui", (String)"/icons/etool16/clear_tab.gif"));
        this.clearTabAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.debug.edc.ui", (String)"/icons/dtool16/clear_tab.gif"));
        toolbarManager.add((IAction)this.clearTabAction);
        this.closeTabAction = new Action(null){

            public void run() {
                Page currentPage = TraceView.this.getCurrentPage();
                if (currentPage != null) {
                    currentPage.dispose();
                }
            }
        };
        this.closeTabAction.setToolTipText("Close the current tab");
        this.closeTabAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.debug.edc.ui", (String)"/icons/etool16/close_tab.gif"));
        this.closeTabAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.debug.edc.ui", (String)"/icons/dtool16/close_tab.gif"));
        toolbarManager.add((IAction)this.closeTabAction);
        this.exportAction = new Action(null){

            public void run() {
                Page currentPage = TraceView.this.getCurrentPage();
                if (currentPage != null) {
                    TraceView.this.handleExport(currentPage);
                }
            }
        };
        this.exportAction.setToolTipText("Export Log");
        this.exportAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.debug.edc.ui", (String)"/icons/etool16/export_log.gif"));
        this.exportAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.debug.edc.ui", (String)"/icons/dtool16/export_log.gif"));
        toolbarManager.add((IAction)this.exportAction);
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        this.filterAction = new Action("Filter heartbeats"){

            public void run() {
                TraceView.this.memento.putString(TraceView.FILTER_HEARTBEATS, this.isChecked() ? "true" : "false");
            }
        };
        this.filterAction.setChecked(this.memento.getString(FILTER_HEARTBEATS).equals("true"));
        mgr.add((IAction)this.filterAction);
        this.reuseAction = new Action("Reuse tab for channel"){

            public void run() {
                TraceView.this.memento.putString(TraceView.REUSE_TABS, this.isChecked() ? "true" : "false");
            }
        };
        this.reuseAction.setChecked(this.memento.getString(REUSE_TABS).equals("true"));
        mgr.add((IAction)this.reuseAction);
    }

    private Page getCurrentPage() {
        int index;
        if (this.tabs != null && (index = this.tabs.getSelectionIndex()) >= 0) {
            return this.tab2page.get(this.tabs.getSelection()[0]);
        }
        return null;
    }

    public void setFocus() {
        if (this.tabs != null) {
            this.tabs.setFocus();
        }
    }

    public void dispose() {
        this.saveViewPreferences();
        final Page[] pages = this.tab2page.values().toArray(new Page[this.tab2page.size()]);
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                Protocol.removeChannelOpenListener((Protocol.ChannelOpenListener)TraceView.this);
                Page[] pageArray = pages;
                int n = pages.length;
                int n2 = 0;
                while (n2 < n) {
                    Page p = pageArray[n2];
                    p.channel.removeTraceListener((AbstractChannel.TraceListener)p);
                    ++n2;
                }
            }
        });
        Page[] pageArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            Page p = pageArray[n2];
            p.dispose();
            ++n2;
        }
        assert (this.tab2page.isEmpty());
        if (this.tabs != null) {
            this.tabs.dispose();
            this.tabs = null;
        }
        if (this.no_data != null) {
            this.no_data.dispose();
            this.no_data = null;
        }
        super.dispose();
    }

    public void onChannelOpen(IChannel channel) {
        if (!(channel instanceof AbstractChannel)) {
            return;
        }
        AbstractChannel c = (AbstractChannel)channel;
        if (this.memento.getBoolean(REUSE_TABS).booleanValue()) {
            for (final Page page : this.tab2page.values()) {
                if (!page.channel.getRemotePeer().equals(channel.getRemotePeer())) continue;
                c.addTraceListener((AbstractChannel.TraceListener)page);
                this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TraceView.this.showTabs();
                        TraceView.this.tabs.setSelection(page.tab);
                        TraceView.this.updateCloseAction();
                    }
                });
                return;
            }
        }
        IPeer rp = c.getRemotePeer();
        final String name = rp.getName();
        final String host = (String)rp.getAttributes().get("Host");
        final String port = (String)rp.getAttributes().get("Port");
        final Page p = new Page(c);
        c.addTraceListener((AbstractChannel.TraceListener)p);
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                TraceView.this.showTabs();
                p.tab = new TabItem(TraceView.this.tabs, 0);
                TraceView.this.tab2page.put(p.tab, p);
                String title = name;
                if (host != null) {
                    title = String.valueOf(title) + ", " + host;
                    if (port != null) {
                        title = String.valueOf(title) + ":" + port;
                    }
                }
                p.tab.setText(title);
                p.text = new Text((Composite)TraceView.this.tabs, 2818);
                p.tab.setControl((Control)p.text);
                p.text.setBackground(TraceView.this.parent.getDisplay().getSystemColor(1));
                TraceView.this.tabs.setSelection(p.tab);
                TraceView.this.updateCloseAction();
            }
        });
    }

    private void showTabs() {
        boolean b = false;
        if (this.no_data != null) {
            this.no_data.dispose();
            this.no_data = null;
            b = true;
        }
        if (this.tabs == null) {
            this.tabs = new TabFolder(this.parent, 0);
            this.tabs.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TraceView.this.updateCloseAction();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            b = true;
        }
        if (b) {
            this.parent.layout();
        }
        this.clearTabAction.setEnabled(true);
        this.closeTabAction.setEnabled(true);
        this.exportAction.setEnabled(true);
    }

    private void updateCloseAction() {
        Page page = this.getCurrentPage();
        if (page != null) {
            this.closeTabAction.setEnabled(page.channel.getState() == 2);
        }
    }

    private void hideTabs() {
        boolean b = false;
        if (this.tabs != null) {
            this.tabs.dispose();
            this.tabs = null;
            b = true;
        }
        if (!this.parent.isDisposed()) {
            if (this.no_data == null) {
                this.no_data = new Label(this.parent, 0);
                this.no_data.setText("No open communication channels at this time.");
                b = true;
            }
            if (b) {
                this.parent.layout();
            }
        }
        this.clearTabAction.setEnabled(false);
        this.closeTabAction.setEnabled(false);
        this.exportAction.setEnabled(false);
    }

    private void handleExport(Page currentPage) {
        FileDialog dialog = new FileDialog(this.getViewSite().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.log"});
        String path = dialog.open();
        if (path != null) {
            File outputFile;
            if (path.indexOf(46) == -1 && !path.endsWith(".log")) {
                path = String.valueOf(path) + ".log";
            }
            if ((outputFile = new Path(path).toFile()).exists()) {
                String message = "File exists.  Would you like to overwrite it?";
                if (!MessageDialog.openQuestion((Shell)this.getViewSite().getShell(), (String)"Export Log", (String)message)) {
                    return;
                }
            }
            OutputStreamWriter out = null;
            try {
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");
            }
            catch (IOException iOException) {
                return;
            }
            StringReader in = new StringReader(currentPage.text.getText());
            this.copy(in, out);
            try {
                ((Reader)in).close();
            }
            catch (IOException iOException) {}
            try {
                ((Writer)out).close();
            }
            catch (IOException iOException) {}
        }
    }

    private void copy(Reader input, Writer output) {
        block24: {
            BufferedReader reader = new BufferedReader(input);
            BufferedWriter writer = new BufferedWriter(output);
            try {
                try {
                    String line;
                    while (reader.ready() && (line = reader.readLine()) != null) {
                        writer.write(line);
                        writer.newLine();
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException2) {}
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block24;
                    }
                    catch (IOException iOException3) {}
                    break block24;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private class Page
    implements AbstractChannel.TraceListener {
        final AbstractChannel channel;
        private TabItem tab;
        private Text text;
        private final StringBuffer bf = new StringBuffer();
        private int bf_line_cnt = 0;
        private boolean closed;
        private final Thread update_thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Page page = Page.this;
                synchronized (page) {
                    while (!Page.this.closed) {
                        if (Page.this.bf_line_cnt > 0) {
                            Runnable r = new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    String str = null;
                                    int cnt = 0;
                                    Page page = Page.this;
                                    synchronized (page) {
                                        str = Page.this.bf.toString();
                                        cnt = Page.this.bf_line_cnt;
                                        Page.this.bf.setLength(0);
                                        Page.this.bf_line_cnt = 0;
                                    }
                                    if (Page.this.text == null) {
                                        return;
                                    }
                                    if (Page.this.text.getLineCount() > 1000 - cnt) {
                                        String s = Page.this.text.getText();
                                        int n = 0;
                                        int i = -1;
                                        while (n < cnt) {
                                            int j = s.indexOf(10, i + 1);
                                            if (j < 0) break;
                                            i = j;
                                            ++n;
                                        }
                                        if (i >= 0) {
                                            Page.this.text.setText(s.substring(i + 1));
                                        }
                                    }
                                    Page.this.text.append(str);
                                }
                            };
                            TraceView.this.getSite().getShell().getDisplay().asyncExec(r);
                        }
                        try {
                            Page.this.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                }
            }
        };

        Page(AbstractChannel channel) {
            this.channel = channel;
            this.update_thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            Page page = this;
            synchronized (page) {
                this.closed = true;
                this.update_thread.interrupt();
            }
            try {
                this.update_thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            TraceView.this.tab2page.remove(this.tab);
            this.tab.dispose();
            this.tab = null;
            this.text = null;
            if (TraceView.this.tab2page.isEmpty()) {
                TraceView.this.hideTabs();
            }
        }

        public synchronized void onChannelClosed(Throwable error) {
            String msg = "";
            msg = error == null ? "Channel closed" : "Channel terminated: " + error;
            this.bf.append("\n<================= " + msg + " =================>\n");
            this.bf_line_cnt += 3;
            TraceView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    TraceView.this.updateCloseAction();
                }
            });
        }

        public synchronized void onMessageReceived(char type, String token, String service, String name, byte[] data) {
            if (TraceView.this.memento.getBoolean(TraceView.FILTER_HEARTBEATS).booleanValue() && name != null && name.contains("HeartBeat")) {
                return;
            }
            try {
                this.bf.append("Time(ms): " + System.currentTimeMillis() + " Inp: ");
                this.bf.append(type);
                if (token != null) {
                    this.bf.append(' ');
                    this.bf.append(token);
                }
                if (service != null) {
                    this.bf.append(' ');
                    this.bf.append(service);
                }
                if (name != null) {
                    this.bf.append(' ');
                    this.bf.append(name);
                }
                if (data != null) {
                    int i = 0;
                    while (i < data.length) {
                        int j = i;
                        while (j < data.length && data[j] != 0) {
                            ++j;
                        }
                        this.bf.append(' ');
                        this.bf.append(new String(data, i, j - i, "UTF8"));
                        if (j >= data.length || data[j] == 0) {
                            // empty if block
                        }
                        i = ++j;
                    }
                }
                this.bf.append('\n');
                ++this.bf_line_cnt;
            }
            catch (UnsupportedEncodingException x) {
                x.printStackTrace();
            }
        }

        public synchronized void onMessageSent(char type, String token, String service, String name, byte[] data) {
            if (TraceView.this.memento.getBoolean(TraceView.FILTER_HEARTBEATS).booleanValue() && name != null && name.contains("HeartBeat")) {
                return;
            }
            try {
                this.bf.append("Time(ms): " + System.currentTimeMillis() + " Out: ");
                this.bf.append(type);
                if (token != null) {
                    this.bf.append(' ');
                    this.bf.append(token);
                }
                if (service != null) {
                    this.bf.append(' ');
                    this.bf.append(service);
                }
                if (name != null) {
                    this.bf.append(' ');
                    this.bf.append(name);
                }
                if (data != null) {
                    int i = 0;
                    while (i < data.length) {
                        int j = i;
                        while (j < data.length && data[j] != 0) {
                            ++j;
                        }
                        this.bf.append(' ');
                        this.bf.append(new String(data, i, j - i, "UTF8"));
                        if (j >= data.length || data[j] == 0) {
                            // empty if block
                        }
                        i = ++j;
                    }
                }
                this.bf.append('\n');
                ++this.bf_line_cnt;
            }
            catch (UnsupportedEncodingException x) {
                x.printStackTrace();
            }
        }
    }
}

