/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.edc.ITCFAgentLauncher;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.TCFServiceManager;
import org.eclipse.cdt.debug.edc.internal.ui.views.SystemDataModel;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IProcesses;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TCFDataModel
extends SystemDataModel {
    private IPeer peer;
    private Map<String, String> peerAttributes = new HashMap<String, String>();
    private boolean buildComplete;

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void buildDataModel(IProgressMonitor monitor) throws Exception {
        try {
            block8: {
                block7: {
                    if (this.peer == null) {
                        this.findPeer();
                    }
                    if (this.getPeer() == null) return;
                    this.setBuildComplete(false);
                    this.fetchModelData(monitor);
                    if (!true) break block7;
                    if (this.isBuildComplete()) return;
                    if (monitor.isCanceled()) break block8;
                }
                do {
                    Thread.sleep(500L);
                    if (this.isBuildComplete()) return;
                } while (!monitor.isCanceled());
            }
            return;
        }
        finally {
            this.setBuildComplete(true);
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void fetchModelData(IProgressMonitor monitor) throws Exception {
        this.fetchProcessServiceData(monitor);
    }

    protected void fetchProcessServiceData(IProgressMonitor monitor) throws Exception {
        TCFServiceManager tcfServiceManager = (TCFServiceManager)EDCDebugger.getDefault().getServiceManager();
        final IProcesses processesService = (IProcesses)tcfServiceManager.getPeerService(this.getPeer(), "Processes");
        if (processesService == null) {
            this.setBuildComplete(true);
        } else {
            Protocol.invokeLater((Runnable)new Runnable(){

                public void run() {
                    processesService.getChildren(null, false, new IProcesses.DoneGetChildren(){

                        public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
                            if (context_ids == null) {
                                TCFDataModel.this.setBuildComplete(true);
                            } else {
                                TCFDataModel.this.receiveContextIDs(null, context_ids);
                            }
                        }
                    });
                }
            });
        }
    }

    protected abstract void receiveContextIDs(String var1, String[] var2);

    protected void getProcessContextInfo(String contextID) throws CoreException {
        TCFServiceManager tcfServiceManager = (TCFServiceManager)EDCDebugger.getDefault().getServiceManager();
        IProcesses processesService = (IProcesses)tcfServiceManager.getPeerService(this.getPeer(), "Processes");
        processesService.getContext(contextID, new IProcesses.DoneGetContext(){

            public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
                TCFDataModel.this.receiveContextInfo(context);
            }
        });
    }

    protected abstract void receiveContextInfo(IProcesses.ProcessContext var1);

    public Map<String, String> getPeerAttributes() {
        return this.peerAttributes;
    }

    public void setPeerAttributes(Map<String, String> peerAttributes) {
        this.peerAttributes = peerAttributes;
    }

    protected void findPeer() throws CoreException {
        TCFServiceManager tcfServiceManager = (TCFServiceManager)EDCDebugger.getDefault().getServiceManager();
        IPeer[] runningPeers = tcfServiceManager.getRunningPeers("Processes", this.peerAttributes, true);
        if (runningPeers.length > 0) {
            this.setPeer(this.choosePeer(runningPeers));
        } else {
            ITCFAgentLauncher[] registered = tcfServiceManager.findSuitableAgentLaunchers("Processes", this.peerAttributes, true);
            if (registered.length > 0) {
                IPeer tcfPeer = tcfServiceManager.launchAgent(registered[0], this.peerAttributes);
                this.setPeer(tcfPeer);
            }
        }
        if (this.getPeer() == null) {
            throw new CoreException((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), "Could not find a suitable TCF peer", null));
        }
    }

    public abstract IPeer choosePeer(IPeer[] var1);

    public IPeer getPeer() {
        return this.peer;
    }

    public void setPeer(IPeer peer) {
        this.peer = peer;
    }

    public void setBuildComplete(boolean buildComplete) {
        this.buildComplete = buildComplete;
    }

    public boolean isBuildComplete() {
        return this.buildComplete;
    }
}

