/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.ui;

import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.internal.ui.EDCDebugUI;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.AbstractThreadVMNode;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerCountingRequestMonitor;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.VMDelegatingPropertiesUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.ui.IMemento;

public class ThreadVMNode
extends AbstractThreadVMNode
implements IElementLabelProvider,
IElementMementoProvider {
    private static final String MEMENTO_NAME = "THREAD_MEMENTO_NAME";

    public ThreadVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session);
    }

    public String toString() {
        return "ThreadVMNode(" + this.getSession().getId() + ")";
    }

    protected void updatePropertiesInSessionThread(IPropertiesUpdate[] updates) {
        IPropertiesUpdate[] parentUpdates = new IPropertiesUpdate[updates.length];
        int i = 0;
        while (i < updates.length) {
            final IPropertiesUpdate update = updates[i];
            final ViewerCountingRequestMonitor countringRm = new ViewerCountingRequestMonitor(ImmediateExecutor.getInstance(), (IViewerUpdate)updates[i]);
            int count = 0;
            parentUpdates[i] = new VMDelegatingPropertiesUpdate(updates[i], (RequestMonitor)countringRm);
            ++count;
            IProcesses processService = (IProcesses)this.getServicesTracker().getService(IProcesses.class);
            IProcesses.IThreadDMContext threadDMC = (IProcesses.IThreadDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IProcesses.IThreadDMContext.class);
            if (processService == null || threadDMC == null) {
                update.setStatus(EDCDebugUI.newErrorStatus(10002, "Service or handle invalid", null));
            } else {
                processService.getExecutionData(threadDMC, (DataRequestMonitor)new ViewerDataRequestMonitor<IProcesses.IThreadDMData>(this.getExecutor(), (IViewerUpdate)update){

                    public void handleCompleted() {
                        if (this.isSuccess()) {
                            ThreadVMNode.this.fillThreadDataProperties(update, (IProcesses.IThreadDMData)this.getData());
                        } else {
                            RunControl.ThreadExecutionDMC execDmc = (RunControl.ThreadExecutionDMC)ThreadVMNode.this.findDmcInPath(update.getViewerInput(), update.getElementPath(), RunControl.ThreadExecutionDMC.class);
                            if (execDmc != null) {
                                update.setProperty("id", (Object)execDmc.getID());
                            } else {
                                update.setStatus(this.getStatus());
                            }
                        }
                        countringRm.done();
                    }
                });
                ++count;
            }
            countringRm.setDoneCount(count);
            ++i;
        }
        super.updatePropertiesInSessionThread(parentUpdates);
    }

    protected void fillThreadDataProperties(IPropertiesUpdate update, IProcesses.IThreadDMData data) {
        update.setProperty("name", (Object)data.getName());
        update.setProperty("id", (Object)("Thread id: " + data.getId()));
    }

    private String produceThreadElementName(String viewName, RunControl.ThreadExecutionDMC execCtx) {
        return "Thread." + execCtx.getID();
    }

    public void compareElements(IElementCompareRequest[] requests) {
        IElementCompareRequest[] iElementCompareRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext dmc;
            IElementCompareRequest request = iElementCompareRequestArray[n2];
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            String mementoName = memento.getString(MEMENTO_NAME);
            if (mementoName != null && element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof RunControl.ThreadExecutionDMC) {
                String elementName = this.produceThreadElementName(request.getPresentationContext().getId(), (RunControl.ThreadExecutionDMC)dmc);
                request.setEqual(elementName.equals(mementoName));
            }
            request.done();
            ++n2;
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        IElementMementoRequest[] iElementMementoRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext dmc;
            IElementMementoRequest request = iElementMementoRequestArray[n2];
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            if (element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof RunControl.ThreadExecutionDMC) {
                String elementName = this.produceThreadElementName(request.getPresentationContext().getId(), (RunControl.ThreadExecutionDMC)dmc);
                memento.putString(MEMENTO_NAME, elementName);
            }
            request.done();
            ++n2;
        }
    }
}

