/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.formatter;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.formatter.EDCFormatterMessages;
import org.eclipse.cdt.debug.edc.formatter.IVariableValueConverter;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.IArrayDimensionType;
import org.eclipse.cdt.debug.edc.internal.formatter.FormatExtensionManager;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Expressions;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Memory;
import org.eclipse.cdt.debug.edc.internal.symbols.ICompositeType;
import org.eclipse.cdt.debug.edc.internal.symbols.IInheritance;
import org.eclipse.cdt.debug.edc.internal.symbols.IPointerType;
import org.eclipse.cdt.debug.edc.internal.symbols.ITypedef;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.debug.edc.services.IEDCExpressions;
import org.eclipse.cdt.debug.edc.services.IEDCMemory;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.TypeUtils;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.model.MemoryByte;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatUtils {
    private static final String CLASS = "class ";
    private static final String STRUCT = "struct ";

    public static boolean checkTypeByName(IType type, String baseName) {
        if (type == null) {
            return false;
        }
        IType baseType = TypeUtils.getBaseTypePreservingTypedef(type);
        while (baseType != null && baseType instanceof ITypedef) {
            if (baseType.getName().equals(baseName)) {
                return true;
            }
            baseType = TypeUtils.getBaseTypePreservingTypedef(baseType.getType());
        }
        if (baseType == null) {
            return false;
        }
        return FormatUtils.checkName(baseType.getName(), baseName);
    }

    public static boolean checkName(String typeName, String baseName) {
        String checkName = typeName;
        if (typeName.startsWith(CLASS)) {
            checkName = typeName.substring(CLASS.length()).trim();
        } else if (typeName.startsWith(STRUCT)) {
            checkName = typeName.substring(STRUCT.length()).trim();
        }
        return checkName.equals(baseName);
    }

    public static boolean checkClassOrInheritanceByName(IType type, String name) {
        if (!((type = TypeUtils.getBaseType(type)) instanceof ICompositeType)) {
            return false;
        }
        ICompositeType composite = (ICompositeType)type;
        String baseName = composite.getBaseName();
        if (baseName.equals(name)) {
            return true;
        }
        if (baseName.indexOf(60) != -1 && baseName.matches(String.valueOf(name) + "<.*>$")) {
            return true;
        }
        IInheritance[] iInheritanceArray = composite.getInheritances();
        int n = iInheritanceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IInheritance inheritance = iInheritanceArray[n2];
            if (FormatUtils.checkClassOrInheritanceByName(inheritance.getType(), name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IExpressions.IExpressionDMContext createSubExpression(IExpressions.IExpressionDMContext variable, String name, String subExpressionStr) {
        IEDCExpression parentExpr = (IEDCExpression)variable;
        IEDCExpressions expressions = parentExpr.getExpressionsService();
        if (expressions == null) {
            return null;
        }
        String expressionStr = String.valueOf(parentExpr.getExpression()) + subExpressionStr;
        IEDCExpression subExpression = (IEDCExpression)expressions.createExpression((IDMContext)parentExpr, expressionStr);
        subExpression.setName(name);
        return subExpression;
    }

    public static String getFormattedString(IExpressions.IExpressionDMContext variable, IAddress address, int length, int charSize) throws CoreException {
        IEDCExpression expression = (IEDCExpression)variable;
        Stack.StackFrameDMC frame = (Stack.StackFrameDMC)expression.getFrame();
        IEDCMemory memory = frame.getEDCServicesTracker().getService(Memory.class);
        StringBuilder sb = new StringBuilder();
        ArrayList<MemoryByte> buffer = new ArrayList<MemoryByte>();
        IStatus status = memory.getMemory(frame.getExecutionDMC(), address, buffer, length * charSize, 1);
        if (status.isOK()) {
            int i = 0;
            while (i < length * charSize) {
                if (!buffer.get(i).isReadable()) {
                    throw EDCDebugger.newCoreException(MessageFormat.format(EDCFormatterMessages.FormatUtils_CannotReadMemory, address.add((long)i).getValue().toString(16)));
                }
                char c = (char)(buffer.get(i).getValue() & 0xFF);
                if (charSize > 1) {
                    char c2 = (char)(buffer.get(++i).getValue() << 8);
                    c = (char)(c | c2);
                }
                sb.append(c);
                ++i;
            }
        }
        return sb.toString();
    }

    public static String getFormattedNullTermString(IExpressions.IExpressionDMContext variable, IAddress address, int charSize, int maximumLength) throws CoreException {
        IEDCExpression expression = (IEDCExpression)variable;
        Stack.StackFrameDMC frame = (Stack.StackFrameDMC)expression.getFrame();
        IEDCMemory memory = frame.getEDCServicesTracker().getService(Memory.class);
        StringBuilder sb = new StringBuilder();
        ArrayList<MemoryByte> buffer = new ArrayList<MemoryByte>(64);
        if (maximumLength == 0) {
            maximumLength = 16384;
        }
        block0: while (maximumLength > 0) {
            int amount = Math.min(maximumLength, 64);
            IStatus status = memory.getMemory(frame.getExecutionDMC(), address, buffer, amount, charSize);
            if (status.isOK()) {
                int i = 0;
                while (i < buffer.size() && maximumLength > 0) {
                    if (!buffer.get(i).isReadable()) {
                        if (i == 0) {
                            throw EDCDebugger.newCoreException(MessageFormat.format(EDCFormatterMessages.FormatUtils_CannotReadMemory, address.add((long)i).getValue().toString(16)));
                        }
                        maximumLength = 0;
                        break block0;
                    }
                    char c = (char)buffer.get(i).getValue();
                    if (charSize > 1) {
                        char c2 = (char)(buffer.get(++i).getValue() << 8);
                        c = (char)(c | c2);
                    }
                    if (c == '\u0000') break block0;
                    sb.append(c);
                    address = address.add((long)charSize);
                    ++i;
                    --maximumLength;
                }
            } else if (amount > 1) {
                maximumLength = Math.min(maximumLength, 64) / 2;
            } else {
                if (sb.length() == 0) {
                    throw EDCDebugger.newCoreException(MessageFormat.format(EDCFormatterMessages.FormatUtils_CannotReadMemory, address.getValue().toString(16)));
                }
                maximumLength = 0;
                break;
            }
            buffer.clear();
        }
        if (maximumLength <= 0) {
            sb.append("...");
        }
        return sb.toString();
    }

    public static IExpressions.IExpressionDMContext findInCollectionByName(Collection<IExpressions.IExpressionDMContext> collection, String name) {
        for (IExpressions.IExpressionDMContext context : collection) {
            if (!((IEDCExpression)context).getName().equals(name)) continue;
            return context;
        }
        return null;
    }

    public static List<IExpressions.IExpressionDMContext> getAllChildExpressions(IExpressions.IExpressionDMContext variable) {
        IEDCExpression variableDMC = (IEDCExpression)variable;
        Expressions expressions = (Expressions)variableDMC.getExpressionsService();
        if (expressions == null) {
            return Collections.emptyList();
        }
        List<IExpressions.IExpressionDMContext> kids = Arrays.asList(expressions.getLogicalSubExpressions(variableDMC));
        return kids;
    }

    public static String getFieldAccessor(IType type) {
        if (type instanceof IPointerType) {
            return "->";
        }
        return ".";
    }

    public static String getMemberValue(IExpressions.IExpressionDMContext variable, IType type, String memberName) {
        return FormatUtils.getMemberValue(variable, type, memberName, "NATURAL.Format");
    }

    public static String getMemberValue(IExpressions.IExpressionDMContext variable, IType type, String memberName, String format) {
        IEDCExpressions expressions = ((IEDCExpression)variable).getExpressionsService();
        if (expressions == null) {
            return "";
        }
        IEDCExpression expression = (IEDCExpression)expressions.createExpression((IDMContext)variable, String.valueOf(variable.getExpression()) + FormatUtils.getFieldAccessor(type) + memberName);
        IFormattedValues.FormattedValueDMContext fvc = expressions.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)expression, format);
        return expression.getFormattedValue(fvc).getFormattedValue();
    }

    public static String getVariableValue(IExpressions.IExpressionDMContext variable) {
        return FormatUtils.getVariableValue(variable, "NATURAL.Format");
    }

    public static String getVariableValue(IExpressions.IExpressionDMContext variable, String format) {
        IEDCExpressions expressions = ((IEDCExpression)variable).getExpressionsService();
        IFormattedValues.FormattedValueDMContext fvc = expressions.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)variable, format);
        IFormattedValues.FormattedValueDMData formattedValue = ((IEDCExpression)variable).getFormattedValue(fvc);
        return formattedValue.getFormattedValue();
    }

    public static IType getUnqualifiedTypeRemovePointers(IType type) {
        IType unqualifiedType = TypeUtils.getStrippedType(type);
        while (unqualifiedType instanceof IPointerType) {
            unqualifiedType = TypeUtils.getStrippedType(unqualifiedType.getType());
        }
        return unqualifiedType;
    }

    public static IVariableValueConverter getCustomValueConverter(IExpressions.IExpressionDMContext variable) {
        IEDCExpression variableDMC = (IEDCExpression)variable;
        variableDMC.evaluateExpression();
        IType type = TypeUtils.getUnRefStrippedType(variableDMC.getEvaluatedType());
        if (type instanceof IArrayDimensionType) {
            type = ((IArrayDimensionType)((Object)type)).getArrayType();
        }
        return FormatExtensionManager.instance().getVariableValueConverter(type);
    }

    public static IAddress getPointerValue(Number value) {
        Object address = null;
        address = value instanceof BigInteger ? new Addr64((BigInteger)value) : new Addr32(value.longValue());
        return address;
    }

    public static String getTemplateTypeName(String typeName, IType type) {
        ICompositeType composite = (ICompositeType)TypeUtils.getBaseType(type);
        String baseName = composite.getBaseName();
        Matcher m = Pattern.compile(String.valueOf(typeName) + "<(.+)>").matcher(baseName);
        if (m.matches()) {
            return m.group(1);
        }
        IInheritance[] iInheritanceArray = composite.getInheritances();
        int n = iInheritanceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IInheritance inheritance = iInheritanceArray[n2];
            String templateTypeName = FormatUtils.getTemplateTypeName(typeName, inheritance.getType());
            if (templateTypeName != null) {
                return templateTypeName;
            }
            ++n2;
        }
        return null;
    }

    public static String getFormattedValue(IExpressions.IExpressionDMContext variable) throws CoreException {
        IVariableValueConverter valueConverter = FormatUtils.getCustomValueConverter(variable);
        if (valueConverter != null) {
            return valueConverter.getValue(variable);
        }
        return FormatUtils.getVariableValue(variable);
    }

    public static int getMaxNumberOfChildren() {
        return 200;
    }

    public static void evaluateExpression(IEDCExpression expression) throws CoreException {
        expression.evaluateExpression();
        IStatus status = expression.getEvaluationError();
        if (status != null && !status.isOK() || expression.getEvaluatedValue() == null) {
            Throwable t = status != null ? status.getException() : null;
            throw EDCDebugger.newDebugException("Error evaluating expression: " + expression.getExpression(), t);
        }
    }
}

