/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.scripting;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.scripting.DOMUtils;
import org.eclipse.cdt.debug.edc.internal.scripting.DebugEventListener;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Expressions;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.debug.edc.symbols.IEDCSymbolReader;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.cdt.debug.internal.core.breakpoints.CAddressBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CFunctionBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CLineBreakpoint;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDC {
    public static String[] getSessions() {
        DsfSession[] sessions;
        ArrayList<String> ids = new ArrayList<String>();
        DsfSession[] dsfSessionArray = sessions = DsfSession.getActiveSessions();
        int n = sessions.length;
        int n2 = 0;
        while (n2 < n) {
            DsfSession dsfSession = dsfSessionArray[n2];
            ids.add(dsfSession.getId());
            ++n2;
        }
        return ids.toArray(new String[ids.size()]);
    }

    public static Map<String, Object>[] getContexts(String sessionId) throws Exception {
        return DOMUtils.getDMContextProperties(DOMUtils.getContexts(sessionId));
    }

    public static Map<String, Object>[] getSuspendedContexts(String sessionId) throws Exception {
        return DOMUtils.getDMContextProperties(DOMUtils.getSuspendedContexts(sessionId));
    }

    public static Map<String, Object>[] getSuspendedThreads(String sessionId) throws Exception {
        return DOMUtils.getDMContextProperties(DOMUtils.getSuspendedThreads(sessionId));
    }

    public static DsfServicesTracker getDsfServicesTracker(String sessionId) {
        return new DsfServicesTracker(EDCDebugger.getDefault().getBundle().getBundleContext(), sessionId);
    }

    public static IBreakpoint[] getBreakpoints() {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
    }

    public static IFunctionScope getFunctionAtAddress(String sessionId, String addressIdentifier) throws Exception {
        return DOMUtils.getFunctionAtAddress(sessionId, addressIdentifier);
    }

    public static IEDCSymbolReader getSymbolReader(String modulePath) {
        return DOMUtils.getSymbolReader((IPath)new Path(modulePath));
    }

    public static IBreakpoint createAddressBreakpoint(long address, String condition) throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", "org.eclipse.cdt.debug.edc");
        attributes.put("charStart", -1);
        attributes.put("charEnd", -1);
        attributes.put("lineNumber", -1);
        attributes.put("org.eclipse.cdt.debug.core.address", Long.toHexString(address));
        attributes.put("org.eclipse.debug.core.enabled", true);
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", 0);
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        attributes.put("org.eclipse.cdt.debug.core.breakpointType", 0);
        IWorkspaceRoot rootResource = ResourcesPlugin.getWorkspace().getRoot();
        return new CAddressBreakpoint((IResource)rootResource, attributes, true);
    }

    public static IBreakpoint createFunctionBreakpoint(IResource resource, String sourceFilePath, String functionName, int lineNumber, String condition) throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", "org.eclipse.cdt.debug.edc");
        attributes.put("charStart", -1);
        attributes.put("charEnd", -1);
        attributes.put("lineNumber", lineNumber);
        attributes.put("org.eclipse.cdt.debug.core.function", functionName);
        attributes.put("org.eclipse.cdt.debug.core.sourceHandle", sourceFilePath);
        attributes.put("org.eclipse.debug.core.enabled", true);
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", 0);
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        attributes.put("org.eclipse.cdt.debug.core.breakpointType", 0);
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return new CFunctionBreakpoint(resource, attributes, true);
    }

    public static IBreakpoint createLineBreakpoint(IResource resource, String sourceFilePath, int lineNumber, String condition) throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", "org.eclipse.cdt.debug.edc");
        attributes.put("charStart", -1);
        attributes.put("charEnd", -1);
        attributes.put("lineNumber", lineNumber);
        attributes.put("org.eclipse.cdt.debug.core.sourceHandle", sourceFilePath);
        attributes.put("org.eclipse.debug.core.enabled", true);
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", 0);
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        attributes.put("org.eclipse.cdt.debug.core.breakpointType", 0);
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return new CLineBreakpoint(resource, attributes, true);
    }

    public static IEDCExpression createExpression(final String sessionId, final IDMContext frame, final String expr) throws Exception {
        Query<IEDCExpression> runnable = new Query<IEDCExpression>(){

            protected void execute(DataRequestMonitor<IEDCExpression> rm) {
                DsfServicesTracker servicesTracker = EDC.getDsfServicesTracker(sessionId);
                Expressions expressionsService = (Expressions)servicesTracker.getService(Expressions.class);
                IEDCExpression expression = (IEDCExpression)expressionsService.createExpression(frame, expr);
                expression.evaluateExpression();
                rm.setData((Object)expression);
                rm.done();
            }
        };
        DsfSession.getSession((String)sessionId).getExecutor().execute((Runnable)runnable);
        return (IEDCExpression)runnable.get();
    }

    public static Map<String, Object> listenForEvents(String clientID) throws InterruptedException {
        return DebugEventListener.getListener().listenForEvents(clientID);
    }

    public static void setBreakpoints(List<Map<String, Object>> breakpoints) throws Exception {
        for (Map<String, Object> properties : breakpoints) {
            if (!properties.containsKey("lineNumber")) continue;
            String sourceFile = (String)properties.get("org.eclipse.cdt.debug.core.sourceHandle");
            int lineNumber = (Integer)properties.get("lineNumber");
            String condition = (String)properties.get("org.eclipse.cdt.debug.core.condition");
            EDC.createLineBreakpoint(null, sourceFile, lineNumber, condition);
        }
    }

    public static List<Map<String, Object>> getVariables(final String sessionID, final String contextID, final int frameLevel) throws InterruptedException, ExecutionException {
        final ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Query<Boolean> runnable = new Query<Boolean>(){

            protected void execute(DataRequestMonitor<Boolean> rm) {
                DsfServicesTracker servicesTracker = EDC.getDsfServicesTracker(sessionID);
                RunControl runControl = (RunControl)servicesTracker.getService(RunControl.class);
                Expressions expressions = (Expressions)servicesTracker.getService(Expressions.class);
                Stack stack = (Stack)servicesTracker.getService(Stack.class);
                RunControl.ExecutionDMC context = runControl.getContext(contextID);
                try {
                    IStack.IFrameDMContext[] frames = stack.getFramesForDMC(context, 0, -1);
                    if (frameLevel < frames.length) {
                        IStack.IVariableDMContext[] locals;
                        Stack.StackFrameDMC frameDMC = (Stack.StackFrameDMC)frames[frameLevel];
                        IStack.IVariableDMContext[] iVariableDMContextArray = locals = frameDMC.getLocals();
                        int n = locals.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStack.IVariableDMContext var = iVariableDMContextArray[n2];
                            Stack.VariableDMC varDMC = (Stack.VariableDMC)var;
                            String varName = varDMC.getName();
                            IEDCExpression expressionContext = (IEDCExpression)expressions.createExpression((IDMContext)frameDMC, varName);
                            expressionContext.evaluateExpression();
                            String value = expressionContext.getEvaluatedValueString();
                            String typeName = expressionContext.getTypeName();
                            Map expressionProps = expressionContext.getProperties();
                            expressionProps.put("value", value);
                            expressionProps.put("type", typeName);
                            IVariableLocation location = expressionContext.getEvaluatedLocation();
                            IAddress addressValue = location.getAddress();
                            BigInteger addressValueValue = addressValue.getValue();
                            expressionProps.put("address", addressValueValue.longValue());
                            expressionProps.put("hasChildren", expressionContext.hasChildren());
                            result.add(expressionProps);
                            ++n2;
                        }
                    }
                    rm.setData((Object)true);
                }
                catch (CoreException e) {
                    Status s = new Status(4, EDCDebugger.getUniqueIdentifier(), null, (Throwable)e);
                    EDCDebugger.getMessageLogger().log((IStatus)s);
                    rm.setStatus((IStatus)s);
                }
                rm.done();
            }
        };
        DsfSession.getSession((String)sessionID).getExecutor().execute((Runnable)runnable);
        runnable.get();
        return result;
    }

    public static List<Map<String, Object>> getStackFrames(final String sessionID, final String contextID) throws ExecutionException, InterruptedException {
        final ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Query<Boolean> runnable = new Query<Boolean>(){

            protected void execute(DataRequestMonitor<Boolean> rm) {
                DsfServicesTracker servicesTracker = EDC.getDsfServicesTracker(sessionID);
                RunControl runControl = (RunControl)servicesTracker.getService(RunControl.class);
                Stack stack = (Stack)servicesTracker.getService(Stack.class);
                RunControl.ExecutionDMC context = runControl.getContext(contextID);
                try {
                    IStack.IFrameDMContext[] frames;
                    IStack.IFrameDMContext[] iFrameDMContextArray = frames = stack.getFramesForDMC(context, 0, -1);
                    int n = frames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStack.IFrameDMContext iFrameDMContext = iFrameDMContextArray[n2];
                        Stack.StackFrameDMC stackDMC = (Stack.StackFrameDMC)iFrameDMContext;
                        result.add(stackDMC.getProperties());
                        ++n2;
                    }
                    rm.setData((Object)true);
                }
                catch (CoreException e) {
                    Status s = new Status(4, EDCDebugger.getUniqueIdentifier(), null, (Throwable)e);
                    EDCDebugger.getMessageLogger().log((IStatus)s);
                    rm.setStatus((IStatus)s);
                }
                rm.done();
            }
        };
        DsfSession.getSession((String)sessionID).getExecutor().execute((Runnable)runnable);
        runnable.get();
        return result;
    }

    public static void terminate(final String sessionID, final String contextID) {
        Query<Boolean> runnable = new Query<Boolean>(){

            protected void execute(DataRequestMonitor<Boolean> rm) {
                DsfServicesTracker servicesTracker = EDC.getDsfServicesTracker(sessionID);
                RunControl runControl = (RunControl)servicesTracker.getService(RunControl.class);
                RunControl.ExecutionDMC context = runControl.getContext(contextID);
                rm.setData((Object)true);
                context.terminate((RequestMonitor)rm);
            }
        };
        DsfSession.getSession((String)sessionID).getExecutor().execute((Runnable)runnable);
    }

    public static void resume(final String sessionID, final String contextID) {
        Query<Boolean> runnable = new Query<Boolean>(){

            protected void execute(DataRequestMonitor<Boolean> rm) {
                DsfServicesTracker servicesTracker = EDC.getDsfServicesTracker(sessionID);
                RunControl runControl = (RunControl)servicesTracker.getService(RunControl.class);
                RunControl.ExecutionDMC context = runControl.getContext(contextID);
                rm.setData((Object)true);
                context.resume((RequestMonitor)rm);
            }
        };
        DsfSession.getSession((String)sessionID).getExecutor().execute((Runnable)runnable);
    }
}

