/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.gdbjtag.ui;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.cdt.debug.gdbjtag.core.Activator;
import org.eclipse.cdt.debug.gdbjtag.core.IGDBJtagConnection;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContribution;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContributionFactory;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.IGDBJtagDevice;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.cdt.debug.gdbjtag.ui.Messages;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.command.factories.CommandFactoryDescriptor;
import org.eclipse.cdt.debug.mi.core.command.factories.CommandFactoryManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class GDBJtagDSFDebuggerTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "Debugger";
    private static final String TAB_ID = "org.eclipse.cdt.debug.gdbjtag.ui.debuggertab.dsf";
    private Text gdbCommand;
    private Button useRemote;
    private Combo jtagDevice;
    private Composite remoteConnectionParameters;
    private StackLayout remoteConnectParmsLayout;
    private Composite remoteTcpipBox;
    private Text ipAddress;
    private Text portNumber;
    private Composite remoteConnectionBox;
    private Text connection;
    private String savedJtagDevice;
    protected Button fUpdateThreadlistOnSuspend;

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        return GDBJtagImages.getDebuggerTabImage();
    }

    public void createControl(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        this.setControl((Control)sc);
        Composite comp = new Composite((Composite)sc, 0);
        sc.setContent((Control)comp);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        Group group = new Group(comp, 0);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText(Messages.getString("GDBJtagDebuggerTab.gdbSetupGroup_Text"));
        this.createCommandControl((Composite)group);
        this.createRemoteControl(comp);
        this.fUpdateThreadlistOnSuspend = new Button(comp, 32);
        this.fUpdateThreadlistOnSuspend.setText(Messages.getString("GDBJtagDebuggerTab.update_thread_list_on_suspend"));
        this.fUpdateThreadlistOnSuspend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagDSFDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fUpdateThreadlistOnSuspend, "org.eclipse.cdt.dsf.gdb.ui.update_threadlist_button_context");
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void variablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            text.append(dialog.getVariableExpression());
        }
    }

    private void createCommandControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        comp.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("GDBJtagDebuggerTab.gdbCommandLabel"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.gdbCommand = new Text(comp, 2052);
        gd = new GridData(768);
        this.gdbCommand.setLayoutData((Object)gd);
        this.gdbCommand.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDSFDebuggerTab.this.scheduleUpdateJob();
            }
        });
        Button button = new Button(comp, 0);
        button.setText(Messages.getString("GDBJtagDebuggerTab.gdbCommandBrowse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagDSFDebuggerTab.this.browseButtonSelected(Messages.getString("GDBJtagDebuggerTab.gdbCommandBrowse_Title"), GDBJtagDSFDebuggerTab.this.gdbCommand);
            }
        });
        button = new Button(comp, 0);
        button.setText(Messages.getString("GDBJtagDebuggerTab.gdbCommandVariable"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagDSFDebuggerTab.this.variablesButtonSelected(GDBJtagDSFDebuggerTab.this.gdbCommand);
            }
        });
    }

    private void createRemoteControl(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText(Messages.getString("GDBJtagDebuggerTab.remoteGroup_Text"));
        this.useRemote = new Button((Composite)group, 32);
        this.useRemote.setText(Messages.getString("GDBJtagDebuggerTab.useRemote_Text"));
        this.useRemote.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagDSFDebuggerTab.this.useRemoteChanged();
                GDBJtagDSFDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("GDBJtagDebuggerTab.jtagDeviceLabel"));
        this.jtagDevice = new Combo(comp, 12);
        GDBJtagDeviceContribution[] availableDevices = GDBJtagDeviceContributionFactory.getInstance().getGDBJtagDeviceContribution();
        int i = 0;
        while (i < availableDevices.length) {
            this.jtagDevice.add(availableDevices[i].getDeviceName());
            ++i;
        }
        this.jtagDevice.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDSFDebuggerTab.this.updateDeviceIpPort(GDBJtagDSFDebuggerTab.this.jtagDevice.getText());
                GDBJtagDSFDebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.remoteConnectionParameters = new Composite((Composite)group, 524296);
        this.remoteConnectParmsLayout = new StackLayout();
        this.remoteConnectionParameters.setLayout((Layout)this.remoteConnectParmsLayout);
        this.remoteTcpipBox = new Composite(this.remoteConnectionParameters, 524296);
        layout = new GridLayout();
        layout.numColumns = 2;
        this.remoteTcpipBox.setLayout((Layout)layout);
        this.remoteTcpipBox.setBackground(this.remoteConnectionParameters.getParent().getBackground());
        label = new Label(this.remoteTcpipBox, 0);
        label.setText(Messages.getString("GDBJtagDebuggerTab.ipAddressLabel"));
        this.ipAddress = new Text(this.remoteTcpipBox, 2048);
        gd = new GridData();
        gd.widthHint = 125;
        this.ipAddress.setLayoutData((Object)gd);
        label = new Label(this.remoteTcpipBox, 0);
        label.setText(Messages.getString("GDBJtagDebuggerTab.portNumberLabel"));
        this.portNumber = new Text(this.remoteTcpipBox, 2048);
        gd = new GridData();
        gd.widthHint = 125;
        this.portNumber.setLayoutData((Object)gd);
        this.remoteConnectionBox = new Composite(this.remoteConnectionParameters, 524296);
        layout = new GridLayout();
        layout.numColumns = 2;
        this.remoteConnectionBox.setLayout((Layout)layout);
        this.remoteConnectionBox.setBackground(this.remoteConnectionParameters.getParent().getBackground());
        label = new Label(this.remoteConnectionBox, 0);
        label.setText(Messages.getString("GDBJtagDebuggerTab.connectionLabel"));
        this.connection = new Text(this.remoteConnectionBox, 2048);
        gd = new GridData();
        gd.widthHint = 125;
        this.connection.setLayoutData((Object)gd);
        this.ipAddress.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDSFDebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.portNumber.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character);
            }
        });
        this.portNumber.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDSFDebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.connection.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDSFDebuggerTab.this.scheduleUpdateJob();
            }
        });
    }

    protected void updateDeviceIpPort(String selectedDeviceName) {
        if (selectedDeviceName.equals(this.savedJtagDevice)) {
            return;
        }
        GDBJtagDeviceContribution[] availableDevices = GDBJtagDeviceContributionFactory.getInstance().getGDBJtagDeviceContribution();
        IGDBJtagDevice selectedDevice = null;
        int i = 0;
        while (i < availableDevices.length) {
            String name = availableDevices[i].getDeviceName();
            if (name.equals(selectedDeviceName) && (selectedDevice = availableDevices[i].getDevice()) != null) {
                if (selectedDevice instanceof IGDBJtagConnection) {
                    IGDBJtagConnection connectionDevice = (IGDBJtagConnection)selectedDevice;
                    this.connection.setText(connectionDevice.getDefaultDeviceConnection());
                } else {
                    this.ipAddress.setText(selectedDevice.getDefaultIpAddress());
                    this.portNumber.setText(selectedDevice.getDefaultPortNumber());
                }
                this.useRemoteChanged();
                this.updateLaunchConfigurationDialog();
                break;
            }
            ++i;
        }
    }

    private void useRemoteChanged() {
        boolean enabled = this.useRemote.getSelection();
        this.jtagDevice.setEnabled(enabled);
        this.ipAddress.setEnabled(enabled);
        this.portNumber.setEnabled(enabled);
        this.connection.setEnabled(enabled);
        GDBJtagDeviceContribution selectedDeviceEntry = this.findJtagDeviceByName(this.jtagDevice.getText());
        if (selectedDeviceEntry == null || selectedDeviceEntry.getDevice() == null) {
            this.remoteConnectParmsLayout.topControl = null;
            this.remoteConnectionParameters.layout();
        } else {
            IGDBJtagDevice device = selectedDeviceEntry.getDevice();
            if (device instanceof IGDBJtagConnection) {
                this.remoteConnectParmsLayout.topControl = this.remoteConnectionBox;
                this.remoteConnectionBox.getParent().layout();
            } else {
                this.remoteConnectParmsLayout.topControl = this.remoteTcpipBox;
                this.remoteTcpipBox.getParent().layout();
            }
        }
    }

    private GDBJtagDeviceContribution findJtagDeviceByName(String name) {
        GDBJtagDeviceContribution[] availableDevices;
        GDBJtagDeviceContribution[] gDBJtagDeviceContributionArray = availableDevices = GDBJtagDeviceContributionFactory.getInstance().getGDBJtagDeviceContribution();
        int n = availableDevices.length;
        int n2 = 0;
        while (n2 < n) {
            GDBJtagDeviceContribution device = gDBJtagDeviceContributionArray[n2];
            if (device.getDeviceName().equals(name)) {
                return device;
            }
            ++n2;
        }
        return null;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String defaultGdbCommand = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "", null);
            String gdbCommandAttr = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultGdbCommand);
            this.gdbCommand.setText(gdbCommandAttr);
            boolean useRemoteAttr = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
            this.useRemote.setSelection(useRemoteAttr);
            this.savedJtagDevice = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "");
            if (this.savedJtagDevice.length() == 0) {
                this.jtagDevice.select(0);
            } else {
                String storedAddress = "";
                int storedPort = 0;
                String storedConnection = "";
                int i = 0;
                while (i < this.jtagDevice.getItemCount()) {
                    if (this.jtagDevice.getItem(i).equals(this.savedJtagDevice)) {
                        storedAddress = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "");
                        storedPort = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", 0);
                        storedConnection = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.connection", "");
                        this.jtagDevice.select(i);
                        break;
                    }
                    ++i;
                }
                if (storedConnection != null) {
                    try {
                        this.connection.setText(new URI(storedConnection).getSchemeSpecificPart());
                    }
                    catch (URISyntaxException e) {
                        Activator.log((Throwable)e);
                    }
                }
                if (storedAddress != null) {
                    this.ipAddress.setText(storedAddress);
                    String portString = storedPort > 0 && storedPort <= 65535 ? Integer.valueOf(storedPort).toString() : "";
                    this.portNumber.setText(portString);
                }
            }
            boolean updateThreadsOnSuspend = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
            this.fUpdateThreadlistOnSuspend.setSelection(updateThreadsOnSuspend);
            this.useRemoteChanged();
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    public String getId() {
        return TAB_ID;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, this.gdbCommand.getText().trim());
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", this.gdbCommand.getText().trim());
        this.savedJtagDevice = this.jtagDevice.getText();
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", this.savedJtagDevice);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", this.useRemote.getSelection());
        if (this.savedJtagDevice.length() > 0) {
            try {
                IGDBJtagDevice device = this.findJtagDeviceByName(this.jtagDevice.getText()).getDevice();
                if (device instanceof IGDBJtagConnection) {
                    String conn = this.connection.getText().trim();
                    URI uri = new URI("gdb", conn, "");
                    configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.connection", uri.toString());
                } else {
                    String ip = this.ipAddress.getText().trim();
                    configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", ip);
                    int port = Integer.valueOf(this.portNumber.getText().trim());
                    configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", port);
                }
            }
            catch (URISyntaxException e) {
                Activator.log((Throwable)e);
            }
            catch (NumberFormatException e) {
                Activator.log((Throwable)e);
            }
        }
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", this.fUpdateThreadlistOnSuspend.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        String defaultGdbCommand = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "", null);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultGdbCommand);
        CommandFactoryManager cfManager = MIPlugin.getDefault().getCommandFactoryManager();
        CommandFactoryDescriptor defDesc = cfManager.getDefaultDescriptor("org.eclipse.cdt.debug.mi.core.CDebuggerNew");
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_COMMAND_FACTORY, defDesc.getName());
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_PROTOCOL, defDesc.getMIVersions()[0]);
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_VERBOSE_MODE, false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
    }
}

