/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.math.BigInteger;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemorySpaceManagement;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.AddWatchpointDialog;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionDelegate;

public class AddWatchpointActionDelegate
extends ActionDelegate
implements IViewActionDelegate {
    private IViewPart fView;

    public void init(IViewPart view) {
        this.setView(view);
    }

    private void setView(IViewPart view) {
        this.fView = view;
    }

    protected IViewPart getView() {
        return this.fView;
    }

    public void run(IAction action) {
        AddWatchpointDialog dlg = new AddWatchpointDialog(CDebugUIPlugin.getActiveWorkbenchShell(), AddWatchpointActionDelegate.getMemorySpaceManagement());
        if (dlg.open() == 0) {
            this.addWatchpoint(dlg.getWriteAccess(), dlg.getReadAccess(), dlg.getExpression(), dlg.getMemorySpace(), dlg.getRange());
        }
    }

    protected void addWatchpoint(boolean write, boolean read, String expression, String memorySpace, BigInteger range) {
        if (this.getResource() == null) {
            return;
        }
        try {
            CDIDebugModel.createWatchpoint((String)this.getSourceHandle(), (IResource)this.getResource(), (boolean)write, (boolean)read, (String)expression, (String)memorySpace, (BigInteger)range, (boolean)true, (int)0, (String)"", (boolean)true);
        }
        catch (CoreException ce) {
            CDebugUIPlugin.errorDialog(ActionMessages.getString("AddWatchpointActionDelegate1.0"), ce);
        }
    }

    private IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private String getSourceHandle() {
        return "";
    }

    static ICDIMemorySpaceManagement getMemorySpaceManagement() {
        ICDITarget target;
        ICDebugTarget debugTarget;
        IAdaptable debugViewElement = DebugUITools.getDebugContext();
        ICDIMemorySpaceManagement memMgr = null;
        if (debugViewElement != null && (debugTarget = (ICDebugTarget)debugViewElement.getAdapter(ICDebugTarget.class)) != null && (target = (ICDITarget)debugTarget.getAdapter(ICDITarget.class)) instanceof ICDIMemorySpaceManagement) {
            memMgr = (ICDIMemorySpaceManagement)target;
        }
        return memMgr;
    }
}

