/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig2;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.ConsoleOutputSniffer;
import org.eclipse.cdt.make.core.MakeBuilder;
import org.eclipse.cdt.make.core.MakeBuilderUtil;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.StreamMonitor;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerInfoConsoleParserFactory;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCMarkerGenerator;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class DefaultRunSIProvider
implements IExternalScannerInfoProvider {
    private static final String EXTERNAL_SI_PROVIDER_ERROR = "ExternalScannerInfoProvider.Provider_Error";
    private static final String GMAKE_ERROR_PARSER_ID = "org.eclipse.cdt.core.GmakeErrorParser";
    private static final String PREF_CONSOLE_ENABLED = "org.eclipse.cdt.make.core.scanner.discovery.console.enabled";
    private static final String LANG_ENV_VAR = "LANG";
    private static final String NEWLINE = System.getProperty("line.separator", "\n");
    private static final String PATH_ENV = "PATH";
    protected IResource resource;
    protected String providerId;
    protected IScannerConfigBuilderInfo2 buildInfo;
    protected IScannerInfoCollector collector;
    protected IPath fWorkingDirectory;
    protected IPath fCompileCommand;
    protected String[] fCompileArguments;
    private SCMarkerGenerator markerGenerator = new SCMarkerGenerator();

    public boolean invokeProvider(IProgressMonitor monitor, IResource resource, String providerId, IScannerConfigBuilderInfo2 buildInfo, IScannerInfoCollector collector) {
        return this.invokeProvider(monitor, resource, new InfoContext(resource.getProject()), providerId, buildInfo, collector, null);
    }

    public boolean invokeProvider(IProgressMonitor monitor, IResource resource, InfoContext context, String providerId, IScannerConfigBuilderInfo2 buildInfo, IScannerInfoCollector collector, Properties env) {
        this.resource = resource;
        this.providerId = providerId;
        this.buildInfo = buildInfo;
        this.collector = collector;
        IProject currentProject = resource.getProject();
        if (!this.initialize()) {
            return false;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(MakeMessages.getString("ExternalScannerInfoProvider.Reading_Specs"), 100);
        try {
            try {
                StreamMonitor streamMon;
                IConsole console;
                ILanguage language = context.getLanguage();
                if (language != null && DefaultRunSIProvider.isConsoleEnabled()) {
                    String consoleId = "org.eclipse.cdt.make.core." + providerId + '.' + language.getId();
                    String consoleName = MakeMessages.getFormattedString("ExternalScannerInfoProvider.Console_Name", language.getName());
                    console = CCorePlugin.getDefault().getBuildConsole(consoleId, consoleName, null);
                } else {
                    console = CCorePlugin.getDefault().getConsole("org.eclipse.cdt.make.core.console.hidden");
                }
                console.start(currentProject);
                ConsoleOutputStream cos = console.getOutputStream();
                monitor.subTask(MakeMessages.getString("ExternalScannerInfoProvider.Reading_Specs"));
                String errMsg = null;
                CommandLauncher launcher = new CommandLauncher();
                launcher.setProject(currentProject);
                launcher.showCommand(true);
                String[] comandLineOptions = this.getCommandLineOptions();
                String params = this.coligate(comandLineOptions);
                monitor.subTask(String.valueOf(MakeMessages.getString("ExternalScannerInfoProvider.Invoking_Command")) + this.getCommandToLaunch() + params);
                ErrorParserManager epm = new ErrorParserManager(currentProject, (IMarkerGenerator)this.markerGenerator, new String[]{GMAKE_ERROR_PARSER_ID});
                epm.setOutputStream((OutputStream)cos);
                StreamMonitor stdout = streamMon = new StreamMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 70), (OutputStream)epm, 100);
                StreamMonitor stderr = streamMon;
                ConsoleOutputSniffer sniffer = ScannerInfoConsoleParserFactory.getESIProviderOutputSniffer(stdout, stderr, currentProject, context, providerId, buildInfo, collector, this.markerGenerator);
                Object consoleOut = sniffer == null ? cos : sniffer.getOutputStream();
                Object consoleErr = sniffer == null ? cos : sniffer.getErrorStream();
                Process p = launcher.execute(this.getCommandToLaunch(), comandLineOptions, this.setEnvironment((ICommandLauncher)launcher, env), this.fWorkingDirectory, monitor);
                if (p != null) {
                    try {
                        p.getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                    if (launcher.waitAndRead((OutputStream)consoleOut, (OutputStream)consoleErr, (IProgressMonitor)new SubProgressMonitor(monitor, 0)) != 0) {
                        errMsg = launcher.getErrorMessage();
                    }
                    monitor.subTask(MakeMessages.getString("ExternalScannerInfoProvider.Parsing_Output"));
                } else {
                    errMsg = launcher.getErrorMessage();
                }
                if (errMsg != null) {
                    String errorPrefix = MakeMessages.getString("ExternalScannerInfoProvider.Error_Prefix");
                    String program = this.fCompileCommand.toString();
                    String msg = MakeMessages.getFormattedString(EXTERNAL_SI_PROVIDER_ERROR, String.valueOf(program) + params);
                    this.printLine((OutputStream)consoleErr, String.valueOf(errorPrefix) + msg + NEWLINE);
                    Properties envMap = this.getEnvMap((ICommandLauncher)launcher, env);
                    String envPath = envMap.getProperty(PATH_ENV);
                    if (envPath == null) {
                        envPath = System.getenv(PATH_ENV);
                    }
                    if (!this.fCompileCommand.isAbsolute() && PathUtil.findProgramLocation((String)program, (String)envPath) == null) {
                        this.printLine((OutputStream)consoleErr, errMsg);
                        msg = MakeMessages.getFormattedString("ExternalScannerInfoProvider.Working_Directory", this.fWorkingDirectory);
                        msg = MakeMessages.getFormattedString("ExternalScannerInfoProvider.Program_Not_In_Path", program);
                        this.printLine((OutputStream)consoleErr, String.valueOf(errorPrefix) + msg + NEWLINE);
                        this.printLine((OutputStream)consoleErr, "PATH=[" + envPath + "]" + NEWLINE);
                    } else {
                        this.printLine((OutputStream)consoleErr, String.valueOf(errorPrefix) + errMsg);
                        msg = MakeMessages.getFormattedString("ExternalScannerInfoProvider.Working_Directory", this.fWorkingDirectory);
                        this.printLine((OutputStream)consoleErr, "PATH=[" + envPath + "]" + NEWLINE);
                    }
                    monitor.subTask(MakeMessages.getString("ExternalScannerInfoProvider.Creating_Markers"));
                }
                ((OutputStream)consoleOut).close();
                ((OutputStream)consoleErr).close();
                cos.close();
            }
            catch (Exception e) {
                MakeCorePlugin.log(e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    protected IPath getCommandToLaunch() {
        return this.fCompileCommand;
    }

    protected String[] getCommandLineOptions() {
        return this.prepareArguments(this.buildInfo.isUseDefaultProviderCommand(this.providerId));
    }

    private void printLine(OutputStream stream, String msg) throws IOException {
        stream.write((String.valueOf(msg) + NEWLINE).getBytes());
        stream.flush();
    }

    protected boolean initialize() {
        IProject currProject = this.resource.getProject();
        URI workingDirURI = MakeBuilderUtil.getBuildDirectoryURI(currProject, MakeBuilder.BUILDER_ID);
        String pathString = EFSExtensionManager.getDefault().getPathFromURI(workingDirURI);
        if (pathString == null) {
            throw new IllegalStateException();
        }
        this.fWorkingDirectory = new Path(pathString);
        this.fCompileCommand = new Path(this.buildInfo.getProviderRunCommand(this.providerId));
        this.fCompileArguments = ScannerConfigUtil.tokenizeStringWithQuotes(this.buildInfo.getProviderRunArguments(this.providerId), "\"");
        return this.fCompileCommand != null;
    }

    protected String[] prepareArguments(boolean isDefaultCommand) {
        return this.fCompileArguments;
    }

    private String coligate(String[] array) {
        StringBuffer sb = new StringBuffer(128);
        int i = 0;
        while (i < array.length) {
            sb.append(' ');
            sb.append(array[i]);
            ++i;
        }
        String ca = sb.toString();
        return ca;
    }

    private Properties getEnvMap(ICommandLauncher launcher, Properties initialEnv) {
        Properties props;
        Properties properties = props = initialEnv != null ? initialEnv : launcher.getEnvironment();
        if (this.fWorkingDirectory != null) {
            props.put("CWD", this.fWorkingDirectory.toOSString());
            props.put("PWD", this.fWorkingDirectory.toOSString());
        }
        if (props.containsKey(LANG_ENV_VAR)) {
            props.put(LANG_ENV_VAR, "en_US.UTF-8");
        }
        return props;
    }

    protected String[] setEnvironment(ICommandLauncher launcher, Properties initialEnv) {
        Properties props = this.getEnvMap(launcher, initialEnv);
        String[] env = null;
        ArrayList<String> envList = new ArrayList<String>();
        Enumeration<?> names = props.propertyNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                envList.add(String.valueOf(key) + "=" + props.getProperty(key));
            }
            env = envList.toArray(new String[envList.size()]);
        }
        return env;
    }

    public static void setConsoleEnabled(boolean value) {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.make.core");
        node.putBoolean(PREF_CONSOLE_ENABLED, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            MakeCorePlugin.log(e);
        }
    }

    public static boolean isConsoleEnabled() {
        boolean value = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.make.core").getBoolean(PREF_CONSOLE_ENABLED, false);
        return value;
    }
}

