/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.core.runtime.IConfigurationElement;

public class ManagedBuildCoreTests
extends TestCase {
    private static IProjectType exeType;
    private static IProjectType libType;
    private static IProjectType dllType;

    public ManagedBuildCoreTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ManagedBuildCoreTests.class.getName());
        suite.addTest((Test)new ManagedBuildCoreTests("testLoadManifest"));
        return suite;
    }

    public void testLoadManifest() throws Exception {
        exeType = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.testgnu21.exe");
        this.checkExeProjectType(exeType);
        dllType = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.testgnu21.so");
        this.checkSoProjectType(dllType);
        libType = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.testgnu21.lib");
        this.checkLibProjectType(libType);
    }

    private void checkExeProjectType(IProjectType ptype) throws BuildException {
        int expecectedNumConfigs = 2;
        String[] expectedConfigName = new String[]{"Dbg", "Rel"};
        String expectedCleanCmd = "rm -rf";
        String expectedParserId = "org.eclipse.cdt.core.CWDLocator;org.eclipse.cdt.core.GCCErrorParser;org.eclipse.cdt.core.GLDErrorParser;org.eclipse.cdt.core.GASErrorParser;org.eclipse.cdt.core.GmakeErrorParser";
        String expectedOSList = "solaris,linux,hpux,aix,qnx";
        int expectedSizeOSList = 5;
        Object[] expectedArchList = new String[]{"all"};
        String expectedBinaryParser = "org.eclipse.cdt.core.ELF";
        String expectedBinaryParser2 = "org.eclipse.cdt.core.PE";
        String[] expectedPlatformName = new String[]{"Dbg Platform", "Rel Platform"};
        String expectedCommand = "make";
        String expectedArguments = "-k";
        String[] expectedBuilderName = new String[]{"Dbg Builder", "Rel Builder"};
        String expectedBuilderInfo = "org.eclipse.cdt.managedbuilder.makegen.gnu.GnuMakefileGenerator";
        String[] expectedToolId1 = new String[]{"cdt.managedbuild.tool.testgnu.c.compiler.exe.debug", "cdt.managedbuild.tool.testgnu.c.compiler.exe.release"};
        String expectedSuperToolId1 = "cdt.managedbuild.tool.testgnu.c.compiler";
        String expectedSuperOutputFlag1 = "-o";
        String expectedSuperGetToolCommand1 = "gcc";
        Object[] expectedSuperInputExt1 = new String[]{"c"};
        Object[] expectedSuperToolInterfaceExt1 = new String[]{"h"};
        Object[] expectedSuperToolOutputExt1 = new String[]{"o"};
        String expectedOptionCategory1 = "testgnu.c.compiler.category.preprocessor";
        String[] OptionId1 = new String[]{"testgnu.c.compiler.exe.debug.option.optimization.level", "testgnu.c.compiler.exe.release.option.optimization.level"};
        String[] expectedOptionIdValue1 = new String[]{"testgnu.c.optimization.level.none", "testgnu.c.optimization.level.most"};
        String expectedEnumList1 = "Posix.Optimize.None, Posix.Optimize.Optimize, Posix.Optimize.More, Posix.Optimize.Most";
        int expectedSizeEnumList1 = 4;
        String[] expectedOptionEnumCmd1arr = new String[]{"-O0", "-O3"};
        String OptionId2 = "testgnu.c.compiler.option.debugging.other";
        String expectedOptionIdName2 = "Posix.Debug.Other";
        String OptionId3 = "testgnu.c.compiler.option.debugging.gprof";
        String expectedOptionIdName3 = "Posix.Debug.gprof";
        String expectedOptionIdCmd3 = "-pg";
        boolean expectedOptionIdValue3 = false;
        int expecectedNumTools = 5;
        int numOrderCCompilerTool = 0;
        int expecectedCNature = 0;
        ManagedBuildCoreTests.assertNotNull((Object)ptype);
        ManagedBuildCoreTests.assertTrue((boolean)ptype.isTestProjectType());
        ManagedBuildCoreTests.assertFalse((boolean)ptype.isAbstract());
        IConfiguration[] configs = ptype.getConfigurations();
        ManagedBuildCoreTests.assertNotNull((Object)configs);
        ManagedBuildCoreTests.assertEquals((int)expecectedNumConfigs, (int)configs.length);
        int iconfig = 0;
        while (iconfig < configs.length) {
            ManagedBuildCoreTests.assertEquals((String)configs[iconfig].getName(), (String)expectedConfigName[iconfig]);
            ManagedBuildCoreTests.assertEquals((String)expectedCleanCmd, (String)configs[iconfig].getCleanCommand());
            ManagedBuildCoreTests.assertEquals((String)expectedParserId, (String)configs[iconfig].getErrorParserIds());
            IToolChain toolChain = configs[iconfig].getToolChain();
            ITargetPlatform platform = toolChain.getTargetPlatform();
            ArrayList<String> expectedOSListarr = new ArrayList<String>();
            String[] expectedOSListTokens = expectedOSList.split(",");
            int i = 0;
            while (i < expectedOSListTokens.length) {
                expectedOSListarr.add(expectedOSListTokens[i].trim());
                ++i;
            }
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(platform.getOSList(), expectedOSListarr.toArray(new String[expectedSizeOSList])));
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(platform.getArchList(), expectedArchList));
            String[] binaryParsers = platform.getBinaryParserList();
            ManagedBuildCoreTests.assertEquals((int)binaryParsers.length, (int)2);
            ManagedBuildCoreTests.assertEquals((String)binaryParsers[0], (String)expectedBinaryParser);
            ManagedBuildCoreTests.assertEquals((String)binaryParsers[1], (String)expectedBinaryParser2);
            ManagedBuildCoreTests.assertEquals((String)platform.getName(), (String)expectedPlatformName[iconfig]);
            IBuilder builder = toolChain.getBuilder();
            ManagedBuildCoreTests.assertEquals((String)builder.getCommand(), (String)expectedCommand);
            ManagedBuildCoreTests.assertEquals((String)builder.getArguments(), (String)expectedArguments);
            ManagedBuildCoreTests.assertEquals((String)builder.getName(), (String)expectedBuilderName[iconfig]);
            IConfigurationElement element = ((Builder)builder).getBuildFileGeneratorElement();
            if (element != null) {
                ManagedBuildCoreTests.assertEquals((String)element.getAttribute("buildfileGenerator"), (String)expectedBuilderInfo);
            }
            ITool[] tools = toolChain.getTools();
            ManagedBuildCoreTests.assertEquals((int)tools.length, (int)expecectedNumTools);
            ITool tool = tools[numOrderCCompilerTool];
            ITool superTool = tool.getSuperClass();
            ManagedBuildCoreTests.assertEquals((String)tool.getId(), (String)expectedToolId1[iconfig]);
            ManagedBuildCoreTests.assertEquals((String)superTool.getId(), (String)expectedSuperToolId1);
            ManagedBuildCoreTests.assertEquals((int)tool.getNatureFilter(), (int)expecectedCNature);
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(superTool.getAllInputExtensions(), expectedSuperInputExt1));
            ManagedBuildCoreTests.assertEquals((String)superTool.getOutputFlag(), (String)expectedSuperOutputFlag1);
            ManagedBuildCoreTests.assertEquals((String)superTool.getToolCommand(), (String)expectedSuperGetToolCommand1);
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(superTool.getAllDependencyExtensions(), expectedSuperToolInterfaceExt1));
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(superTool.getOutputsAttribute(), expectedSuperToolOutputExt1));
            ManagedBuildCoreTests.assertTrue((boolean)superTool.isAbstract());
            IOptionCategory[] optionCats = superTool.getChildCategories();
            ManagedBuildCoreTests.assertEquals((String)optionCats[0].getId(), (String)expectedOptionCategory1);
            IOption option = tool.getOptionById(OptionId1[iconfig]);
            ManagedBuildCoreTests.assertTrue((boolean)option.isExtensionElement());
            String optionDefaultValue = (String)option.getDefaultValue();
            ManagedBuildCoreTests.assertEquals((int)option.getValueType(), (int)1);
            ManagedBuildCoreTests.assertEquals((String)optionDefaultValue, (String)expectedOptionIdValue1[iconfig]);
            String optionEnumCmd1 = option.getEnumCommand(optionDefaultValue);
            ManagedBuildCoreTests.assertEquals((String)optionEnumCmd1, (String)expectedOptionEnumCmd1arr[iconfig]);
            ArrayList<String> expectedEnumList1arr = new ArrayList<String>();
            String[] expectedEnumList1Tokens = expectedEnumList1.split(",");
            i = 0;
            while (i < expectedEnumList1Tokens.length) {
                expectedEnumList1arr.add(expectedEnumList1Tokens[i].trim());
                ++i;
            }
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(option.getApplicableValues(), expectedEnumList1arr.toArray(new String[expectedSizeEnumList1])));
            option = tool.getOptionById(OptionId2);
            ManagedBuildCoreTests.assertTrue((boolean)option.isExtensionElement());
            ManagedBuildCoreTests.assertEquals((int)option.getValueType(), (int)2);
            ManagedBuildCoreTests.assertEquals((String)option.getName(), (String)expectedOptionIdName2);
            option = tool.getOptionById(OptionId3);
            ManagedBuildCoreTests.assertTrue((boolean)option.isExtensionElement());
            ManagedBuildCoreTests.assertEquals((int)option.getValueType(), (int)0);
            boolean optionDefaultValueb = option.getBooleanValue();
            ManagedBuildCoreTests.assertEquals((boolean)optionDefaultValueb, (boolean)expectedOptionIdValue3);
            ManagedBuildCoreTests.assertEquals((String)option.getName(), (String)expectedOptionIdName3);
            ManagedBuildCoreTests.assertEquals((String)option.getCommand(), (String)expectedOptionIdCmd3);
            ++iconfig;
        }
    }

    private void checkSoProjectType(IProjectType ptype) throws BuildException {
        int expecectedNumConfigs = 2;
        String[] expectedConfigName = new String[]{"Debug", "Release"};
        String expectedCleanCmd = "rm -rf";
        String expectedParserId = "org.eclipse.cdt.core.CWDLocator;org.eclipse.cdt.core.GCCErrorParser;org.eclipse.cdt.core.GLDErrorParser;org.eclipse.cdt.core.GASErrorParser;org.eclipse.cdt.core.GmakeErrorParser";
        String expectedArtifactExtension = "so";
        String expectedOSList = "solaris,linux,hpux,aix,qnx";
        int expectedSizeOSList = 5;
        Object[] expectedArchList = new String[]{"all"};
        String expectedBinaryParser = "org.eclipse.cdt.core.ELF";
        String[] expectedPlatformName = new String[]{"so Debug Platform", "so Release Platform"};
        String expectedCommand = "make";
        String expectedArguments = "-k";
        String[] expectedBuilderName = new String[]{"so Debug Builder", "so Release Builder"};
        String expectedScannerConfigDiscoveryProfileId = "org.eclipse.cdt.managedbuilder.core.GCCManagedMakePerProjectProfile";
        String[] expectedToolChainName = new String[]{"so Debug ToolChain", "so Release ToolChain"};
        String[] expectedToolId1 = new String[]{"cdt.managedbuild.tool.testgnu.c.linker.so.debug", "cdt.managedbuild.tool.testgnu.c.linker.so.release"};
        String expectedSuperToolId1 = "cdt.managedbuild.tool.testgnu.c.linker";
        String expectedToolOutputPrefix = "lib";
        Object[] expectedToolOutput = new String[]{""};
        String expectedSuperOutputFlag1 = "-o";
        String expectedSuperGetToolCommand1 = "gcc";
        Object[] expectedSuperInputExt1 = new String[]{"o"};
        Object[] expectedSuperToolOutputExt1 = new String[]{""};
        String expectedOptionCategory1 = "testgnu.c.link.category.general";
        String OptionId1A = "testgnu.c.link.option.libs";
        String OptionId1B = "testgnu.c.link.option.paths";
        String OptionId1C = "testgnu.c.link.option.userobjs";
        String expectedOptionCmd1Aarr = "-l";
        String expectedOptionCmd1Barr = "-L";
        String OptionId2 = "testgnu.c.link.option.defname";
        String expectedOptionIdName2 = "Posix.Linker.Defname";
        String expectedOptionIdCmd2 = "-Wl,--output-def=";
        String OptionId3 = "testgnu.c.link.option.nostart";
        String expectedOptionIdName3 = "Posix.Linker.NoStartFiles";
        String expectedOptionIdCmd3 = "-nostartfiles";
        boolean expectedOptionIdValue3 = false;
        String OptionId4 = "testgnu.c.link.option.shared";
        String expectedOptionIdName4 = "Posix.Linker.Shared";
        String expectedOptionIdCmd4 = "-shared";
        boolean expectedOptionIdValue4 = false;
        int expecectedNumTools = 5;
        int numOrderCLinkerTool = 2;
        int expecectedCNature = 0;
        ManagedBuildCoreTests.assertNotNull((Object)ptype);
        ManagedBuildCoreTests.assertTrue((boolean)ptype.isTestProjectType());
        ManagedBuildCoreTests.assertFalse((boolean)ptype.isAbstract());
        IConfiguration[] configs = ptype.getConfigurations();
        ManagedBuildCoreTests.assertNotNull((Object)configs);
        ManagedBuildCoreTests.assertEquals((int)expecectedNumConfigs, (int)configs.length);
        int iconfig = 0;
        while (iconfig < configs.length) {
            ManagedBuildCoreTests.assertEquals((String)configs[iconfig].getName(), (String)expectedConfigName[iconfig]);
            ManagedBuildCoreTests.assertEquals((String)expectedCleanCmd, (String)configs[iconfig].getCleanCommand());
            ManagedBuildCoreTests.assertEquals((String)expectedParserId, (String)configs[iconfig].getErrorParserIds());
            ManagedBuildCoreTests.assertEquals((String)configs[iconfig].getArtifactExtension(), (String)expectedArtifactExtension);
            IToolChain toolChain = configs[iconfig].getToolChain();
            ManagedBuildCoreTests.assertEquals((String)toolChain.getName(), (String)expectedToolChainName[iconfig]);
            ArrayList<String> expectedOSListarr = new ArrayList<String>();
            String[] expectedOSListTokens = expectedOSList.split(",");
            int i = 0;
            while (i < expectedOSListTokens.length) {
                expectedOSListarr.add(expectedOSListTokens[i].trim());
                ++i;
            }
            ManagedBuildCoreTests.assertEquals((String)expectedParserId, (String)configs[iconfig].getErrorParserIds());
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(toolChain.getOSList(), expectedOSListarr.toArray(new String[expectedSizeOSList])));
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(toolChain.getArchList(), expectedArchList));
            ManagedBuildCoreTests.assertEquals((String)expectedScannerConfigDiscoveryProfileId, (String)toolChain.getScannerConfigDiscoveryProfileId());
            ITargetPlatform platform = toolChain.getTargetPlatform();
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(platform.getOSList(), expectedOSListarr.toArray(new String[expectedSizeOSList])));
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(platform.getArchList(), expectedArchList));
            String[] binaryParsers = platform.getBinaryParserList();
            ManagedBuildCoreTests.assertEquals((int)binaryParsers.length, (int)1);
            ManagedBuildCoreTests.assertEquals((String)binaryParsers[0], (String)expectedBinaryParser);
            ManagedBuildCoreTests.assertEquals((String)platform.getName(), (String)expectedPlatformName[iconfig]);
            IBuilder builder = toolChain.getBuilder();
            ManagedBuildCoreTests.assertEquals((String)builder.getCommand(), (String)expectedCommand);
            ManagedBuildCoreTests.assertEquals((String)builder.getArguments(), (String)expectedArguments);
            ManagedBuildCoreTests.assertEquals((String)builder.getName(), (String)expectedBuilderName[iconfig]);
            ITool[] tools = toolChain.getTools();
            ManagedBuildCoreTests.assertEquals((int)tools.length, (int)expecectedNumTools);
            ITool tool = tools[numOrderCLinkerTool];
            ITool superTool = tool.getSuperClass();
            ManagedBuildCoreTests.assertEquals((String)tool.getId(), (String)expectedToolId1[iconfig]);
            ManagedBuildCoreTests.assertEquals((String)superTool.getId(), (String)expectedSuperToolId1);
            ManagedBuildCoreTests.assertEquals((int)tool.getNatureFilter(), (int)expecectedCNature);
            ManagedBuildCoreTests.assertEquals((String)tool.getOutputPrefix(), (String)expectedToolOutputPrefix);
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(superTool.getOutputsAttribute(), expectedToolOutput));
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(superTool.getAllInputExtensions(), expectedSuperInputExt1));
            ManagedBuildCoreTests.assertEquals((String)superTool.getOutputFlag(), (String)expectedSuperOutputFlag1);
            ManagedBuildCoreTests.assertEquals((String)superTool.getToolCommand(), (String)expectedSuperGetToolCommand1);
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(superTool.getOutputsAttribute(), expectedSuperToolOutputExt1));
            IOptionCategory[] optionCats = superTool.getChildCategories();
            ManagedBuildCoreTests.assertEquals((String)optionCats[0].getId(), (String)expectedOptionCategory1);
            IOption option = tool.getOptionById(OptionId1A);
            ManagedBuildCoreTests.assertTrue((boolean)option.isExtensionElement());
            ManagedBuildCoreTests.assertEquals((int)option.getValueType(), (int)6);
            ManagedBuildCoreTests.assertEquals((String)option.getCommand(), (String)expectedOptionCmd1Aarr);
            ManagedBuildCoreTests.assertEquals((int)option.getBrowseType(), (int)1);
            option = tool.getOptionById(OptionId1B);
            ManagedBuildCoreTests.assertTrue((boolean)option.isExtensionElement());
            ManagedBuildCoreTests.assertEquals((int)option.getValueType(), (int)3);
            ManagedBuildCoreTests.assertEquals((String)option.getCommand(), (String)expectedOptionCmd1Barr);
            ManagedBuildCoreTests.assertEquals((int)option.getBrowseType(), (int)2);
            option = tool.getOptionById(OptionId1C);
            ManagedBuildCoreTests.assertTrue((boolean)option.isExtensionElement());
            ManagedBuildCoreTests.assertEquals((int)option.getValueType(), (int)7);
            ManagedBuildCoreTests.assertEquals((int)option.getBrowseType(), (int)1);
            option = tool.getOptionById(OptionId2);
            ManagedBuildCoreTests.assertTrue((boolean)option.isExtensionElement());
            ManagedBuildCoreTests.assertEquals((int)option.getValueType(), (int)2);
            ManagedBuildCoreTests.assertEquals((String)option.getName(), (String)expectedOptionIdName2);
            ManagedBuildCoreTests.assertEquals((String)option.getCommand(), (String)expectedOptionIdCmd2);
            option = tool.getOptionById(OptionId3);
            ManagedBuildCoreTests.assertTrue((boolean)option.isExtensionElement());
            ManagedBuildCoreTests.assertEquals((int)option.getValueType(), (int)0);
            boolean optionDefaultValueb1 = option.getBooleanValue();
            ManagedBuildCoreTests.assertEquals((boolean)optionDefaultValueb1, (boolean)expectedOptionIdValue3);
            ManagedBuildCoreTests.assertEquals((String)option.getName(), (String)expectedOptionIdName3);
            ManagedBuildCoreTests.assertEquals((String)option.getCommand(), (String)expectedOptionIdCmd3);
            option = tool.getOptionById(OptionId4);
            ManagedBuildCoreTests.assertTrue((boolean)option.isExtensionElement());
            ManagedBuildCoreTests.assertEquals((int)option.getValueType(), (int)0);
            boolean optionDefaultValueb2 = option.getBooleanValue();
            ManagedBuildCoreTests.assertEquals((boolean)optionDefaultValueb2, (boolean)expectedOptionIdValue4);
            ManagedBuildCoreTests.assertEquals((String)option.getName(), (String)expectedOptionIdName4);
            ManagedBuildCoreTests.assertEquals((String)option.getCommand(), (String)expectedOptionIdCmd4);
            ++iconfig;
        }
    }

    private void checkLibProjectType(IProjectType ptype) throws BuildException {
        int expecectedNumConfigs = 2;
        String[] expectedConfigName = new String[]{"Dbg", "Rel"};
        String expectedCleanCmd = "rm -rf";
        String expectedParserId = "org.eclipse.cdt.core.CWDLocator;org.eclipse.cdt.core.GCCErrorParser;org.eclipse.cdt.core.GLDErrorParser;org.eclipse.cdt.core.GASErrorParser;org.eclipse.cdt.core.GmakeErrorParser";
        String expectedArtifactExtension = "a";
        String expectedOSList = "solaris,linux,hpux,aix,qnx";
        int expectedSizeOSList = 5;
        Object[] expectedArchList = new String[]{"all"};
        String expectedBinaryParser = "org.eclipse.cdt.core.ELF";
        String[] expectedPlatformName = new String[]{"Dbg P", "Rel P"};
        String expectedCommand = "make";
        String expectedArguments = "-k";
        String[] expectedBuilderName = new String[]{"Dbg B", "Rel B"};
        String expectedScannerConfigDiscoveryProfileId = "org.eclipse.cdt.managedbuilder.core.GCCManagedMakePerProjectProfile";
        String[] expectedToolId1 = new String[]{"cdt.managedbuild.tool.testgnu.cpp.compiler.lib.debug", "cdt.managedbuild.tool.testgnu.cpp.compiler.lib.release"};
        String expectedSuperToolId1 = "cdt.managedbuild.tool.testgnu.cpp.compiler";
        String expectedSuperOutputFlag1 = "-o";
        String expectedSuperGetToolCommand1 = "g++";
        Object[] expectedSuperInputExt1 = new String[]{"c", "C", "cc", "cxx", "cpp"};
        Object[] expectedSuperToolInterfaceExt1 = new String[]{"h", "H", "hpp"};
        Object[] expectedSuperToolOutputExt1 = new String[]{"o"};
        String expectedOptionCategory1 = "testgnu.cpp.compiler.category.preprocessor";
        String[] OptionId1 = new String[]{"testgnu.cpp.compiler.lib.debug.option.optimization.level", "testgnu.cpp.compiler.lib.release.option.optimization.level"};
        String[] expectedOptionIdValue1 = new String[]{"testgnu.cpp.compiler.optimization.level.none", "testgnu.cpp.compiler.optimization.level.most"};
        String expectedEnumList1 = "Posix.Optimize.None, Posix.Optimize.Optimize, Posix.Optimize.More, Posix.Optimize.Most";
        int expectedSizeEnumList1 = 4;
        String[] expectedOptionEnumCmd1arr = new String[]{"-O0", "-O3"};
        String OptionId2 = "testgnu.cpp.compiler.option.other.other";
        String expectedOptionIdName2 = "OtherFlags";
        String OptionId3 = "testgnu.cpp.compiler.option.other.verbose";
        String expectedOptionIdName3 = "Posix.Verbose";
        String expectedOptionIdCmd3 = "-v";
        boolean expectedOptionIdValue3 = false;
        int expecectedNumTools = 4;
        int numOrderCppCompilerTool = 1;
        int expecectedCCNature = 1;
        ManagedBuildCoreTests.assertNotNull((Object)ptype);
        ManagedBuildCoreTests.assertTrue((boolean)ptype.isTestProjectType());
        ManagedBuildCoreTests.assertFalse((boolean)ptype.isAbstract());
        IConfiguration[] configs = ptype.getConfigurations();
        ManagedBuildCoreTests.assertNotNull((Object)configs);
        ManagedBuildCoreTests.assertEquals((int)expecectedNumConfigs, (int)configs.length);
        int iconfig = 0;
        while (iconfig < configs.length) {
            ManagedBuildCoreTests.assertEquals((String)configs[iconfig].getName(), (String)expectedConfigName[iconfig]);
            ManagedBuildCoreTests.assertEquals((String)expectedCleanCmd, (String)configs[iconfig].getCleanCommand());
            ManagedBuildCoreTests.assertEquals((String)expectedParserId, (String)configs[iconfig].getErrorParserIds());
            ManagedBuildCoreTests.assertEquals((String)configs[iconfig].getArtifactExtension(), (String)expectedArtifactExtension);
            IToolChain toolChain = configs[iconfig].getToolChain();
            ArrayList<String> expectedOSListarr = new ArrayList<String>();
            String[] expectedOSListTokens = expectedOSList.split(",");
            int i = 0;
            while (i < expectedOSListTokens.length) {
                expectedOSListarr.add(expectedOSListTokens[i].trim());
                ++i;
            }
            ManagedBuildCoreTests.assertEquals((String)expectedParserId, (String)configs[iconfig].getErrorParserIds());
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(toolChain.getOSList(), expectedOSListarr.toArray(new String[expectedSizeOSList])));
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(toolChain.getArchList(), expectedArchList));
            ManagedBuildCoreTests.assertEquals((String)expectedScannerConfigDiscoveryProfileId, (String)toolChain.getScannerConfigDiscoveryProfileId());
            ITargetPlatform platform = toolChain.getTargetPlatform();
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(platform.getOSList(), expectedOSListarr.toArray(new String[expectedSizeOSList])));
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(platform.getArchList(), expectedArchList));
            String[] binaryParsers = platform.getBinaryParserList();
            ManagedBuildCoreTests.assertEquals((int)binaryParsers.length, (int)1);
            ManagedBuildCoreTests.assertEquals((String)binaryParsers[0], (String)expectedBinaryParser);
            ManagedBuildCoreTests.assertEquals((String)platform.getName(), (String)expectedPlatformName[iconfig]);
            IBuilder builder = toolChain.getBuilder();
            ManagedBuildCoreTests.assertEquals((String)builder.getCommand(), (String)expectedCommand);
            ManagedBuildCoreTests.assertEquals((String)builder.getArguments(), (String)expectedArguments);
            ManagedBuildCoreTests.assertEquals((String)builder.getName(), (String)expectedBuilderName[iconfig]);
            ITool[] tools = toolChain.getTools();
            ManagedBuildCoreTests.assertEquals((int)tools.length, (int)expecectedNumTools);
            ITool tool = tools[numOrderCppCompilerTool];
            ITool superTool = tool.getSuperClass();
            ManagedBuildCoreTests.assertEquals((String)tool.getId(), (String)expectedToolId1[iconfig]);
            ManagedBuildCoreTests.assertEquals((String)superTool.getId(), (String)expectedSuperToolId1);
            ManagedBuildCoreTests.assertEquals((int)tool.getNatureFilter(), (int)expecectedCCNature);
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(superTool.getAllInputExtensions(), expectedSuperInputExt1));
            ManagedBuildCoreTests.assertEquals((String)superTool.getOutputFlag(), (String)expectedSuperOutputFlag1);
            ManagedBuildCoreTests.assertEquals((String)superTool.getToolCommand(), (String)expectedSuperGetToolCommand1);
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(superTool.getAllDependencyExtensions(), expectedSuperToolInterfaceExt1));
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(superTool.getOutputsAttribute(), expectedSuperToolOutputExt1));
            IOptionCategory[] optionCats = superTool.getChildCategories();
            ManagedBuildCoreTests.assertEquals((String)optionCats[0].getId(), (String)expectedOptionCategory1);
            IOption option = tool.getOptionById(OptionId1[iconfig]);
            ManagedBuildCoreTests.assertTrue((boolean)option.isExtensionElement());
            String optionDefaultValue = (String)option.getDefaultValue();
            ManagedBuildCoreTests.assertEquals((int)option.getValueType(), (int)1);
            ManagedBuildCoreTests.assertEquals((String)optionDefaultValue, (String)expectedOptionIdValue1[iconfig]);
            String optionEnumCmd1 = option.getEnumCommand(optionDefaultValue);
            ManagedBuildCoreTests.assertEquals((String)optionEnumCmd1, (String)expectedOptionEnumCmd1arr[iconfig]);
            ArrayList<String> expectedEnumList1arr = new ArrayList<String>();
            String[] expectedEnumList1Tokens = expectedEnumList1.split(",");
            i = 0;
            while (i < expectedEnumList1Tokens.length) {
                expectedEnumList1arr.add(expectedEnumList1Tokens[i].trim());
                ++i;
            }
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(option.getApplicableValues(), expectedEnumList1arr.toArray(new String[expectedSizeEnumList1])));
            option = tool.getOptionById(OptionId2);
            ManagedBuildCoreTests.assertTrue((boolean)option.isExtensionElement());
            ManagedBuildCoreTests.assertEquals((int)option.getValueType(), (int)2);
            ManagedBuildCoreTests.assertEquals((String)option.getName(), (String)expectedOptionIdName2);
            option = tool.getOptionById(OptionId3);
            ManagedBuildCoreTests.assertTrue((boolean)option.isExtensionElement());
            ManagedBuildCoreTests.assertEquals((int)option.getValueType(), (int)0);
            boolean optionDefaultValueb = option.getBooleanValue();
            ManagedBuildCoreTests.assertEquals((boolean)optionDefaultValueb, (boolean)expectedOptionIdValue3);
            ManagedBuildCoreTests.assertEquals((String)option.getName(), (String)expectedOptionIdName3);
            ManagedBuildCoreTests.assertEquals((String)option.getCommand(), (String)expectedOptionIdCmd3);
            ++iconfig;
        }
    }
}

