/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfigurationV2;
import org.eclipse.cdt.managedbuilder.core.IEnvVarBuildPath;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IOptionPathConverter;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.IToolReference;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.ConfigurationV2;
import org.eclipse.cdt.managedbuilder.internal.core.OptionReference;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGeneratorType;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolReference
implements IToolReference {
    private static final String DEFAULT_SEPARATOR = ",";
    private String command;
    private boolean isDirty = false;
    private List<OptionReference> optionReferences;
    private IBuildObject owner;
    private String outputExtensions;
    private String outputFlag;
    private String outputPrefix;
    protected ITool parent;
    private boolean resolved = true;
    private String versionsSupported;
    private String convertToId;

    public ToolReference(BuildObject owner, Element element) {
        this.owner = owner;
        if (owner instanceof ConfigurationV2) {
            if (this.parent == null) {
                Target parentTarget = (Target)((ConfigurationV2)owner).getTarget();
                try {
                    this.parent = ((Target)parentTarget.getParent()).getTool(element.getAttribute("id"));
                }
                catch (NullPointerException nullPointerException) {
                    this.parent = null;
                }
            }
            ((ConfigurationV2)owner).addToolReference(this);
        } else if (owner instanceof Target) {
            if (this.parent == null) {
                try {
                    this.parent = ((Target)((Target)owner).getParent()).getTool(element.getAttribute("id"));
                }
                catch (NullPointerException nullPointerException) {
                    this.parent = null;
                }
            }
            ((Target)owner).addToolReference(this);
        }
        if (element.hasAttribute("command")) {
            this.command = element.getAttribute("command");
        }
        if (element.hasAttribute("outputPrefix")) {
            this.outputPrefix = element.getAttribute("outputPrefix");
        }
        if (element.hasAttribute("outputs")) {
            this.outputExtensions = element.getAttribute("outputs");
        }
        if (element.hasAttribute("outputFlag")) {
            this.outputFlag = element.getAttribute("outputFlag");
        }
        NodeList configElements = element.getChildNodes();
        int i = 0;
        while (i < configElements.getLength()) {
            Node configElement = configElements.item(i);
            if (configElement.getNodeName().equals("optionReference")) {
                new OptionReference(this, (Element)configElement);
            }
            ++i;
        }
    }

    public ToolReference(BuildObject owner, IManagedConfigElement element) {
        ManagedBuildManager.putConfigElement(this, element);
        this.resolved = false;
        this.owner = owner;
        if (owner instanceof ConfigurationV2) {
            ((ConfigurationV2)owner).addToolReference(this);
        } else if (owner instanceof Target) {
            ((Target)owner).addToolReference(this);
        }
        this.command = element.getAttribute("command");
        this.outputPrefix = element.getAttribute("outputPrefix");
        String output = element.getAttribute("outputs");
        if (output != null) {
            this.outputExtensions = output;
        }
        this.outputFlag = element.getAttribute("outputFlag");
        IManagedConfigElement[] toolElements = element.getChildren();
        int m = 0;
        while (m < toolElements.length) {
            IManagedConfigElement toolElement = toolElements[m];
            if (toolElement.getName().equals("optionReference")) {
                new OptionReference(this, toolElement);
            }
            ++m;
        }
    }

    public ToolReference(BuildObject owner, ITool tool) {
        this.owner = owner;
        this.parent = tool instanceof ToolReference ? ((ToolReference)tool).getTool() : tool;
        this.command = tool.getToolCommand();
        this.outputFlag = tool.getOutputFlag();
        this.outputPrefix = tool.getOutputPrefix();
        String[] extensions = tool.getOutputsAttribute();
        this.outputExtensions = new String();
        if (extensions != null) {
            int index = 0;
            while (index < extensions.length) {
                if (extensions[index] != null) {
                    this.outputExtensions = String.valueOf(this.outputExtensions) + extensions[index];
                    if (index < extensions.length - 1) {
                        this.outputExtensions = String.valueOf(this.outputExtensions) + DEFAULT_SEPARATOR;
                    }
                }
                ++index;
            }
        }
        if (tool instanceof ToolReference) {
            List<OptionReference> parentRefs = ((ToolReference)tool).getOptionReferenceList();
            for (OptionReference parent : parentRefs) {
                OptionReference clone = this.createOptionReference(parent);
                try {
                    switch (parent.getValueType()) {
                        case 0: {
                            clone.setValue(parent.getBooleanValue());
                            break;
                        }
                        case 2: {
                            clone.setValue(parent.getStringValue());
                        }
                        case 1: {
                            clone.setValue(parent.getSelectedEnum());
                            break;
                        }
                        default: {
                            clone.setValue(parent.getStringListValue());
                            break;
                        }
                    }
                }
                catch (BuildException buildException) {}
            }
        }
        if (owner instanceof ConfigurationV2) {
            ((ConfigurationV2)owner).addToolReference(this);
        } else if (owner instanceof Target) {
            ((Target)owner).addToolReference(this);
        }
    }

    @Override
    public boolean references(ITool target) {
        if (this.equals(target)) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        if (this.parent instanceof IToolReference) {
            return ((IToolReference)this.parent).references(target);
        }
        if (target instanceof IToolReference) {
            return this.parent.equals(((IToolReference)target).getTool());
        }
        return this.parent.equals(target);
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            IManagedConfigElement element = ManagedBuildManager.getConfigElement(this);
            if (this.owner instanceof ConfigurationV2) {
                Target target = (Target)((ConfigurationV2)this.owner).getTarget();
                this.parent = target.getTool(element.getAttribute("id"));
            } else if (this.owner instanceof Target) {
                this.parent = ((Target)this.owner).getTool(element.getAttribute("id"));
            }
            if (this.parent instanceof Tool) {
                ((Tool)this.parent).resolveReferences();
            } else if (this.parent instanceof ToolReference) {
                ((ToolReference)this.parent).resolveReferences();
            }
            List<OptionReference> optionReferenceList = this.getOptionReferenceList();
            for (OptionReference optRef : optionReferenceList) {
                optRef.resolveReferences();
            }
        }
    }

    public void addOptionReference(OptionReference optionRef) {
        this.getOptionReferenceList().add(optionRef);
        this.isDirty = true;
    }

    @Override
    public boolean buildsFileType(String extension) {
        if (this.parent == null) {
            return false;
        }
        return this.parent.buildsFileType(extension);
    }

    @Override
    public boolean isInputFileType(String extension) {
        if (this.parent == null) {
            return false;
        }
        return this.parent.isInputFileType(extension);
    }

    @Override
    public OptionReference createOptionReference(IOption option) {
        OptionReference ref = this.getOptionReference(option);
        if (ref == null || !ref.getToolReference().owner.equals(this.owner)) {
            ref = new OptionReference(this, option);
        }
        return ref;
    }

    protected List<OptionReference> getAllOptionRefs() {
        if (this.owner instanceof ConfigurationV2) {
            return ((ConfigurationV2)this.owner).getOptionReferences(this.parent);
        }
        if (this.owner instanceof Target) {
            return ((Target)this.owner).getOptionReferences(this.parent);
        }
        return null;
    }

    @Override
    public String getId() {
        if (this.parent == null) {
            return new String();
        }
        return this.parent.getId();
    }

    @Override
    public String getBaseId() {
        if (this.parent == null) {
            return new String();
        }
        return this.parent.getBaseId();
    }

    @Override
    public List<String> getInputExtensions() {
        String[] exts = this.getPrimaryInputExtensions();
        ArrayList<String> extList = new ArrayList<String>();
        int i = 0;
        while (i < exts.length) {
            extList.add(exts[i]);
            ++i;
        }
        return extList;
    }

    @Override
    public String getName() {
        if (this.parent == null) {
            return new String();
        }
        return this.parent.getName();
    }

    @Override
    public int getNatureFilter() {
        if (this.parent == null) {
            return 2;
        }
        return this.parent.getNatureFilter();
    }

    @Override
    public IOption getOption(String id) {
        return this.getOptionById(id);
    }

    @Override
    public IOption getOptionById(String id) {
        IOption[] options = this.getOptions();
        int i = 0;
        while (i < options.length) {
            IOption current = options[i];
            if (current.getId().equals(id)) {
                return current;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean producesFileType(String outputExtension) {
        if (!this.getOutputsList().contains(outputExtension)) {
            return this.parent.producesFileType(outputExtension);
        }
        return true;
    }

    private List<String> getOutputsList() {
        ArrayList<String> answer = new ArrayList<String>();
        if (this.outputExtensions != null) {
            String[] exts = this.outputExtensions.split(DEFAULT_SEPARATOR);
            answer.addAll(Arrays.asList(exts));
        }
        return answer;
    }

    @Override
    public ITool getTool() {
        return this.parent;
    }

    @Override
    public String getToolCommand() {
        if (this.command == null) {
            if (this.parent != null) {
                return this.parent.getToolCommand();
            }
            return new String();
        }
        return this.command;
    }

    @Override
    public String getToolFlags() throws BuildException {
        StringBuffer buf = new StringBuffer();
        IOption[] opts = this.getOptions();
        int index = 0;
        while (index < opts.length) {
            IOption option = opts[index];
            IOptionApplicability applicabilityCalculator = option.getApplicabilityCalculator();
            boolean optionIsApplicable = true;
            if (applicabilityCalculator != null) {
                ITool tool = this.getTool();
                IBuildObject config = tool.getParent() instanceof IResourceConfiguration ? tool.getParent() : ((IToolChain)tool.getParent()).getParent();
                optionIsApplicable = applicabilityCalculator.isOptionUsedInCommandLine(config, tool, option);
            }
            if (optionIsApplicable) {
                switch (option.getValueType()) {
                    case 0: {
                        String boolCmd = option.getBooleanValue() ? option.getCommand() : option.getCommandFalse();
                        if (boolCmd == null || boolCmd.length() <= 0) break;
                        buf.append(String.valueOf(boolCmd) + " ");
                        break;
                    }
                    case 1: {
                        String enumVal = option.getEnumCommand(option.getSelectedEnum());
                        if (enumVal.length() <= 0) break;
                        buf.append(String.valueOf(enumVal) + " ");
                        break;
                    }
                    case 2: {
                        String strCmd = option.getCommand();
                        String val = option.getStringValue();
                        if (val.length() <= 0) break;
                        if (strCmd != null) {
                            buf.append(strCmd);
                        }
                        buf.append(String.valueOf(val) + " ");
                        break;
                    }
                    case 3: {
                        String cmd = option.getCommand();
                        String[] list = option.getStringListValue();
                        int j = 0;
                        while (j < list.length) {
                            String temp = list[j];
                            if (cmd != null) {
                                buf.append(cmd);
                            }
                            buf.append(String.valueOf(temp) + " ");
                            ++j;
                        }
                        break;
                    }
                    case 4: {
                        String incCmd = option.getCommand();
                        String[] paths = option.getIncludePaths();
                        int j = 0;
                        while (j < paths.length) {
                            String temp = paths[j];
                            buf.append(String.valueOf(incCmd) + temp + " ");
                            ++j;
                        }
                        break;
                    }
                    case 5: {
                        String defCmd = option.getCommand();
                        String[] symbols = option.getDefinedSymbols();
                        int j = 0;
                        while (j < symbols.length) {
                            String temp = symbols[j];
                            buf.append(String.valueOf(defCmd) + temp + " ");
                            ++j;
                        }
                        break;
                    }
                }
            }
            ++index;
        }
        return buf.toString().trim();
    }

    @Override
    public IOptionCategory getTopOptionCategory() {
        try {
            return this.parent.getTopOptionCategory();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private OptionReference getOptionReference(IOption option) {
        List<OptionReference> allOptionRefs = this.getAllOptionRefs();
        for (OptionReference optionRef : allOptionRefs) {
            if (!optionRef.references(option)) continue;
            return optionRef;
        }
        return null;
    }

    @Override
    public List<OptionReference> getOptionReferenceList() {
        if (this.optionReferences == null) {
            this.optionReferences = new ArrayList<OptionReference>();
        }
        return this.optionReferences;
    }

    @Override
    public IOption[] getOptions() {
        IOption[] options = this.parent.getOptions();
        int i = 0;
        while (i < options.length) {
            OptionReference ref = this.getOptionReference(options[i]);
            if (ref != null) {
                options[i] = ref;
            }
            ++i;
        }
        return options;
    }

    @Override
    public String[] getOutputExtensions() {
        if (this.outputExtensions == null) {
            if (this.parent != null) {
                return this.parent.getOutputsAttribute();
            }
            return new String[0];
        }
        return this.outputExtensions.split(DEFAULT_SEPARATOR);
    }

    @Override
    public String getOutputExtension(String inputExtension) {
        if (this.parent == null) {
            return new String();
        }
        return this.parent.getOutputExtension(inputExtension);
    }

    @Override
    public String getOutputFlag() {
        if (this.outputFlag == null) {
            if (this.parent != null) {
                return this.parent.getOutputFlag();
            }
            return new String();
        }
        return this.outputFlag;
    }

    @Override
    public String getOutputPrefix() {
        if (this.outputPrefix == null) {
            if (this.parent != null) {
                return this.parent.getOutputPrefix();
            }
            return new String();
        }
        return this.outputPrefix;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public boolean isHeaderFile(String ext) {
        if (this.parent == null) {
            return false;
        }
        return this.parent.isHeaderFile(ext);
    }

    public boolean ownedByConfiguration(IConfigurationV2 config) {
        if (this.owner instanceof ConfigurationV2) {
            return ((IConfigurationV2)this.owner).equals(config);
        }
        return false;
    }

    public void serialize(Document doc, Element element) {
        if (this.parent == null) {
            return;
        }
        element.setAttribute("id", this.parent.getId());
        if (this.command != null) {
            element.setAttribute("command", this.getToolCommand());
        }
        if (this.outputPrefix != null) {
            element.setAttribute("outputPrefix", this.getOutputPrefix());
        }
        if (this.outputFlag != null) {
            element.setAttribute("outputFlag", this.getOutputFlag());
        }
        if (this.outputExtensions != null) {
            element.setAttribute("outputs", this.outputExtensions);
        }
        List<OptionReference> optionReferenceList = this.getOptionReferenceList();
        for (OptionReference optionRef : optionReferenceList) {
            Element optionRefElement = doc.createElement("optionReference");
            element.appendChild(optionRefElement);
            optionRef.serialize(doc, optionRefElement);
        }
        this.isDirty = false;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    @Override
    public boolean setToolCommand(String cmd) {
        if (cmd != null && !cmd.equals(this.command)) {
            this.command = cmd;
            this.isDirty = true;
            return true;
        }
        return false;
    }

    @Override
    public void setOutputFlag(String flag) {
        if (flag == null) {
            return;
        }
        if (this.outputFlag == null || !flag.equals(this.outputFlag)) {
            this.outputFlag = flag;
            this.isDirty = true;
        }
    }

    @Override
    public void setOutputPrefix(String prefix) {
        if (prefix == null) {
            return;
        }
        if (this.outputPrefix == null || !prefix.equals(this.outputPrefix)) {
            this.outputPrefix = prefix;
            this.isDirty = true;
        }
    }

    public void setOutputExtensions(String ext) {
        if (ext == null) {
            return;
        }
        if (this.outputExtensions == null || !ext.equals(this.outputExtensions)) {
            this.outputExtensions = ext;
            this.isDirty = true;
        }
    }

    public void setToolParent(IBuildObject newParent) {
        if (this.parent == null) {
            return;
        }
        ((Tool)this.parent).setToolParent(newParent);
    }

    @Override
    public IBuildObject getParent() {
        return this.owner;
    }

    @Override
    public String getCommandLinePattern() {
        if (this.parent == null) {
            return new String();
        }
        return this.parent.getCommandLinePattern();
    }

    @Override
    public IManagedCommandLineGenerator getCommandLineGenerator() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getCommandLineGenerator();
    }

    @Override
    public IManagedDependencyGenerator getDependencyGenerator() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getDependencyGenerator();
    }

    @Override
    public String[] getCommandFlags() throws BuildException {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getToolCommandFlags(null, null);
    }

    @Override
    public String[] getToolCommandFlags(IPath inputFileLocation, IPath outputFileLocation) throws BuildException {
        return this.getCommandFlags();
    }

    @Override
    public String getToolCommandFlagsString(IPath inputFileLocation, IPath outputFileLocation) throws BuildException {
        return this.getToolFlags();
    }

    public String toString() {
        String answer = new String();
        if (this.parent != null) {
            answer = String.valueOf(answer) + "Reference to " + this.parent.getName();
        }
        if (answer.length() > 0) {
            return answer;
        }
        return super.toString();
    }

    @Override
    public ITool getSuperClass() {
        return null;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public String getUnusedChildren() {
        return null;
    }

    @Override
    public String[] getErrorParserList() {
        return null;
    }

    @Override
    public String getErrorParserIds() {
        return null;
    }

    @Override
    public void setErrorParserIds(String ids) {
    }

    @Override
    public List<String> getInterfaceExtensions() {
        return null;
    }

    @Override
    public boolean isExtensionElement() {
        return false;
    }

    @Override
    public IOption createOption(IOption superClass, String Id, String name, boolean b) {
        return null;
    }

    @Override
    public void createOptions(IHoldsOptions options) {
    }

    @Override
    public void removeOption(IOption o) {
    }

    @Override
    public IOptionCategory[] getChildCategories() {
        return null;
    }

    @Override
    public void setIsAbstract(boolean b) {
    }

    @Override
    public void setCommandLinePattern(String pattern) {
    }

    public void setCommandLineGeneratorElement(IConfigurationElement element) {
    }

    public IConfigurationElement getDependencyGeneratorElement() {
        return null;
    }

    public void setDependencyGeneratorElement(IConfigurationElement element) {
    }

    public IConfigurationElement getCommandLineGeneratorElement() {
        return null;
    }

    @Override
    public boolean getAdvancedInputCategory() {
        return false;
    }

    @Override
    public void setAdvancedInputCategory(boolean display) {
    }

    @Override
    public IInputType createInputType(IInputType superClass, String Id, String name, boolean isExtensionElement) {
        return null;
    }

    @Override
    public IOutputType createOutputType(IOutputType superClass, String Id, String name, boolean isExtensionElement) {
        return null;
    }

    @Override
    public String getAnnouncement() {
        return null;
    }

    @Override
    public IInputType getInputTypeById(String id) {
        return null;
    }

    @Override
    public IInputType[] getInputTypes() {
        return null;
    }

    @Override
    public IOutputType getOutputTypeById(String id) {
        return null;
    }

    @Override
    public IOutputType[] getOutputTypes() {
        return null;
    }

    @Override
    public void removeInputType(IInputType type) {
    }

    @Override
    public void removeOutputType(IOutputType type) {
    }

    @Override
    public void setAnnouncement(String announcement) {
    }

    @Override
    public String getDefaultInputExtension() {
        return null;
    }

    @Override
    public String[] getAllInputExtensions() {
        return null;
    }

    @Override
    public String[] getPrimaryInputExtensions() {
        return null;
    }

    @Override
    public IInputType getInputType(String inputExtension) {
        return null;
    }

    @Override
    public String[] getOutputsAttribute() {
        return null;
    }

    @Override
    public IOutputType getOutputType(String outputExtension) {
        return null;
    }

    @Override
    public void setOutputsAttribute(String extensions) {
    }

    @Override
    public String[] getAllOutputExtensions() {
        return null;
    }

    @Override
    public String[] getAllDependencyExtensions() {
        return null;
    }

    @Override
    public IInputType getPrimaryInputType() {
        return null;
    }

    @Override
    public IOutputType getPrimaryOutputType() {
        return null;
    }

    @Override
    public IPath[] getAdditionalDependencies() {
        return null;
    }

    @Override
    public IPath[] getAdditionalResources() {
        return null;
    }

    public IConfigurationElement getDependencyGeneratorElementForExtension(String sourceExt) {
        return null;
    }

    @Override
    public IManagedDependencyGeneratorType getDependencyGeneratorForExtension(String sourceExt) {
        return null;
    }

    @Override
    public boolean getCustomBuildStep() {
        return false;
    }

    @Override
    public void setCustomBuildStep(boolean customBuildStep) {
    }

    @Override
    public IOption getOptionBySuperClassId(String id) {
        return null;
    }

    @Override
    public IOptionCategory getOptionCategory(String id) {
        return null;
    }

    @Override
    public void addOptionCategory(IOptionCategory category) {
    }

    @Override
    public String getRawOutputExtensions() {
        return this.outputExtensions;
    }

    @Override
    public String getRawOutputFlag() {
        return this.outputFlag;
    }

    @Override
    public String getRawOutputPrefix() {
        return this.outputPrefix;
    }

    @Override
    public String getRawToolCommand() {
        return this.command;
    }

    @Override
    public String getConvertToId() {
        if (this.convertToId == null) {
            if (this.parent != null) {
                return this.parent.getConvertToId();
            }
            return new String();
        }
        return this.convertToId;
    }

    @Override
    public void setConvertToId(String convertToId) {
        if (convertToId == null && this.convertToId == null) {
            return;
        }
        if (convertToId == null || this.convertToId == null || !convertToId.equals(this.convertToId)) {
            this.convertToId = convertToId;
            this.setDirty(true);
        }
    }

    @Override
    public String getVersionsSupported() {
        if (this.versionsSupported == null) {
            if (this.parent != null) {
                return this.parent.getVersionsSupported();
            }
            return new String();
        }
        return this.versionsSupported;
    }

    @Override
    public void setVersionsSupported(String versionsSupported) {
        if (versionsSupported == null && this.versionsSupported == null) {
            return;
        }
        if (versionsSupported == null || this.versionsSupported == null || !versionsSupported.equals(this.versionsSupported)) {
            this.versionsSupported = versionsSupported;
            this.setDirty(true);
        }
    }

    @Override
    public IEnvVarBuildPath[] getEnvVarBuildPaths() {
        return null;
    }

    @Override
    public Version getVersion() {
        return null;
    }

    @Override
    public void setVersion(Version version) {
    }

    @Override
    public String getManagedBuildRevision() {
        return null;
    }

    @Override
    public IOption getOptionToSet(IOption option, boolean adjustExtension) {
        return null;
    }

    @Override
    public boolean needsRebuild() {
        return false;
    }

    @Override
    public void setRebuildState(boolean rebuild) {
    }

    @Override
    public IOptionPathConverter getOptionPathConverter() {
        if (this.parent != null) {
            return this.parent.getOptionPathConverter();
        }
        return null;
    }

    @Override
    public CLanguageData getCLanguageData(IInputType type) {
        return null;
    }

    @Override
    public CLanguageData[] getCLanguageDatas() {
        return new CLanguageData[0];
    }

    @Override
    public IInputType getInputTypeForCLanguageData(CLanguageData data) {
        return null;
    }

    @Override
    public IResourceInfo getParentResourceInfo() {
        return null;
    }

    @Override
    public IInputType getEditableInputType(IInputType base) {
        return null;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public boolean isReal() {
        return false;
    }

    public boolean supportsManagedBuild() {
        return true;
    }

    @Override
    public boolean supportsBuild(boolean managed) {
        return true;
    }

    @Override
    public boolean matches(ITool tool) {
        return false;
    }

    @Override
    public boolean isSystemObject() {
        return false;
    }

    @Override
    public String getUniqueRealName() {
        return this.getName();
    }

    @Override
    public IOutputType getEditableOutputType(IOutputType base) {
        return null;
    }

    @Override
    public void setOutputPrefixForPrimaryOutput(String prefix) {
        this.setOutputPrefix(prefix);
    }
}

