/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectTypeBasedStorage<T>
implements Cloneable {
    private static final int TOOL_INDEX = 0;
    private static final int TOOLCHAIN_INDEX = 1;
    private static final int BUILDER_INDEX = 2;
    private static final int CFG_INDEX = 3;
    private static final int SIZE = 4;
    private static final int[] OBJECT_TYPES = new int[]{2, 1, 4, 32};
    private T[] fStorage = new Object[4];

    public static int[] getSupportedObjectTypes() {
        return (int[])OBJECT_TYPES.clone();
    }

    private int getIndex(int type) {
        switch (type) {
            case 2: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 32: {
                return 3;
            }
        }
        throw new IllegalArgumentException();
    }

    public T get(int type) {
        return this.fStorage[this.getIndex(type)];
    }

    public T set(int type, T value) {
        int index = this.getIndex(type);
        T oldValue = this.fStorage[index];
        this.fStorage[index] = value;
        return oldValue;
    }

    public Object clone() {
        try {
            ObjectTypeBasedStorage clone = (ObjectTypeBasedStorage)super.clone();
            clone.fStorage = (Object[])this.fStorage.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isEmpty() {
        int i = 0;
        while (i < this.fStorage.length) {
            if (this.fStorage[i] != null) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

