/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.cdt.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

public class EvaluationContextManager
implements IWindowListener,
IPageListener,
ISelectionListener,
IPartListener2 {
    private static final String DEBUGGER_ACTIVE = "org.eclipse.cdt.debug.ui.debuggerActive";
    protected static EvaluationContextManager fgManager;
    private Map<IWorkbenchPage, TCFNode> fContextsByPage = null;

    protected EvaluationContextManager() {
    }

    public static void startup() {
        WorkbenchJob job = new WorkbenchJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (fgManager == null) {
                    fgManager = new EvaluationContextManager();
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        fgManager.windowOpened(windows[i]);
                        ++i;
                    }
                    workbench.addWindowListener((IWindowListener)fgManager);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setSystem(true);
        job.schedule();
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.windowOpened(window);
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.removePageListener((IPageListener)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        IWorkbenchPage[] pages = window.getPages();
        int i = 0;
        while (i < pages.length) {
            window.addPageListener((IPageListener)this);
            this.pageOpened(pages[i]);
            ++i;
        }
    }

    public void pageActivated(IWorkbenchPage page) {
        this.pageOpened(page);
    }

    public void pageClosed(IWorkbenchPage page) {
        page.removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        page.removePartListener((IPartListener2)this);
    }

    public void pageOpened(IWorkbenchPage page) {
        page.addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        page.addPartListener((IPartListener2)this);
        IWorkbenchPartReference ref = page.getActivePartReference();
        if (ref != null) {
            this.partActivated(ref);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object element;
        IStructuredSelection ss;
        IWorkbenchPage page = part.getSite().getPage();
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && ((element = ss.getFirstElement()) instanceof TCFNodeExecContext || element instanceof TCFNodeStackFrame)) {
            this.setContext(page, (TCFNode)element);
            return;
        }
        this.removeContext(page);
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        if ("org.eclipse.debug.ui.DebugView".equals(partRef.getId())) {
            this.removeContext(partRef.getPage());
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    private void setContext(IWorkbenchPage page, TCFNode target) {
        if (this.fContextsByPage == null) {
            this.fContextsByPage = new HashMap<IWorkbenchPage, TCFNode>();
        }
        this.fContextsByPage.put(page, target);
        System.setProperty(DEBUGGER_ACTIVE, Boolean.TRUE.toString());
    }

    private void removeContext(IWorkbenchPage page) {
        if (this.fContextsByPage != null) {
            this.fContextsByPage.remove(page);
            if (this.fContextsByPage.isEmpty()) {
                System.setProperty(DEBUGGER_ACTIVE, Boolean.FALSE.toString());
                this.fContextsByPage = null;
            }
        }
    }
}

