/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.util.LinkedList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildren;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFRunnable;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.util.TCFDataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TCFNode
extends PlatformObject
implements Comparable<TCFNode> {
    protected final String id;
    protected final TCFNode parent;
    protected final TCFModel model;
    protected final IChannel channel;
    private boolean disposed;
    private LinkedList<TCFDataCache<?>> caches;

    protected TCFNode(TCFModel model) {
        this.id = null;
        this.parent = null;
        this.channel = model.getChannel();
        this.model = model;
    }

    protected TCFNode(TCFNode parent, String id) {
        assert (Protocol.isDispatchThread());
        assert (parent != null);
        assert (id != null);
        assert (!parent.disposed);
        this.parent = parent;
        this.id = id;
        this.model = parent.model;
        this.model.addNode(id, this);
        this.channel = this.model.getChannel();
    }

    final void addDataCache(TCFDataCache<?> c) {
        if (this.caches == null) {
            this.caches = new LinkedList();
        }
        this.caches.add(c);
    }

    final void removeDataCache(TCFDataCache<?> c) {
        if (this.caches != null) {
            this.caches.remove(c);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    void dispose() {
        if (TCFNode.$assertionsDisabled || !this.disposed) ** GOTO lbl4
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            this.caches.getLast().dispose();
lbl4:
            // 2 sources

            ** while (this.caches != null && this.caches.size() > 0)
        }
lbl5:
        // 1 sources

        if (this.parent != null && this.parent.caches != null) {
            for (TCFDataCache c : this.parent.caches) {
                if (!(c instanceof TCFChildren)) continue;
                ((TCFChildren)c).onNodeDisposed(this.id);
            }
        }
        if (this.id != null) {
            if (!TCFNode.$assertionsDisabled && this.model.getNode(this.id) != this) {
                throw new AssertionError();
            }
            this.model.removeNode(this.id);
        }
        this.disposed = true;
    }

    public final boolean isDisposed() {
        return this.disposed;
    }

    public TCFModel getModel() {
        return this.model;
    }

    public IChannel getChannel() {
        return this.channel;
    }

    public String getID() {
        return this.id;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this.model)) {
            return this.model;
        }
        Object o = this.model.getAdapter(adapter, this);
        if (o != null) {
            return o;
        }
        return Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
    }

    public final TCFNode getParent() {
        assert (Protocol.isDispatchThread());
        return this.parent;
    }

    public TCFNode getParent(IPresentationContext ctx) {
        assert (Protocol.isDispatchThread());
        return this.parent;
    }

    final void update(final IChildrenCountUpdate update) {
        new TCFRunnable((IRequest)update){

            public void run() {
                if (!this.done) {
                    if (!update.isCanceled()) {
                        if (!TCFNode.this.disposed && TCFNode.this.channel.getState() == 1) {
                            if (!TCFNode.this.getData(update, (Runnable)this)) {
                                return;
                            }
                        } else {
                            update.setChildCount(0);
                        }
                        update.setStatus(Status.OK_STATUS);
                    }
                    this.done();
                }
            }
        };
    }

    final void update(final IChildrenUpdate update) {
        new TCFRunnable((IRequest)update){

            public void run() {
                if (!this.done) {
                    if (!update.isCanceled()) {
                        if (!TCFNode.this.disposed && TCFNode.this.channel.getState() == 1 && !TCFNode.this.getData(update, (Runnable)this)) {
                            return;
                        }
                        update.setStatus(Status.OK_STATUS);
                    }
                    this.done();
                }
            }
        };
    }

    final void update(final IHasChildrenUpdate update) {
        new TCFRunnable((IRequest)update){

            public void run() {
                if (!this.done) {
                    if (!update.isCanceled()) {
                        IChannel channel = TCFNode.this.model.getLaunch().getChannel();
                        if (!TCFNode.this.disposed && channel.getState() == 1) {
                            if (!TCFNode.this.getData(update, (Runnable)this)) {
                                return;
                            }
                        } else {
                            update.setHasChilren(false);
                        }
                        update.setStatus(Status.OK_STATUS);
                    }
                    this.done();
                }
            }
        };
    }

    final void update(final ILabelUpdate update) {
        new TCFRunnable((IRequest)update){

            public void run() {
                if (!this.done) {
                    if (!update.isCanceled()) {
                        if (!TCFNode.this.disposed && TCFNode.this.channel.getState() == 1) {
                            if (!TCFNode.this.getData(update, (Runnable)this)) {
                                return;
                            }
                        } else {
                            update.setLabel("...", 0);
                        }
                        update.setStatus(Status.OK_STATUS);
                    }
                    this.done();
                }
            }
        };
    }

    final void update(final IViewerInputUpdate update) {
        new TCFRunnable((IRequest)update){

            public void run() {
                if (!this.done) {
                    if (!update.isCanceled()) {
                        if (!TCFNode.this.disposed && TCFNode.this.channel.getState() == 1) {
                            if (!TCFNode.this.getData(update, (Runnable)this)) {
                                return;
                            }
                        } else {
                            update.setInputElement(update.getElement());
                        }
                        update.setStatus(Status.OK_STATUS);
                    }
                    this.done();
                }
            }
        };
    }

    protected boolean getData(IChildrenCountUpdate update, Runnable done) {
        update.setChildCount(0);
        return true;
    }

    protected boolean getData(IChildrenUpdate update, Runnable done) {
        return true;
    }

    protected boolean getData(IHasChildrenUpdate update, Runnable done) {
        update.setHasChilren(false);
        return true;
    }

    protected boolean getData(ILabelUpdate update, Runnable done) {
        update.setLabel(this.id, 0);
        return true;
    }

    protected boolean getData(IViewerInputUpdate update, Runnable done) {
        update.setInputElement(update.getElement());
        return true;
    }

    @Override
    public int compareTo(TCFNode n) {
        return this.id.compareTo(n.id);
    }

    public String toString() {
        String s = "[" + Integer.toHexString(this.hashCode()) + "] " + this.id;
        if (this.disposed) {
            s = String.valueOf(s) + ", disposed";
        }
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class TCFData<V>
    extends TCFDataCache<V> {
        TCFData(IChannel channel) {
            super(channel);
            TCFNode.this.addDataCache(this);
        }

        public void dispose() {
            TCFNode.this.removeDataCache(this);
            super.dispose();
        }
    }
}

