/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.tcf.ssl;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.security.KeyFactory;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.tm.tcf.Activator;
import org.eclipse.tm.tcf.core.Base64;
import org.eclipse.tm.tcf.protocol.Protocol;

public class TCFSecurityManager {
    public static File getCertificatesDirectory() {
        File certs;
        try {
            certs = Activator.getDefault().getStateLocation().append("certificates").toFile();
        }
        catch (IllegalStateException illegalStateException) {
            certs = new File(System.getProperty("user.home"), ".tcf");
            certs = new File(certs, "certificates");
        }
        if (!certs.exists()) {
            certs.mkdirs();
        }
        return certs;
    }

    public static SSLContext createSSLContext() {
        try {
            final File certs = TCFSecurityManager.getCertificatesDirectory();
            if (!certs.exists()) {
                certs.mkdirs();
            }
            final CertificateFactory cf = CertificateFactory.getInstance("X.509");
            SSLContext context = SSLContext.getInstance("TLS");
            X509ExtendedKeyManager km = new X509ExtendedKeyManager(){

                public X509Certificate[] getCertificateChain(String alias) {
                    File f = new File(certs, "Local.cert");
                    try {
                        BufferedInputStream inp = new BufferedInputStream(new FileInputStream(f));
                        X509Certificate cert = (X509Certificate)cf.generateCertificate(inp);
                        ((InputStream)inp).close();
                        return new X509Certificate[]{cert};
                    }
                    catch (Exception x) {
                        Protocol.log((String)("Cannot read certificate: " + f), (Throwable)x);
                        return null;
                    }
                }

                public PrivateKey getPrivateKey(String alias) {
                    File f = new File(certs, "Local.priv");
                    try {
                        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "ASCII"));
                        StringBuffer bf = new StringBuffer();
                        boolean app = false;
                        while (true) {
                            String s;
                            if ((s = r.readLine()) == null) {
                                new Exception("Invalid format");
                                continue;
                            }
                            if (s.indexOf("-----BEGIN ") == 0) {
                                app = true;
                                continue;
                            }
                            if (s.indexOf("-----END ") == 0) break;
                            if (!app) continue;
                            bf.append(s);
                        }
                        r.close();
                        KeyFactory kf = KeyFactory.getInstance("RSA");
                        byte[] bytes = Base64.toByteArray((char[])bf.toString().toCharArray());
                        return kf.generatePrivate(new PKCS8EncodedKeySpec(bytes));
                    }
                    catch (Exception x) {
                        Protocol.log((String)("Cannot read private key: " + f), (Throwable)x);
                        return null;
                    }
                }

                public String[] getClientAliases(String keyType, Principal[] issuers) {
                    return new String[]{"TCF"};
                }

                public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
                    return "TCF";
                }

                public String[] getServerAliases(String keyType, Principal[] issuers) {
                    return new String[]{"TCF"};
                }

                public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
                    return "TCF";
                }
            };
            X509TrustManager tm = new X509TrustManager(){

                public void checkClientTrusted(X509Certificate[] chain, String auth_type) throws CertificateException {
                    if ("RSA".equals(auth_type) && chain != null && chain.length == 1) {
                        X509Certificate[] x509CertificateArray = this.getAcceptedIssuers();
                        int n = x509CertificateArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            X509Certificate cert = x509CertificateArray[n2];
                            if (cert.equals(chain[0])) {
                                return;
                            }
                            ++n2;
                        }
                    }
                    throw new CertificateException("Client certificate validation failed");
                }

                public void checkServerTrusted(X509Certificate[] chain, String auth_type) throws CertificateException {
                    if ("RSA".equals(auth_type) && chain != null && chain.length == 1) {
                        X509Certificate[] x509CertificateArray = this.getAcceptedIssuers();
                        int n = x509CertificateArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            X509Certificate cert = x509CertificateArray[n2];
                            if (cert.equals(chain[0])) {
                                return;
                            }
                            ++n2;
                        }
                    }
                    throw new CertificateException("Server certificate validation failed");
                }

                public X509Certificate[] getAcceptedIssuers() {
                    ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
                    String[] stringArray = certs.list();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fnm = stringArray[n2];
                        if (fnm.endsWith(".cert")) {
                            try {
                                BufferedInputStream inp = new BufferedInputStream(new FileInputStream(new File(certs, fnm)));
                                X509Certificate cert = (X509Certificate)cf.generateCertificate(inp);
                                ((InputStream)inp).close();
                                list.add(cert);
                            }
                            catch (Throwable x) {
                                Protocol.log((String)("Cannot load certificate: " + fnm), (Throwable)x);
                            }
                        }
                        ++n2;
                    }
                    return list.toArray(new X509Certificate[list.size()]);
                }
            };
            context.init(new KeyManager[]{km}, new TrustManager[]{tm}, null);
            return context;
        }
        catch (Throwable x) {
            Protocol.log((String)"Cannot initialize SSL context", (Throwable)x);
            return null;
        }
    }
}

