/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import org.eclipse.cdt.core.envvar.IEnvironmentContributor;
import org.eclipse.cdt.core.settings.model.ICBuildSetting;
import org.eclipse.cdt.core.settings.model.ICOutputEntry;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescription;
import org.eclipse.cdt.internal.core.settings.model.CDataProxy;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class CBuildSetting
extends CDataProxy
implements ICBuildSetting {
    CBuildSetting(CBuildData data, CConfigurationDescription cfg) {
        super(data, cfg, cfg);
    }

    public IPath getBuilderCWD() {
        CBuildData data = this.getBuildData(false);
        return data.getBuilderCWD();
    }

    private CBuildData getBuildData(boolean write) {
        return (CBuildData)this.getData(write);
    }

    public String[] getErrorParserIDs() {
        CBuildData data = this.getBuildData(false);
        return data.getErrorParserIDs();
    }

    public ICOutputEntry[] getOutputDirectories() {
        CBuildData data = this.getBuildData(false);
        ICOutputEntry[] entries = data.getOutputDirectories();
        IProject project = this.getProject();
        entries = CDataUtil.adjustEntries(entries, true, project);
        return entries;
    }

    public void setBuilderCWD(IPath path) {
        CBuildData data = this.getBuildData(true);
        data.setBuilderCWD(path);
    }

    public void setErrorParserIDs(String[] ids) {
        CBuildData data = this.getBuildData(true);
        data.setErrorParserIDs(ids);
    }

    public void setOutputDirectories(ICOutputEntry[] entries) {
        CBuildData data = this.getBuildData(true);
        IProject project = this.getProject();
        if (entries != null) {
            entries = CDataUtil.adjustEntries(entries, false, project);
        }
        data.setOutputDirectories(entries);
        if (entries == null) {
            CExternalSettingsManager.getInstance().restoreOutputEntryDefaults(this.getConfiguration());
        }
    }

    public final int getType() {
        return 64;
    }

    public IEnvironmentContributor getBuildEnvironmentContributor() {
        CBuildData data = this.getBuildData(false);
        return data.getBuildEnvironmentContributor();
    }

    public ICOutputEntry[] getResolvedOutputDirectories() {
        ICOutputEntry[] entries = this.getOutputDirectories();
        return CDataUtil.resolveEntries(entries, this.getConfiguration());
    }
}

