/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.tcf.extension.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.edc.tcf.extension.services.ILogging;
import org.eclipse.tm.tcf.core.Command;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingProxy
implements ILogging {
    private final IChannel channel;
    private Map<String, List<ILogging.LogListener>> mapIdToListeners;
    private IChannel.IEventListener eventListener;

    public LoggingProxy(IChannel channel) {
        this.channel = channel;
    }

    @Override
    public IToken addListener(final String id, final ILogging.LogListener listener, final ILogging.DoneAddListener done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"addListener", (Object[])new Object[]{id}){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                if (error == null) {
                    LoggingProxy.this.addListener(id, listener);
                }
                done.doneAddListener(this.token, error);
            }
        }.token;
    }

    @Override
    public IToken removeListener(final String id, final ILogging.LogListener listener, final ILogging.DoneRemoveListener done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"removeListener", (Object[])new Object[]{id}){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                if (error == null) {
                    LoggingProxy.this.removeListener(id, listener);
                }
                done.doneRemoveListener(this.token, error);
            }
        }.token;
    }

    private void addListener(String id, ILogging.LogListener listener) {
        List<ILogging.LogListener> listeners;
        if (this.mapIdToListeners == null) {
            this.mapIdToListeners = new HashMap<String, List<ILogging.LogListener>>();
        }
        if ((listeners = this.mapIdToListeners.get(id)) == null) {
            listeners = new ArrayList<ILogging.LogListener>();
            this.mapIdToListeners.put(id, listeners);
        }
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
        if (this.eventListener == null) {
            this.eventListener = new ChannelEventListener();
            this.channel.addEventListener((IService)this, this.eventListener);
        }
    }

    private void removeListener(String id, ILogging.LogListener listener) {
        List<ILogging.LogListener> listeners;
        if (this.mapIdToListeners != null && (listeners = this.mapIdToListeners.get(id)) != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.mapIdToListeners.remove(id);
                if (this.mapIdToListeners.isEmpty()) {
                    this.mapIdToListeners = null;
                }
            }
        }
        if (this.mapIdToListeners == null && this.eventListener != null) {
            this.channel.removeEventListener((IService)this, this.eventListener);
            this.eventListener = null;
        }
    }

    private Collection<ILogging.LogListener> getListeners(String id) {
        List<ILogging.LogListener> listeners;
        if (this.mapIdToListeners != null && (listeners = this.mapIdToListeners.get(id)) != null) {
            return listeners;
        }
        return Collections.emptyList();
    }

    private ILogging.LogListener getFirstListener(String id) {
        List<ILogging.LogListener> listeners;
        if (this.mapIdToListeners != null && (listeners = this.mapIdToListeners.get(id)) != null) {
            return listeners.get(0);
        }
        return null;
    }

    public void write(String id, String msg) {
        for (ILogging.LogListener listener : this.getListeners(id)) {
            listener.write(msg);
        }
    }

    public void writeln(String id, String msg) {
        for (ILogging.LogListener listener : this.getListeners(id)) {
            listener.writeln(msg);
        }
    }

    public void dialog(String id, int severity, String summary, String details) {
        this.getFirstListener(id).dialog(severity, summary, details);
    }

    public String getName() {
        return "Logging";
    }

    private final class ChannelEventListener
    implements IChannel.IEventListener {
        private ChannelEventListener() {
        }

        public void event(String name, byte[] data) {
            block8: {
                try {
                    Object[] args = JSON.parseSequence((byte[])data);
                    if (name.equals("write")) {
                        assert (args.length == 2);
                        LoggingProxy.this.write((String)args[0], (String)args[1]);
                        break block8;
                    }
                    if (name.equals("writeln")) {
                        assert (args.length == 2);
                        LoggingProxy.this.writeln((String)args[0], (String)args[1]);
                        break block8;
                    }
                    if (name.equals("dialog")) {
                        assert (args.length == 4);
                        LoggingProxy.this.dialog((String)args[0], (Integer)args[1], (String)args[2], (String)args[3]);
                        break block8;
                    }
                    throw new IOException("Logging service: unknown event: " + name);
                }
                catch (Throwable x) {
                    LoggingProxy.this.channel.terminate(x);
                }
            }
        }
    }
}

