/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui;

import org.eclipse.cdt.debug.edc.internal.ui.EDCDebugUI;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.SyncVariableDataAccess;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.variables.details.DetailPaneMaxLengthAction;
import org.eclipse.debug.internal.ui.actions.variables.details.DetailPaneWordWrapAction;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.internal.ui.views.variables.details.AbstractDetailPane;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.operations.OperationHistoryActionHandler;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public abstract class AbstractEDCDetailPane
extends AbstractDetailPane
implements IPropertyChangeListener,
IViewerUpdateListener {
    protected static final String COPY_ACTION = ActionFactory.COPY.getId();
    protected static final String CUT_ACTION = ActionFactory.CUT.getId();
    protected static final String PASTE_ACTION = ActionFactory.PASTE.getId();
    protected static final String SELECT_ALL_ACTION = IDebugView.SELECT_ALL_ACTION;
    protected static final String WORD_WRAP_ACTION = "org.eclipse.debug.ui.detail_pane_word_wrap";
    protected static final String SET_VALUE_ACTION = "setValue";
    protected static final String MAX_LENGTH_ACTION = "org.eclipse.debug.ui.max_detail_length";
    protected SourceViewer viewer;
    protected Document document;
    protected IStructuredSelection currentSelection = StructuredSelection.EMPTY;
    private Job displayDetailJob;

    protected abstract Job createDisplayDetailJob(IStructuredSelection var1);

    protected abstract boolean canSetValue(IStructuredSelection var1);

    protected abstract Job createSetValueJob(IStructuredSelection var1, String var2);

    public Control createControl(Composite parent) {
        Control control = this.createViewer(parent);
        if (this.isInView()) {
            this.hookViewer();
            this.createContextMenu();
            this.createActions();
            DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
            JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        }
        return control;
    }

    protected Control createViewer(Composite parent) {
        this.viewer = new SourceViewer(parent, null, 768);
        this.viewer.setDocument(this.getDocument());
        this.viewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.DetailPaneFont"));
        this.viewer.getTextWidget().setWordWrap(this.getWordWrapPreference());
        this.viewer.setEditable(false);
        this.viewer.unconfigure();
        this.viewer.configure(new SourceViewerConfiguration());
        Control control = this.viewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        return control;
    }

    private IDocument getDocument() {
        if (this.document == null) {
            this.document = new Document();
        }
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(IStructuredSelection selection) {
        this.currentSelection = selection;
        if (selection == null || selection.isEmpty()) {
            this.clearSourceViewer();
            return;
        }
        if (this.isInView()) {
            this.viewer.setEditable(this.isEditingEnabled(selection));
        }
        AbstractEDCDetailPane abstractEDCDetailPane = this;
        synchronized (abstractEDCDetailPane) {
            if (this.displayDetailJob != null) {
                this.displayDetailJob.cancel();
            }
            this.displayDetailJob = this.createDisplayDetailJob(selection);
            if (this.displayDetailJob != null) {
                this.displayDetailJob.schedule();
            }
        }
    }

    public void redisplay() {
        IStructuredSelection reset = this.currentSelection;
        this.currentSelection = null;
        this.display(reset);
    }

    private void clearSourceViewer() {
        if (this.displayDetailJob != null) {
            this.displayDetailJob.cancel();
        }
        this.document.set("");
    }

    public boolean setFocus() {
        if (this.viewer != null) {
            this.viewer.getTextWidget().setFocus();
            return true;
        }
        return false;
    }

    protected void hookViewer() {
        Viewer variablesViewer;
        this.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                AbstractEDCDetailPane.this.updateSelectionDependentActions();
            }
        });
        this.viewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractEDCDetailPane.this.updateSelectionDependentActions();
            }
        });
        this.viewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                AbstractEDCDetailPane.this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, AbstractEDCDetailPane.this.getAction(SELECT_ALL_ACTION));
                AbstractEDCDetailPane.this.setGlobalAction(IDebugView.COPY_ACTION, AbstractEDCDetailPane.this.getAction(COPY_ACTION));
                AbstractEDCDetailPane.this.setGlobalAction(IDebugView.CUT_ACTION, AbstractEDCDetailPane.this.getAction(CUT_ACTION));
                AbstractEDCDetailPane.this.setGlobalAction(IDebugView.PASTE_ACTION, AbstractEDCDetailPane.this.getAction(PASTE_ACTION));
                IAction action = AbstractEDCDetailPane.this.getAction(AbstractEDCDetailPane.SET_VALUE_ACTION);
                AbstractEDCDetailPane.this.setGlobalAction(action.getActionDefinitionId(), action);
                AbstractEDCDetailPane.this.getViewSite().getActionBars().updateActionBars();
            }

            public void focusLost(FocusEvent e) {
                AbstractEDCDetailPane.this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, null);
                AbstractEDCDetailPane.this.setGlobalAction(IDebugView.COPY_ACTION, null);
                AbstractEDCDetailPane.this.setGlobalAction(IDebugView.CUT_ACTION, null);
                AbstractEDCDetailPane.this.setGlobalAction(IDebugView.PASTE_ACTION, null);
                AbstractEDCDetailPane.this.setGlobalAction(AbstractEDCDetailPane.this.getAction(AbstractEDCDetailPane.SET_VALUE_ACTION).getActionDefinitionId(), null);
                AbstractEDCDetailPane.this.getViewSite().getActionBars().updateActionBars();
            }
        });
        IWorkbenchPart part = this.getWorkbenchPartSite().getPart();
        if (part instanceof VariablesView && (variablesViewer = ((VariablesView)part).getViewer()) instanceof TreeModelViewer) {
            ((TreeModelViewer)variablesViewer).addViewerUpdateListener((IViewerUpdateListener)this);
        }
    }

    protected void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AbstractEDCDetailPane.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTextWidget());
        this.viewer.getTextWidget().setMenu(menu);
        this.getViewSite().registerContextMenu("org.eclipse.debug.ui.VariableView.detail", menuMgr, this.viewer.getSelectionProvider());
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("variableGroup"));
        menu.add(this.getAction(COPY_ACTION));
        menu.add(this.getAction(CUT_ACTION));
        menu.add(this.getAction(PASTE_ACTION));
        menu.add(this.getAction(SELECT_ALL_ACTION));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(SET_VALUE_ACTION));
        menu.add(this.getAction(WORD_WRAP_ACTION));
        menu.add(this.getAction(MAX_LENGTH_ACTION));
    }

    protected void createActions() {
        TextViewerAction textAction = new TextViewerAction((ITextViewer)this.viewer, 7);
        textAction.setText("Select &All");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.setAction(SELECT_ALL_ACTION, (IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.viewer, 4);
        textAction.setText("&Copy");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.setAction(COPY_ACTION, (IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.viewer, 3);
        textAction.setText("&Cut");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.setAction(CUT_ACTION, (IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.viewer, 5);
        textAction.setText("&Paste");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.setAction(PASTE_ACTION, (IAction)textAction);
        this.setSelectionDependantAction(COPY_ACTION);
        this.setSelectionDependantAction(CUT_ACTION);
        this.updateSelectionDependentActions();
        this.setAction(SET_VALUE_ACTION, (IAction)new SetValueAction());
        this.setAction(WORD_WRAP_ACTION, (IAction)new DetailPaneWordWrapAction((ITextViewer)this.viewer));
        this.setAction(MAX_LENGTH_ACTION, (IAction)new DetailPaneMaxLengthAction(this.viewer.getControl().getShell()));
        this.createUndoRedoActions();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (propertyName.equals("org.eclipse.debug.ui.DetailPaneFont")) {
            this.viewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.DetailPaneFont"));
        } else if (propertyName.equals(WORD_WRAP_ACTION)) {
            this.viewer.getTextWidget().setWordWrap(this.getWordWrapPreference());
            this.getAction(WORD_WRAP_ACTION).setChecked(this.getWordWrapPreference());
        } else if (propertyName.equals(MAX_LENGTH_ACTION)) {
            this.redisplay();
        }
    }

    private boolean getWordWrapPreference() {
        return DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(WORD_WRAP_ACTION);
    }

    protected boolean isEditingEnabled(IStructuredSelection selection) {
        return this.canSetValue(selection);
    }

    public void dispose() {
        if (this.displayDetailJob != null) {
            this.displayDetailJob.cancel();
        }
        if (this.viewer != null && this.viewer.getControl() != null) {
            this.viewer.getControl().dispose();
        }
        if (this.isInView()) {
            IWorkbenchPart part = this.getWorkbenchPartSite().getPart();
            if (part instanceof VariablesView) {
                Viewer viewer = ((VariablesView)part).getViewer();
                if (part instanceof TreeModelViewer) {
                    ((TreeModelViewer)viewer).removeViewerUpdateListener((IViewerUpdateListener)this);
                }
            }
            DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
            JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
            this.disposeUndoRedoAction(ITextEditorActionConstants.UNDO);
            this.disposeUndoRedoAction(ITextEditorActionConstants.REDO);
        }
        super.dispose();
    }

    private void createUndoRedoActions() {
        this.disposeUndoRedoAction(ITextEditorActionConstants.UNDO);
        this.disposeUndoRedoAction(ITextEditorActionConstants.REDO);
        IUndoContext undoContext = this.getUndoContext();
        if (undoContext != null) {
            UndoActionHandler undoAction = new UndoActionHandler((IWorkbenchPartSite)this.getViewSite(), undoContext);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)undoAction, IAbstractTextEditorHelpContextIds.UNDO_ACTION);
            undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
            this.setAction(ITextEditorActionConstants.UNDO, (IAction)undoAction);
            this.setGlobalAction(ITextEditorActionConstants.UNDO, (IAction)undoAction);
            RedoActionHandler redoAction = new RedoActionHandler((IWorkbenchPartSite)this.getViewSite(), undoContext);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)redoAction, IAbstractTextEditorHelpContextIds.REDO_ACTION);
            redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
            this.setAction(ITextEditorActionConstants.REDO, (IAction)redoAction);
            this.setGlobalAction(ITextEditorActionConstants.REDO, (IAction)redoAction);
            this.getViewSite().getActionBars().updateActionBars();
        }
    }

    private IUndoContext getUndoContext() {
        IUndoManager undoManager = this.viewer.getUndoManager();
        if (undoManager instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)undoManager).getUndoContext();
        }
        return null;
    }

    private void disposeUndoRedoAction(String actionId) {
        OperationHistoryActionHandler action = (OperationHistoryActionHandler)this.getAction(actionId);
        if (action != null) {
            action.dispose();
            this.setAction(actionId, null);
        }
    }

    protected static SyncVariableDataAccess createSyncVariableDataAccess(IFormattedValues.IFormattedDataDMContext context) {
        DsfSession session = DsfSession.getSession((String)context.getSessionId());
        return new SyncVariableDataAccess(session);
    }

    public void updateStarted(IViewerUpdate update) {
    }

    public void updateComplete(IViewerUpdate update) {
    }

    public synchronized void viewerUpdatesBegin() {
    }

    public synchronized void viewerUpdatesComplete() {
        this.redisplay();
    }

    public class SetValueAction
    extends Action {
        public SetValueAction() {
            this.setText("Set Value");
        }

        public void run() {
            Point selectedRange = AbstractEDCDetailPane.this.viewer.getSelectedRange();
            String value = null;
            if (selectedRange.y == 0) {
                value = AbstractEDCDetailPane.this.viewer.getDocument().get();
            } else {
                try {
                    value = AbstractEDCDetailPane.this.viewer.getDocument().get(selectedRange.x, selectedRange.y);
                }
                catch (BadLocationException e) {
                    EDCDebugUI.logError(null, e);
                }
            }
            this.setValue(AbstractEDCDetailPane.this.currentSelection, value);
        }

        private void setValue(IStructuredSelection selection, String value) {
            Job setValueJob = AbstractEDCDetailPane.this.createSetValueJob(selection, value);
            if (setValueJob != null) {
                setValueJob.schedule();
            }
        }

        public boolean isEnabled() {
            return AbstractEDCDetailPane.this.isEditingEnabled(AbstractEDCDetailPane.this.currentSelection);
        }

        public String getActionDefinitionId() {
            return "org.eclipse.ui.file.save";
        }
    }
}

