/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui.views;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.edc.internal.ui.EDCDebugUI;
import org.eclipse.cdt.debug.edc.internal.ui.views.ISystemVMContainer;
import org.eclipse.cdt.debug.edc.internal.ui.views.SystemDataModel;
import org.eclipse.cdt.debug.edc.internal.ui.views.SystemRefreshOptionsDialog;
import org.eclipse.cdt.debug.edc.internal.ui.views.SystemVMContainer;
import org.eclipse.cdt.debug.edc.internal.ui.views.SystemViewInput;
import org.eclipse.cdt.debug.edc.internal.ui.views.SystemViewModel;
import org.eclipse.cdt.internal.ui.util.StringMatcher;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SystemView
extends ViewPart {
    public static final String PREF_REFRESH_INTERVAL = "refresh_interval";
    public static final String PREF_SHOULD_AUTO_REFRESH = "should_auto_refresh";
    public static final String PREF_ROOT_VM_PROPERTIES = "root_vm_properties";
    protected static final int DEFAULT_REFRESH_INTERVAL = 30000;
    private PresentationContext presentationContext;
    private boolean autoRefresh = true;
    private int refreshInterval = 30000;
    private IEclipsePreferences prefsNode;
    private RefreshJob refreshjob;
    private Text filterText;
    private StringMatcher filter_matcher = new StringMatcher("*", true, false);
    private Action refreshAction;
    private Action refreshSettingsAction;
    private SystemDataModel dataModel;
    private SystemViewModel viewModel;
    private List<CTabItem> tabs = new ArrayList<CTabItem>();
    private List<TreeModelViewer> viewers = new ArrayList<TreeModelViewer>();
    private Action debugAction;
    private TreeModelViewer selectedViewer;

    protected void createRootComposite(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SystemView.this.getRefreshJob().cancel();
                SystemView.this.selectedViewer = null;
            }
        });
        this.createFilterTextBox(parent);
        CTabFolder tabFolder = new CTabFolder(parent, 2048);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        tabFolder.setLayout((Layout)new FillLayout(768));
        List<SystemVMContainer> vmContainers = this.getViewModel().getRootContainers();
        for (SystemVMContainer systemVMContainer : vmContainers) {
            CTabItem tab = new CTabItem(tabFolder, 0);
            tab.setText(systemVMContainer.getName());
            tab.setImage(systemVMContainer.getImage());
            Composite composite = new Composite((Composite)tabFolder, 0);
            composite.setLayout((Layout)new FillLayout(768));
            tab.setControl((Control)composite);
            this.tabs.add(tab);
            TreeModelViewer viewer = new TreeModelViewer((Composite)tab.getControl(), 0x10010000, (IPresentationContext)this.getPresentationContext());
            viewer.setInput((Object)new SystemViewInput(systemVMContainer));
            this.viewers.add(viewer);
            tab.setData("VIEWER", (Object)viewer);
            TreeColumn[] columns = viewer.getTree().getColumns();
            if (columns.length <= 0) continue;
            String[] columnKeys = (String[])systemVMContainer.getProperties().get("Column_Keys");
            String sortProperty = (String)systemVMContainer.getProperties().get("Sort_Property");
            Integer sortDirection = (Integer)systemVMContainer.getProperties().get("Sort_Direction");
            int i = 0;
            while (i < columns.length) {
                TreeColumn treeColumn = columns[i];
                ColumnSelectionAdapter columnSelectionAdapter = new ColumnSelectionAdapter(systemVMContainer, i, viewer);
                treeColumn.addSelectionListener((SelectionListener)columnSelectionAdapter);
                if (columnKeys[i].equals(sortProperty)) {
                    viewer.getTree().setSortColumn(treeColumn);
                    viewer.getTree().setSortDirection(sortDirection.intValue());
                }
                ++i;
            }
        }
        this.selectedViewer = this.viewers.get(0);
        tabFolder.setSelection(this.tabs.get(0));
        tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SystemView.this.selectedViewer = (TreeModelViewer)e.item.getData("VIEWER");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SystemView.this.selectedViewer = (TreeModelViewer)e.item.getData("VIEWER");
            }
        });
        tabFolder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                List<SystemVMContainer> vmContainers = SystemView.this.getViewModel().getRootContainers();
                for (SystemVMContainer systemVMContainer : vmContainers) {
                    systemVMContainer.setImage(null);
                }
            }
        });
    }

    public void refreshViewModel() {
        this.getViewModel().buildViewModel();
        this.refreshViewers();
    }

    public void setFocus() {
        if (this.selectedViewer != null) {
            this.selectedViewer.getControl().setFocus();
        }
    }

    public List<CTabItem> getTabs() {
        return this.tabs;
    }

    public List<TreeModelViewer> getViewers() {
        return this.viewers;
    }

    public void setPresentationContext(PresentationContext presentationContext) {
        this.presentationContext = presentationContext;
    }

    public PresentationContext getPresentationContext() {
        return this.presentationContext;
    }

    public IStatus refresh(IProgressMonitor monitor, boolean refreshData) {
        if (refreshData) {
            try {
                this.getDataModel().buildDataModel(monitor);
            }
            catch (Exception e) {
                return new Status(2, "org.eclipse.cdt.debug.edc.ui", e.getMessage(), (Throwable)e);
            }
        }
        this.refreshViewModel();
        return Status.OK_STATUS;
    }

    protected void refreshViewers() {
        int i = 0;
        while (i < this.viewers.size()) {
            final TreeModelViewer viewer = this.viewers.get(i);
            final SystemVMContainer input = this.getViewModel().getRootContainers().get(i);
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (viewer.getTree().isDisposed()) {
                        return;
                    }
                    viewer.getTree().setEnabled(false);
                    viewer.setInput((Object)new SystemViewInput(input));
                    viewer.getTree().setEnabled(true);
                }
            });
            ++i;
        }
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public Job getRefreshJob() {
        if (this.refreshjob == null) {
            this.refreshjob = new RefreshJob();
            this.refreshjob.setSystem(true);
        }
        return this.refreshjob;
    }

    protected void createFilterTextBox(Composite parent) {
        this.filterText = new Text(parent, 2048);
        this.filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.filterText.setText("type filter text");
        this.filterText.selectAll();
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemView.this.setFilter(SystemView.this.filterText.getText());
                ((RefreshJob)SystemView.this.getRefreshJob()).setRefreshData(false);
                SystemView.this.getRefreshJob().schedule();
            }
        });
    }

    public void setFilter(String text) {
        this.setFilterMatcher(new StringMatcher("*" + text + "*", true, false));
    }

    public void setFilterMatcher(StringMatcher filter_matcher) {
        this.filter_matcher = filter_matcher;
    }

    public StringMatcher getFilterMatcher() {
        return this.filter_matcher;
    }

    public void createRefreshAction() {
        this.refreshAction = new Action(){

            public void run() {
                SystemView.this.getRefreshJob().cancel();
                SystemView.this.getRefreshJob().schedule();
            }
        };
        this.refreshAction.setId("SYSTEM_REFRESH");
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refreshes system information");
        this.refreshAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.debug.edc.ui", (String)"/icons/etool16/refresh.gif"));
        this.createRefreshSettingsAction();
    }

    public void createRefreshSettingsAction() {
        this.refreshSettingsAction = new Action(){

            public void run() {
                SystemRefreshOptionsDialog dialog = new SystemRefreshOptionsDialog(null);
                dialog.setAutoRefresh(SystemView.this.shouldAutoRefresh());
                dialog.setRefreshInterval(SystemView.this.getRefreshInterval() / 1000);
                int result = dialog.open();
                if (result == 0) {
                    SystemView.this.setAutoRefresh(dialog.isAutoRefresh());
                    SystemView.this.setRefreshInterval(dialog.getRefreshInterval() * 1000);
                    try {
                        SystemView.this.saveSettings();
                    }
                    catch (Exception e) {
                        EDCDebugUI.logError("", e);
                    }
                    if (SystemView.this.shouldAutoRefresh()) {
                        SystemView.this.getRefreshJob().schedule((long)SystemView.this.getRefreshInterval());
                    } else {
                        SystemView.this.getRefreshJob().cancel();
                    }
                }
            }
        };
        this.refreshSettingsAction.setId("SYSTEM_REFRESH_SETTINGS");
        this.refreshSettingsAction.setText("Refresh Options...");
        this.refreshSettingsAction.setToolTipText("Options for refreshing system information");
    }

    public void saveSettings() throws BackingStoreException, IOException {
        this.getPrefsNode().putBoolean(PREF_SHOULD_AUTO_REFRESH, this.shouldAutoRefresh());
        this.getPrefsNode().putInt(PREF_REFRESH_INTERVAL, this.getRefreshInterval());
        ArrayList rootContainerProperties = new ArrayList();
        for (ISystemVMContainer iSystemVMContainer : this.viewModel.getRootContainers()) {
            Map<String, Object> vmProps = iSystemVMContainer.getProperties();
            HashMap<String, Object> props = new HashMap<String, Object>();
            if (vmProps.containsKey("Sort_Property")) {
                props.put("Sort_Property", vmProps.get("Sort_Property"));
            }
            if (vmProps.containsKey("Sort_Direction")) {
                props.put("Sort_Direction", vmProps.get("Sort_Direction"));
            }
            rootContainerProperties.add(props);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(byteArrayOutputStream);
        oos.writeObject(rootContainerProperties);
        byteArrayOutputStream.close();
        this.getPrefsNode().putByteArray(PREF_ROOT_VM_PROPERTIES, byteArrayOutputStream.toByteArray());
        this.getPrefsNode().flush();
    }

    public void loadSettings() {
        this.setAutoRefresh(this.getPrefsNode().getBoolean(PREF_SHOULD_AUTO_REFRESH, this.shouldAutoRefresh()));
        this.setRefreshInterval(this.getPrefsNode().getInt(PREF_REFRESH_INTERVAL, this.getRefreshInterval()));
        byte[] prefData = this.getPrefsNode().getByteArray(PREF_ROOT_VM_PROPERTIES, null);
        if (prefData != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(prefData);
            try {
                ObjectInputStream ois = new ObjectInputStream(bais);
                List rootContainerProperties = (List)ois.readObject();
                int vmIndex = 0;
                for (Map map : rootContainerProperties) {
                    ISystemVMContainer rootVM = this.viewModel.getRootContainers().get(vmIndex++);
                    rootVM.getProperties().putAll(map);
                }
            }
            catch (Exception e) {
                EDCDebugUI.logError("", e);
            }
        }
    }

    public void createDebugAction() {
        this.debugAction = new Action(){

            public void run() {
                try {
                    TreeModelViewer viewer = SystemView.this.getSelectedViewer();
                    if (viewer != null) {
                        SystemVMContainer node = (SystemVMContainer)((IStructuredSelection)viewer.getSelection()).getFirstElement();
                        SystemView.this.doAttach(node);
                    }
                }
                catch (Exception e) {
                    EDCDebugUI.logError("", e);
                }
            }
        };
        this.debugAction.setText("Debug");
        this.debugAction.setToolTipText("Debug the selected process");
    }

    protected void doAttach(SystemVMContainer node) throws Exception {
    }

    protected void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SystemView.this.fillContextMenu(manager);
            }
        });
        List<TreeModelViewer> allViewers = this.getViewers();
        for (TreeModelViewer viewer : allViewers) {
            Menu menu = menuMgr.createContextMenu(viewer.getControl());
            viewer.getControl().setMenu(menu);
            this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
            viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    ISystemVMContainer vmContainer = (ISystemVMContainer)selection.getFirstElement();
                    if (vmContainer != null) {
                        Boolean canDebug = (Boolean)vmContainer.getProperties().get("Can_Debug");
                        SystemView.this.debugAction.setEnabled(canDebug != null && canDebug != false);
                    } else {
                        SystemView.this.debugAction.setEnabled(false);
                    }
                }
            });
        }
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.debugAction);
    }

    protected void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.refreshSettingsAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator());
    }

    public void setDataModel(SystemDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public SystemDataModel getDataModel() {
        return this.dataModel;
    }

    public void setViewModel(SystemViewModel viewModel) {
        this.viewModel = viewModel;
    }

    public SystemViewModel getViewModel() {
        return this.viewModel;
    }

    public TreeModelViewer getSelectedViewer() {
        return this.selectedViewer;
    }

    public void setPrefsNode(IEclipsePreferences prefsNode) {
        this.prefsNode = prefsNode;
    }

    public IEclipsePreferences getPrefsNode() {
        return this.prefsNode;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    public boolean shouldAutoRefresh() {
        return this.autoRefresh;
    }

    class ColumnSelectionAdapter
    extends SelectionAdapter {
        private int selector;
        private TreeModelViewer viewer;
        private ISystemVMContainer systemVMContainer;
        private int currentSortDirection;

        public ColumnSelectionAdapter(ISystemVMContainer systemVMContainer, int selector, TreeModelViewer viewer) {
            this.viewer = viewer;
            this.setSelector(selector);
            this.setSystemVMContainer(systemVMContainer);
            this.currentSortDirection = viewer.getTree().getSortDirection();
        }

        public void widgetSelected(SelectionEvent e) {
            this.viewer.setComparator(new ViewerComparator());
            TreeColumn currentSortColumn = this.viewer.getTree().getSortColumn();
            TreeColumn newSortColumn = (TreeColumn)e.getSource();
            if (newSortColumn.equals(currentSortColumn)) {
                if (this.currentSortDirection == 128) {
                    this.viewer.getTree().setSortDirection(1024);
                } else if (this.currentSortDirection == 1024) {
                    this.viewer.getTree().setSortDirection(128);
                }
                this.currentSortDirection = this.viewer.getTree().getSortDirection();
            } else {
                this.viewer.getTree().setSortColumn((TreeColumn)e.getSource());
            }
            String[] sortProperties = (String[])this.systemVMContainer.getProperties().get("Column_Keys");
            assert (sortProperties != null);
            this.currentSortDirection = this.viewer.getTree().getSortDirection();
            this.systemVMContainer.getProperties().put("Sort_Property", sortProperties[this.getSelector()]);
            this.systemVMContainer.getProperties().put("Sort_Direction", this.currentSortDirection);
            SystemView.this.refreshViewModel();
            try {
                SystemView.this.saveSettings();
            }
            catch (Exception e1) {
                EDCDebugUI.logError("", e1);
            }
        }

        public void setSelector(int selector) {
            this.selector = selector;
        }

        public int getSelector() {
            return this.selector;
        }

        public void setSystemVMContainer(ISystemVMContainer systemVMContainer) {
            this.systemVMContainer = systemVMContainer;
        }

        public ISystemVMContainer getSystemVMContainer() {
            return this.systemVMContainer;
        }
    }

    private class RefreshJob
    extends Job {
        private boolean refreshData;

        public RefreshJob() {
            super("Refresh " + SystemView.this.getTitle());
            this.refreshData = true;
        }

        protected IStatus run(IProgressMonitor monitor) {
            final Boolean[] shouldRefresh = new Boolean[]{SystemView.this.selectedViewer != null};
            if (shouldRefresh[0].booleanValue()) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        if (SystemView.this.selectedViewer != null) {
                            shouldRefresh[0] = SystemView.this.selectedViewer.getTree().isVisible();
                        }
                    }
                });
            }
            IStatus result = Status.OK_STATUS;
            if (shouldRefresh[0].booleanValue()) {
                result = SystemView.this.refresh(monitor, this.shouldRefreshData());
            }
            this.setRefreshData(true);
            if (SystemView.this.shouldAutoRefresh() && SystemView.this.selectedViewer != null) {
                this.schedule(SystemView.this.refreshInterval);
            }
            return result;
        }

        public boolean shouldRefreshData() {
            return this.refreshData;
        }

        public void setRefreshData(boolean refreshData) {
            this.refreshData = refreshData;
        }
    }
}

