/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.windows.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.TCFServiceManager;
import org.eclipse.cdt.debug.edc.internal.ui.views.SystemDMContainer;
import org.eclipse.cdt.debug.edc.internal.ui.views.SystemDataModel;
import org.eclipse.cdt.debug.edc.internal.ui.views.SystemVMContainer;
import org.eclipse.cdt.debug.edc.internal.ui.views.SystemView;
import org.eclipse.cdt.debug.edc.internal.ui.views.SystemViewModel;
import org.eclipse.cdt.debug.edc.internal.ui.views.TCFDataModel;
import org.eclipse.cdt.debug.edc.internal.windows.ui.WindowsDebuggerUI;
import org.eclipse.cdt.debug.edc.windows.IWindowsOSData;
import org.eclipse.cdt.internal.ui.util.StringMatcher;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IProcesses;

public class WindowsSystemView
extends SystemView {
    public static final String VIEW_ID = "org.eclipse.cdt.debug.edc.windows.system";

    public void createPartControl(Composite parent) {
        this.setPresentationContext(new PresentationContext(VIEW_ID));
        this.setPrefsNode(InstanceScope.INSTANCE.getNode("org.eclipse.cdt.debug.edc.windows.ui"));
        this.setDataModel((SystemDataModel)new WindowsDataModel());
        this.setViewModel(new WindowsViewModel());
        this.getViewModel().buildViewModel();
        this.loadSettings();
        this.createRootComposite(parent);
        this.createRefreshAction();
        this.createDebugAction();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.getRefreshJob().schedule();
    }

    protected void doAttach(SystemVMContainer target) {
        Map targetProps = target.getDMContainer().getProperties();
        int pid = Integer.parseInt((String)targetProps.get("OSID"));
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchType = lm.getLaunchConfigurationType("org.eclipse.cdt.launch.attachLaunchType");
        if (launchType != null) {
            String lcName = lm.generateLaunchConfigurationName(target.getName());
            try {
                ILaunchConfigurationWorkingCopy attachLaunchConfigWC = launchType.newInstance(null, lcName);
                attachLaunchConfigWC.setAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", pid);
                attachLaunchConfigWC.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "attach");
                final ILaunchConfiguration attachLaunchConfig = attachLaunchConfigWC.doSave();
                Job launchJob = new Job("Launching " + attachLaunchConfig.getName()){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            attachLaunchConfig.launch("debug", (IProgressMonitor)new NullProgressMonitor(), false, true);
                        }
                        catch (CoreException e) {
                            WindowsDebuggerUI.getMessageLogger().logError(null, (Throwable)e);
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                };
                launchJob.schedule();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public class WindowsDataModel
    extends TCFDataModel {
        private SystemDMContainer processes = new SystemDMContainer();
        private SystemDMContainer threads = new SystemDMContainer();
        private Map<Integer, SystemDMContainer> processesByID = new HashMap<Integer, SystemDMContainer>();
        private Map<Integer, IProcesses.ProcessContext> processContextsByOSID = new HashMap<Integer, IProcesses.ProcessContext>();
        private int contextCountdown;

        public WindowsDataModel() {
            this.getPeerAttributes().put("DebugSupport", "Win32 Debug API");
        }

        public void buildDataModel(IProgressMonitor monitor) throws Exception {
            this.processes = new SystemDMContainer();
            super.buildDataModel(monitor);
        }

        public IPeer choosePeer(IPeer[] runningPeers) {
            if (runningPeers.length > 0) {
                return runningPeers[0];
            }
            return null;
        }

        protected void receiveContextIDs(String parentID, String[] context_ids) {
            try {
                this.contextCountdown = context_ids.length;
                int i = 0;
                while (i < context_ids.length) {
                    this.getProcessContextInfo(context_ids[i]);
                    ++i;
                }
                this.getThreadInfo();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }

        protected void receiveContextInfo(IProcesses.ProcessContext context) {
            if (context != null) {
                Integer osid = (Integer)context.getProperties().get("OSID");
                this.processesByID.put(osid, new SystemDMContainer(this.getProcesses(), context.getProperties()));
                this.processContextsByOSID.put(osid, context);
            }
            this.setBuildComplete(--this.contextCountdown <= 0);
        }

        public SystemDMContainer getProcesses() {
            return this.processes;
        }

        private void getThreadInfo() throws CoreException {
            TCFServiceManager tcfServiceManager = (TCFServiceManager)EDCDebugger.getDefault().getServiceManager();
            IWindowsOSData windowsDataService = (IWindowsOSData)tcfServiceManager.getPeerService(this.getPeer(), "WindowsOSData");
            if (windowsDataService != null) {
                ++this.contextCountdown;
                windowsDataService.getThreads(new IWindowsOSData.DoneGetThreads(){

                    public void doneGetThreads(IToken token, Exception error, List<Map<String, Object>> threads) {
                        if (threads != null) {
                            for (Map<String, Object> props : threads) {
                                Integer threadID = (Integer)props.get("OSID");
                                new SystemDMContainer(WindowsDataModel.this.getThreads(), threadID.toString(), props);
                                Integer processID = (Integer)props.get("p_os_id");
                                if (processID == null || !WindowsDataModel.this.processesByID.containsKey(processID)) continue;
                                new SystemDMContainer((SystemDMContainer)WindowsDataModel.this.processesByID.get(processID), threadID.toString(), props);
                            }
                        }
                        WindowsDataModel windowsDataModel = WindowsDataModel.this;
                        int n = windowsDataModel.contextCountdown - 1;
                        windowsDataModel.contextCountdown = n;
                        WindowsDataModel.this.setBuildComplete(n <= 0);
                    }
                });
            }
        }

        public SystemDMContainer getThreads() {
            return this.threads;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WindowsViewModel
    extends SystemViewModel {
        private List<SystemVMContainer> rootVMContainers = new ArrayList<SystemVMContainer>();
        private SystemVMContainer overview;

        public WindowsViewModel() {
            this.createOverviewContainer();
        }

        public void buildViewModel() {
            this.buildOverviewVMContainer();
        }

        private void createOverviewContainer() {
            this.overview = new SystemVMContainer(null, "Overview");
            this.overview.getProperties().put("ID", String.valueOf(WindowsSystemView.this.getPresentationContext().getId()) + "_overview");
            this.rootVMContainers.add(this.overview);
        }

        private void buildOverviewVMContainer() {
            this.overview.clearChildren();
            List processes = ((WindowsDataModel)WindowsSystemView.this.getDataModel()).getProcesses().getChildren();
            if (processes.size() > 0) {
                SystemVMContainer processesVMC = new SystemVMContainer(this.overview, "Processes");
                StringMatcher matcher = WindowsSystemView.this.getFilterMatcher();
                for (SystemDMContainer process : processes) {
                    if (!matcher.match(process.getName())) continue;
                    SystemVMContainer processVMC = new SystemVMContainer(processesVMC, process);
                    List threads = process.getChildren();
                    for (SystemDMContainer threadDMContainer : threads) {
                        new SystemVMContainer(processVMC, threadDMContainer);
                    }
                }
            }
        }

        public List<SystemVMContainer> getRootContainers() {
            return this.rootVMContainers;
        }
    }
}

