/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.windows.launch;

import java.util.HashSet;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.debug.edc.launch.EDCLaunchDelegate;
import org.eclipse.cdt.debug.edc.windows.WindowsDebugger;
import org.eclipse.cdt.debug.edc.windows.launch.WindowsFinalLaunchSequence;
import org.eclipse.cdt.debug.edc.windows.launch.WindowsLaunch;
import org.eclipse.cdt.debug.edc.x86.DebugServicesFactoryX86;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;

public class WindowsLaunchDelegate
extends EDCLaunchDelegate {
    public static final String WINDOWS_DEBUG_MODEL_ID = "org.eclipse.cdt.debug.edc.windows";

    public String getDebugModelID() {
        return WINDOWS_DEBUG_MODEL_ID;
    }

    protected Sequence getLiveLaunchSequence(DsfExecutor executor, EDCLaunch launch, IProgressMonitor pm) {
        return new WindowsFinalLaunchSequence(executor, launch, pm);
    }

    protected IDsfDebugServicesFactory newServiceFactory() {
        return new DebugServicesFactoryX86();
    }

    protected String getPluginID() {
        return WindowsDebugger.getUniqueIdentifier();
    }

    protected boolean isSameTarget(EDCLaunch existingLaunch, ILaunchConfiguration configuration, String mode) {
        try {
            ILaunchConfigurationType newType;
            ILaunchConfigurationType existingType;
            ILaunchConfiguration existingConfiguration = existingLaunch.getLaunchConfiguration();
            if (existingConfiguration != null && (existingType = existingConfiguration.getType()).equals(newType = configuration.getType())) {
                HashSet<String> modes = new HashSet<String>();
                modes.add(mode);
                ILaunchDelegate existingDelegate = existingConfiguration.getPreferredDelegate(modes);
                ILaunchDelegate delegate = configuration.getPreferredDelegate(modes);
                if (existingDelegate.equals(delegate)) {
                    return true;
                }
            }
        }
        catch (CoreException e) {
            EDCDebugger.getMessageLogger().logError(null, (Throwable)e);
        }
        return false;
    }

    public EDCLaunch createLaunch(ILaunchConfiguration configuration, String mode) {
        return new WindowsLaunch(configuration, mode, null, this.getDebugModelID());
    }
}

