/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.MemoryUtils;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Memory;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.internal.symbols.SymbolsMessages;
import org.eclipse.cdt.debug.edc.services.EDCServicesTracker;
import org.eclipse.cdt.debug.edc.services.ITargetEnvironment;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.debug.edc.symbols.IMemoryVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.model.MemoryByte;

public class MemoryVariableLocation
implements IMemoryVariableLocation {
    protected IAddress address;
    protected boolean isRuntimeAddress;
    protected EDCServicesTracker tracker;
    private IDMContext context;

    public MemoryVariableLocation(EDCServicesTracker tracker, IDMContext context, BigInteger addressValue, boolean isRuntimeAddress) {
        this.initialize(tracker, context, addressValue, isRuntimeAddress, false);
    }

    public MemoryVariableLocation(EDCServicesTracker tracker, IDMContext context, BigInteger addressValue, boolean isRuntimeAddress, boolean checkNonLocalConstVariable) {
        this.initialize(tracker, context, addressValue, isRuntimeAddress, checkNonLocalConstVariable);
    }

    private void initialize(EDCServicesTracker tracker, IDMContext context, BigInteger addressValue, boolean isRuntimeAddress, boolean checkNonLocalConstVariable) {
        this.tracker = tracker;
        this.context = context;
        BigInteger MAXADDR = BigInteger.valueOf(0xFFFFFFFFL);
        ITargetEnvironment targetEnvironment = tracker.getService(ITargetEnvironment.class);
        if (targetEnvironment != null && targetEnvironment.getPointerSize() == 8) {
            MAXADDR = BigInteger.valueOf(-1L);
        }
        this.address = new Addr64(addressValue.and(MAXADDR));
        this.isRuntimeAddress = isRuntimeAddress;
        if (checkNonLocalConstVariable) {
            this.checkNonLocalConstVariableAddr();
        }
    }

    private void checkNonLocalConstVariableAddr() {
        ArrayList<MemoryByte> memBuffer;
        IAddress theAddress = this.address;
        if (!this.isRuntimeAddress) {
            Stack.StackFrameDMC frame = (Stack.StackFrameDMC)DMContexts.getAncestorOfType((IDMContext)this.context, Stack.StackFrameDMC.class);
            if (frame == null) {
                this.isRuntimeAddress = !this.isRuntimeAddress;
                return;
            }
            theAddress = frame.getModule().toRuntimeAddress(theAddress);
        }
        RunControl.ExecutionDMC exeDMC = (RunControl.ExecutionDMC)DMContexts.getAncestorOfType((IDMContext)this.context, RunControl.ExecutionDMC.class);
        Memory memoryService = this.tracker.getService(Memory.class);
        IStatus memGetStatus = memoryService.getMemory(exeDMC, theAddress, memBuffer = new ArrayList<MemoryByte>(1), 1, 1);
        if (!memGetStatus.isOK()) {
            this.isRuntimeAddress = !this.isRuntimeAddress;
            return;
        }
        if (!memBuffer.get(0).isReadable()) {
            this.isRuntimeAddress = !this.isRuntimeAddress;
            return;
        }
    }

    public String toString() {
        return "0x" + Long.toHexString(this.address.getValue().longValue()) + (this.isRuntimeAddress ? "" : " (link address)");
    }

    public IAddress getAddress() {
        try {
            return this.getRealAddress();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public boolean isRuntimeAddress() {
        return this.isRuntimeAddress;
    }

    public BigInteger readValue(int varSize) throws CoreException {
        ArrayList<MemoryByte> memBuffer;
        IAddress theAddress = this.address;
        if (!this.isRuntimeAddress) {
            theAddress = this.getRealAddress();
        }
        RunControl.ExecutionDMC exeDMC = (RunControl.ExecutionDMC)DMContexts.getAncestorOfType((IDMContext)this.context, RunControl.ExecutionDMC.class);
        Memory memoryService = this.tracker.getService(Memory.class);
        IStatus memGetStatus = memoryService.getMemory(exeDMC, theAddress, memBuffer = new ArrayList<MemoryByte>(), varSize, 1);
        if (!memGetStatus.isOK()) {
            throw EDCDebugger.newCoreException(MessageFormat.format(SymbolsMessages.MemoryVariableLocation_CannotReadAddrFormat, theAddress.toHexAddressString()));
        }
        int i = 0;
        while (i < memBuffer.size()) {
            if (!memBuffer.get(i).isReadable()) {
                throw EDCDebugger.newCoreException(MessageFormat.format(SymbolsMessages.MemoryVariableLocation_CannotReadAddrFormat, theAddress.add((long)i).getValue().toString(16)));
            }
            ++i;
        }
        MemoryByte[] memArray = memBuffer.toArray(new MemoryByte[varSize]);
        return MemoryUtils.convertByteArrayToUnsignedLong(memArray, this.getEndian());
    }

    private int getEndian() {
        ITargetEnvironment targetEnvironment = this.tracker.getService(ITargetEnvironment.class);
        int endian = 0;
        if (targetEnvironment != null) {
            endian = targetEnvironment.isLittleEndian(this.context) ? 0 : 1;
        }
        return endian;
    }

    private IAddress getRealAddress() throws CoreException {
        IAddress theAddress = this.address;
        if (!this.isRuntimeAddress) {
            Stack.StackFrameDMC frame = (Stack.StackFrameDMC)DMContexts.getAncestorOfType((IDMContext)this.context, Stack.StackFrameDMC.class);
            if (frame == null) {
                throw EDCDebugger.newCoreException(SymbolsMessages.MemoryVariableLocation_CannotFindFrame);
            }
            theAddress = frame.getModule().toRuntimeAddress(theAddress);
        }
        return theAddress;
    }

    public IVariableLocation addOffset(long offset) {
        return new MemoryVariableLocation(this.tracker, this.context, this.address.getValue().add(BigInteger.valueOf(offset)), this.isRuntimeAddress);
    }

    public String getLocationName() {
        if (!this.isRuntimeAddress) {
            try {
                return String.valueOf(SymbolsMessages.MemoryVariableLocation_Hex) + Long.toHexString(this.getRealAddress().getValue().longValue());
            }
            catch (CoreException coreException) {
                return String.valueOf(SymbolsMessages.MemoryVariableLocation_Hex) + Long.toHexString(this.address.getValue().longValue()) + SymbolsMessages.MemoryVariableLocation_LinkTime;
            }
        }
        return String.valueOf(SymbolsMessages.MemoryVariableLocation_Hex) + Long.toHexString(this.address.getValue().longValue());
    }

    public void writeValue(int bytes, BigInteger value) throws CoreException {
        byte[] buffer = MemoryUtils.convertSignedBigIntToByteArray(value, this.getEndian(), bytes);
        IAddress theAddress = !this.isRuntimeAddress ? this.getRealAddress() : this.address;
        RunControl.ExecutionDMC exeDMC = (RunControl.ExecutionDMC)DMContexts.getAncestorOfType((IDMContext)this.context, RunControl.ExecutionDMC.class);
        Memory memory = this.tracker.getService(Memory.class);
        IStatus status = memory.setMemory(exeDMC, theAddress, 1, bytes, buffer);
        if (!status.isOK()) {
            throw EDCDebugger.newCoreException(MessageFormat.format(SymbolsMessages.MemoryVariableLocation_CannotWriteAddrFormat, theAddress.toHexAddressString()), status.getException());
        }
    }

    public IDMContext getContext() {
        return this.context;
    }

    public EDCServicesTracker getServicesTracker() {
        return this.tracker;
    }
}

