/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.formatter.qt;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.edc.formatter.AbstractCompositeFormatProvider;
import org.eclipse.cdt.debug.edc.formatter.FormatUtils;
import org.eclipse.cdt.debug.edc.formatter.ITypeContentProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableFormatProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableValueConverter;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.symbols.IPointerType;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.debug.edc.services.IEDCExpressions;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.core.runtime.CoreException;

public class QMapFormatter
implements IVariableFormatProvider {
    private static final String TYPE_NAME = "QMap";

    public ITypeContentProvider getTypeContentProvider(IType type) {
        if (FormatUtils.checkClassOrInheritanceByName(type, TYPE_NAME)) {
            return new FormatProvider(type, false);
        }
        return null;
    }

    public IVariableValueConverter getVariableValueConverter(IType type) {
        if (FormatUtils.checkClassOrInheritanceByName(type, TYPE_NAME)) {
            return new FormatProvider(type, false);
        }
        return null;
    }

    public IVariableValueConverter getDetailValueConverter(IType type) {
        if (FormatUtils.checkClassOrInheritanceByName(type, TYPE_NAME)) {
            return new FormatProvider(type, true);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FormatProvider
    extends AbstractCompositeFormatProvider {
        private static final String SIZE_NAME = "size";
        private static final String SIZE_PATH = "$unnamed$1.d->size";
        private static final String HEAD_NAME = "head";
        private static final String HEAD_PATH = "$unnamed$1.d->forward[0]";
        private static final int SIZE_CHILD_INDEX = 0;
        private static final int HEAD_CHILD_INDEX = 1;
        private static final int NODE_FORWARD_INDEX = 3;
        private static final String FIRST_ELEMENT_SUFFIX = "[0]";
        private static final String NODE_CAST_FMT = "reinterpret_cast<QMapNode<{0}>*>({1})";
        private static final String DETAIL_SIZE_FMT = "size={0}";
        private static final String DETAIL_FMT = "size={0} {1}";
        private static final int STOP_LENGTH = 300;
        private static final int SIZE_OF_PTR = 4;
        private static Map<String, String> nameToFieldPathMap = new LinkedHashMap<String, String>();

        static {
            nameToFieldPathMap.put(SIZE_NAME, SIZE_PATH);
            nameToFieldPathMap.put(HEAD_NAME, HEAD_PATH);
        }

        public FormatProvider(IType type, boolean forDetails) {
            super(type, forDetails, FormatProvider.getNameToFieldPaths());
        }

        private static List<AbstractCompositeFormatProvider.NameToFieldPath> getNameToFieldPaths() {
            ArrayList<AbstractCompositeFormatProvider.NameToFieldPath> nameToFieldPaths = new ArrayList<AbstractCompositeFormatProvider.NameToFieldPath>();
            for (Map.Entry<String, String> entry : nameToFieldPathMap.entrySet()) {
                nameToFieldPaths.add(new AbstractCompositeFormatProvider.NameToFieldPath(entry.getKey(), entry.getValue()));
            }
            return nameToFieldPaths;
        }

        @Override
        public int getChildCount(IExpressions.IExpressionDMContext variable) throws CoreException {
            List<IExpressions.IExpressionDMContext> childContexts = super.getChildren(variable);
            IEDCExpression sizeChild = (IEDCExpression)childContexts.get(0);
            FormatUtils.evaluateExpression(sizeChild);
            int size = sizeChild.getEvaluatedValue().intValue();
            if (size < 0 || size > 0x1000000) {
                throw EDCDebugger.newCoreException("Uninitialized");
            }
            return size;
        }

        @Override
        protected List<IExpressions.IExpressionDMContext> getChildren(IExpressions.IExpressionDMContext variable) throws CoreException {
            ArrayList<IExpressions.IExpressionDMContext> children = new ArrayList<IExpressions.IExpressionDMContext>();
            List<IExpressions.IExpressionDMContext> childContexts = super.getChildren(variable);
            IEDCExpression sizeChild = (IEDCExpression)childContexts.get(0);
            FormatUtils.evaluateExpression(sizeChild);
            children.add(sizeChild);
            int size = sizeChild.getEvaluatedValue().intValue();
            if (size < 0 || size > 0x1000000) {
                throw EDCDebugger.newCoreException("Uninitialized");
            }
            if (size > 0) {
                IEDCExpressions expressions = sizeChild.getExpressionsService();
                children.addAll(this.getElementsFromMapHead((IExpressions)expressions, (IEDCExpression)childContexts.get(1), size));
            }
            return children;
        }

        private List<IEDCExpression> getElementsFromMapHead(IExpressions expressions, IEDCExpression listHead, int size) throws CoreException {
            FormatUtils.evaluateExpression(listHead);
            int listHeadValue = listHead.getEvaluatedValue().intValue();
            IStack.IFrameDMContext frame = listHead.getFrame();
            String templateArgs = FormatUtils.getTemplateTypeName(QMapFormatter.TYPE_NAME, this.type);
            int keyValueSize = this.getKeyAndValueSize(expressions, frame, templateArgs, listHeadValue);
            ArrayList<IEDCExpression> elements = new ArrayList<IEDCExpression>();
            IEDCExpression mapNode = this.createCastedMapNodeExpression(expressions, frame, templateArgs, listHeadValue - keyValueSize);
            while (elements.size() < size) {
                IEDCExpression copy = (IEDCExpression)expressions.createExpression((IDMContext)frame, mapNode.getExpression());
                copy.setName("" + (elements.size() + 1));
                elements.add(copy);
                mapNode = this.getNextNode(expressions, frame, templateArgs, mapNode, keyValueSize);
                if (elements.size() < FormatUtils.getMaxNumberOfChildren()) continue;
                IEDCExpression moreExpression = (IEDCExpression)expressions.createExpression((IDMContext)frame, "0");
                moreExpression.setName("more...");
                elements.add(moreExpression);
                break;
            }
            return elements;
        }

        private IEDCExpression getNextNode(IExpressions expressions, IStack.IFrameDMContext frame, String templateArgs, IEDCExpression mapNode, int keyValueSize) throws CoreException {
            List<IExpressions.IExpressionDMContext> childExpressions = FormatUtils.getAllChildExpressions(mapNode);
            IEDCExpression forwardExp = (IEDCExpression)childExpressions.get(3);
            forwardExp = (IEDCExpression)expressions.createExpression((IDMContext)frame, String.valueOf(forwardExp.getExpression()) + FIRST_ELEMENT_SUFFIX);
            FormatUtils.evaluateExpression(forwardExp);
            int forwardVal = forwardExp.getEvaluatedValue().intValue();
            return this.createCastedMapNodeExpression(expressions, frame, templateArgs, forwardVal - keyValueSize);
        }

        private int getKeyAndValueSize(IExpressions expressions, IStack.IFrameDMContext frame, String templateArgs, int listHeadValue) throws CoreException {
            IEDCExpression castedMapNodeExpression = this.createCastedMapNodeExpression(expressions, frame, templateArgs, listHeadValue);
            FormatUtils.evaluateExpression(castedMapNodeExpression);
            IPointerType pointerType = (IPointerType)castedMapNodeExpression.getEvaluatedType();
            IType mapNodeType = pointerType.getType();
            int mapNodeSize = mapNodeType.getByteSize();
            return mapNodeSize - 8;
        }

        private IEDCExpression createCastedMapNodeExpression(IExpressions expressions, IStack.IFrameDMContext frame, String templateArgs, int nodeValue) throws CoreException {
            String expression = MessageFormat.format(NODE_CAST_FMT, templateArgs, "0x" + Integer.toHexString(nodeValue));
            IEDCExpression nextNode = (IEDCExpression)expressions.createExpression((IDMContext)frame, expression);
            FormatUtils.evaluateExpression(nextNode);
            return nextNode;
        }

        @Override
        public String getValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            int count = this.getChildCount(variable);
            return MessageFormat.format(DETAIL_SIZE_FMT, count);
        }

        protected String getFullStringValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            List<IExpressions.IExpressionDMContext> children = this.getChildren(variable);
            IEDCExpression sizeExp = (IEDCExpression)children.get(0);
            StringBuilder sb = new StringBuilder("[");
            int i = 1;
            while (i < children.size()) {
                String elementString;
                IEDCExpression elementChild = (IEDCExpression)children.get(i);
                if (i > 1) {
                    sb.append(", ");
                }
                if ((elementString = FormatUtils.getFormattedValue(elementChild)) != null) {
                    sb.append('{');
                    sb.append(elementString);
                    sb.append('}');
                }
                if (sb.length() > 300) {
                    if (children.get(children.size() - 1).equals(elementChild)) break;
                    sb.append(", ...");
                    break;
                }
                ++i;
            }
            return MessageFormat.format(DETAIL_FMT, FormatUtils.getVariableValue(sizeExp), sb.append(']').toString());
        }
    }
}

