/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.preferences;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.SortedMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.IInternalCDebugUIConstants;
import org.eclipse.cdt.debug.internal.ui.preferences.ICDebugPreferenceConstants;
import org.eclipse.cdt.debug.internal.ui.preferences.PreferenceMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;

public class CDebugPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench fWorkbench;
    private Combo fVariableFormatCombo;
    private Combo fExpressionFormatCombo;
    private Combo fRegisterFormatCombo;
    private Combo fCharsetCombo;
    private static int[] fFormatIds;
    private static String[] fFormatLabels;
    private PropertyChangeListener fPropertyChangeListener;
    private Button fShowBinarySourceFilesButton;

    static {
        int[] nArray = new int[4];
        nArray[1] = 4;
        nArray[2] = 1;
        nArray[3] = 2;
        fFormatIds = nArray;
        fFormatLabels = new String[]{PreferenceMessages.getString("CDebugPreferencePage.0"), PreferenceMessages.getString("CDebugPreferencePage.1"), PreferenceMessages.getString("CDebugPreferencePage.2"), PreferenceMessages.getString("CDebugPreferencePage.14")};
    }

    public CDebugPreferencePage() {
        this.setPreferenceStore(CDebugUIPlugin.getDefault().getPreferenceStore());
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.getPropertyChangeListener());
        this.setDescription(PreferenceMessages.getString("CDebugPreferencePage.3"));
    }

    protected Control createContents(Composite parent) {
        this.getWorkbench().getHelpSystem().setHelp(this.getControl(), ICDebugHelpContextIds.C_DEBUG_PREFERENCE_PAGE);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createSpacer(composite, 1);
        this.createViewSettingPreferences(composite);
        this.createSpacer(composite, 1);
        this.createBinarySettings(composite);
        this.setValues();
        return composite;
    }

    private Composite createGroupComposite(Composite parent, int numColumns, String labelText) {
        return ControlFactory.createGroup((Composite)parent, (String)labelText, (int)numColumns);
    }

    private void setValues() {
        this.fVariableFormatCombo.select(CDebugPreferencePage.getFormatIndex(CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_VARIABLE_FORMAT)));
        this.fExpressionFormatCombo.select(CDebugPreferencePage.getFormatIndex(CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT)));
        this.fRegisterFormatCombo.select(CDebugPreferencePage.getFormatIndex(CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_REGISTER_FORMAT)));
        this.fCharsetCombo.setText(CDebugCorePlugin.getDefault().getPluginPreferences().getString(ICDebugConstants.PREF_CHARSET));
        this.fShowBinarySourceFilesButton.setSelection(CCorePlugin.getDefault().getPluginPreferences().getBoolean("org.eclipse.cdt.core.showSourceFilesInBinaries"));
    }

    public void init(IWorkbench workbench) {
        this.fWorkbench = workbench;
    }

    protected PropertyChangeListener getPropertyChangeListener() {
        if (this.fPropertyChangeListener == null) {
            this.fPropertyChangeListener = new PropertyChangeListener();
        }
        return this.fPropertyChangeListener;
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(ICDebugPreferenceConstants.PREF_SHOW_HEX_VALUES, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)IInternalCDebugUIConstants.DISASSEMBLY_SOURCE_LINE_COLOR, (RGB)IInternalCDebugUIConstants.DEFAULT_DISASSEMBLY_SOURCE_LINE_RGB);
    }

    public void dispose() {
        super.dispose();
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.getPropertyChangeListener());
    }

    private void createViewSettingPreferences(Composite parent) {
        Composite comp = this.createGroupComposite(parent, 1, PreferenceMessages.getString("CDebugPreferencePage.4"));
        Composite formatComposite = ControlFactory.createCompositeEx((Composite)comp, (int)2, (int)0);
        ((GridLayout)formatComposite.getLayout()).makeColumnsEqualWidth = true;
        this.fVariableFormatCombo = this.createComboBox(formatComposite, PreferenceMessages.getString("CDebugPreferencePage.8"), fFormatLabels, fFormatLabels[0]);
        this.fExpressionFormatCombo = this.createComboBox(formatComposite, PreferenceMessages.getString("CDebugPreferencePage.9"), fFormatLabels, fFormatLabels[0]);
        this.fRegisterFormatCombo = this.createComboBox(formatComposite, PreferenceMessages.getString("CDebugPreferencePage.10"), fFormatLabels, fFormatLabels[0]);
        String[] charsetNames = this.getCharsetNames();
        this.fCharsetCombo = this.createComboBox(formatComposite, PreferenceMessages.getString("CDebugPreferencePage.16"), charsetNames, charsetNames[0]);
    }

    private String[] getCharsetNames() {
        ArrayList<String> names = new ArrayList<String>();
        SortedMap<String, Charset> setmap = Charset.availableCharsets();
        for (String entry : setmap.keySet()) {
            names.add(entry);
        }
        return names.toArray(new String[names.size()]);
    }

    private void createBinarySettings(Composite parent) {
        this.fShowBinarySourceFilesButton = this.createCheckButton(parent, PreferenceMessages.getString("CDebugPreferencePage.15"));
    }

    private Button createCheckButton(Composite parent, String label) {
        Button button = new Button(parent, 16416);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    private Combo createComboBox(Composite parent, String label, String[] items, String selection) {
        ControlFactory.createLabel((Composite)parent, (String)label);
        Combo combo = ControlFactory.createSelectCombo((Composite)parent, (String[])items, (String)selection);
        combo.setLayoutData((Object)new GridData());
        return combo;
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    public boolean performOk() {
        this.storeValues();
        if (this.getPropertyChangeListener().hasStateChanged()) {
            this.refreshViews();
        }
        CDebugUIPlugin.getDefault().savePluginPreferences();
        CDebugCorePlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void refreshViews() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IWorkbenchWindow[] windows = CDebugUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
                IWorkbenchPage page = null;
                int i = 0;
                while (i < windows.length) {
                    page = windows[i].getActivePage();
                    if (page != null) {
                        CDebugPreferencePage.this.refreshViews(page, "org.eclipse.debug.ui.ExpressionView");
                        CDebugPreferencePage.this.refreshViews(page, "org.eclipse.debug.ui.VariableView");
                        CDebugPreferencePage.this.refreshViews(page, "org.eclipse.debug.ui.RegisterView");
                    }
                    ++i;
                }
            }
        });
    }

    protected void refreshViews(IWorkbenchPage page, String viewID) {
        Viewer viewer;
        IDebugView adapter;
        IViewPart part = page.findView(viewID);
        if (part != null && (adapter = (IDebugView)part.getAdapter(IDebugView.class)) != null && (viewer = adapter.getViewer()) instanceof StructuredViewer) {
            ((StructuredViewer)viewer).refresh();
        }
    }

    private void storeValues() {
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_DEFAULT_VARIABLE_FORMAT, CDebugPreferencePage.getFormatId(this.fVariableFormatCombo.getSelectionIndex()));
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT, CDebugPreferencePage.getFormatId(this.fExpressionFormatCombo.getSelectionIndex()));
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_DEFAULT_REGISTER_FORMAT, CDebugPreferencePage.getFormatId(this.fRegisterFormatCombo.getSelectionIndex()));
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_CHARSET, this.fCharsetCombo.getItem(this.fCharsetCombo.getSelectionIndex()));
        CCorePlugin.getDefault().getPluginPreferences().setValue("org.eclipse.cdt.core.showSourceFilesInBinaries", this.fShowBinarySourceFilesButton.getSelection());
    }

    protected void performDefaults() {
        this.setDefaultValues();
        super.performDefaults();
    }

    private void setDefaultValues() {
        this.fVariableFormatCombo.select(CDebugPreferencePage.getFormatIndex(CDebugCorePlugin.getDefault().getPluginPreferences().getDefaultInt(ICDebugConstants.PREF_DEFAULT_VARIABLE_FORMAT)));
        this.fExpressionFormatCombo.select(CDebugPreferencePage.getFormatIndex(CDebugCorePlugin.getDefault().getPluginPreferences().getDefaultInt(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT)));
        this.fRegisterFormatCombo.select(CDebugPreferencePage.getFormatIndex(CDebugCorePlugin.getDefault().getPluginPreferences().getDefaultInt(ICDebugConstants.PREF_DEFAULT_REGISTER_FORMAT)));
        this.fCharsetCombo.setText(CDebugCorePlugin.getDefault().getPluginPreferences().getDefaultString(ICDebugConstants.PREF_CHARSET));
    }

    private static int getFormatId(int index) {
        return index >= 0 && index < fFormatIds.length ? fFormatIds[index] : fFormatIds[0];
    }

    private static int getFormatIndex(int id) {
        int i = 0;
        while (i < fFormatIds.length) {
            if (fFormatIds[i] == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private IWorkbench getWorkbench() {
        return this.fWorkbench;
    }

    protected class PropertyChangeListener
    implements IPropertyChangeListener {
        private boolean fHasStateChanged = false;

        protected PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(ICDebugPreferenceConstants.PREF_SHOW_HEX_VALUES)) {
                this.fHasStateChanged = true;
            } else if (event.getProperty().equals(ICDebugPreferenceConstants.PREF_SHOW_CHAR_VALUES)) {
                this.fHasStateChanged = true;
            }
        }

        protected boolean hasStateChanged() {
            return this.fHasStateChanged;
        }
    }
}

