/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.service.DebugNewProcessSequence_7_2;
import org.eclipse.cdt.dsf.gdb.service.GDBProcesses_7_1;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IReverseRunControl;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIAddInferiorInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDBProcesses_7_2
extends GDBProcesses_7_1 {
    private CommandFactory fCommandFactory;
    private IGDBControl fCommandControl;
    private IGDBBackend fBackend;
    private Set<IRunControl.IContainerDMContext> fProcRestarting = new HashSet<IRunControl.IContainerDMContext>();

    public GDBProcesses_7_2(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor(ImmediateExecutor.getInstance(), requestMonitor){

            protected void handleSuccess() {
                GDBProcesses_7_2.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fCommandControl = (IGDBControl)this.getServicesTracker().getService(IGDBControl.class);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.fBackend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        requestMonitor.done();
    }

    @Override
    public void shutdown(RequestMonitor requestMonitor) {
        super.shutdown(requestMonitor);
    }

    @Override
    public IMIContainerDMContext createContainerContextFromGroupId(ICommandControlService.ICommandControlDMContext controlDmc, String groupId) {
        String pid = this.getGroupToPidMap().get(groupId);
        if (pid == null) {
            pid = "";
        }
        IProcesses.IProcessDMContext processDmc = this.createProcessContext(controlDmc, pid);
        return this.createContainerContext(processDmc, groupId);
    }

    @Override
    protected boolean doIsDebuggerAttachSupported() {
        if (this.fBackend.getSessionType() == SessionType.CORE) {
            return false;
        }
        if (this.fBackend.getSessionType() == SessionType.REMOTE && !this.fBackend.getIsAttachSession()) {
            return false;
        }
        IMIRunControl runControl = (IMIRunControl)this.getServicesTracker().getService(IMIRunControl.class);
        if (runControl != null && runControl.getRunMode() == IMIRunControl.MIRunMode.ALL_STOP) {
            return this.getNumConnected() == 0;
        }
        return true;
    }

    @Override
    public void attachDebuggerToProcess(IProcesses.IProcessDMContext procCtx, DataRequestMonitor<IDMContext> rm) {
        this.attachDebuggerToProcess(procCtx, null, rm);
    }

    @Override
    public void attachDebuggerToProcess(IProcesses.IProcessDMContext procCtx, String binaryPath, DataRequestMonitor<IDMContext> dataRm) {
        if (procCtx instanceof IMIProcessDMContext) {
            if (!this.doIsDebuggerAttachSupported()) {
                dataRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Attach not supported.", null));
                dataRm.done();
                return;
            }
            ImmediateExecutor.getInstance().execute((Runnable)new Sequence(this.getExecutor(), (RequestMonitor)dataRm, procCtx, binaryPath, (DataRequestMonitor)dataRm){
                private IMIContainerDMContext fContainerDmc;
                private Sequence.Step[] steps;
                {
                    this.steps = new Sequence.Step[]{new Sequence.Step(){

                        public void execute(final RequestMonitor rm) {
                            if (GDBProcesses_7_2.this.isInitialProcess()) {
                                GDBProcesses_7_2.this.setIsInitialProcess(false);
                                fContainerDmc = GDBProcesses_7_2.this.createContainerContext(iProcessDMContext, "i1");
                                rm.done();
                                return;
                            }
                            ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)iProcessDMContext, ICommandControlService.ICommandControlDMContext.class);
                            GDBProcesses_7_2.this.fCommandControl.queueCommand(GDBProcesses_7_2.this.fCommandFactory.createMIAddInferior(controlDmc), (DataRequestMonitor)new DataRequestMonitor<MIAddInferiorInfo>(ImmediateExecutor.getInstance(), rm){

                                protected void handleSuccess() {
                                    String groupId = ((MIAddInferiorInfo)this.getData()).getGroupId();
                                    if (groupId == null || groupId.trim().length() == 0) {
                                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid gdb group id.", null));
                                    } else {
                                        fContainerDmc = GDBProcesses_7_2.this.createContainerContext(iProcessDMContext, groupId);
                                    }
                                    rm.done();
                                }
                            });
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            if (string != null) {
                                GDBProcesses_7_2.this.fCommandControl.queueCommand(GDBProcesses_7_2.this.fCommandFactory.createMIFileExecAndSymbols(fContainerDmc, string), new DataRequestMonitor(ImmediateExecutor.getInstance(), rm));
                                return;
                            }
                            rm.done();
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            boolean shouldInterrupt = true;
                            IMIRunControl runControl = (IMIRunControl)GDBProcesses_7_2.this.getServicesTracker().getService(IMIRunControl.class);
                            if (runControl != null && runControl.getRunMode() == IMIRunControl.MIRunMode.NON_STOP) {
                                shouldInterrupt = false;
                            }
                            GDBProcesses_7_2.this.fCommandControl.queueCommand(GDBProcesses_7_2.this.fCommandFactory.createMITargetAttach(fContainerDmc, ((IMIProcessDMContext)iProcessDMContext).getProcId(), shouldInterrupt), new DataRequestMonitor(ImmediateExecutor.getInstance(), rm));
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            MIBreakpointsManager bpmService = (MIBreakpointsManager)((Object)GDBProcesses_7_2.this.getServicesTracker().getService(MIBreakpointsManager.class));
                            IBreakpoints.IBreakpointsTargetDMContext bpTargetDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)fContainerDmc, IBreakpoints.IBreakpointsTargetDMContext.class);
                            bpmService.startTrackingBreakpoints(bpTargetDmc, rm);
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            ILaunch launch;
                            IReverseRunControl reverseService = (IReverseRunControl)GDBProcesses_7_2.this.getServicesTracker().getService(IReverseRunControl.class);
                            if (reverseService != null && (launch = (ILaunch)iProcessDMContext.getAdapter(ILaunch.class)) != null) {
                                try {
                                    boolean reverseEnabled = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.REVERSE", false);
                                    if (reverseEnabled) {
                                        reverseService.enableReverseMode(GDBProcesses_7_2.this.fCommandControl.getContext(), true, rm);
                                        return;
                                    }
                                }
                                catch (CoreException coreException) {}
                            }
                            rm.done();
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            dataRequestMonitor.setData((Object)fContainerDmc);
                            rm.done();
                        }
                    }};
                }

                public Sequence.Step[] getSteps() {
                    return this.steps;
                }
            });
        } else {
            dataRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid process context.", null));
            dataRm.done();
        }
    }

    @Override
    public void detachDebuggerFromProcess(IDMContext dmc, final RequestMonitor rm) {
        ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        final IMIContainerDMContext containerDmc = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIContainerDMContext.class);
        if (controlDmc != null && containerDmc != null) {
            if (!this.doCanDetachDebuggerFromProcess()) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Detach not supported.", null));
                rm.done();
                return;
            }
            IMIRunControl runControl = (IMIRunControl)this.getServicesTracker().getService(IMIRunControl.class);
            if (runControl != null && !runControl.isTargetAcceptingCommands()) {
                this.fBackend.interrupt();
            }
            this.fCommandControl.queueCommand(this.fCommandFactory.createMITargetDetach(controlDmc, containerDmc.getGroupId()), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        rm.done();
                    } else {
                        GDBProcesses_7_2.this.fCommandControl.queueCommand(GDBProcesses_7_2.this.fCommandFactory.createMITargetDetach(containerDmc), new DataRequestMonitor((Executor)GDBProcesses_7_2.this.getExecutor(), rm));
                    }
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid context.", null));
            rm.done();
        }
    }

    @Override
    protected boolean doIsDebugNewProcessSupported() {
        SessionType type = this.fBackend.getSessionType();
        if (type == SessionType.CORE) {
            return false;
        }
        if (type == SessionType.REMOTE && !this.fBackend.getIsAttachSession()) {
            return false;
        }
        return type != SessionType.REMOTE || !this.fBackend.getIsAttachSession();
    }

    @Override
    protected Sequence getDebugNewProcessSequence(DsfExecutor executor, boolean isInitial, IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IDMContext> rm) {
        return new DebugNewProcessSequence_7_2(executor, isInitial, dmc, file, attributes, rm);
    }

    @Override
    protected IMIContainerDMContext createContainerContextForRestart(String groupId) {
        IProcesses.IProcessDMContext processDmc = this.createProcessContext(this.fCommandControl.getContext(), "");
        return this.createContainerContext(processDmc, groupId);
    }

    @Override
    public void restart(final IRunControl.IContainerDMContext containerDmc, Map<String, Object> attributes, DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
        this.fProcRestarting.add(containerDmc);
        super.restart(containerDmc, attributes, new DataRequestMonitor<IRunControl.IContainerDMContext>(ImmediateExecutor.getInstance(), rm){

            protected void handleCompleted() {
                if (!this.isSuccess()) {
                    GDBProcesses_7_2.this.fProcRestarting.remove(containerDmc);
                }
                this.setData((IRunControl.IContainerDMContext)this.getData());
                super.handleCompleted();
            }
        });
    }

    @Override
    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        IDMContext dmc = e.getDMContext();
        if (dmc instanceof IRunControl.IContainerDMContext && !this.fProcRestarting.remove(dmc) && this.fBackend.getSessionType() != SessionType.CORE) {
            IBreakpoints.IBreakpointsTargetDMContext bpTargetDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IBreakpoints.IBreakpointsTargetDMContext.class);
            MIBreakpointsManager bpmService = (MIBreakpointsManager)((Object)this.getServicesTracker().getService(MIBreakpointsManager.class));
            if (bpmService != null) {
                bpmService.stopTrackingBreakpoints(bpTargetDmc, new RequestMonitor(ImmediateExecutor.getInstance(), null){

                    protected void handleCompleted() {
                    }
                });
            }
        }
        super.eventDispatched(e);
    }
}

