/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IRunControl2;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIStack;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.events.MIBreakpointHitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIInferiorExitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIThreadExitEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakInsertInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIFrame;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDBRunControl
extends MIRunControl {
    private IGDBBackend fGdb;
    private IMIProcesses fProcService;
    private CommandFactory fCommandFactory;
    private IRunControl.IExecutionDMContext[] fOldExecutionCtxts;
    private RunToLineActiveOperation fRunToLineActiveOperation = null;

    public GDBRunControl(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor(ImmediateExecutor.getInstance(), requestMonitor){

            public void handleSuccess() {
                GDBRunControl.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fGdb = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        this.fProcService = (IMIProcesses)this.getServicesTracker().getService(IMIProcesses.class);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.register(new String[]{IRunControl.class.getName(), IRunControl2.class.getName(), IMIRunControl.class.getName(), MIRunControl.class.getName(), GDBRunControl.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    @Override
    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    @Override
    public IMIExecutionDMContext createMIExecutionContext(IRunControl.IContainerDMContext container, int threadId) {
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)container, IProcesses.IProcessDMContext.class);
        IProcesses.IThreadDMContext threadDmc = null;
        if (procDmc != null) {
            threadDmc = this.fProcService.createThreadContext(procDmc, Integer.toString(threadId));
        }
        return this.fProcService.createExecutionContext(container, threadDmc, Integer.toString(threadId));
    }

    @Override
    public void suspend(final IRunControl.IExecutionDMContext context, final RequestMonitor rm) {
        this.canSuspend(context, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (((Boolean)this.getData()).booleanValue()) {
                    if (GDBRunControl.this.fGdb.getIsAttachSession() && GDBRunControl.this.fGdb.getSessionType() != SessionType.REMOTE && Platform.getOS().equals("win32")) {
                        IMIProcessDMContext processDmc = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIProcessDMContext.class);
                        String inferiorPid = processDmc.getProcId();
                        if (inferiorPid != null) {
                            GDBRunControl.this.fGdb.interruptInferiorAndWait(Long.parseLong(inferiorPid), 0, rm);
                        } else {
                            if (!$assertionsDisabled) {
                                throw new AssertionError((Object)"why don't we have the inferior's pid?");
                            }
                            GDBRunControl.this.fGdb.interruptAndWait(0, rm);
                        }
                    } else {
                        GDBRunControl.this.fGdb.interruptAndWait(0, rm);
                    }
                } else {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Context cannot be suspended.", null));
                    rm.done();
                }
            }
        });
    }

    @Override
    public void getExecutionContexts(IRunControl.IContainerDMContext containerDmc, final DataRequestMonitor<IRunControl.IExecutionDMContext[]> rm) {
        this.fProcService.getProcessesBeingDebugged((IDMContext)containerDmc, (DataRequestMonitor)new DataRequestMonitor<IDMContext[]>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (this.getData() instanceof IRunControl.IExecutionDMContext[]) {
                    IRunControl.IExecutionDMContext[] execDmcs = (IRunControl.IExecutionDMContext[])this.getData();
                    GDBRunControl.this.raiseExitEvents(execDmcs);
                    GDBRunControl.this.fOldExecutionCtxts = execDmcs;
                    rm.setData((Object)GDBRunControl.this.fOldExecutionCtxts);
                } else {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid contexts", null));
                }
                rm.done();
            }
        });
    }

    private void raiseExitEvents(IRunControl.IExecutionDMContext[] ctxts) {
        if (ctxts == null || this.fOldExecutionCtxts == null) {
            return;
        }
        List<IRunControl.IExecutionDMContext> list = Arrays.asList(ctxts);
        List<IRunControl.IExecutionDMContext> oldThreadList = Arrays.asList(this.fOldExecutionCtxts);
        for (IRunControl.IExecutionDMContext ctxt : oldThreadList) {
            if (list.contains(ctxt)) continue;
            IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)ctxt, IRunControl.IContainerDMContext.class);
            MIThreadExitEvent e = new MIThreadExitEvent(containerDmc, Integer.toString(((IMIExecutionDMContext)ctxt).getThreadId()));
            this.getSession().dispatchEvent((Object)e, this.getProperties());
        }
    }

    @Override
    public void canResume(IRunControl.IExecutionDMContext context, DataRequestMonitor<Boolean> rm) {
        if (this.fGdb.getSessionType() == SessionType.CORE) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        super.canResume(context, rm);
    }

    @Override
    public void canSuspend(IRunControl.IExecutionDMContext context, DataRequestMonitor<Boolean> rm) {
        if (this.fGdb.getSessionType() == SessionType.CORE) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        super.canSuspend(context, rm);
    }

    @Override
    public void canStep(final IRunControl.IExecutionDMContext context, IRunControl.StepType stepType, final DataRequestMonitor<Boolean> rm) {
        MIStack stackService;
        if (this.fGdb.getSessionType() == SessionType.CORE) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        if (context instanceof IRunControl.IContainerDMContext) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        if (stepType == IRunControl.StepType.STEP_RETURN && (stackService = (MIStack)((Object)this.getServicesTracker().getService(MIStack.class))) != null) {
            stackService.getStackDepth((IDMContext)context, 2, new DataRequestMonitor<Integer>((Executor)this.getExecutor(), rm){

                public void handleCompleted() {
                    if (this.isSuccess() && (Integer)this.getData() == 1) {
                        rm.setData((Object)false);
                        rm.done();
                    } else {
                        GDBRunControl.this.canResume(context, (DataRequestMonitor<Boolean>)rm);
                    }
                }
            });
            return;
        }
        this.canResume(context, rm);
    }

    @Override
    public void runToLocation(IRunControl.IExecutionDMContext context, final String location, final boolean skipBreakpoints, final RequestMonitor rm) {
        assert (context != null);
        final IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Given context: " + context + " is not an execution context.", null));
            rm.done();
            return;
        }
        if (this.doCanResume(dmc)) {
            IBreakpoints.IBreakpointsTargetDMContext bpDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)context, IBreakpoints.IBreakpointsTargetDMContext.class);
            this.getConnection().queueCommand(this.fCommandFactory.createMIBreakInsert(bpDmc, true, false, null, 0, location, dmc.getThreadId()), (DataRequestMonitor)new DataRequestMonitor<MIBreakInsertInfo>((Executor)this.getExecutor(), rm){

                public void handleSuccess() {
                    int bpId = ((MIBreakInsertInfo)this.getData()).getMIBreakpoints()[0].getNumber();
                    String addr = ((MIBreakInsertInfo)this.getData()).getMIBreakpoints()[0].getAddress();
                    GDBRunControl.this.fRunToLineActiveOperation = new RunToLineActiveOperation(dmc, bpId, location, addr, skipBreakpoints);
                    GDBRunControl.this.resume(dmc, new RequestMonitor((Executor)GDBRunControl.this.getExecutor(), rm){

                        public void handleFailure() {
                            IBreakpoints.IBreakpointsTargetDMContext bpDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)GDBRunControl.this.fRunToLineActiveOperation.getThreadContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
                            int bpId = GDBRunControl.this.fRunToLineActiveOperation.getBreakointId();
                            GDBRunControl.this.getConnection().queueCommand(GDBRunControl.this.fCommandFactory.createMIBreakDelete(bpDmc, new int[]{bpId}), new DataRequestMonitor((Executor)GDBRunControl.this.getExecutor(), null));
                            GDBRunControl.this.fRunToLineActiveOperation = null;
                            super.handleFailure();
                        }
                    });
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Cannot resume given DMC.", null));
            rm.done();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIInferiorExitEvent e) {
        if (this.fRunToLineActiveOperation != null) {
            IBreakpoints.IBreakpointsTargetDMContext bpDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)this.fRunToLineActiveOperation.getThreadContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
            int bpId = this.fRunToLineActiveOperation.getBreakointId();
            this.getConnection().queueCommand(this.fCommandFactory.createMIBreakDelete(bpDmc, new int[]{bpId}), new DataRequestMonitor((Executor)this.getExecutor(), null));
            this.fRunToLineActiveOperation = null;
        }
    }

    @Override
    @DsfServiceEventHandler
    public void eventDispatched(MIStoppedEvent e) {
        if (this.fRunToLineActiveOperation != null) {
            int bpId = 0;
            if (e instanceof MIBreakpointHitEvent) {
                bpId = ((MIBreakpointHitEvent)e).getNumber();
            }
            boolean equalFileLocation = false;
            boolean equalAddrLocation = false;
            boolean equalBpId = bpId == this.fRunToLineActiveOperation.getBreakointId();
            MIFrame frame = e.getFrame();
            if (frame != null) {
                String fileLocation = String.valueOf(frame.getFile()) + ":" + frame.getLine();
                String addrLocation = frame.getAddress();
                equalFileLocation = fileLocation.equals(this.fRunToLineActiveOperation.getFileLocation());
                equalAddrLocation = addrLocation.equals(this.fRunToLineActiveOperation.getAddrLocation());
            }
            if (equalFileLocation || equalAddrLocation || equalBpId) {
                this.fRunToLineActiveOperation = null;
            } else {
                if (this.fRunToLineActiveOperation.shouldSkipBreakpoints() && e instanceof MIBreakpointHitEvent) {
                    this.getConnection().queueCommand(this.fCommandFactory.createMIExecContinue(this.fRunToLineActiveOperation.getThreadContext()), new DataRequestMonitor((Executor)this.getExecutor(), null));
                    return;
                }
                IBreakpoints.IBreakpointsTargetDMContext bpDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)this.fRunToLineActiveOperation.getThreadContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
                this.getConnection().queueCommand(this.fCommandFactory.createMIBreakDelete(bpDmc, new int[]{this.fRunToLineActiveOperation.getBreakointId()}), new DataRequestMonitor((Executor)this.getExecutor(), null));
                this.fRunToLineActiveOperation = null;
            }
        }
        super.eventDispatched(e);
    }

    private static class RunToLineActiveOperation {
        private IMIExecutionDMContext fThreadContext;
        private int fBpId;
        private String fFileLocation;
        private String fAddrLocation;
        private boolean fSkipBreakpoints;

        public RunToLineActiveOperation(IMIExecutionDMContext threadContext, int bpId, String fileLoc, String addr, boolean skipBreakpoints) {
            this.fThreadContext = threadContext;
            this.fBpId = bpId;
            this.fFileLocation = fileLoc;
            this.fAddrLocation = addr;
            this.fSkipBreakpoints = skipBreakpoints;
        }

        public IMIExecutionDMContext getThreadContext() {
            return this.fThreadContext;
        }

        public int getBreakointId() {
            return this.fBpId;
        }

        public String getFileLocation() {
            return this.fFileLocation;
        }

        public String getAddrLocation() {
            return this.fAddrLocation;
        }

        public boolean shouldSkipBreakpoints() {
            return this.fSkipBreakpoints;
        }
    }
}

