/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStreamRecord;

public class CLITraceInfo
extends MIInfo {
    private Integer fReference = null;

    public CLITraceInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public Integer getTraceReference() {
        return this.fReference;
    }

    protected void parse() {
        if (this.isDone()) {
            MIOutput out = this.getMIOutput();
            MIOOBRecord[] oobs = out.getMIOOBRecords();
            int i = 0;
            while (i < oobs.length) {
                if (oobs[i] instanceof MIConsoleStreamOutput) {
                    Pattern pattern;
                    Matcher matcher;
                    MIStreamRecord cons = (MIStreamRecord)oobs[i];
                    String str = cons.getString();
                    str.trim();
                    if (str.length() > 0 && (matcher = (pattern = Pattern.compile("^Tracepoint\\s(\\d+)", 8)).matcher(str)).find()) {
                        String id = matcher.group(1);
                        try {
                            this.fReference = Integer.parseInt(id);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.fReference = null;
                        }
                    }
                }
                ++i;
            }
        }
    }
}

