/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.viewmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.MultiRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerCountingRequestMonitor;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.VMChildrenCountUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.VMHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfinedToDsfExecutor(value="#getExecutor()")
public class DefaultVMContentProviderStrategy
implements IElementContentProvider {
    private final AbstractVMProvider fVMProvider;

    public DefaultVMContentProviderStrategy(AbstractVMProvider provider) {
        this.fVMProvider = provider;
    }

    protected AbstractVMProvider getVMProvider() {
        return this.fVMProvider;
    }

    public void update(IHasChildrenUpdate[] updates) {
        if (updates.length == 0) {
            return;
        }
        boolean allNodesTheSame = true;
        IVMNode firstNode = this.getNodeForElement(updates[0].getElement());
        int i = 1;
        while (i < updates.length) {
            if (firstNode != this.getNodeForElement(updates[i].getElement())) {
                allNodesTheSame = false;
                break;
            }
            ++i;
        }
        if (allNodesTheSame) {
            this.updateNodeChildren(firstNode, updates);
        } else {
            HashMap nodeUpdatesMap = new HashMap();
            IHasChildrenUpdate[] iHasChildrenUpdateArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                IHasChildrenUpdate update = iHasChildrenUpdateArray[n2];
                IVMNode node = this.getNodeForElement(update.getElement());
                if (node == null) {
                    update.done();
                } else {
                    if (!nodeUpdatesMap.containsKey(node)) {
                        nodeUpdatesMap.put(node, new ArrayList());
                    }
                    ((List)nodeUpdatesMap.get(node)).add(update);
                }
                ++n2;
            }
            for (IVMNode node : nodeUpdatesMap.keySet()) {
                this.updateNodeChildren(node, ((List)nodeUpdatesMap.get(node)).toArray(new IHasChildrenUpdate[((List)nodeUpdatesMap.get(node)).size()]));
            }
        }
    }

    private void updateNodeChildren(IVMNode node, IHasChildrenUpdate[] updates) {
        IVMNode[] childNodes = this.getVMProvider().getChildVMNodes(node);
        if (childNodes.length == 0) {
            IHasChildrenUpdate[] iHasChildrenUpdateArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                IHasChildrenUpdate update = iHasChildrenUpdateArray[n2];
                update.setHasChilren(false);
                update.done();
                ++n2;
            }
        } else if (childNodes.length == 1) {
            this.getVMProvider().updateNode(childNodes[0], updates);
        } else {
            VMHasChildrenUpdate[][] elementsUpdates = new VMHasChildrenUpdate[childNodes.length][updates.length];
            int i = 0;
            while (i < updates.length) {
                final IHasChildrenUpdate update = updates[i];
                MultiRequestMonitor<DataRequestMonitor<Boolean>> hasChildrenMultiRequestMon = new MultiRequestMonitor<DataRequestMonitor<Boolean>>(this.getVMProvider().getExecutor(), null){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            boolean isContainer = false;
                            for (DataRequestMonitor hasElementsDone : this.getRequestMonitors()) {
                                isContainer |= hasElementsDone.isSuccess() && (Boolean)hasElementsDone.getData() != false;
                            }
                            update.setHasChilren(isContainer);
                        } else {
                            update.setStatus(this.getStatus());
                        }
                        update.done();
                    }
                };
                hasChildrenMultiRequestMon.requireDoneAdding();
                int j = 0;
                while (j < childNodes.length) {
                    elementsUpdates[j][i] = new VMHasChildrenUpdate((IViewerUpdate)update, (DataRequestMonitor<Boolean>)((DataRequestMonitor)hasChildrenMultiRequestMon.add((RequestMonitor)new ViewerDataRequestMonitor<Boolean>(this.getVMProvider().getExecutor(), (IViewerUpdate)update, (MultiRequestMonitor)hasChildrenMultiRequestMon){
                        private final /* synthetic */ MultiRequestMonitor val$hasChildrenMultiRequestMon;
                        {
                            this.val$hasChildrenMultiRequestMon = multiRequestMonitor;
                            super($anonymous0, $anonymous1);
                        }

                        protected void handleCompleted() {
                            this.val$hasChildrenMultiRequestMon.requestMonitorDone((RequestMonitor)this);
                        }
                    })));
                    ++j;
                }
                hasChildrenMultiRequestMon.doneAdding();
                ++i;
            }
            int j = 0;
            while (j < childNodes.length) {
                this.getVMProvider().updateNode(childNodes[j], elementsUpdates[j]);
                ++j;
            }
        }
    }

    public void update(IChildrenCountUpdate[] updates) {
        IChildrenCountUpdate[] iChildrenCountUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IChildrenCountUpdate update = iChildrenCountUpdateArray[n2];
            IVMNode node = this.getNodeForElement(update.getElement());
            if (node != null && !update.isCanceled()) {
                IVMNode[] childNodes = this.getVMProvider().getChildVMNodes(node);
                if (childNodes.length == 0) {
                    update.setChildCount(0);
                    update.done();
                } else if (childNodes.length == 1) {
                    this.getVMProvider().updateNode(childNodes[0], update);
                } else {
                    this.getChildrenCountsForNode((IViewerUpdate)update, node, (DataRequestMonitor<Integer[]>)new ViewerDataRequestMonitor<Integer[]>(this.getVMProvider().getExecutor(), (IViewerUpdate)update){

                        protected void handleCompleted() {
                            if (this.isSuccess()) {
                                int numChildren = 0;
                                Integer[] integerArray = (Integer[])this.getData();
                                int n = integerArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Integer count = integerArray[n2];
                                    numChildren += count.intValue();
                                    ++n2;
                                }
                                update.setChildCount(numChildren);
                            } else {
                                update.setChildCount(0);
                            }
                            update.done();
                        }
                    });
                }
            } else {
                update.done();
            }
            ++n2;
        }
    }

    public void update(IChildrenUpdate[] updates) {
        IChildrenUpdate[] iChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IChildrenUpdate update = iChildrenUpdateArray[n2];
            final IVMNode node = this.getNodeForElement(update.getElement());
            if (node != null && !update.isCanceled()) {
                IVMNode[] childNodes = this.getVMProvider().getChildVMNodes(node);
                if (childNodes.length == 0) {
                    update.done();
                } else if (childNodes.length == 1) {
                    this.getVMProvider().updateNode(childNodes[0], update);
                } else {
                    this.getChildrenCountsForNode((IViewerUpdate)update, node, (DataRequestMonitor<Integer[]>)new ViewerDataRequestMonitor<Integer[]>(this.getVMProvider().getExecutor(), (IViewerUpdate)update){

                        protected void handleCompleted() {
                            if (!this.isSuccess()) {
                                update.done();
                                return;
                            }
                            DefaultVMContentProviderStrategy.this.updateChildrenWithCounts(update, node, (Integer[])this.getData());
                        }
                    });
                }
            } else {
                update.done();
            }
            ++n2;
        }
    }

    private void getChildrenCountsForNode(IViewerUpdate update, IVMNode updateNode, DataRequestMonitor<Integer[]> rm) {
        IVMNode[] childNodes = this.getVMProvider().getChildVMNodes(updateNode);
        assert (childNodes.length != 0);
        final Integer[] counts = new Integer[childNodes.length];
        final CountingRequestMonitor crm = new CountingRequestMonitor(this.getVMProvider().getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm, counts){
            private final /* synthetic */ DataRequestMonitor val$rm;
            private final /* synthetic */ Integer[] val$counts;
            {
                this.val$rm = dataRequestMonitor;
                this.val$counts = integerArray;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                this.val$rm.setData((Object)this.val$counts);
                this.val$rm.done();
            }
        };
        int countRM = 0;
        int i = 0;
        while (i < childNodes.length) {
            final int nodeIndex = i;
            this.getVMProvider().updateNode(childNodes[i], new VMChildrenCountUpdate(update, new DataRequestMonitor<Integer>(this.getVMProvider().getExecutor(), (RequestMonitor)crm){

                protected void handleSuccess() {
                    counts[nodeIndex] = (Integer)this.getData();
                    crm.done();
                }
            }));
            ++countRM;
            ++i;
        }
        crm.setDoneCount(countRM);
    }

    private void updateChildrenWithCounts(final IChildrenUpdate update, IVMNode node, Integer[] nodeElementCounts) {
        int length;
        ViewerCountingRequestMonitor multiRm = new ViewerCountingRequestMonitor(this.getVMProvider().getExecutor(), (IViewerUpdate)update){

            protected void handleCompleted() {
                update.done();
            }
        };
        int multiRmCount = 0;
        int updateStartIdx = update.getOffset();
        if (updateStartIdx < 0) {
            updateStartIdx = 0;
        }
        int updateEndIdx = (length = update.getLength()) <= 0 ? Integer.MAX_VALUE : updateStartIdx + length;
        int idx = 0;
        IVMNode[] nodes = this.getVMProvider().getChildVMNodes(node);
        int i = 0;
        while (i < nodes.length) {
            int nodeEndIdx;
            final int nodeStartIdx = idx;
            idx = nodeEndIdx = idx + nodeElementCounts[i];
            if (updateStartIdx <= nodeEndIdx && updateEndIdx > nodeStartIdx) {
                final int elementsStartIdx = Math.max(updateStartIdx - nodeStartIdx, 0);
                int elementsEndIdx = Math.min(updateEndIdx - nodeStartIdx, nodeElementCounts[i]);
                final int elementsLength = elementsEndIdx - elementsStartIdx;
                if (elementsLength > 0) {
                    this.getVMProvider().updateNode(nodes[i], new VMChildrenUpdate((IViewerUpdate)update, elementsStartIdx, elementsLength, new DataRequestMonitor<List<Object>>(this.getVMProvider().getExecutor(), (RequestMonitor)multiRm){

                        protected void handleCompleted() {
                            if (this.getData() != null) {
                                int i = 0;
                                while (i < elementsLength && i < ((List)this.getData()).size()) {
                                    Object child = ((List)this.getData()).get(i);
                                    if (child != null) {
                                        update.setChild(((List)this.getData()).get(i), elementsStartIdx + nodeStartIdx + i);
                                    }
                                    ++i;
                                }
                            }
                            super.handleCompleted();
                        }
                    }));
                    ++multiRmCount;
                }
            }
            ++i;
        }
        multiRm.setDoneCount(multiRmCount);
    }

    protected IVMNode getNodeForElement(Object element) {
        if (element instanceof IVMContext) {
            IVMNode node = ((IVMContext)element).getVMNode();
            if (this.isOurNode(((IVMContext)element).getVMNode())) {
                return node;
            }
        }
        return this.getVMProvider().getRootVMNode();
    }

    private boolean isOurNode(IVMNode node) {
        return node.getVMProvider() == this.getVMProvider();
    }
}

