/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.views;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeUIImages;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.MakeContentProvider;
import org.eclipse.cdt.make.ui.TargetSourceContainer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class FilterEmtpyFoldersAction
extends Action {
    private static final String FILTER_EMPTY_FOLDERS = "FilterEmptyFolders";
    private TreeViewer fViewer;

    public FilterEmtpyFoldersAction(TreeViewer viewer) {
        super(MakeUIPlugin.getResourceString("FilterEmptyFolderAction.label"), 2);
        this.fViewer = viewer;
        this.setToolTipText(MakeUIPlugin.getResourceString("FilterEmptyFolderAction.tooltip"));
        this.setChecked(this.getSettings().getBoolean(FILTER_EMPTY_FOLDERS));
        MakeUIImages.setImageDescriptors((IAction)this, "tool16", MakeUIImages.IMG_TOOLS_MAKE_TARGET_FILTER);
        this.fViewer.addFilter(new ViewerFilter(){

            private boolean hasMakeTargets(IContainer container) throws CoreException {
                IMakeTarget[] targets = MakeCorePlugin.getDefault().getTargetManager().getTargets(container);
                if (targets != null && targets.length > 0) {
                    return true;
                }
                final boolean[] haveTargets = new boolean[]{false};
                IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        boolean isSourceEntry;
                        if (haveTargets[0]) {
                            return false;
                        }
                        if (proxy.getType() != 2) {
                            return true;
                        }
                        IContainer folder = (IContainer)proxy.requestResource();
                        if (CCorePlugin.showSourceRootsAtTopOfProject() && !(folder instanceof IProject) && (isSourceEntry = MakeContentProvider.isSourceEntry((IResource)folder))) {
                            return false;
                        }
                        IMakeTarget[] targets = MakeCorePlugin.getDefault().getTargetManager().getTargets(folder);
                        if (targets != null && targets.length > 0) {
                            haveTargets[0] = true;
                            return false;
                        }
                        return true;
                    }
                };
                container.accept(visitor, 0);
                return haveTargets[0];
            }

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (FilterEmtpyFoldersAction.this.isChecked()) {
                    IContainer container = null;
                    if (element instanceof IContainer) {
                        container = (IContainer)element;
                        if (!(container instanceof IProject) && CCorePlugin.showSourceRootsAtTopOfProject() && MakeContentProvider.isSourceEntry((IResource)container)) {
                            return false;
                        }
                    } else if (element instanceof TargetSourceContainer) {
                        container = ((TargetSourceContainer)element).getContainer();
                    }
                    if (container != null) {
                        try {
                            return this.hasMakeTargets(container);
                        }
                        catch (Exception exception) {
                            return false;
                        }
                    }
                }
                return true;
            }
        });
    }

    public void run() {
        this.fViewer.refresh();
        this.getSettings().put(FILTER_EMPTY_FOLDERS, this.isChecked());
    }

    private IDialogSettings getSettings() {
        IDialogSettings settings = MakeUIPlugin.getDefault().getDialogSettings().getSection("org.eclipse.cdt.internal.ui.MakeView");
        if (settings == null) {
            settings = MakeUIPlugin.getDefault().getDialogSettings().addNewSection("org.eclipse.cdt.internal.ui.MakeView");
        }
        return settings;
    }
}

