/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProjectManager;
import org.eclipse.cdt.managedbuilder.testplugin.CTestPlugin;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class ManagedProject21MakefileTests
extends TestCase {
    private IPath resourcesLocation = new Path(CTestPlugin.getFileInPlugin((IPath)new Path("resources/test21Projects/")).getAbsolutePath());
    public static final String MBS_TEMP_DIR = "MBSTemp";
    static boolean pathVariableCreated = false;

    public ManagedProject21MakefileTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ManagedProject21MakefileTests.class.getName());
        suite.addTest((Test)new ManagedProject21MakefileTests("testSingleFileExe"));
        suite.addTest((Test)new ManagedProject21MakefileTests("testTwoFileSO"));
        suite.addTest((Test)new ManagedProject21MakefileTests("testMultiResConfig"));
        suite.addTest((Test)new ManagedProject21MakefileTests("testLinkedLib"));
        suite.addTest((Test)new ManagedProject21MakefileTests("testLinkedFolder"));
        return suite;
    }

    private IProject[] createProject(String projName, IPath location, String projectTypeId, boolean containsZip) {
        Path path = new Path("resources/test21Projects/" + projName);
        File testDir = CTestPlugin.getFileInPlugin((IPath)path);
        if (testDir == null) {
            ManagedProject21MakefileTests.fail((String)("Test project directory " + path + " is missing."));
            return null;
        }
        ArrayList<IProject> projectList = null;
        if (containsZip) {
            File[] projectZips = testDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return !pathname.isDirectory();
                }
            });
            projectList = new ArrayList<IProject>(projectZips.length);
            int i = 0;
            while (i < projectZips.length) {
                try {
                    IProject project;
                    String projectName = projectZips[i].getName();
                    if (projectName.endsWith(".zip") && (projectName = projectName.substring(0, projectName.length() - ".zip".length())).length() != 0 && (project = ManagedBuildTestHelper.createProject(projectName, projectZips[i], location, projectTypeId)) != null) {
                        projectList.add(project);
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
            if (projectList.size() == 0) {
                ManagedProject21MakefileTests.fail((String)("No projects found in test project directory " + testDir.getName() + ".  The .zip file may be missing or corrupt."));
                return null;
            }
        } else {
            try {
                IProject project = ManagedBuildTestHelper.createProject(projName, null, location, projectTypeId);
                if (project != null) {
                    projectList = new ArrayList(1);
                }
                projectList.add(project);
            }
            catch (Exception exception) {}
        }
        return projectList.toArray(new IProject[projectList.size()]);
    }

    private IProject[] createProjects(String projName, IPath location, String projectTypeId, boolean containsZip) {
        IOverwriteQuery queryALL = new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "ALL";
            }
        };
        UpdateManagedProjectManager.setBackupFileOverwriteQuery((IOverwriteQuery)queryALL);
        UpdateManagedProjectManager.setUpdateProjectQuery((IOverwriteQuery)queryALL);
        IProject[] projects = this.createProject(projName, location, projectTypeId, containsZip);
        return projects;
    }

    private boolean buildProjects(String benchmarkDir, IProject[] projects, IPath[] files) {
        if (projects == null || projects.length == 0) {
            return false;
        }
        boolean succeeded = true;
        int i = 0;
        while (i < projects.length) {
            IProject curProject = projects[i];
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)curProject);
            boolean isCompatible = UpdateManagedProjectManager.isCompatibleProject((IManagedBuildInfo)info);
            ManagedProject21MakefileTests.assertTrue((boolean)isCompatible);
            if (isCompatible) {
                try {
                    curProject.build(10, null);
                }
                catch (CoreException e) {
                    ManagedProject21MakefileTests.fail((String)e.getStatus().getMessage());
                }
                catch (OperationCanceledException e) {
                    ManagedProject21MakefileTests.fail((String)("the project \"" + curProject.getName() + "\" build was cancelled, exception message: " + e.getMessage()));
                }
                if (files != null && files.length > 0 && i == 0) {
                    String configName = info.getDefaultConfiguration().getName();
                    IPath buildDir = Path.fromOSString((String)configName);
                    IPath benchmarkLocationBase = this.resourcesLocation.append(benchmarkDir);
                    IPath buildLocation = curProject.getLocation().append(buildDir);
                    succeeded = ManagedBuildTestHelper.compareBenchmarks(curProject, buildLocation, files, benchmarkLocationBase);
                }
            }
            ++i;
        }
        if (succeeded) {
            i = 0;
            while (i < projects.length) {
                ManagedBuildTestHelper.removeProject(projects[i].getName());
                ++i;
            }
        }
        return succeeded;
    }

    private void createPathVariable(IPath tmpDir) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace = ResourcesPlugin.getWorkspace();
        IPathVariableManager pathMan = workspace.getPathVariableManager();
        String name = MBS_TEMP_DIR;
        try {
            if (pathMan.validateName(name).isOK() && pathMan.validateValue(tmpDir).isOK()) {
                pathMan.setValue(name, tmpDir);
                ManagedProject21MakefileTests.assertTrue((boolean)pathMan.isDefined(name));
            } else {
                ManagedProject21MakefileTests.fail((String)("could not create the path variable " + name));
            }
        }
        catch (Exception exception) {
            ManagedProject21MakefileTests.fail((String)("could not create the path variable " + name));
        }
    }

    private void createFileLink(IProject project, IPath tmpDir, String linkName, String fileName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String name = MBS_TEMP_DIR;
        if (!pathVariableCreated) {
            this.createPathVariable(tmpDir);
            pathVariableCreated = true;
        }
        try {
            IFile linkF1 = project.getFile(linkName);
            Path location = new Path("MBSTemp/" + fileName);
            if (workspace.validateLinkLocation((IResource)linkF1, (IPath)location).isOK()) {
                linkF1.createLink((IPath)location, 0, null);
            } else {
                ManagedProject21MakefileTests.fail((String)("could not create the link to " + name));
            }
        }
        catch (Exception e) {
            ManagedProject21MakefileTests.fail((String)("could not create the link to " + name + ": " + e));
        }
    }

    public void testSingleFileExe() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        IProject[] projects = this.createProjects("singleFileExe", null, null, true);
        this.buildProjects("singleFileExe", projects, makefiles);
    }

    public void testTwoFileSO() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        IProject[] projects = this.createProjects("twoFileSO", null, null, true);
        this.buildProjects("twoFileSO", projects, makefiles);
    }

    public void testMultiResConfig() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"source1/subdir.mk"), Path.fromOSString((String)"source2/subdir.mk"), Path.fromOSString((String)"source2/source21/subdir.mk")};
        IProject[] projects = this.createProjects("multiResConfig", null, null, true);
        this.buildProjects("multiResConfig", projects, makefiles);
    }

    public void testLinkedLib() {
        boolean succeeded = false;
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk")};
        IPath[] linkedFiles = new IPath[]{Path.fromOSString((String)"f1.c"), Path.fromOSString((String)"f2.c"), Path.fromOSString((String)"test_ar.h")};
        File srcDirFile = CTestPlugin.getFileInPlugin((IPath)new Path("resources/test21Projects/linkedLib/"));
        IPath srcDir = Path.fromOSString((String)srcDirFile.toString());
        IPath tmpSubDir = Path.fromOSString((String)"CDTMBSTest");
        IPath tmpDir = ManagedBuildTestHelper.copyFilesToTempDir(srcDir, tmpSubDir, linkedFiles);
        try {
            IProject[] projects = this.createProjects("linkedLib", null, "cdt.managedbuild.target.testgnu21.lib", true);
            IProject project = projects[0];
            this.createFileLink(project, tmpDir, "f1.c", "f1.c");
            this.createFileLink(project, tmpDir, "f2link.c", "f2.c");
            this.createFileLink(project, tmpDir, "test_ar.h", "test_ar.h");
            succeeded = this.buildProjects("linkedLib", projects, makefiles);
        }
        finally {
            if (succeeded) {
                ManagedBuildTestHelper.deleteTempDir(tmpSubDir, linkedFiles);
            }
        }
    }

    public void testLinkedFolder() {
        boolean succeeded = false;
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"sources.mk")};
        IPath[] linkedFiles = new IPath[]{Path.fromOSString((String)"f1.c"), Path.fromOSString((String)"f2.c"), Path.fromOSString((String)"test_ar.h"), Path.fromOSString((String)"Benchmarks/makefile"), Path.fromOSString((String)"Benchmarks/objects.mk"), Path.fromOSString((String)"Benchmarks/subdir.mk"), Path.fromOSString((String)"Benchmarks/sources.mk")};
        File srcDirFile = CTestPlugin.getFileInPlugin((IPath)new Path("resources/test21Projects/linkedFolder/"));
        IPath srcDir = Path.fromOSString((String)srcDirFile.toString());
        IPath tmpSubDir = Path.fromOSString((String)"CDTMBSTest");
        IPath tmpDir = ManagedBuildTestHelper.copyFilesToTempDir(srcDir, tmpSubDir, linkedFiles);
        if (!pathVariableCreated) {
            this.createPathVariable(tmpDir);
            pathVariableCreated = true;
        }
        IPath location = Path.fromOSString((String)MBS_TEMP_DIR);
        IProject[] projects = this.createProjects("linkedFolder", location, "cdt.managedbuild.target.testgnu21.lib", false);
        succeeded = this.buildProjects("linkedFolder", projects, makefiles);
        ManagedProject21MakefileTests.assertTrue((boolean)succeeded);
    }
}

