/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.managedbuilder.core.IAdditionalInput;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.InputType;

public class AdditionalInput
implements IAdditionalInput {
    private static final String EMPTY_STRING = new String();
    private IInputType fParent;
    private String fPaths;
    private Integer fKind;
    private boolean fIsExtensionAdditionalInput = false;
    private boolean fIsDirty = false;
    private boolean fResolved = true;
    private boolean fRebuildState;

    public AdditionalInput(IInputType parent, IManagedConfigElement element) {
        this.fParent = parent;
        this.fIsExtensionAdditionalInput = true;
        this.fResolved = false;
        this.loadFromManifest(element);
    }

    public AdditionalInput(InputType parent, boolean isExtensionElement) {
        this.fParent = parent;
        this.fIsExtensionAdditionalInput = isExtensionElement;
        if (!isExtensionElement) {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public AdditionalInput(IInputType parent, ICStorageElement element) {
        this.fParent = parent;
        this.fIsExtensionAdditionalInput = false;
        this.loadFromProject(element);
    }

    public AdditionalInput(IInputType parent, AdditionalInput additionalInput) {
        this.fParent = parent;
        this.fIsExtensionAdditionalInput = false;
        if (additionalInput.fPaths != null) {
            this.fPaths = new String(additionalInput.fPaths);
        }
        if (additionalInput.fKind != null) {
            this.fKind = new Integer(additionalInput.fKind);
        }
        this.setDirty(true);
        this.setRebuildState(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        this.fPaths = SafeStringInterner.safeIntern((String)element.getAttribute("paths"));
        String kindStr = element.getAttribute("kind");
        if (kindStr == null || kindStr.equals("additionalinputdependency")) {
            this.fKind = new Integer(3);
        } else if (kindStr.equals("additionalinput")) {
            this.fKind = new Integer(2);
        } else if (kindStr.equals("additionaldependency")) {
            this.fKind = new Integer(1);
        }
    }

    protected void loadFromProject(ICStorageElement element) {
        if (element.getAttribute("paths") != null) {
            this.fPaths = SafeStringInterner.safeIntern((String)element.getAttribute("paths"));
        }
        if (element.getAttribute("kind") != null) {
            String kindStr = element.getAttribute("kind");
            if (kindStr == null || kindStr.equals("additionalinputdependency")) {
                this.fKind = new Integer(3);
            } else if (kindStr.equals("additionalinput")) {
                this.fKind = new Integer(2);
            } else if (kindStr.equals("additionaldependency")) {
                this.fKind = new Integer(1);
            }
        }
    }

    public void serialize(ICStorageElement element) {
        if (this.fPaths != null) {
            element.setAttribute("paths", this.fPaths);
        }
        if (this.fKind != null) {
            String str;
            switch (this.getKind()) {
                case 2: {
                    str = "additionalinput";
                    break;
                }
                case 1: {
                    str = "additionaldependency";
                    break;
                }
                case 3: {
                    str = "additionalinputdependency";
                    break;
                }
                default: {
                    str = EMPTY_STRING;
                }
            }
            element.setAttribute("kind", str);
        }
        this.fIsDirty = false;
    }

    public IInputType getParent() {
        return this.fParent;
    }

    public String[] getPaths() {
        if (this.fPaths == null) {
            return null;
        }
        String[] nameTokens = CDataUtil.stringToArray((String)this.fPaths, (String)";");
        return nameTokens;
    }

    public void setPaths(String newPaths) {
        if (this.fPaths == null && newPaths == null) {
            return;
        }
        if (this.fPaths == null || newPaths == null || !this.fPaths.equals(newPaths)) {
            this.fPaths = newPaths;
            this.fIsDirty = true;
            this.setRebuildState(true);
        }
    }

    public int getKind() {
        if (this.fKind == null) {
            return 3;
        }
        return this.fKind;
    }

    public void setKind(int newKind) {
        if (this.fKind == null || this.fKind != newKind) {
            this.fKind = new Integer(newKind);
            this.fIsDirty = true;
            this.setRebuildState(true);
        }
    }

    public boolean isExtensionElement() {
        return this.fIsExtensionAdditionalInput;
    }

    public boolean isDirty() {
        if (this.fIsExtensionAdditionalInput) {
            return false;
        }
        return this.fIsDirty;
    }

    public void setDirty(boolean isDirty) {
        this.fIsDirty = isDirty;
    }

    public void resolveReferences() {
        if (!this.fResolved) {
            this.fResolved = true;
        }
    }

    public boolean needsRebuild() {
        return this.fRebuildState;
    }

    public void setRebuildState(boolean rebuild) {
        if (this.isExtensionElement() && rebuild) {
            return;
        }
        this.fRebuildState = rebuild;
    }
}

