/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import com.ibm.icu.text.Collator;
import java.util.Arrays;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.cdt.internal.corext.util.Strings;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public final class SortLinesAction
extends TextEditorAction {
    public SortLinesAction(ITextEditor editor) {
        super(CEditorMessages.getBundleForConstructedKeys(), "SortLines.", editor);
    }

    public void run() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        ISelection selection = editor.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        if (textSelection.getStartLine() < 0 || textSelection.getEndLine() < 0) {
            return;
        }
        IEditorInput editorInput = editor.getEditorInput();
        ICProject cProject = EditorUtility.getCProject(editorInput);
        IDocument document = editor.getDocumentProvider().getDocument((Object)editorInput);
        try {
            IRegion block = this.getTextBlockFromSelection(textSelection, document);
            Object[] elements = this.createSortElements(block, document, CodeFormatterUtil.getTabWidth(cProject));
            if (elements.length <= 1) {
                return;
            }
            Arrays.sort(elements);
            StringBuilder buf = new StringBuilder();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                buf.append(document.get(((SortElement)element).getOffset(), ((SortElement)element).getLength()));
                if (!SortLinesAction.isLastLineTerminated((IRegion)element, document)) {
                    buf.append(TextUtilities.getDefaultLineDelimiter((IDocument)document));
                }
                ++n2;
            }
            String replacement = buf.toString();
            if (replacement.equals(document.get(block.getOffset(), block.getLength()))) {
                return;
            }
            if (!this.validateEditorInputState()) {
                return;
            }
            ReplaceEdit edit = new ReplaceEdit(block.getOffset(), block.getLength(), replacement);
            IDocumentUndoManager manager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)document);
            manager.beginCompoundChange();
            edit.apply(document);
            editor.getSelectionProvider().setSelection((ISelection)new TextSelection(block.getOffset(), buf.length()));
            manager.endCompoundChange();
        }
        catch (BadLocationException e) {
            CUIPlugin.log(e);
        }
    }

    private IRegion getTextBlockFromSelection(ITextSelection selection, IDocument document) {
        try {
            IRegion firstLine = document.getLineInformationOfOffset(selection.getOffset());
            int selectionEnd = selection.getOffset() + selection.getLength();
            IRegion lastLine = document.getLineInformationOfOffset(selectionEnd);
            int length = lastLine.getOffset() - firstLine.getOffset();
            if (selectionEnd > lastLine.getOffset()) {
                length += document.getLineLength(document.getLineOfOffset(selectionEnd));
            }
            return new Region(firstLine.getOffset(), length);
        }
        catch (BadLocationException e) {
            CUIPlugin.log(e);
            return null;
        }
    }

    private SortElement[] createSortElements(IRegion block, IDocument document, int tabWidth) throws BadLocationException {
        SortElement[] elements;
        ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)document, (String)"___c_partitioning", (int)block.getOffset(), (int)block.getLength(), (boolean)false);
        int numLines = document.getNumberOfLines(block.getOffset(), block.getLength());
        if (this.endOf(block) <= document.getLineInformationOfOffset(this.endOf(block)).getOffset()) {
            --numLines;
        }
        LineInfo[] lineDescriptors = new LineInfo[numLines];
        int numNonCommentLines = 0;
        int i = 0;
        int k = 0;
        int line = document.getLineOfOffset(block.getOffset());
        int endLine = line + numLines;
        while (line < endLine) {
            LineInfo lineInfo = new LineInfo(document, line);
            lineDescriptors[k++] = lineInfo;
            while (i < regions.length && this.endOf((IRegion)regions[i]) <= lineInfo.getTrimmedOffset()) {
                ++i;
            }
            while (i < regions.length && regions[i].getOffset() < lineInfo.getTrimmedEndOffset()) {
                ITypedRegion region = regions[i];
                if (region.getType() != "__c_multiline_comment" && region.getType() != "__c_multiline_doc_comment" && region.getType() != "__c_singleline_comment" && region.getType() != "__c_singleline_doc_comment") {
                    lineInfo.nonComment = true;
                    break;
                }
                ++i;
            }
            if (lineInfo.nonComment) {
                ++numNonCommentLines;
            }
            ++line;
        }
        if (numNonCommentLines > 1) {
            elements = new SortElement[numNonCommentLines];
            k = 0;
            int offset = block.getOffset();
            int j = 0;
            while (j < lineDescriptors.length) {
                LineInfo lineInfo = lineDescriptors[j];
                if (lineInfo.nonComment) {
                    int endOffset = k < numNonCommentLines - 1 ? lineInfo.getEndOffset() : block.getOffset() + block.getLength();
                    elements[k++] = new SortElement((IRegion)new Region(offset, endOffset - offset), lineInfo, document, tabWidth);
                    offset = lineInfo.getEndOffset();
                }
                ++j;
            }
        } else {
            elements = new SortElement[numLines];
            int j = 0;
            while (j < lineDescriptors.length) {
                LineInfo lineInfo = lineDescriptors[j];
                elements[j] = new SortElement(lineInfo, lineInfo, document, tabWidth);
                ++j;
            }
        }
        return elements;
    }

    private int endOf(IRegion region) {
        return region.getOffset() + region.getLength();
    }

    private static boolean isLastLineTerminated(IRegion region, IDocument document) throws BadLocationException {
        int offset = region.getOffset() + region.getLength();
        IRegion nextLine = document.getLineInformationOfOffset(offset);
        return nextLine.getOffset() == offset;
    }

    public void update() {
        ISelection selection;
        if (!this.canModifyEditor()) {
            this.setEnabled(false);
            return;
        }
        boolean enabled = false;
        ITextEditor editor = this.getTextEditor();
        if (editor != null && (selection = editor.getSelectionProvider().getSelection()) instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            int startLine = textSelection.getStartLine();
            int endLine = textSelection.getEndLine();
            if (startLine >= 0 && endLine > startLine) {
                if (endLine == startLine + 1) {
                    IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                    try {
                        if (textSelection.getOffset() + textSelection.getLength() > document.getLineOffset(endLine)) {
                            enabled = true;
                        }
                    }
                    catch (BadLocationException e) {
                        CUIPlugin.log(e);
                    }
                } else {
                    enabled = true;
                }
            }
        }
        this.setEnabled(enabled);
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
    }

    private static class LineInfo
    implements IRegion {
        final int offset;
        final int length;
        final int trimmedOffset;
        final int trimmedEndOffset;
        boolean nonComment;

        LineInfo(IDocument document, int line) throws BadLocationException {
            this.offset = document.getLineOffset(line);
            this.length = document.getLineLength(line);
            int begin = this.offset;
            int end = this.offset + this.length;
            while (--end >= begin && Character.isWhitespace(document.getChar(end))) {
            }
            ++end;
            while (begin < end && Character.isWhitespace(document.getChar(begin))) {
                ++begin;
            }
            this.trimmedOffset = begin;
            this.trimmedEndOffset = end;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public int getEndOffset() {
            return this.offset + this.length;
        }

        public int getTrimmedOffset() {
            return this.trimmedOffset;
        }

        public int getTrimmedEndOffset() {
            return this.trimmedEndOffset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SortElement
    implements Comparable<SortElement>,
    IRegion {
        private static final Collator collator = Collator.getInstance();
        private final IRegion region;
        private final String collationKey;

        public SortElement(IRegion region, IRegion collationLine, IDocument document, int tabWidth) throws BadLocationException {
            this.region = region;
            this.collationKey = Strings.convertTabsToSpaces(Strings.trimTrailingTabsAndSpaces(document.get(collationLine.getOffset(), collationLine.getLength())), tabWidth);
        }

        @Override
        public int compareTo(SortElement other) {
            return collator.compare(this.collationKey, other.collationKey);
        }

        public int getOffset() {
            return this.region.getOffset();
        }

        public int getLength() {
            return this.region.getLength();
        }
    }
}

